/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.auth;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.budget.framework.core.BudgetParentDocument;
import org.kuali.coeus.common.framework.auth.KcKradTransactionalDocumentAuthorizerBase;
import org.kuali.coeus.common.framework.auth.UnitAuthorizationService;
import org.kuali.coeus.common.framework.auth.perm.KcAuthorizationService;
import org.kuali.coeus.common.framework.auth.perm.Permissionable;
import org.kuali.coeus.propdev.impl.attachment.Narrative;
import org.kuali.coeus.propdev.impl.attachment.NarrativeRight;
import org.kuali.coeus.propdev.impl.attachment.NarrativeUserRights;
import org.kuali.coeus.propdev.impl.auth.perm.ProposalDevelopmentPermissionsService;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentUtils;
import org.kuali.coeus.propdev.impl.hierarchy.ProposalHierarchyException;
import org.kuali.coeus.propdev.impl.hierarchy.ProposalHierarchyService;
import org.kuali.coeus.propdev.impl.person.ProposalPerson;
import org.kuali.coeus.propdev.impl.person.attachment.ProposalPersonBiography;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.workflow.KcDocumentRejectionService;
import org.kuali.coeus.sys.framework.workflow.KcWorkflowService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.action.ActionTaken;
import org.kuali.rice.kew.api.action.WorkflowDocumentActionsService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.DocumentRequestAuthorizationCache;

public class ProposalDevelopmentDocumentAuthorizer
extends KcKradTransactionalDocumentAuthorizerBase {
    private static final Logger LOG = LogManager.getLogger(ProposalDevelopmentDocumentAuthorizer.class);
    private static final String MODIFY_BUDGET = "ModifyBudget";
    private static final String SAVE_CERTIFICATION = "SaveCertification";
    private static final String IS_AUTHORIZED_TO_MODIFY = "IsAuthorizedToModify";
    private static final String MODIFY_NARRATIVE_CACHE_KEY_PREFIX = "ModifyNarrative";
    private static final String CACHE_KEY_SEPARATOR = "|";
    private KcAuthorizationService kcAuthorizationService;
    private UnitAuthorizationService unitAuthorizationService;
    private KcWorkflowService kcWorkflowService;
    private KcDocumentRejectionService kcDocumentRejectionService;
    private ProposalHierarchyService proposalHierarchyService;
    private ProposalDevelopmentPermissionsService proposalDevelopmentPermissionsService;

    @Override
    public Set<String> getEditModes(Document document, Person user, Set<String> currentEditModes) {
        HashSet<String> editModes = new HashSet<String>();
        ProposalDevelopmentDocument proposalDoc = (ProposalDevelopmentDocument)document;
        DevelopmentProposal developmentProposal = proposalDoc.getDevelopmentProposal();
        String proposalNbr = developmentProposal.getProposalNumber();
        if (proposalNbr == null) {
            if (this.isAuthorizedToCreate(document, user)) {
                editModes.add("fullEntry");
                this.setPermissions(user, proposalDoc, editModes);
            } else {
                editModes.add("unviewable");
            }
        } else if (this.canEdit(document, user)) {
            editModes.add("fullEntry");
            this.setPermissions(user, proposalDoc, editModes);
        } else if (this.isAuthorizedToView(document, user)) {
            editModes.add("viewOnly");
            this.setPermissions(user, proposalDoc, editModes);
        } else {
            editModes.add("unviewable");
        }
        return editModes;
    }

    @Override
    public boolean canDeleteDocument(Document document, Person user) {
        if (document != null && document instanceof Permissionable) {
            return this.getKcAuthorizationService().hasPermission(user.getPrincipalId(), (Permissionable)document, "Delete Proposal");
        }
        return false;
    }

    public boolean canCreateInstitutionalProposal(Document document, Person user) {
        boolean hasPermission = ProposalDevelopmentDocumentAuthorizer.getPermissionService().hasPermission(user.getPrincipalId(), "KC-IP", "Create Institutional Proposal");
        if (hasPermission) {
            hasPermission = ProposalDevelopmentDocumentAuthorizer.getPermissionService().hasPermission(user.getPrincipalId(), "KC-IP", "Submit Institutional Proposal");
        }
        return hasPermission;
    }

    public boolean canNotifyProposalPerson(Document document, Person user) {
        return this.getKcAuthorizationService().hasPermission(user.getPrincipalId(), (Permissionable)document, "NOTIFY_PROPOSAL_PERSONS");
    }

    private void setPermissions(Person user, ProposalDevelopmentDocument doc, Set<String> editModes) {
        if (editModes.contains("fullEntry")) {
            editModes.add("modifyProposal");
        }
        if (editModes.contains("viewOnly")) {
            editModes.add("viewProposal");
        }
        if (this.isAuthorizedToAddBudget(doc, user)) {
            editModes.add("addBudget");
        }
        if (this.isAuthorizedToOpenBudget(doc, user)) {
            editModes.add("viewBudget");
        }
        if (this.isAuthorizedToModifyBudget(doc, user)) {
            editModes.add("modifyBudget");
        }
        if (this.isAuthorizedToModifyProposalRoles(doc, user)) {
            editModes.add("modifyPermissions");
        }
        if (this.isAuthorizedToAddNarrative(doc, user)) {
            editModes.add("addNarratives");
        }
        if (this.isAuthorizedToReplaceNarrative(doc, user)) {
            editModes.add("replaceNarratives");
        }
        if (this.isAuthorizedToModifyS2sOverride(doc, user)) {
            editModes.add("modifyS2sOverride");
        }
        if (this.isAuthorizedToCertify(doc, user)) {
            editModes.add("certify");
        }
        if (this.isAuthorizedToCopyProposal(doc, user)) {
            editModes.add("canCopyProposal");
        }
        if (this.isAuthorizedToPrint(doc, user)) {
            editModes.add("printProposal");
        }
        if (this.isAuthorizedToAlterProposalData(doc, user)) {
            editModes.add("alterProposalData");
        }
        if (this.isAuthorizedToShowAlterProposalData(doc, user)) {
            editModes.add("showAlterProposalData");
        }
        if (this.isAuthorizedToSubmitToSponsor(doc, user)) {
            editModes.add("submitToSponsor");
        }
        if (this.isAuthorizedToModifyS2s(doc, user)) {
            editModes.add("modifyS2s");
        }
        if (this.isAuthorizedToMaintainProposalHierarchy(doc, user)) {
            editModes.add("maintainProposalHierarchy");
        }
        if (this.isAuthorizedToRejectProposal(doc, user)) {
            editModes.add("rejectProposal");
        }
        if (this.isAuthorizedToAddAddressBook(doc, user)) {
            editModes.add("addAddressBook");
        }
        if (this.canSaveCertification(doc, user)) {
            editModes.add("canSaveCertification");
        }
        if (this.isAuthorizedToOverrideComplianceEntry(doc, user)) {
            editModes.add("overridePDComplianceEntry");
        }
        if (this.isAuthorizedToMaintainPersonnelPrimeHomeUnits(doc, user)) {
            editModes.add("maintainPersonnelPrimeHomeUnits");
        }
        this.setNarrativePermissions(user, doc, editModes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNarrativePermissions(Person user, ProposalDevelopmentDocument doc, Set<String> editModes) {
        List<Narrative> narratives;
        List<Narrative> list = narratives = doc.getDevelopmentProposal().getNarratives();
        synchronized (list) {
            String prefix;
            for (Narrative narrative : narratives) {
                prefix = "proposalAttachment." + narrative.getModuleNumber() + ".";
                if (this.isAuthorizedToViewNarrative(narrative, user)) {
                    editModes.add(prefix + "download");
                }
                if (this.isAuthorizedToReplaceNarrative(narrative, user)) {
                    editModes.add(prefix + "replace");
                }
                if (this.isAuthorizedToDeleteNarrative(narrative, user)) {
                    editModes.add(prefix + "delete");
                }
                if (this.isAuthorizedToModifyNarrative(narrative, user)) {
                    editModes.add(prefix + "modifyStatus");
                }
                if (!this.isAuthorizedToModifyNarrative(narrative, user)) continue;
                editModes.add(prefix + "modifyRights");
            }
            narratives = doc.getDevelopmentProposal().getInstituteAttachments();
            for (Narrative narrative : narratives) {
                prefix = "instituteAttachment." + narrative.getModuleNumber() + ".";
                if (this.isAuthorizedToViewNarrative(narrative, user)) {
                    editModes.add(prefix + "download");
                }
                if (this.isAuthorizedToReplaceNarrative(narrative, user)) {
                    editModes.add(prefix + "replace");
                }
                if (this.isAuthorizedToDeleteNarrative(narrative, user)) {
                    editModes.add(prefix + "delete");
                }
                if (!this.isAuthorizedToModifyNarrative(narrative, user)) continue;
                editModes.add(prefix + "modifyRights");
            }
            int i = 0;
            boolean canReplace = this.isAuthorizedToReplacePersonnelAttachement(doc, user);
            for (ProposalPersonBiography ppb : doc.getDevelopmentProposal().getPropPersonBios()) {
                ppb.setPositionNumber(i);
                String prefix2 = "biographyAttachments." + ppb.getPositionNumber() + ".";
                if (canReplace) {
                    editModes.add(prefix2 + "replace");
                }
                ++i;
            }
        }
    }

    public boolean canOpen(Document document, Person user) {
        ProposalDevelopmentDocument proposalDocument = (ProposalDevelopmentDocument)document;
        if (proposalDocument.getDevelopmentProposal().getProposalNumber() == null) {
            return this.isAuthorizedToCreate(document, user);
        }
        return this.isAuthorizedToView(document, user);
    }

    @Override
    public boolean canEdit(Document document, Person user) {
        return this.isAuthorizedToModify(document, user);
    }

    @Override
    public boolean canSave(Document document, Person user) {
        return this.canEdit(document, user);
    }

    @Override
    public boolean canCancel(Document document, Person user) {
        return this.canEdit(document, user) && super.canCancel(document, user);
    }

    @Override
    public boolean canReload(Document document, Person user) {
        DocumentRequestAuthorizationCache.WorkflowDocumentInfo workflowDocumentInfo = this.getDocumentRequestAuthorizationCache(document).getWorkflowDocumentInfo();
        return this.canEdit(document, user) && !workflowDocumentInfo.isInitiated() || workflowDocumentInfo.isCanceled();
    }

    @Override
    public boolean canRoute(Document document, Person user) {
        return this.isAuthorizedToSubmitToWorkflow(document, user) && this.isAuthorizedToHierarchyChildWorkflowAction(document, user);
    }

    @Override
    public boolean canAnnotate(Document document, Person user) {
        return this.canRoute(document, user) && this.isAuthorizedToHierarchyChildWorkflowAction(document, user);
    }

    @Override
    public boolean canCopy(Document document, Person user) {
        return false;
    }

    @Override
    public boolean canApprove(Document document, Person user) {
        return super.canApprove(document, user) && this.isAuthorizedToHierarchyChildWorkflowAction(document, user);
    }

    @Override
    public boolean canDisapprove(Document document, Person user) {
        return super.canDisapprove(document, user) && this.isAuthorizedToHierarchyChildWorkflowAction(document, user) && this.getParameterService().getParameterValueAsBoolean("KC-PD", "Document", "ENABLE_PD_WORKFLOW_DISAPPROVE") != false;
    }

    @Override
    public boolean canBlanketApprove(Document document, Person user) {
        return super.canBlanketApprove(document, user) && this.isAuthorizedToHierarchyChildWorkflowAction(document, user);
    }

    @Override
    public boolean canAcknowledge(Document document, Person user) {
        return super.canAcknowledge(document, user) && this.isAuthorizedToHierarchyChildAckWorkflowAction(document, user);
    }

    @Override
    public boolean canAddNoteAttachment(Document document, String attachmentTypeCode, Person user) {
        return this.isAuthorizedToAddNote(document, user);
    }

    @Override
    public boolean canDeleteNoteAttachment(Document document, String attachmentTypeCode, String createdBySelfOnly, Person user) {
        boolean retVal = false;
        Boolean allowNotesDeletion = this.getParameterService().getParameterValueAsBoolean(ProposalDevelopmentDocument.class, "allowProposalDevelopmentNotesDeletion");
        if (allowNotesDeletion != null && allowNotesDeletion.booleanValue()) {
            retVal = super.canDeleteNoteAttachment(document, attachmentTypeCode, createdBySelfOnly, user);
        }
        return retVal;
    }

    @Override
    public boolean canViewNoteAttachment(Document document, String attachmentTypeCode, Person user) {
        return this.isAuthorizedToView(document, user);
    }

    @Override
    public boolean canFyi(Document document, Person user) {
        return super.canFyi(document, user) && this.isAuthorizedToHierarchyChildWorkflowAction(document, user);
    }

    public boolean canSendNoteFyi(Document document, Person user) {
        return false;
    }

    @Override
    public boolean canRecall(Document document, Person user) {
        return this.isAuthorizedToRecallProposal(document, user) && this.isSubmittedToSponsor(document) == false;
    }

    public boolean hasCertificationPermissions(ProposalDevelopmentDocument document, Person user, ProposalPerson proposalPerson) {
        return this.getProposalDevelopmentPermissionsService().hasCertificationPermissions(document, user, proposalPerson);
    }

    public boolean canSaveCertificationForPerson(ProposalDevelopmentDocument document, Person user, ProposalPerson proposalPerson) {
        return this.isProposalStateEditableForCertification(document.getDevelopmentProposal()) && this.hasCertificationPermissions(document, user, proposalPerson);
    }

    protected boolean canSaveCertification(ProposalDevelopmentDocument document, Person user) {
        boolean hasSaveCertificationPermission;
        String saveCertificationCacheKey;
        DevelopmentProposal proposal = document.getDevelopmentProposal();
        DocumentRequestAuthorizationCache documentRequestAuthorizationCache = this.getDocumentRequestAuthorizationCache(document);
        if (documentRequestAuthorizationCache.hasPermissionResult(saveCertificationCacheKey = this.buildPermissionCacheKey(document, user, SAVE_CERTIFICATION))) {
            hasSaveCertificationPermission = documentRequestAuthorizationCache.getPermissionResult(saveCertificationCacheKey);
        } else {
            boolean bl = hasSaveCertificationPermission = this.isProposalStateEditableForCertification(document.getDevelopmentProposal()) && document.getDevelopmentProposal().getProposalPersons().stream().filter(person -> this.getProposalDevelopmentPermissionsService().hasCertificationPermissions(document, user, (ProposalPerson)person)).anyMatch(person -> true);
        }
        if (proposal.isChild() && hasSaveCertificationPermission) {
            BudgetParentDocument<DevelopmentProposal> parent = proposal.getParent().getDocument();
            String parentResultCacheKey = this.buildPermissionCacheKey((Document)parent, user, SAVE_CERTIFICATION);
            documentRequestAuthorizationCache.getPermissionResultCache().remove(parentResultCacheKey);
            hasSaveCertificationPermission = this.canSaveCertification((ProposalDevelopmentDocument)parent, user);
        }
        documentRequestAuthorizationCache.addPermissionResult(saveCertificationCacheKey, hasSaveCertificationPermission);
        return hasSaveCertificationPermission;
    }

    protected boolean canViewCertification(ProposalDevelopmentDocument document, Person user) {
        return this.getKcAuthorizationService().hasPermission(user.getPrincipalId(), document, "View Certification");
    }

    public boolean isProposalStateEditableForCertification(DevelopmentProposal proposal) {
        return this.getProposalStatesEditableForCertification().contains(proposal.getProposalStateTypeCode());
    }

    protected Set<String> getProposalStatesEditableForCertification() {
        HashSet<String> proposalStates = new HashSet<String>();
        if (this.isCertificationRequiredOnlyBeforeApproval()) {
            proposalStates.add("1");
            proposalStates.add("12");
            proposalStates.add("5");
            proposalStates.add("2");
        } else {
            proposalStates.add("1");
            proposalStates.add("12");
        }
        return proposalStates;
    }

    public boolean hasProposalPersonApproved(ProposalDevelopmentDocument document, ProposalPerson proposalPerson) {
        String personId = proposalPerson.getPersonId();
        boolean proposalPersonApprovedDocument = Boolean.FALSE;
        boolean personIsInRouteLog = Boolean.FALSE;
        List<ActionTaken> actionsTaken = this.getActionsTaken(document);
        if (personId != null) {
            proposalPersonApprovedDocument = actionsTaken.stream().anyMatch(actionTaken -> "A".equalsIgnoreCase(actionTaken.getActionTaken().getCode()) && personId.equalsIgnoreCase(actionTaken.getPrincipalId()));
            List<String> principalIdsInRouteLog = this.getPrincipalIdsInRouteLog(document);
            personIsInRouteLog = principalIdsInRouteLog.stream().anyMatch(ids -> ids.equalsIgnoreCase(personId));
        }
        return proposalPersonApprovedDocument || !personIsInRouteLog && this.piApprovedDocument(document);
    }

    private boolean piApprovedDocument(ProposalDevelopmentDocument document) {
        ProposalPerson principalInvestigator = document.getDevelopmentProposal().getPrincipalInvestigator();
        if (principalInvestigator == null) {
            return false;
        }
        String principalInvestigatorId = principalInvestigator.getPersonId() == null ? principalInvestigator.getRolodexId().toString() : principalInvestigator.getPersonId();
        List<ActionTaken> actionsTaken = this.getActionsTaken(document);
        return actionsTaken.stream().anyMatch(actionTaken -> "A".equalsIgnoreCase(actionTaken.getActionTaken().getCode()) && principalInvestigatorId.equalsIgnoreCase(actionTaken.getPrincipalId()));
    }

    protected List<ActionTaken> getActionsTaken(ProposalDevelopmentDocument document) {
        return document.getDocumentHeader().getWorkflowDocument().getActionsTaken();
    }

    protected List<String> getPrincipalIdsInRouteLog(ProposalDevelopmentDocument document) {
        return this.getWorkflowDocumentActionsService().getPrincipalIdsInRouteLog(document.getDocumentNumber(), true);
    }

    public WorkflowDocumentActionsService getWorkflowDocumentActionsService() {
        return (WorkflowDocumentActionsService)KcServiceLocator.getService("workflowDocumentActionsService");
    }

    protected boolean isCertificationRequiredOnlyBeforeApproval() {
        String keyPersonCertDefferalParam = ProposalDevelopmentUtils.getProposalDevelopmentDocumentParameter(ProposalDevelopmentUtils.KEY_PERSON_CERTIFICATION_DEFERRAL_PARM);
        return keyPersonCertDefferalParam.equalsIgnoreCase("BA");
    }

    protected boolean isAuthorizedToReplaceNarrative(Narrative narrative, Person user) {
        ProposalDevelopmentDocument pdDocument = (ProposalDevelopmentDocument)narrative.getDevelopmentProposal().getDocument();
        boolean hasPermission = false;
        if (!pdDocument.getDevelopmentProposal().getSubmitFlag().booleanValue() && this.getModifyNarrativePermission(pdDocument, user)) {
            hasPermission = this.hasNarrativeRight(user.getPrincipalId(), narrative, NarrativeRight.MODIFY_NARRATIVE_RIGHT) || this.isAuthorizedToAlterProposalData(pdDocument, user);
        }
        return hasPermission;
    }

    protected boolean isAuthorizedToModifyNarrative(Narrative narrative, Person user) {
        ProposalDevelopmentDocument pdDocument = (ProposalDevelopmentDocument)narrative.getDevelopmentProposal().getDocument();
        boolean rejectedDocument = this.getKcDocumentRejectionService().isDocumentOnInitialNode(pdDocument.getDocumentHeader().getWorkflowDocument());
        boolean hasPermission = false;
        boolean inWorkflow = this.getKcWorkflowService().isInWorkflow(pdDocument);
        if (!(inWorkflow && !rejectedDocument || pdDocument.getDevelopmentProposal().getSubmitFlag().booleanValue())) {
            hasPermission = this.getModifyNarrativePermission(pdDocument, user);
        } else if (inWorkflow && !rejectedDocument && !pdDocument.getDevelopmentProposal().getSubmitFlag().booleanValue() && this.getModifyNarrativePermission(pdDocument, user)) {
            hasPermission = this.getModifyNarrativePermission(pdDocument, user);
        }
        return hasPermission;
    }

    protected boolean isAuthorizedToViewNarrative(Narrative narrative, Person user) {
        ProposalDevelopmentDocument pdDocument = (ProposalDevelopmentDocument)narrative.getDevelopmentProposal().getDocument();
        boolean hasPermission = false;
        if (this.getKcAuthorizationService().hasPermission(user.getPrincipalId(), pdDocument, "View Narratives")) {
            boolean bl = hasPermission = this.hasNarrativeRight(user.getPrincipalId(), narrative, NarrativeRight.VIEW_NARRATIVE_RIGHT) || this.hasNarrativeRight(user.getPrincipalId(), narrative, NarrativeRight.MODIFY_NARRATIVE_RIGHT);
        }
        if (!hasPermission) {
            hasPermission = this.getUnitAuthorizationService().hasPermission(user.getPrincipalId(), pdDocument.getDevelopmentProposal().getOwnedByUnitNumber(), "KC-PD", "View Narratives") || this.getKcWorkflowService().hasWorkflowPermission(user.getPrincipalId(), pdDocument);
        }
        return hasPermission;
    }

    public boolean isAuthorizedToDeleteNarrative(Narrative narrative, Person user) {
        ProposalDevelopmentDocument pdDocument = (ProposalDevelopmentDocument)narrative.getDevelopmentProposal().getDocument();
        KcDocumentRejectionService documentRejectionService = this.getKcDocumentRejectionService();
        boolean rejectedDocument = documentRejectionService.isDocumentOnInitialNode(pdDocument.getDocumentHeader().getWorkflowDocument());
        boolean hasPermission = false;
        boolean inWorkflow = this.getKcWorkflowService().isInWorkflow(pdDocument);
        if ((!inWorkflow || rejectedDocument) && !pdDocument.getDevelopmentProposal().getSubmitFlag().booleanValue() && this.getModifyNarrativePermission(pdDocument, user)) {
            hasPermission = this.hasNarrativeRight(user.getPrincipalId(), narrative, NarrativeRight.MODIFY_NARRATIVE_RIGHT);
        }
        return hasPermission;
    }

    protected final boolean hasNarrativeRight(String userId, Narrative narrative, NarrativeRight narrativeRight) {
        List<NarrativeUserRights> userRightsList = narrative.getNarrativeUserRights();
        for (NarrativeUserRights userRights : userRightsList) {
            if (!StringUtils.equals((CharSequence)userId, (CharSequence)userRights.getUserId()) || !StringUtils.equals((CharSequence)userRights.getAccessType(), (CharSequence)narrativeRight.getAccessType())) continue;
            return true;
        }
        return false;
    }

    protected boolean isAuthorizedToModifyBudget(Document document, Person user) {
        String modifyBudgetCacheKey;
        ProposalDevelopmentDocument pdDocument = (ProposalDevelopmentDocument)document;
        DevelopmentProposal proposal = pdDocument.getDevelopmentProposal();
        DocumentRequestAuthorizationCache documentRequestAuthorizationCache = this.getDocumentRequestAuthorizationCache(pdDocument);
        boolean hasModifyBudgetPermission = documentRequestAuthorizationCache.hasPermissionResult(modifyBudgetCacheKey = this.buildPermissionCacheKey(pdDocument, user, MODIFY_BUDGET)) ? documentRequestAuthorizationCache.getPermissionResult(modifyBudgetCacheKey).booleanValue() : this.getKcAuthorizationService().hasPermission(user.getPrincipalId(), pdDocument, "Modify Budget");
        boolean rejectedDocument = this.getKcDocumentRejectionService().isDocumentOnInitialNode(pdDocument.getDocumentHeader().getWorkflowDocument());
        boolean bl = hasModifyBudgetPermission = (!this.getKcWorkflowService().isInWorkflow(pdDocument) || rejectedDocument) && hasModifyBudgetPermission;
        if (proposal.isChild() && !hasModifyBudgetPermission) {
            BudgetParentDocument<DevelopmentProposal> parent = proposal.getParent().getDocument();
            String parentResultCacheKey = this.buildPermissionCacheKey((Document)parent, user, MODIFY_BUDGET);
            documentRequestAuthorizationCache.getPermissionResultCache().remove(parentResultCacheKey);
            hasModifyBudgetPermission = this.isAuthorizedToModifyBudget((Document)parent, user);
        }
        documentRequestAuthorizationCache.addPermissionResult(modifyBudgetCacheKey, hasModifyBudgetPermission);
        return hasModifyBudgetPermission;
    }

    Boolean getCachedPermissionResult(Document document, String permissionCacheKey) {
        DocumentRequestAuthorizationCache documentRequestAuthorizationCache = this.getDocumentRequestAuthorizationCache(document);
        if (documentRequestAuthorizationCache.hasPermissionResult(permissionCacheKey)) {
            return documentRequestAuthorizationCache.getPermissionResult(permissionCacheKey);
        }
        return null;
    }

    void addCachedPermissionResult(Document document, String permissionCacheKey, boolean result) {
        DocumentRequestAuthorizationCache documentRequestAuthorizationCache = this.getDocumentRequestAuthorizationCache(document);
        documentRequestAuthorizationCache.addPermissionResult(permissionCacheKey, result);
    }

    String buildPermissionCacheKey(Document document, Person user, String permissionCacheName) {
        return permissionCacheName + CACHE_KEY_SEPARATOR + document.getDocumentNumber() + CACHE_KEY_SEPARATOR + user.getPrincipalId();
    }

    protected boolean hasModifyS2sEnroutePermission(Document document, Person user) {
        ProposalDevelopmentDocument pdDocument;
        boolean hasS2sPermission;
        DocumentRequestAuthorizationCache documentRequestAuthorizationCache = this.getDocumentRequestAuthorizationCache(document);
        String cacheKey = this.buildPermissionCacheKey(document, user, "Modify Proposal Development S2s While Enroute");
        Boolean cachedResult = this.getCachedPermissionResult(document, cacheKey);
        if (cachedResult != null) {
            hasS2sPermission = cachedResult;
        } else {
            pdDocument = (ProposalDevelopmentDocument)document;
            hasS2sPermission = this.getKcAuthorizationService().hasPermission(user.getPrincipalId(), pdDocument, "Modify Proposal Development S2s While Enroute");
        }
        pdDocument = (ProposalDevelopmentDocument)document;
        DevelopmentProposal proposal = pdDocument.getDevelopmentProposal();
        if (proposal.isChild() && hasS2sPermission) {
            BudgetParentDocument<DevelopmentProposal> parent = proposal.getParent().getDocument();
            String parentResultCacheKey = this.buildPermissionCacheKey((Document)parent, user, "Modify Proposal Development S2s While Enroute");
            documentRequestAuthorizationCache.getPermissionResultCache().remove(parentResultCacheKey);
            hasS2sPermission = this.isAuthorizedToModifyBudget((Document)parent, user);
        }
        this.addCachedPermissionResult(document, cacheKey, hasS2sPermission);
        return hasS2sPermission;
    }

    protected boolean isAuthorizedToOpenBudget(Document document, Person user) {
        ProposalDevelopmentDocument pdDocument = (ProposalDevelopmentDocument)document;
        return this.getKcAuthorizationService().hasPermission(user.getPrincipalId(), pdDocument, "View Budget") || this.getKcWorkflowService().isInWorkflow(pdDocument) && this.getKcWorkflowService().hasWorkflowPermission(user.getPrincipalId(), pdDocument);
    }

    protected boolean isAuthorizedToAddBudget(Document document, Person user) {
        ProposalDevelopmentDocument pdDocument = (ProposalDevelopmentDocument)document;
        boolean rejectedDocument = this.getKcDocumentRejectionService().isDocumentOnInitialNode(pdDocument.getDocumentHeader().getWorkflowDocument());
        return (!this.getKcWorkflowService().isInWorkflow(pdDocument) || rejectedDocument) && !pdDocument.isViewOnly() && pdDocument.getDevelopmentProposal().getSubmitFlag() == false && !pdDocument.getDevelopmentProposal().isParent();
    }

    protected boolean isAuthorizedToAddNarrative(Document document, Person user) {
        ProposalDevelopmentDocument pdDocument = (ProposalDevelopmentDocument)document;
        boolean rejectedDocument = this.getKcDocumentRejectionService().isDocumentOnInitialNode(pdDocument.getDocumentHeader().getWorkflowDocument());
        boolean hasPermission = false;
        if (!(this.getKcWorkflowService().isInWorkflow(pdDocument) && !rejectedDocument || pdDocument.isViewOnly() || pdDocument.getDevelopmentProposal().getSubmitFlag().booleanValue())) {
            hasPermission = this.getModifyNarrativePermission(pdDocument, user);
        }
        return hasPermission;
    }

    protected boolean isAuthorizedToReplaceNarrative(Document document, Person user) {
        ProposalDevelopmentDocument pdDocument = (ProposalDevelopmentDocument)document;
        boolean hasPermission = false;
        if (!pdDocument.getDevelopmentProposal().getSubmitFlag().booleanValue() && pdDocument.getDocumentHeader().getWorkflowDocument().isEnroute()) {
            hasPermission = this.getModifyNarrativePermission(pdDocument, user) || this.isAuthorizedToAlterProposalData(document, user);
        }
        return hasPermission;
    }

    protected boolean isAuthorizedToModifyS2sOverride(Document document, Person user) {
        ProposalDevelopmentDocument pdDocument = (ProposalDevelopmentDocument)document;
        boolean hasNotBeenSubmittedToS2s = pdDocument.getDevelopmentProposal().hasS2sOpportunity() && (pdDocument.getDevelopmentProposal().getS2sAppSubmission() == null || pdDocument.getDevelopmentProposal().getS2sAppSubmission().size() == 0);
        return this.hasModifyS2sOverridePermission((ProposalDevelopmentDocument)document, user) && hasNotBeenSubmittedToS2s;
    }

    protected boolean isAuthorizedToCertify(Document document, Person user) {
        ProposalDevelopmentDocument pdDocument = (ProposalDevelopmentDocument)document;
        return this.getKcAuthorizationService().hasPermission(user.getPrincipalId(), pdDocument, "Certify");
    }

    protected boolean isAuthorizedToCopyProposal(Document document, Person user) {
        return this.getUnitAuthorizationService().hasPermission(user.getPrincipalId(), "KC-PD", "Create ProposalDevelopmentDocument");
    }

    protected boolean isAuthorizedToReplacePersonnelAttachement(Document document, Person user) {
        ProposalDevelopmentDocument pdDocument = (ProposalDevelopmentDocument)document;
        return this.getModifyNarrativePermission(pdDocument, user) || this.isAuthorizedToAlterProposalData(document, user);
    }

    protected boolean isAuthorizedToRecallProposal(Document document, Person user) {
        ProposalDevelopmentDocument pdDocument = (ProposalDevelopmentDocument)document;
        return pdDocument.getDocumentHeader().hasWorkflowDocument() && pdDocument.getDocumentHeader().getWorkflowDocument().isEnroute() && this.getKcAuthorizationService().hasPermission(user.getPrincipalId(), pdDocument, "Recall Document") && !this.isRevisionRequested(pdDocument.getDevelopmentProposal().getProposalStateTypeCode());
    }

    protected boolean isRevisionRequested(String code) {
        return StringUtils.equalsIgnoreCase((CharSequence)code, (CharSequence)"12");
    }

    protected boolean isAuthorizedToRejectProposal(Document document, Person user) {
        ProposalDevelopmentDocument pdDocument = (ProposalDevelopmentDocument)document;
        DocumentRequestAuthorizationCache.WorkflowDocumentInfo workflowDocumentInfo = this.getDocumentRequestAuthorizationCache(document).getWorkflowDocumentInfo();
        return (!workflowDocumentInfo.isCompletionRequested() && workflowDocumentInfo.isApprovalRequested() || this.canReject(user)) && !this.getKcDocumentRejectionService().isDocumentOnInitialNode(pdDocument.getDocumentHeader().getWorkflowDocument()) && workflowDocumentInfo.isEnroute() && this.isSubmittedToSponsor(document) == false;
    }

    protected boolean canReject(Person user) {
        return ProposalDevelopmentDocumentAuthorizer.getPermissionService().hasPermission(user.getPrincipalId(), "KC-PD", "Return ProposalDevelopmentDocument");
    }

    protected boolean isAuthorizedToSubmitToWorkflow(Document document, Person user) {
        ProposalDevelopmentDocument pdDocument = (ProposalDevelopmentDocument)document;
        return !this.getKcWorkflowService().isInWorkflow(pdDocument) && this.getKcAuthorizationService().hasPermission(user.getPrincipalId(), pdDocument, "Submit ProposalDevelopmentDocument") && !pdDocument.getDevelopmentProposal().isChild();
    }

    protected boolean isAuthorizedToHierarchyChildWorkflowAction(Document document, Person user) {
        boolean authorized = true;
        ProposalDevelopmentDocument pdDocument = (ProposalDevelopmentDocument)document;
        if (pdDocument.getDevelopmentProposal().isChild()) {
            try {
                WorkflowDocument parentWDoc = this.getProposalHierarchyService().getParentWorkflowDocument(pdDocument);
                if (!parentWDoc.isInitiated()) {
                    authorized = false;
                }
            }
            catch (ProposalHierarchyException e) {
                LOG.error(String.format("Could not find parent workflow document for proposal document number:%s, which claims to be a child. Returning false.", pdDocument.getDocumentHeader().getDocumentNumber()), (Throwable)e);
                authorized = false;
            }
        }
        return authorized;
    }

    protected boolean isAuthorizedToHierarchyChildAckWorkflowAction(Document document, Person user) {
        boolean authorized = true;
        ProposalDevelopmentDocument pdDocument = (ProposalDevelopmentDocument)document;
        if (pdDocument.getDevelopmentProposal().isChild()) {
            try {
                WorkflowDocument parentWDoc = this.getProposalHierarchyService().getParentWorkflowDocument(pdDocument);
                if (!parentWDoc.isAcknowledgeRequested() || parentWDoc.isInitiated()) {
                    authorized = false;
                }
            }
            catch (ProposalHierarchyException e) {
                LOG.error(String.format("Could not find parent workflow document for proposal document number:%s, which claims to be a child. Returning false.", pdDocument.getDocumentHeader().getDocumentNumber()), (Throwable)e);
                authorized = false;
            }
        }
        return authorized;
    }

    protected boolean isAuthorizedToMaintainProposalHierarchy(Document document, Person user) {
        String cacheKey;
        ProposalDevelopmentDocument pdDocument = (ProposalDevelopmentDocument)document;
        DevelopmentProposal proposal = pdDocument.getDevelopmentProposal();
        DocumentRequestAuthorizationCache documentRequestAuthorizationCache = this.getDocumentRequestAuthorizationCache(pdDocument);
        boolean hasMaintainProposalHierarchyPermission = documentRequestAuthorizationCache.hasPermissionResult(cacheKey = this.buildPermissionCacheKey(pdDocument, user, "Maintain ProposalHierarchy")) ? documentRequestAuthorizationCache.getPermissionResult(cacheKey).booleanValue() : this.getKcAuthorizationService().hasPermission(user.getPrincipalId(), pdDocument, "Maintain ProposalHierarchy");
        if (proposal.isChild() && hasMaintainProposalHierarchyPermission) {
            BudgetParentDocument<DevelopmentProposal> parent = proposal.getParent().getDocument();
            String parentResultCacheKey = this.buildPermissionCacheKey((Document)parent, user, "Maintain ProposalHierarchy");
            documentRequestAuthorizationCache.getPermissionResultCache().remove(parentResultCacheKey);
            hasMaintainProposalHierarchyPermission = this.isAuthorizedToModifyBudget((Document)parent, user);
        }
        documentRequestAuthorizationCache.addPermissionResult(cacheKey, hasMaintainProposalHierarchyPermission);
        return hasMaintainProposalHierarchyPermission;
    }

    protected boolean isAuthorizedToAlterProposalData(Document document, Person user) {
        ProposalDevelopmentDocument pdDocument = (ProposalDevelopmentDocument)document;
        boolean ret = true;
        if (pdDocument.getDevelopmentProposal().isChild()) {
            try {
                if (this.getProposalHierarchyService().getParentWorkflowDocument(pdDocument).isEnroute()) {
                    ret = false;
                }
            }
            catch (ProposalHierarchyException e) {
                LOG.error(String.format("Exception looking up parent of DevelopmentProposal %s, authorizer is going to deny edit access to this child.", pdDocument.getDevelopmentProposal().getProposalNumber()), (Throwable)e);
                ret = false;
            }
        }
        if (ret) {
            ret = this.getKcWorkflowService().isEnRoute(pdDocument) && pdDocument.getDevelopmentProposal().getSubmitFlag() == false && this.getKcAuthorizationService().hasPermission(user.getPrincipalId(), pdDocument, "Alter Proposal Data");
        }
        return ret;
    }

    protected boolean isAuthorizedToShowAlterProposalData(Document document, Person user) {
        return this.getKcWorkflowService().isInWorkflow(document);
    }

    protected boolean isAuthorizedToModifyProposalRoles(Document document, Person user) {
        return this.hasFullAuthorization(document, user) || this.hasAddViewerAuthorization(document, user);
    }

    protected boolean getModifyNarrativePermission(ProposalDevelopmentDocument document, Person user) {
        boolean hasModifyNarrativePermission;
        String modifyNarrativeCacheKey;
        DocumentRequestAuthorizationCache documentRequestAuthorizationCache = this.getDocumentRequestAuthorizationCache(document);
        if (documentRequestAuthorizationCache.hasPermissionResult(modifyNarrativeCacheKey = this.buildPermissionCacheKey(document, user, MODIFY_NARRATIVE_CACHE_KEY_PREFIX))) {
            hasModifyNarrativePermission = documentRequestAuthorizationCache.getPermissionResult(modifyNarrativeCacheKey);
        } else {
            hasModifyNarrativePermission = this.getKcAuthorizationService().hasPermission(user.getPrincipalId(), document, "Modify Narrative");
            documentRequestAuthorizationCache.addPermissionResult(modifyNarrativeCacheKey, hasModifyNarrativePermission);
        }
        if (!hasModifyNarrativePermission) {
            hasModifyNarrativePermission = document.getDevelopmentProposal().getSubmitFlag() == false && document.getDocumentHeader().getWorkflowDocument().isEnroute() && this.getKcAuthorizationService().hasPermission(user.getPrincipalId(), document, "Alter Proposal Data");
            documentRequestAuthorizationCache.addPermissionResult(modifyNarrativeCacheKey, hasModifyNarrativePermission);
        }
        return hasModifyNarrativePermission;
    }

    protected boolean hasModifyS2sOverridePermission(ProposalDevelopmentDocument document, Person user) {
        boolean hasModifyS2sOverridePermission;
        String modifyS2sOverrideCacheKey;
        DocumentRequestAuthorizationCache documentRequestAuthorizationCache = this.getDocumentRequestAuthorizationCache(document);
        if (documentRequestAuthorizationCache.hasPermissionResult(modifyS2sOverrideCacheKey = this.buildPermissionCacheKey(document, user, "Modify S2S Override"))) {
            hasModifyS2sOverridePermission = documentRequestAuthorizationCache.getPermissionResult(modifyS2sOverrideCacheKey);
        } else {
            hasModifyS2sOverridePermission = this.getKcAuthorizationService().hasPermission(user.getPrincipalId(), document, "Modify S2S Override");
            documentRequestAuthorizationCache.addPermissionResult(modifyS2sOverrideCacheKey, hasModifyS2sOverridePermission);
        }
        if (!hasModifyS2sOverridePermission) {
            hasModifyS2sOverridePermission = document.getDevelopmentProposal().getSubmitFlag() == false && document.getDocumentHeader().getWorkflowDocument().isEnroute() && this.getKcAuthorizationService().hasPermission(user.getPrincipalId(), document, "Alter Proposal Data");
            documentRequestAuthorizationCache.addPermissionResult(modifyS2sOverrideCacheKey, hasModifyS2sOverridePermission);
        }
        return hasModifyS2sOverridePermission;
    }

    protected boolean hasFullAuthorization(Document document, Person user) {
        ProposalDevelopmentDocument pdDocument = (ProposalDevelopmentDocument)document;
        return !pdDocument.isViewOnly() && this.getKcAuthorizationService().hasPermission(user.getPrincipalId(), pdDocument, "Modify ProposalPermissions") && !this.getKcWorkflowService().isInWorkflow(pdDocument) && pdDocument.getDevelopmentProposal().getSubmitFlag() == false;
    }

    protected boolean hasAddViewerAuthorization(Document document, Person user) {
        boolean hasPermission = false;
        ProposalDevelopmentDocument pdDocument = (ProposalDevelopmentDocument)document;
        if (this.getKcAuthorizationService().hasPermission(user.getPrincipalId(), pdDocument, "Add Proposal Viewer") && this.getKcWorkflowService().isInWorkflow(pdDocument)) {
            hasPermission = true;
        } else if (this.getKcWorkflowService().isEnRoute(pdDocument) && this.getKcWorkflowService().hasWorkflowPermission(user.getPrincipalId(), pdDocument)) {
            hasPermission = true;
        }
        return hasPermission;
    }

    protected boolean isAuthorizedToCreate(Document document, Person user) {
        return this.getUnitAuthorizationService().hasPermission(user.getPrincipalId(), "KC-PD", "Create ProposalDevelopmentDocument");
    }

    protected boolean isAuthorizedToSubmitToSponsor(Document document, Person user) {
        ProposalDevelopmentDocument pdDocument = (ProposalDevelopmentDocument)document;
        return this.getKcAuthorizationService().hasPermission(user.getPrincipalId(), pdDocument, "Submit to Sponsor") && !pdDocument.getDevelopmentProposal().isChild();
    }

    public boolean isAuthorizedToPrint(Document document, Person user) {
        ProposalDevelopmentDocument pdDocument = (ProposalDevelopmentDocument)document;
        return this.getKcAuthorizationService().hasPermission(user.getPrincipalId(), pdDocument, "Print Proposal") || this.getKcWorkflowService().isInWorkflow(pdDocument) && this.getKcWorkflowService().hasWorkflowPermission(user.getPrincipalId(), pdDocument);
    }

    protected boolean isAuthorizedToView(Document document, Person user) {
        ProposalDevelopmentDocument pdDocument = (ProposalDevelopmentDocument)document;
        return this.getKcAuthorizationService().hasPermission(user.getPrincipalId(), pdDocument, "View Proposal") || this.getKcWorkflowService().hasWorkflowPermission(user.getPrincipalId(), pdDocument);
    }

    protected boolean isAuthorizedToModifyS2s(Document document, Person user) {
        ProposalDevelopmentDocument pdDocument = (ProposalDevelopmentDocument)document;
        return this.canEdit(document, user) || this.hasModifyS2sEnroutePermission(document, user) && (pdDocument.getDevelopmentProposal().getS2sAppSubmission() == null || pdDocument.getDevelopmentProposal().getS2sAppSubmission().size() == 0);
    }

    protected boolean isAuthorizedToAddNote(Document document, Person user) {
        ProposalDevelopmentDocument pdDocument = (ProposalDevelopmentDocument)document;
        String proposalNbr = pdDocument.getDevelopmentProposal().getProposalNumber();
        boolean hasPermission = proposalNbr == null ? this.hasPermissionByOwnedByUnit(document, user) : this.getKcAuthorizationService().hasPermission(user.getPrincipalId(), pdDocument, "View Proposal") || this.getKcWorkflowService().hasWorkflowPermission(user.getPrincipalId(), document);
        return hasPermission;
    }

    protected boolean isAuthorizedToAddAddressBook(Document doc, Person user) {
        return ProposalDevelopmentDocumentAuthorizer.getPermissionService().hasPermissionByTemplate(user.getPrincipalId(), "KR-SYS", "Initiate Document", Map.of("documentTypeName", "RolodexMaintenanceDocument"));
    }

    protected boolean isAuthorizedToModify(Document document, Person user) {
        boolean hasPermission;
        String resultCacheKey;
        DocumentRequestAuthorizationCache documentRequestAuthorizationCache = this.getDocumentRequestAuthorizationCache(document);
        if (documentRequestAuthorizationCache.hasPermissionResult(resultCacheKey = this.buildPermissionCacheKey(document, user, IS_AUTHORIZED_TO_MODIFY))) {
            return documentRequestAuthorizationCache.getPermissionResult(resultCacheKey);
        }
        ProposalDevelopmentDocument pdDocument = (ProposalDevelopmentDocument)document;
        DevelopmentProposal proposal = pdDocument.getDevelopmentProposal();
        if (!this.isEditableState(proposal.getProposalStateTypeCode())) {
            return false;
        }
        String proposalNbr = proposal.getProposalNumber();
        if (proposalNbr == null) {
            hasPermission = this.hasPermissionByOwnedByUnit(document, user);
        } else {
            boolean hasBeenRejected = "12".equals(proposal.getProposalStateTypeCode());
            boolean bl = hasPermission = !pdDocument.isViewOnly() && this.getKcAuthorizationService().hasPermission(user.getPrincipalId(), pdDocument, "Modify ProposalDevelopmentDocument") && (!this.getKcWorkflowService().isInWorkflow(document) || hasBeenRejected) && proposal.getSubmitFlag() == false;
        }
        if (proposal.isChild() && !hasPermission) {
            BudgetParentDocument<DevelopmentProposal> parent = proposal.getParent().getDocument();
            String parentResultCacheKey = this.buildPermissionCacheKey((Document)parent, user, IS_AUTHORIZED_TO_MODIFY);
            documentRequestAuthorizationCache.getPermissionResultCache().remove(parentResultCacheKey);
            hasPermission = this.isAuthorizedToModify((Document)parent, user);
        }
        documentRequestAuthorizationCache.addPermissionResult(resultCacheKey, hasPermission);
        return hasPermission;
    }

    protected boolean hasPermissionByOwnedByUnit(Document document, Person user) {
        ProposalDevelopmentDocument pdDocument = (ProposalDevelopmentDocument)document;
        DevelopmentProposal proposal = pdDocument.getDevelopmentProposal();
        String unitNumber = proposal.getOwnedByUnitNumber();
        return unitNumber != null && this.getUnitAuthorizationService().hasPermission(user.getPrincipalId(), unitNumber, "KC-PD", "Create ProposalDevelopmentDocument") || unitNumber == null;
    }

    protected boolean isEditableState(String propsalState) {
        return !"10".equals(propsalState) && !"7".equals(propsalState);
    }

    protected boolean isAuthorizedToOverrideComplianceEntry(Document document, Person user) {
        ProposalDevelopmentDocument pdDocument = (ProposalDevelopmentDocument)document;
        return this.isApprovalPending(pdDocument.getDevelopmentProposal().getProposalStateTypeCode()) && this.getKcAuthorizationService().hasPermission(user.getPrincipalId(), pdDocument, "Override PD Compliance Entry");
    }

    protected boolean isApprovalPending(String propsalState) {
        return StringUtils.equalsIgnoreCase((CharSequence)propsalState, (CharSequence)"2");
    }

    public boolean isAuthorizedToMaintainPersonnelPrimeHomeUnits(ProposalDevelopmentDocument document, Person user) {
        return this.getKcAuthorizationService().hasPermission(user.getPrincipalId(), document, "Maintain Proposal Development Personnel Prime/Home Units");
    }

    public KcAuthorizationService getKcAuthorizationService() {
        if (this.kcAuthorizationService == null) {
            this.kcAuthorizationService = KcServiceLocator.getService(KcAuthorizationService.class);
        }
        return this.kcAuthorizationService;
    }

    public void setKcAuthorizationService(KcAuthorizationService kcAuthorizationService) {
        this.kcAuthorizationService = kcAuthorizationService;
    }

    public UnitAuthorizationService getUnitAuthorizationService() {
        if (this.unitAuthorizationService == null) {
            this.unitAuthorizationService = KcServiceLocator.getService(UnitAuthorizationService.class);
        }
        return this.unitAuthorizationService;
    }

    public void setUnitAuthorizationService(UnitAuthorizationService unitAuthorizationService) {
        this.unitAuthorizationService = unitAuthorizationService;
    }

    public KcWorkflowService getKcWorkflowService() {
        if (this.kcWorkflowService == null) {
            this.kcWorkflowService = KcServiceLocator.getService(KcWorkflowService.class);
        }
        return this.kcWorkflowService;
    }

    public void setKcWorkflowService(KcWorkflowService kcWorkflowService) {
        this.kcWorkflowService = kcWorkflowService;
    }

    public KcDocumentRejectionService getKcDocumentRejectionService() {
        if (this.kcDocumentRejectionService == null) {
            this.kcDocumentRejectionService = KcServiceLocator.getService(KcDocumentRejectionService.class);
        }
        return this.kcDocumentRejectionService;
    }

    public void setKcDocumentRejectionService(KcDocumentRejectionService kcDocumentRejectionService) {
        this.kcDocumentRejectionService = kcDocumentRejectionService;
    }

    protected ProposalHierarchyService getProposalHierarchyService() {
        if (this.proposalHierarchyService == null) {
            this.proposalHierarchyService = KcServiceLocator.getService(ProposalHierarchyService.class);
        }
        return this.proposalHierarchyService;
    }

    public void setProposalHierarchyService(ProposalHierarchyService proposalHierarchyService) {
        this.proposalHierarchyService = proposalHierarchyService;
    }

    public ProposalDevelopmentPermissionsService getProposalDevelopmentPermissionsService() {
        if (this.proposalDevelopmentPermissionsService == null) {
            this.proposalDevelopmentPermissionsService = KcServiceLocator.getService(ProposalDevelopmentPermissionsService.class);
        }
        return this.proposalDevelopmentPermissionsService;
    }

    public void setProposalDevelopmentPermissionsService(ProposalDevelopmentPermissionsService proposalDevelopmentPermissionsService) {
        this.proposalDevelopmentPermissionsService = proposalDevelopmentPermissionsService;
    }

    protected Boolean isSubmittedToSponsor(Document document) {
        return ((ProposalDevelopmentDocument)document).getDevelopmentProposal().getSubmitFlag();
    }
}

