/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.budget.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import javax.servlet.http.HttpServletResponse;
import org.kuali.coeus.common.budget.framework.calculator.BudgetCalculationService;
import org.kuali.coeus.common.budget.framework.core.AbstractBudget;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.BudgetAuditRuleEvent;
import org.kuali.coeus.common.budget.framework.core.BudgetSaveEvent;
import org.kuali.coeus.common.budget.framework.core.BudgetService;
import org.kuali.coeus.common.budget.framework.print.BudgetPrintService;
import org.kuali.coeus.common.budget.impl.print.BudgetPrintForm;
import org.kuali.coeus.common.framework.print.AttachmentDataSource;
import org.kuali.coeus.common.framework.ruleengine.KcBusinessRulesEngine;
import org.kuali.coeus.propdev.impl.budget.ProposalDevelopmentBudgetExt;
import org.kuali.coeus.propdev.impl.budget.core.ProposalAddBudgetVersionEvent;
import org.kuali.coeus.propdev.impl.budget.core.ProposalBudgetSharedControllerService;
import org.kuali.coeus.propdev.impl.budget.core.SelectableBudget;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.lock.ProposalBudgetLockService;
import org.kuali.coeus.sys.framework.controller.ControllerFileUtils;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.validation.Auditable;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.document.authorization.PessimisticLock;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.kuali.rice.krad.web.service.ModelAndViewService;
import org.kuali.rice.krad.web.service.RefreshControllerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.ModelAndView;

@Component(value="proposalBudgetSharedControllerService")
public class ProposalBudgetSharedControllerServiceImpl
implements ProposalBudgetSharedControllerService {
    private static final String BUDGET_SUMMARY_DIALOG_ID = "PropBudget-SummaryPage-Dialog";
    private static final String BUDGET_PRINT_FORMS_DIALOG_ID = "PropBudget-PrintForms-Dialog";
    private static final String BUDGET_PRINT_FORMS_REPORT_NAME = "Proposal Budget Reports";
    @Autowired
    @Qualifier(value="proposalBudgetService")
    private BudgetService budgetService;
    @Autowired
    @Qualifier(value="modelAndViewService")
    private ModelAndViewService modelAndViewService;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="kcBusinessRulesEngine")
    private KcBusinessRulesEngine kcBusinessRulesEngine;
    @Autowired
    @Qualifier(value="refreshControllerService")
    private RefreshControllerService refreshControllerService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;
    @Autowired
    @Qualifier(value="budgetPrintService")
    private BudgetPrintService budgetPrintService;
    @Autowired
    @Qualifier(value="budgetCalculationService")
    private BudgetCalculationService budgetCalculationService;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;
    @Autowired
    @Qualifier(value="proposalBudgetLockService")
    private ProposalBudgetLockService proposalBudgetLockService;

    @Override
    public ModelAndView addBudget(String budgetName, Boolean summaryBudget, Boolean modularBudget, DevelopmentProposal developmentProposal, UifFormBase form) throws Exception {
        ProposalDevelopmentBudgetExt budget = null;
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("modularBudgetFlag", modularBudget != null ? modularBudget : Boolean.FALSE);
        if (this.kcBusinessRulesEngine.applyRules(new ProposalAddBudgetVersionEvent("addBudgetDto", developmentProposal, budgetName)).booleanValue()) {
            budget = (ProposalDevelopmentBudgetExt)this.getBudgetService().addBudgetVersion(developmentProposal.getDocument(), budgetName, options);
        }
        if (budget != null) {
            Properties props = new Properties();
            props.put("methodToCall", "initiate");
            props.put("budgetId", budget.getBudgetId().toString());
            props.put("summaryBudget", summaryBudget.toString());
            props.put("auditActivated", String.valueOf(((Auditable)form).isAuditActivated()));
            return this.getModelAndViewService().performRedirect(form, "proposalBudget", props);
        }
        form.setAjaxReturnType(UifConstants.AjaxReturnTypes.UPDATECOMPONENT.getKey());
        form.setUpdateComponentId("PropDev-BudgetPage-NewBudgetDialog");
        return this.getModelAndViewService().getModelAndView(form);
    }

    @Override
    public ModelAndView copyBudget(String budgetName, Long originalBudgetId, Boolean allPeriods, DevelopmentProposal developmentProposal, UifFormBase form) throws Exception {
        AbstractBudget budget = null;
        if (this.kcBusinessRulesEngine.applyRules(new ProposalAddBudgetVersionEvent("copyBudgetDto", developmentProposal, budgetName)).booleanValue()) {
            ProposalDevelopmentBudgetExt originalBudget = (ProposalDevelopmentBudgetExt)this.getDataObjectService().findUnique(ProposalDevelopmentBudgetExt.class, QueryByCriteria.Builder.forAttribute((String)"budgetId", (Object)originalBudgetId).build());
            budget = (ProposalDevelopmentBudgetExt)this.getBudgetService().copyBudgetVersion(originalBudget, allPeriods == false);
        }
        if (budget != null) {
            budget.setName(budgetName);
            budget = (ProposalDevelopmentBudgetExt)this.getDataObjectService().save((Object)budget, new PersistenceOption[0]);
            Properties props = new Properties();
            props.put("methodToCall", "initiate");
            props.put("budgetId", budget.getBudgetId().toString());
            props.put("auditActivated", String.valueOf(((Auditable)form).isAuditActivated()));
            return this.getModelAndViewService().performRedirect(form, "proposalBudget", props);
        }
        form.setAjaxReturnType(UifConstants.AjaxReturnTypes.UPDATECOMPONENT.getKey());
        form.setUpdateComponentId("PropDev-BudgetPage-CopyBudgetDialog");
        return this.getModelAndViewService().getModelAndView(form);
    }

    @Override
    public ModelAndView openBudget(String budgetId, boolean viewOnly, UifFormBase form) throws Exception {
        if (this.getGlobalVariableService().getMessageMap().hasNoErrors()) {
            form.setDirtyForm(false);
            Properties props = new Properties();
            props.put("methodToCall", "start");
            props.put("budgetId", budgetId);
            props.put("viewOnly", String.valueOf(viewOnly));
            props.put("auditActivated", String.valueOf(((Auditable)form).isAuditActivated()));
            return this.getModelAndViewService().performRedirect(form, "proposalBudget", props);
        }
        form.setAjaxReturnType(UifConstants.AjaxReturnTypes.UPDATEPAGE.getKey());
        return this.getRefreshControllerService().refresh(form);
    }

    @Override
    public void markBudgetVersionStatus(ProposalDevelopmentBudgetExt budget, String status) {
        String budgetStatus = this.getParameterService().getParameterValueAsString(Budget.class, status);
        budget.setBudgetStatus(budgetStatus);
        this.getDataObjectService().wrap((Object)budget).fetchRelationship("budgetStatusDo");
        this.getDataObjectService().save((Object)budget, new PersistenceOption[0]);
    }

    @Override
    public boolean isBudgetLocked(int budgetVersion, List<PessimisticLock> locks, String errorPath) {
        Person user = this.getGlobalVariableService().getUserSession().getPerson();
        for (PessimisticLock lock : locks) {
            if (lock.isOwnedByUser(user) || !this.getProposalBudgetLockService().doesBudgetVersionMatchDescriptor(lock.getLockDescriptor(), budgetVersion)) continue;
            this.getGlobalVariableService().getMessageMap().putError(errorPath, "error.completeBudget.locked", new String[0]);
            return true;
        }
        return false;
    }

    @Override
    public ProposalDevelopmentBudgetExt getSelectedBudget(Long budgetId, List<ProposalDevelopmentBudgetExt> budgets) {
        for (ProposalDevelopmentBudgetExt curBudget : budgets) {
            if (!Objects.equals(budgetId, curBudget.getBudgetId())) continue;
            return curBudget;
        }
        return null;
    }

    @Override
    public boolean isAllowedToCompleteBudget(ProposalDevelopmentBudgetExt budget, String errorPath) {
        boolean isRulePassed = this.getKcBusinessRulesEngine().applyRules(new BudgetAuditRuleEvent(budget));
        isRulePassed &= this.getKcBusinessRulesEngine().applyRules(new BudgetSaveEvent(budget)).booleanValue();
        boolean isAuditRulePassed = this.getGlobalVariableService().getAuditErrorMap().entrySet().stream().noneMatch(entry -> ((AuditCluster)entry.getValue()).getCategory().equals("Error") && !((AuditCluster)entry.getValue()).getAuditErrorList().isEmpty());
        if (!isAuditRulePassed) {
            this.getGlobalVariableService().getMessageMap().putError(errorPath, "clear.audit.error.before.change.status.to.complete", new String[0]);
        }
        return isRulePassed;
    }

    @Override
    public <T extends UifFormBase> ModelAndView populateBudgetSummary(Long budgetId, List<ProposalDevelopmentBudgetExt> budgets, T form) throws Exception {
        ProposalDevelopmentBudgetExt selectedBudget = null;
        if (budgets != null) {
            for (ProposalDevelopmentBudgetExt curBudget : budgets) {
                if (!Objects.equals(budgetId, curBudget.getBudgetId())) continue;
                selectedBudget = curBudget;
            }
        }
        ((SelectableBudget)form).setSelectedBudget(selectedBudget);
        return this.getModelAndViewService().showDialog(BUDGET_SUMMARY_DIALOG_ID, true, form);
    }

    @Override
    public <T extends UifFormBase> ModelAndView populatePrintForms(Long budgetId, List<ProposalDevelopmentBudgetExt> budgets, T form) throws Exception {
        Budget selectedBudget = null;
        if (budgets != null) {
            for (ProposalDevelopmentBudgetExt curBudget : budgets) {
                if (!Objects.equals(budgetId, curBudget.getBudgetId())) continue;
                selectedBudget = curBudget;
            }
        }
        ((SelectableBudget)form).setSelectedBudget((ProposalDevelopmentBudgetExt)selectedBudget);
        if (selectedBudget.getBudgetPrintForms().isEmpty()) {
            this.getBudgetPrintService().populateBudgetPrintForms(selectedBudget);
        }
        return this.getModelAndViewService().showDialog(BUDGET_PRINT_FORMS_DIALOG_ID, true, form);
    }

    @Override
    public <T extends UifFormBase> ModelAndView printBudgetForms(ProposalDevelopmentBudgetExt selectedBudget, T form, HttpServletResponse response) throws Exception {
        ArrayList<BudgetPrintForm> selectedBudgetPrintForms = new ArrayList<BudgetPrintForm>();
        for (BudgetPrintForm selectedForm : selectedBudget.getBudgetPrintForms()) {
            if (!Boolean.TRUE.equals(selectedForm.getSelectToPrint())) continue;
            selectedBudgetPrintForms.add(selectedForm);
        }
        if (selectedBudgetPrintForms.size() > 0) {
            String reportName = selectedBudgetPrintForms.size() > 1 ? BUDGET_PRINT_FORMS_REPORT_NAME : ((BudgetPrintForm)selectedBudgetPrintForms.get(0)).getBudgetReportName();
            AttachmentDataSource dataStream = this.getBudgetPrintService().readBudgetSelectedPrintStreams(selectedBudget, selectedBudgetPrintForms, reportName);
            if (dataStream.getData() != null) {
                ControllerFileUtils.streamToResponse(dataStream, response);
                return null;
            }
        }
        return this.getModelAndViewService().getModelAndView(form);
    }

    public BudgetService getBudgetService() {
        return this.budgetService;
    }

    public void setBudgetService(BudgetService budgetService) {
        this.budgetService = budgetService;
    }

    public ModelAndViewService getModelAndViewService() {
        return this.modelAndViewService;
    }

    public void setModelAndViewService(ModelAndViewService modelAndViewService) {
        this.modelAndViewService = modelAndViewService;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public KcBusinessRulesEngine getKcBusinessRulesEngine() {
        return this.kcBusinessRulesEngine;
    }

    public void setKcBusinessRulesEngine(KcBusinessRulesEngine kcBusinessRulesEngine) {
        this.kcBusinessRulesEngine = kcBusinessRulesEngine;
    }

    public RefreshControllerService getRefreshControllerService() {
        return this.refreshControllerService;
    }

    public void setRefreshControllerService(RefreshControllerService refreshControllerService) {
        this.refreshControllerService = refreshControllerService;
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    public BudgetPrintService getBudgetPrintService() {
        return this.budgetPrintService;
    }

    public void setBudgetPrintService(BudgetPrintService budgetPrintService) {
        this.budgetPrintService = budgetPrintService;
    }

    public BudgetCalculationService getBudgetCalculationService() {
        return this.budgetCalculationService;
    }

    public void setBudgetCalculationService(BudgetCalculationService budgetCalculationService) {
        this.budgetCalculationService = budgetCalculationService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public ProposalBudgetLockService getProposalBudgetLockService() {
        return this.proposalBudgetLockService;
    }

    public void setProposalBudgetLockService(ProposalBudgetLockService proposalBudgetLockService) {
        this.proposalBudgetLockService = proposalBudgetLockService;
    }
}

