/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.graphql;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public final class GraphqlRequest {
    private final String query;
    private final Map<String, Object> variables;
    private final String operationName;

    private GraphqlRequest(Builder builder) {
        this.query = builder.query;
        this.variables = Collections.unmodifiableMap(builder.variables);
        this.operationName = builder.operationName;
    }

    public String getQuery() {
        return this.query;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GraphqlRequest)) {
            return false;
        }
        GraphqlRequest that = (GraphqlRequest)o;
        return Objects.equals(this.query, that.query) && Objects.equals(this.variables, that.variables) && Objects.equals(this.operationName, that.operationName);
    }

    public int hashCode() {
        return Objects.hash(this.query, this.variables, this.operationName);
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.JSON_STYLE);
    }

    public static final class Builder {
        private String query;
        private final Map<String, Object> variables = new HashMap<String, Object>();
        private String operationName;

        public Builder() {
        }

        public Builder(String query) {
            this.query = query;
        }

        public Builder query(String query) {
            this.query = query;
            return this;
        }

        public Builder variable(String name, Object value) {
            this.variables.put(name, value);
            return this;
        }

        public Builder variables(Map<String, Object> variables) {
            this.variables.putAll(variables);
            return this;
        }

        public Builder operationName(String operationName) {
            this.operationName = operationName;
            return this;
        }

        public GraphqlRequest build() {
            return new GraphqlRequest(this);
        }
    }
}

