/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.sponsor.Sponsor;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.AuditError;

public class AwardDetailsAndDatesAuditRule
implements DocumentAuditRule {
    public static final String SPONSOR_CODE = "document.awardList[0].sponsorCode";
    public static final String PRIME_SPONSOR_CODE = "document.awardList[0].primeSponsorCode";
    public static final String HOME_PAGE_AUDIT_ERRORS = "homePageAuditErrors";
    public static final String HOME_PAGE_AUDIT_WARNINGS = "homePageAuditWarnings";
    public static final String EFFECTIVE_DATE = "document.awardList[0].awardEffectiveDate";

    public boolean processRunAuditBusinessRules(Document document) {
        boolean valid = true;
        Award award = ((AwardDocument)document).getAward();
        valid &= this.validateSponsorCode(award.getSponsorCode(), SPONSOR_CODE, "error.award.sponsorCode");
        if (StringUtils.isNotEmpty((CharSequence)award.getPrimeSponsorCode())) {
            valid &= this.validateSponsorCode(award.getPrimeSponsorCode(), PRIME_SPONSOR_CODE, "error.award.primeSponsorCode");
        }
        this.validateAwardEffectiveDate(award.getAwardEffectiveDate());
        return valid;
    }

    protected void validateAwardEffectiveDate(Date awardEffectiveDate) {
        if (awardEffectiveDate == null) {
            this.getAuditErrors(HOME_PAGE_AUDIT_WARNINGS, "Warnings").add(new AuditError(EFFECTIVE_DATE, "warn.awardProjectStartDate.null", "home.anchorDetailsDates"));
        }
    }

    protected boolean validateSponsorCode(String sponsorCode, String errorKey, String messageKey) {
        if (!this.isValidSponsorCode(sponsorCode)) {
            this.getAuditErrors(HOME_PAGE_AUDIT_ERRORS, "Error").add(new AuditError(errorKey, messageKey, "home.anchorDetailsDates", new String[]{sponsorCode}));
            return false;
        }
        return true;
    }

    protected boolean isValidSponsorCode(String sponsorCode) {
        return this.getBusinessObjectService().countMatching(Sponsor.class, Collections.singletonMap("sponsorCode", sponsorCode)) > 0;
    }

    protected List<AuditError> getAuditErrors(String key, String severity) {
        if (!this.getGlobalVariableService().getAuditErrorMap().containsKey(key)) {
            this.getGlobalVariableService().getAuditErrorMap().put(key, new AuditCluster("Details & Dates", new ArrayList(), severity));
        }
        return this.getGlobalVariableService().getAuditErrorMap().get(key).getAuditErrorList();
    }

    private GlobalVariableService getGlobalVariableService() {
        return KcServiceLocator.getService(GlobalVariableService.class);
    }

    protected BusinessObjectService getBusinessObjectService() {
        return KcServiceLocator.getService(BusinessObjectService.class);
    }
}

