/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.home.fundingproposal;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardCommentFactory;
import org.kuali.kra.award.home.fundingproposal.FundingProposalMergeType;
import org.kuali.kra.award.home.fundingproposal.ProposalDataFeedCommandBase;
import org.kuali.kra.award.specialreview.AwardSpecialReview;
import org.kuali.kra.award.specialreview.AwardSpecialReviewExemption;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.specialreview.InstitutionalProposalSpecialReview;
import org.kuali.kra.institutionalproposal.specialreview.InstitutionalProposalSpecialReviewExemption;

class SpecialReviewDataFeedCommand
extends ProposalDataFeedCommandBase {
    private static final String SPECIAL_REVIEW_COMMENT_PATTERN = "Added Compliance entries from Proposal Number %s for Compliance #%d and Protocol #%s";

    public SpecialReviewDataFeedCommand(Award award, InstitutionalProposal proposal, FundingProposalMergeType mergeType) {
        super(award, proposal, mergeType);
    }

    @Override
    void performDataFeed() {
        if (this.mergeType != FundingProposalMergeType.NOCHANGE) {
            this.proposal.refreshReferenceObject("specialReviews");
            for (InstitutionalProposalSpecialReview ipSpecialReview : this.proposal.getSpecialReviews()) {
                this.copySpecialReview(this.award, this.proposal, ipSpecialReview);
            }
        }
    }

    private void addSpecialReviewComment(Award award, InstitutionalProposal proposal, AwardSpecialReview copiedSpecialReview) {
        String newComment = String.format(SPECIAL_REVIEW_COMMENT_PATTERN, proposal.getProposalNumber(), copiedSpecialReview.getSpecialReviewNumber(), copiedSpecialReview.getProtocolNumber());
        this.appendComments(this.findOrCreateCommentOfSpecifiedType(new AwardCommentFactory().createSpecialReviewComment()), newComment);
    }

    private void copySpecialReview(Award award, InstitutionalProposal proposal, InstitutionalProposalSpecialReview ipSpecialReview) {
        AwardSpecialReview copiedSpecialReview = this.copySpecialReview(ipSpecialReview);
        award.add(copiedSpecialReview);
        this.addSpecialReviewComment(award, proposal, copiedSpecialReview);
    }

    private AwardSpecialReview copySpecialReview(InstitutionalProposalSpecialReview ipSpecialReview) {
        AwardSpecialReview copiedSpecialReview = new AwardSpecialReview();
        copiedSpecialReview.setApplicationDate(ipSpecialReview.getApplicationDate());
        copiedSpecialReview.setApprovalDate(ipSpecialReview.getApprovalDate());
        copiedSpecialReview.setApprovalTypeCode(ipSpecialReview.getApprovalTypeCode());
        copiedSpecialReview.setComments(ipSpecialReview.getComments());
        copiedSpecialReview.setExemptionTypeCodes(ipSpecialReview.getExemptionTypeCodes());
        copiedSpecialReview.setExpirationDate(ipSpecialReview.getExpirationDate());
        copiedSpecialReview.setProtocolNumber(ipSpecialReview.getProtocolNumber());
        copiedSpecialReview.setSpecialReviewType(ipSpecialReview.getSpecialReviewType());
        copiedSpecialReview.setApprovalType(ipSpecialReview.getApprovalType());
        copiedSpecialReview.setSpecialReviewTypeCode(ipSpecialReview.getSpecialReviewTypeCode());
        for (InstitutionalProposalSpecialReviewExemption ipExempt : ipSpecialReview.getSpecialReviewExemptions()) {
            if (!StringUtils.isNotBlank((CharSequence)ipExempt.getExemptionTypeCode())) continue;
            AwardSpecialReviewExemption newAwardExempt = copiedSpecialReview.createSpecialReviewExemption(ipExempt.getExemptionTypeCode());
            copiedSpecialReview.getSpecialReviewExemptions().add(newAwardExempt);
        }
        copiedSpecialReview.setSpecialReviewNumber(ipSpecialReview.getSpecialReviewNumber());
        return copiedSpecialReview;
    }
}

