/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.paymentreports.closeout;

import java.util.List;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.kra.award.paymentreports.closeout.AddAwardCloseoutRuleEvent;
import org.kuali.kra.award.paymentreports.closeout.AwardCloseout;
import org.kuali.kra.award.paymentreports.closeout.AwardCloseoutRule;
import org.kuali.kra.award.paymentreports.closeout.AwardCloseoutRuleEvent;
import org.kuali.rice.krad.util.GlobalVariables;

public class AwardCloseoutRuleImpl
extends KcTransactionalDocumentRuleBase
implements AwardCloseoutRule {
    private static final String CLOSEOUT_REPORT_NAME_PROPERTY = "closeoutReportName";
    private static final String REPORT_NAME_ERROR_PARM = "Final Report (Final Report)";

    @Override
    public boolean processAwardCloseoutBusinessRules(AwardCloseoutRuleEvent event) {
        return this.processCommonValidations(event);
    }

    @Override
    public boolean processAddAwardCloseoutBusinessRules(AddAwardCloseoutRuleEvent event) {
        return this.areRequiredFieldsComplete(event.getCloseoutItemForValidation()) && this.processCommonValidations(event);
    }

    private boolean processCommonValidations(AwardCloseoutRuleEvent event) {
        AwardCloseout closeoutItem = event.getCloseoutItemForValidation();
        List<AwardCloseout> items = event.getAward().getAwardCloseoutItems();
        return this.isUnique(items, closeoutItem);
    }

    protected boolean isUnique(List<AwardCloseout> closeoutItems, AwardCloseout closeoutItem) {
        boolean duplicateFound = false;
        for (AwardCloseout listItem : closeoutItems) {
            duplicateFound = closeoutItem != listItem && listItem.equals(closeoutItem);
            if (!duplicateFound) continue;
            if (this.hasDuplicateErrorBeenReported()) break;
            this.reportError("closeoutItems", "error.awardCloseout.notunique", REPORT_NAME_ERROR_PARM);
            break;
        }
        return !duplicateFound;
    }

    protected boolean areRequiredFieldsComplete(AwardCloseout closeoutItem) {
        boolean itemValid;
        boolean bl = itemValid = closeoutItem != null && closeoutItem.getCloseoutReportName() != null;
        if (!itemValid) {
            this.reportError(CLOSEOUT_REPORT_NAME_PROPERTY, "error.required", REPORT_NAME_ERROR_PARM);
        }
        return itemValid;
    }

    private boolean hasDuplicateErrorBeenReported() {
        return GlobalVariables.getMessageMap().containsMessageKey("error.awardCloseout.notunique");
    }
}

