/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.excon.project;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.bo.AbstractPersonRoleAware;
import org.kuali.kra.excon.project.ExconProject;
import org.kuali.kra.excon.project.ExconProjectAssociate;
import org.kuali.kra.excon.project.ExconProjectPersonRoleType;
import org.kuali.kra.excon.project.ExconProjectTravelerCommunication;
import org.kuali.kra.excon.project.ExconProjectUnitContactTypeValuesFinder;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.util.AutoPopulatingList;

public class ExconProjectPerson
extends ExconProjectAssociate
implements AbstractPersonRoleAware {
    private static final long serialVersionUID = 4063631952041257985L;
    private Long projectPersonId;
    private String personId;
    private Integer rolodexId;
    private String fullName;
    private String roleTypeCode;
    private String userName;
    private ExconProjectPersonRoleType roleType;
    private List<ExconProjectTravelerCommunication> travelerCommunications = new AutoPopulatingList(ExconProjectTravelerCommunication.class);
    private transient KcPersonService kcPersonService;
    private transient BusinessObjectService businessObjectService;

    public Long getProjectPersonId() {
        return this.projectPersonId;
    }

    public void setProjectPersonId(Long projectPersonId) {
        this.projectPersonId = projectPersonId;
    }

    @Override
    public String getPersonId() {
        return this.personId;
    }

    public void setPersonId(String personId) {
        this.personId = personId;
    }

    @Override
    public Integer getRolodexId() {
        return this.rolodexId;
    }

    public void setRolodexId(Integer rolodexId) {
        this.rolodexId = rolodexId;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public String getFullName() {
        KcPerson person;
        if (this.fullName == null && (person = this.getPerson()) != null) {
            this.fullName = person.getFullName();
        }
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getRoleTypeCode() {
        return this.roleTypeCode;
    }

    public void setRoleTypeCode(String roleTypeCode) {
        this.roleTypeCode = roleTypeCode;
    }

    public ExconProjectPersonRoleType getRoleType() {
        if (!StringUtils.isEmpty((CharSequence)this.roleTypeCode)) {
            this.refreshReferenceObject("roleType");
        }
        return this.roleType;
    }

    public String getPersonRoleTypeName() {
        if (this.roleTypeCode != null) {
            return new ExconProjectUnitContactTypeValuesFinder().getKeyLabel(this.roleTypeCode);
        }
        return null;
    }

    public void setRoleType(ExconProjectPersonRoleType roleType) {
        this.roleType = roleType;
    }

    public void setTravelerCommunications(List<ExconProjectTravelerCommunication> travelerCommunications) {
        this.travelerCommunications = travelerCommunications;
    }

    public List<ExconProjectTravelerCommunication> getTravelerCommunications() {
        return this.travelerCommunications;
    }

    public boolean getIsUnitRestricted() {
        if (this.getPerson() == null || this.getPerson().getUnit() == null) {
            return false;
        }
        return this.getExconProject().isUnitRestricted(this.getPerson().getUnit().getUnitNumber());
    }

    @Override
    public void resetPersistenceState() {
        this.projectPersonId = null;
        this.versionNumber = null;
    }

    @Override
    public KcPerson getPerson() {
        if (this.personId != null) {
            return this.getKcPersonService().getKcPersonByPersonId(this.personId);
        }
        if (this.userName != null) {
            KcPerson person = this.getKcPersonService().getKcPersonByUserName(this.userName);
            if (person != null) {
                this.setPersonId(person.getPersonId());
            }
            return person;
        }
        return null;
    }

    public ExconProject getParent() {
        return this.getExconProject();
    }

    @Override
    public String getRoleCode() {
        return this.roleTypeCode;
    }

    @Override
    public boolean isPrincipalInvestigator() {
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Objects.equals(this.projectPersonId, ((ExconProjectPerson)o).projectPersonId);
    }

    protected KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KcServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    public BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected void preRemove() {
        super.preRemove();
        this.getBusinessObjectService().deleteMatching(ExconProjectTravelerCommunication.class, Collections.singletonMap("projectPersonId", this.getProjectPersonId()));
        this.getTravelerCommunications().clear();
    }
}

