/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.excon.project;

import java.sql.Date;
import java.util.Calendar;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.excon.common.service.RPSRetrievalService;
import org.kuali.kra.excon.project.ExconProject;
import org.kuali.kra.excon.project.ExconProjectAssociate;
import org.kuali.kra.excon.project.ExconProjectRPSEntity;
import org.kuali.rice.krad.util.ObjectUtils;

public class ExconProjectRPSResult
extends ExconProjectAssociate
implements Comparable<ExconProjectRPSResult> {
    private static final long serialVersionUID = 361123423492205490L;
    private Long rpsResultId;
    private Long rpsEntityId;
    private String rpsResultContent;
    private String searchingUser;
    private Date rpsSearchDate;
    private int numMatches = -1;
    private ExconProjectRPSEntity exconProjectRPSEntity;
    private transient KcPersonService kcPersonService;
    private transient RPSRetrievalService rpsRetrievalService;

    public ExconProjectRPSResult() {
    }

    public ExconProjectRPSResult(String rpsResultContent) {
        this();
        this.setRpsResultContent(rpsResultContent);
    }

    public Long getRpsResultId() {
        return this.rpsResultId;
    }

    public void setRpsResultId(Long rpsResultId) {
        this.rpsResultId = rpsResultId;
    }

    public Long getRpsEntityId() {
        return this.rpsEntityId;
    }

    public void setRpsEntityId(Long rpsEntityId) {
        this.rpsEntityId = rpsEntityId;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.rpsResultId == null ? 0 : this.rpsResultId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExconProjectRPSResult other = (ExconProjectRPSResult)obj;
        return this.rpsResultId.equals(other.rpsResultId);
    }

    public String getRpsResultContent() {
        return this.rpsResultContent;
    }

    public void setRpsResultContent(String rpsResultContent) {
        this.rpsResultContent = rpsResultContent;
    }

    public int getNumMatches() {
        if (this.numMatches < 0) {
            this.numMatches = this.getRPSRetrievalService().getNumMatches(this.getRpsResultContent());
        }
        return this.numMatches;
    }

    public String getSearchingUser() {
        return this.searchingUser;
    }

    public void setSearchingUser(String searchingUser) {
        this.searchingUser = searchingUser;
    }

    public String getSearchingUserName() {
        KcPerson person = this.getKcPersonService().getKcPersonByUserName(this.getSearchingUser());
        return ObjectUtils.isNull((Object)person) ? "Person not found" : person.getFullName();
    }

    public Date getRpsSearchDate() {
        return this.rpsSearchDate;
    }

    public String getRpsSearchDateStr() {
        return ExconProject.formattedDate(this.rpsSearchDate);
    }

    public void setRpsSearchDate(Date rpsSearchDate) {
        this.rpsSearchDate = rpsSearchDate;
    }

    public String getUpdateTimestampDateString() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(this.getUpdateTimestamp().getTime()));
        return cal.get(2) + "/" + cal.get(5) + "/" + cal.get(1);
    }

    public ExconProjectRPSEntity getExconProjectRPSEntity() {
        return this.exconProjectRPSEntity;
    }

    public void setExconProjectRPSEntity(ExconProjectRPSEntity exconProjectRPSEntity) {
        this.exconProjectRPSEntity = exconProjectRPSEntity;
    }

    @Override
    public void resetPersistenceState() {
        this.rpsResultId = null;
        this.versionNumber = null;
    }

    @Override
    public int compareTo(ExconProjectRPSResult exconProjectRPSResult) {
        return exconProjectRPSResult.getRpsSearchDate().compareTo(this.getRpsSearchDate());
    }

    protected KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KcServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    protected RPSRetrievalService getRPSRetrievalService() {
        if (this.rpsRetrievalService == null) {
            this.rpsRetrievalService = KcServiceLocator.getServicesOfType(RPSRetrievalService.class).get(0);
        }
        return this.rpsRetrievalService;
    }

    public void setRpsRetrievalService(RPSRetrievalService rpsRetrievalService) {
        this.rpsRetrievalService = rpsRetrievalService;
    }
}

