/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.negotiations.bo;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.negotiations.bo.Negotiation;
import org.kuali.kra.negotiations.bo.NegotiationActivityAttachment;
import org.kuali.kra.negotiations.bo.NegotiationActivityType;
import org.kuali.kra.negotiations.bo.NegotiationLocation;
import org.kuali.rice.krad.util.GlobalVariables;

public class NegotiationActivity
extends KcPersistableBusinessObjectBase {
    private static final long serialVersionUID = 1927288853033781994L;
    public static final long MILLISECS_PER_DAY = 86400000L;
    private Long activityId;
    private Long negotiationId;
    private Negotiation negotiation;
    private Long locationId;
    private NegotiationLocation location;
    private Long activityTypeId;
    private NegotiationActivityType activityType;
    private java.sql.Date startDate;
    private java.sql.Date endDate;
    private java.sql.Date createDate;
    private java.sql.Date followupDate;
    private String lastModifiedUsername;
    private java.sql.Date lastModifiedDate;
    private String description;
    private Boolean restricted = Boolean.FALSE;
    private List<NegotiationActivityAttachment> attachments = new ArrayList<NegotiationActivityAttachment>();
    private transient NegotiationActivityAttachment newAttachment = new NegotiationActivityAttachment();
    private transient boolean updated;
    private transient KcPersonService kcPersonService;

    public String getNumberOfDays() {
        return NegotiationActivity.getNumberOfDays(this.getStartDate(), this.getEndDate());
    }

    public static String getNumberOfDays(java.sql.Date startDate, java.sql.Date endDate) {
        return Objects.toString(Negotiation.getNumberOfDays(startDate, endDate), "");
    }

    public void updateActivity() {
        if (this.updated) {
            this.refreshReferenceObject("location");
            this.refreshReferenceObject("activityType");
            this.setLastModifiedDate(new java.sql.Date(new Date().getTime()));
            this.setLastModifiedUsername(GlobalVariables.getUserSession().getPrincipalName());
            this.updated = false;
        }
    }

    public Long getActivityId() {
        return this.activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public Long getNegotiationId() {
        return this.negotiationId;
    }

    public void setNegotiationId(Long negotiationId) {
        this.negotiationId = negotiationId;
    }

    public Negotiation getNegotiation() {
        return this.negotiation;
    }

    public void setNegotiation(Negotiation negotiation) {
        this.negotiation = negotiation;
    }

    public Long getLocationId() {
        return this.locationId;
    }

    public void setLocationId(Long locationId) {
        if (!Objects.equals(this.locationId, locationId)) {
            this.updated = true;
        }
        this.locationId = locationId;
    }

    public NegotiationLocation getLocation() {
        return this.location;
    }

    public void setLocation(NegotiationLocation location) {
        if (!Objects.equals(this.location, location)) {
            this.updated = true;
        }
        this.location = location;
    }

    public Long getActivityTypeId() {
        return this.activityTypeId;
    }

    public void setActivityTypeId(Long activityTypeId) {
        if (!Objects.equals(this.activityTypeId, activityTypeId)) {
            this.updated = true;
        }
        this.activityTypeId = activityTypeId;
    }

    public NegotiationActivityType getActivityType() {
        return this.activityType;
    }

    public void setActivityType(NegotiationActivityType activityType) {
        this.activityType = activityType;
    }

    public java.sql.Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(java.sql.Date startDate) {
        if (!Objects.equals(this.startDate, startDate)) {
            this.updated = true;
        }
        this.startDate = startDate;
    }

    public java.sql.Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(java.sql.Date endDate) {
        if (!Objects.equals(this.endDate, endDate)) {
            this.updated = true;
        }
        this.endDate = endDate;
    }

    public java.sql.Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(java.sql.Date createDate) {
        this.createDate = createDate;
    }

    public java.sql.Date getFollowupDate() {
        return this.followupDate;
    }

    public void setFollowupDate(java.sql.Date followupDate) {
        if (!Objects.equals(this.followupDate, followupDate)) {
            this.updated = true;
        }
        this.followupDate = followupDate;
    }

    public String getLastModifiedUsername() {
        return this.lastModifiedUsername;
    }

    public void setLastModifiedUsername(String lastModifiedUsername) {
        this.lastModifiedUsername = lastModifiedUsername;
    }

    public KcPerson getLastModifiedUser() {
        if (this.getLastModifiedUsername() == null) {
            return null;
        }
        return this.getKcPersonService().getKcPersonByUserName(this.getLastModifiedUsername());
    }

    public String getLastModifiedUserFullName() {
        KcPerson user = this.getLastModifiedUser();
        return user == null ? "" : user.getFullName();
    }

    public java.sql.Date getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(java.sql.Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        if (!Objects.equals(this.description, description)) {
            this.updated = true;
        }
        this.description = description;
    }

    public Boolean getRestricted() {
        return this.restricted;
    }

    public void setRestricted(Boolean restricted) {
        if (!Objects.equals(this.restricted, restricted)) {
            this.updated = true;
        }
        this.restricted = restricted;
    }

    public List<NegotiationActivityAttachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<NegotiationActivityAttachment> attachments) {
        this.attachments = attachments;
    }

    public void add(NegotiationActivityAttachment attachment) {
        this.updated = true;
        this.attachments.add(attachment);
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public void setUpdated(boolean updated) {
        this.updated = updated;
    }

    public NegotiationActivityAttachment getNewAttachment() {
        return this.newAttachment;
    }

    public void setNewAttachment(NegotiationActivityAttachment newAttachment) {
        this.newAttachment = newAttachment;
    }

    protected KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KcServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }
}

