/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.subaward.bo;

import java.text.SimpleDateFormat;
import org.kuali.kra.bo.CommentType;
import org.kuali.kra.bo.MutableComment;
import org.kuali.kra.subaward.bo.SubAwardAssociate;

public class SubAwardComment
extends SubAwardAssociate
implements Comparable<SubAwardComment>,
MutableComment {
    public static final String UPDATE_DATE_FORMAT = "M/dd/yyyy";
    private static final long serialVersionUID = 3611932717292205490L;
    private Long subAwardCommentId;
    private String commentTypeCode;
    private Boolean checklistPrintFlag;
    private String comments;
    private CommentType commentType;

    public SubAwardComment() {
        this.setChecklistPrintFlag(Boolean.FALSE);
    }

    public SubAwardComment(CommentType commentType, String comments) {
        this.setCommentType(commentType);
        this.setComments(comments);
        this.setChecklistPrintFlag(Boolean.FALSE);
    }

    public Long getSubAwardCommentId() {
        return this.subAwardCommentId;
    }

    public void setSubAwardCommentId(Long subAwardCommentId) {
        this.subAwardCommentId = subAwardCommentId;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.subAwardCommentId == null ? 0 : this.subAwardCommentId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubAwardComment other = (SubAwardComment)obj;
        return this.subAwardCommentId.equals(other.subAwardCommentId);
    }

    public boolean sameText(SubAwardComment compare) {
        if (this.getComments() == compare.getComments()) {
            return true;
        }
        if (!this.isEntered() && !compare.isEntered()) {
            return true;
        }
        if (!this.isEntered() || !compare.isEntered()) {
            return false;
        }
        return this.comments.equals(compare.getComments());
    }

    @Override
    public String getCommentTypeCode() {
        return this.commentTypeCode;
    }

    @Override
    public void setCommentTypeCode(String commentTypeCode) {
        this.commentTypeCode = commentTypeCode;
    }

    @Override
    public Boolean getChecklistPrintFlag() {
        return this.checklistPrintFlag;
    }

    @Override
    public void setChecklistPrintFlag(Boolean checklistPrintFlag) {
        this.checklistPrintFlag = checklistPrintFlag;
    }

    @Override
    public String getComments() {
        return this.comments;
    }

    @Override
    public void setComments(String comments) {
        this.comments = comments;
    }

    @Override
    public CommentType getCommentType() {
        return this.commentType;
    }

    @Override
    public void setCommentType(CommentType commentType) {
        this.commentType = commentType;
        this.commentTypeCode = commentType != null ? commentType.getCommentTypeCode() : null;
    }

    public String getUpdateTimestampDateString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(UPDATE_DATE_FORMAT);
        return dateFormat.format(this.getUpdateTimestamp());
    }

    @Override
    public void resetPersistenceState() {
        this.subAwardCommentId = null;
        this.versionNumber = null;
    }

    @Override
    public int compareTo(SubAwardComment awardCommentArg) {
        return awardCommentArg.getUpdateTimestamp().compareTo(this.getUpdateTimestamp());
    }

    public void disableComment() {
        this.setVersionNumber(-1L);
    }

    public boolean isDisabled() {
        return Long.valueOf(-1L).equals(this.getVersionNumber());
    }

    public boolean isEntered() {
        return this.comments != null && this.comments.length() > 0;
    }
}

