/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.framework.engine.expression;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.rice.krms.framework.engine.expression.DefaultComparisonOperator;
import org.kuali.rice.krms.framework.engine.expression.EngineComparatorExtension;

public class ListComparisonOperator
implements EngineComparatorExtension {
    private EngineComparatorExtension baseComparator;

    public int compare(Object lhs, Object rhs) {
        ArrayList<Object> rhList;
        ArrayList<Object> lhList;
        if (!(lhs instanceof List) && !(rhs instanceof List)) {
            if (rhs instanceof String && rhs.toString().equals("EMPTY")) {
                return lhs == null || StringUtils.isBlank((CharSequence)lhs.toString()) ? 0 : -1;
            }
            return this.getBaseComparator().compare(lhs, rhs);
        }
        if (lhs instanceof List) {
            lhList = new ArrayList((List)lhs);
        } else {
            lhList = new ArrayList<Object>();
            lhList.add(lhs);
        }
        if (rhs instanceof List) {
            rhList = new ArrayList((List)rhs);
        } else {
            rhList = new ArrayList<Object>();
            rhList.add(rhs);
        }
        if (rhs instanceof String && rhs.toString().equals("EMPTY")) {
            return this.isListEmpty(lhList);
        }
        return this.compareLists(lhList, rhList);
    }

    protected int isListEmpty(List<Object> list) {
        for (Object item : list) {
            if (item == null) continue;
            return -1;
        }
        return 0;
    }

    protected int compareLists(List<Object> lhList, List<Object> rhList) {
        for (Object lhItem : lhList) {
            for (Object rhItem : rhList) {
                if (this.getBaseComparator().compare(lhItem, rhItem) != 0) continue;
                return 0;
            }
        }
        return -1;
    }

    public boolean canCompare(Object lhs, Object rhs) {
        try {
            this.compare(lhs, rhs);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setBaseComparator(EngineComparatorExtension baseComparator) {
        this.baseComparator = baseComparator;
    }

    protected EngineComparatorExtension getBaseComparator() {
        if (this.baseComparator == null) {
            this.baseComparator = new DefaultComparisonOperator();
        }
        return this.baseComparator;
    }
}

