<?xml version="1.0" encoding="UTF-8"?>
<!--
  #%L
  %%
  Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  -->


	<!--
		Designed and generated by Altova StyleVision Enterprise Edition 2008
		rel. 2 sp2 - see http://www.altova.com/stylevision for more
		information.
	-->
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fn="http://www.w3.org/2005/xpath-functions"
	xmlns:xdt="http://www.w3.org/2005/xpath-datatypes" xmlns:xs="http://www.w3.org/2001/XMLSchema"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output version="1.0" method="xml" encoding="UTF-8"
		indent="no" />
	<xsl:param name="SV_OutputFormat" select="'PDF'" />
	<xsl:variable name="XML" select="/" />
	<xsl:variable name="fo:layout-master-set">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="default-page"
				page-height="11in" page-width="8.5in" margin-left="0.2in"
				margin-right="0.1in">
				<fo:region-body margin-top="1.2in" margin-bottom="0.79in" />
				<fo:region-before extent="1.2in" />
			</fo:simple-page-master>
		</fo:layout-master-set>
	</xsl:variable>
	<xsl:template match="/">
		<fo:root>
			<xsl:copy-of select="$fo:layout-master-set" />
			<fo:page-sequence master-reference="default-page"
				initial-page-number="1" format="1">
				<xsl:call-template name="headerall" />
				<fo:flow flow-name="xsl-region-body">
					<fo:block>
						<fo:block />
						<xsl:for-each select="$XML">
							<xsl:if
								test="count(  AwardNotice/AwardDisclosure/DisclosureItem  ) &gt; 0">
								<xsl:for-each select="AwardNotice">
									<xsl:for-each select="SchoolInfo">
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:block font-family="Arial" text-align="center"
											margin="0pt">
											<fo:block>
												<xsl:for-each select="SchoolName">
													<xsl:variable name="value-of-template">
														<xsl:apply-templates />
													</xsl:variable>
													<xsl:choose>
														<xsl:when
															test="contains(string($value-of-template),'&#x2029;')">
															<fo:block font-family="Arial" font-size="16pt"
																font-weight="bold">
																<xsl:copy-of select="$value-of-template" />
															</fo:block>
														</xsl:when>
														<xsl:otherwise>
															<fo:inline font-family="Arial" font-size="16pt"
																font-weight="bold">
																<xsl:copy-of select="$value-of-template" />
															</fo:inline>
														</xsl:otherwise>
													</xsl:choose>
												</xsl:for-each>
											</fo:block>
										</fo:block>
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:block font-family="Arial" margin-left="(100% - 100%) div 2"
											margin-right="(100% - 100%) div 2" text-align="center"
											margin="0pt">
											<fo:block>
												<fo:block />
												<fo:inline font-family="Arial" font-size="14pt"
													font-weight="bold">
													<xsl:text>Notice of Award - Disclosure Status</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:block>
									</xsl:for-each>
								</xsl:for-each>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:table font-family="Arial" table-layout="fixed"
									width="100%" border-spacing="2pt">
									<fo:table-column column-width="20%" />
									<fo:table-column column-width="80%" />
									<fo:table-body start-indent="0pt">
										<fo:table-row>
											<fo:table-cell font-family="Arial" font-size="9pt"
												font-weight="bold" padding="2pt" text-align="right"
												display-align="center">
												<fo:block>
													<fo:inline>
														<xsl:text>Account Number</xsl:text>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell font-family="Arial" font-size="9pt"
												padding="2pt" text-align="left" display-align="center">
												<fo:block>
													<xsl:for-each select="AwardNotice">
														<xsl:for-each select="AwardDisclosure">
															<xsl:for-each select="AwardHeader">
																<xsl:for-each select="AccountNumber">
																	<xsl:if test=". != 0">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates />
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when
																				test="contains(string($value-of-template),'&#x2029;')">
																				<fo:block font-family="Arial" font-size="9pt">
																					<xsl:copy-of select="$value-of-template" />
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline font-family="Arial" font-size="9pt">
																					<xsl:copy-of select="$value-of-template" />
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:if>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
													<fo:inline>
														<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
													</fo:inline>
													<fo:inline font-family="Arial" font-size="9pt"
														font-weight="bold">
														<xsl:text>Award Number: </xsl:text>
													</fo:inline>
													<xsl:for-each select="AwardNotice">
														<xsl:for-each select="AwardDisclosure">
															<xsl:for-each select="AwardHeader">
																<xsl:for-each select="AwardNumber">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates />
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when
																			test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block font-family="Arial" font-size="9pt">
																				<xsl:copy-of select="$value-of-template" />
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline font-family="Arial" font-size="9pt">
																				<xsl:copy-of select="$value-of-template" />
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
													<fo:inline font-family="Arial" font-size="9pt"
														font-weight="bold">
														<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; Sequence:</xsl:text>
													</fo:inline>
													<xsl:for-each select="AwardNotice">
														<xsl:for-each select="AwardDisclosure">
															<xsl:for-each select="AwardHeader">
																<xsl:for-each select="SequenceNumber">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates />
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when
																			test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block font-family="Arial" font-size="9pt">
																				<xsl:copy-of select="$value-of-template" />
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline font-family="Arial" font-size="9pt">
																				<xsl:copy-of select="$value-of-template" />
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
													<fo:inline>
														<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
													</fo:inline>
													<fo:inline font-family="Arial" font-size="9pt"
														font-weight="bold">
														<xsl:text>Status:</xsl:text>
													</fo:inline>
													<xsl:for-each select="AwardNotice">
														<xsl:for-each select="AwardDisclosure">
															<xsl:for-each select="AwardHeader">
																<xsl:for-each select="StatusDescription">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates />
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when
																			test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block font-family="Arial" font-size="9pt">
																				<xsl:copy-of select="$value-of-template" />
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline font-family="Arial" font-size="9pt">
																				<xsl:copy-of select="$value-of-template" />
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
										<fo:table-row>
											<fo:table-cell font-family="Arial" font-size="9pt"
												font-weight="bold" padding="2pt" text-align="right"
												display-align="center">
												<fo:block>
													<fo:inline>
														<xsl:text>Modification Number:</xsl:text>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell font-family="Arial" font-size="9pt"
												padding="2pt" display-align="center">
												<fo:block>
													<xsl:for-each select="AwardNotice">
														<xsl:for-each select="AwardDisclosure">
															<xsl:for-each select="AwardHeader">
																<xsl:for-each select="ModificationNumber">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates />
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when
																			test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template" />
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template" />
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
										<fo:table-row>
											<fo:table-cell font-family="Arial" font-size="9pt"
												font-weight="bold" padding="2pt" text-align="right"
												display-align="center">
												<fo:block>
													<fo:inline>
														<xsl:text>Sponsor Award Number:</xsl:text>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell font-family="Arial" font-size="9pt"
												padding="2pt" display-align="center">
												<fo:block>
													<fo:inline-container>
														<fo:block>
															<xsl:text>&#x2029;</xsl:text>
														</fo:block>
													</fo:inline-container>
													<fo:block white-space="pre" white-space-collapse="false"
														wrap-option="wrap" white-space-treatment="ignore-if-surrounding-linefeed"
														margin="0pt">
														<fo:block>
															<xsl:for-each select="AwardNotice">
																<xsl:for-each select="AwardDisclosure">
																	<xsl:for-each select="AwardHeader">
																		<xsl:for-each select="SponsorAwardNumber">
																			<xsl:variable name="value-of-template">
																				<xsl:apply-templates />
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when
																					test="contains(string($value-of-template),'&#x2029;')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template" />
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template" />
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</fo:block>
													</fo:block>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
										<fo:table-row>
											<fo:table-cell font-family="Arial" font-size="9pt"
												font-weight="bold" padding="2pt" text-align="right"
												display-align="center">
												<fo:block>
													<fo:inline>
														<xsl:text>Sponsor:</xsl:text>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell font-family="Arial" font-size="9pt"
												padding="2pt" display-align="center">
												<fo:block>
													<fo:inline-container>
														<fo:block>
															<xsl:text>&#x2029;</xsl:text>
														</fo:block>
													</fo:inline-container>
													<fo:block white-space="pre" white-space-collapse="false"
														wrap-option="wrap" white-space-treatment="ignore-if-surrounding-linefeed"
														margin="0pt">
														<fo:block>
															<xsl:for-each select="AwardNotice">
																<xsl:for-each select="AwardDisclosure">
																	<xsl:for-each select="AwardHeader">
																		<xsl:for-each select="SponsorCode">
																			<xsl:variable name="value-of-template">
																				<xsl:apply-templates />
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when
																					test="contains(string($value-of-template),'&#x2029;')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template" />
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template" />
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																		<fo:inline>
																			<xsl:text> - </xsl:text>
																		</fo:inline>
																		<xsl:for-each select="SponsorDescription">
																			<xsl:variable name="value-of-template">
																				<xsl:apply-templates />
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when
																					test="contains(string($value-of-template),'&#x2029;')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template" />
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template" />
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</fo:block>
													</fo:block>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
										<fo:table-row>
											<fo:table-cell font-family="Arial" font-size="9pt"
												font-weight="bold" padding="2pt" text-align="right"
												display-align="center">
												<fo:block>
													<fo:inline>
														<xsl:text>Title:</xsl:text>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell font-family="Arial" font-size="9pt"
												padding="2pt" display-align="center">
												<fo:block>
													<fo:inline-container>
														<fo:block>
															<xsl:text>&#x2029;</xsl:text>
														</fo:block>
													</fo:inline-container>
													<fo:block white-space="pre" white-space-collapse="false"
														wrap-option="wrap" white-space-treatment="ignore-if-surrounding-linefeed"
														margin="0pt">
														<fo:block>
															<xsl:for-each select="AwardNotice">
																<xsl:for-each select="AwardDisclosure">
																	<xsl:for-each select="AwardHeader">
																		<xsl:for-each select="Title">
																			<xsl:variable name="value-of-template">
																				<xsl:apply-templates />
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when
																					test="contains(string($value-of-template),'&#x2029;')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template" />
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template" />
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</fo:block>
													</fo:block>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
										<fo:table-row>
											<fo:table-cell font-family="Arial"
												number-columns-spanned="2" padding="2pt" display-align="center">
												<fo:block>
													<fo:inline font-family="Arial" font-size="9pt"
														font-weight="bold">
														<xsl:text>This award has financial interest disclosures associated with it which are in Pending or Incomplete status.</xsl:text>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
									</fo:table-body>
								</fo:table>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:table font-family="Arial" font-size="9pt"
									line-height="9pt" table-layout="fixed" width="100%"
									border-spacing="2pt">
									<fo:table-column column-width="proportional-column-width(1)" />
									<fo:table-column column-width="proportional-column-width(1)" />
									<fo:table-body font-family="Arial" start-indent="0pt">
										<fo:table-row>
											<fo:table-cell font-family="Arial"
												number-columns-spanned="2" padding="2pt" display-align="center">
												<fo:block>
													<fo:block>
														<fo:leader leader-pattern="space" />
													</fo:block>
													<fo:inline-container>
														<fo:block>
															<xsl:text>&#x2029;</xsl:text>
														</fo:block>
													</fo:inline-container>
													<fo:block padding="0" padding-top="8pt" margin="0pt">
														<fo:block>
															<fo:inline font-family="Arial" font-size="12pt"
																font-weight="bold">
																<xsl:text>&#160;&#160;&#160; Disclosures for this award</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:block>
													<xsl:for-each select="AwardNotice">
														<xsl:for-each select="AwardDisclosure">
															<fo:inline-container>
																<fo:block>
																	<xsl:text>&#x2029;</xsl:text>
																</fo:block>
															</fo:inline-container>
															<xsl:if test="DisclosureItem">
																<fo:table font-family="Arial" table-layout="fixed"
																	width="100%" border-spacing="2pt">
																	<fo:table-column column-width="25%" />
																	<fo:table-column column-width="40%" />
																	<fo:table-column column-width="15%" />
																	<fo:table-column column-width="20%" />
																	<fo:table-header start-indent="0pt">
																		<fo:table-row>
																			<fo:table-cell font-family="Arial"
																				padding-left="20pt" padding="2pt" display-align="center">
																				<fo:block>
																					<fo:inline font-weight="bold">
																						<xsl:text>Disclosure Number</xsl:text>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell padding="2pt"
																				display-align="center">
																				<fo:block>
																					<fo:inline font-family="Arial"
																						font-weight="bold">
																						<xsl:text>Investigator</xsl:text>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell padding="2pt"
																				display-align="center">
																				<fo:block>
																					<fo:inline font-family="Arial"
																						font-weight="bold">
																						<xsl:text>Type</xsl:text>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell padding="2pt"
																				display-align="center">
																				<fo:block>
																					<fo:inline font-family="Arial"
																						font-weight="bold">
																						<xsl:text>Status</xsl:text>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																		</fo:table-row>
																	</fo:table-header>
																	<fo:table-body start-indent="0pt">
																		<xsl:for-each select="DisclosureItem">
																			<fo:table-row>
																				<fo:table-cell padding-left="20pt"
																					padding="2pt" display-align="center">
																					<fo:block>
																						<xsl:for-each select="DisclosureNumber">
																							<xsl:variable name="value-of-template">
																								<xsl:apply-templates />
																							</xsl:variable>
																							<xsl:choose>
																								<xsl:when
																									test="contains(string($value-of-template),'&#x2029;')">
																									<fo:block>
																										<xsl:copy-of select="$value-of-template" />
																									</fo:block>
																								</xsl:when>
																								<xsl:otherwise>
																									<fo:inline>
																										<xsl:copy-of select="$value-of-template" />
																									</fo:inline>
																								</xsl:otherwise>
																							</xsl:choose>
																						</xsl:for-each>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt"
																					display-align="center">
																					<fo:block>
																						<fo:inline-container>
																							<fo:block>
																								<xsl:text>&#x2029;</xsl:text>
																							</fo:block>
																						</fo:inline-container>
																						<fo:block white-space="pre"
																							white-space-collapse="false" wrap-option="wrap"
																							white-space-treatment="ignore-if-surrounding-linefeed"
																							margin="0pt">
																							<fo:block>
																								<xsl:for-each select="PersonName">
																									<xsl:variable name="value-of-template">
																										<xsl:apply-templates />
																									</xsl:variable>
																									<xsl:choose>
																										<xsl:when
																											test="contains(string($value-of-template),'&#x2029;')">
																											<fo:block font-family="Arial">
																												<xsl:copy-of select="$value-of-template" />
																											</fo:block>
																										</xsl:when>
																										<xsl:otherwise>
																											<fo:inline font-family="Arial">
																												<xsl:copy-of select="$value-of-template" />
																											</fo:inline>
																										</xsl:otherwise>
																									</xsl:choose>
																								</xsl:for-each>
																							</fo:block>
																						</fo:block>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt"
																					display-align="center">
																					<fo:block>
																						<xsl:for-each select="DisclosureTypeDesc">
																							<xsl:variable name="value-of-template">
																								<xsl:apply-templates />
																							</xsl:variable>
																							<xsl:choose>
																								<xsl:when
																									test="contains(string($value-of-template),'&#x2029;')">
																									<fo:block>
																										<xsl:copy-of select="$value-of-template" />
																									</fo:block>
																								</xsl:when>
																								<xsl:otherwise>
																									<fo:inline>
																										<xsl:copy-of select="$value-of-template" />
																									</fo:inline>
																								</xsl:otherwise>
																							</xsl:choose>
																						</xsl:for-each>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt"
																					display-align="center">
																					<fo:block>
																						<xsl:for-each select="DisclosureStatusDesc">
																							<xsl:variable name="value-of-template">
																								<xsl:apply-templates />
																							</xsl:variable>
																							<xsl:choose>
																								<xsl:when
																									test="contains(string($value-of-template),'&#x2029;')">
																									<fo:block>
																										<xsl:copy-of select="$value-of-template" />
																									</fo:block>
																								</xsl:when>
																								<xsl:otherwise>
																									<fo:inline>
																										<xsl:copy-of select="$value-of-template" />
																									</fo:inline>
																								</xsl:otherwise>
																							</xsl:choose>
																						</xsl:for-each>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																		</xsl:for-each>
																	</fo:table-body>
																</fo:table>
															</xsl:if>
														</xsl:for-each>
													</xsl:for-each>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
										<fo:table-row>
											<fo:table-cell padding="0" padding-left="0"
												number-columns-spanned="2" display-align="center">
												<fo:block>
													<fo:inline-container>
														<fo:block>
															<xsl:text>&#x2029;</xsl:text>
														</fo:block>
													</fo:inline-container>
													<fo:table font-family="Arial" table-layout="fixed"
														width="100%" border-spacing="2pt">
														<fo:table-column column-width="15%" />
														<fo:table-column column-width="50%" />
														<fo:table-column column-width="35%" />
														<fo:table-body start-indent="0pt">
															<fo:table-row>
																<fo:table-cell padding="2pt" text-align="right"
																	display-align="center">
																	<fo:block>
																		<fo:inline font-family="Arial" font-weight="bold">
																			<xsl:text>Okay for release:</xsl:text>
																		</fo:inline>
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell padding-right="30pt"
																	padding="2pt" text-align="center" display-align="center">
																	<fo:block>
																		<fo:inline>
																			<xsl:text>&#160; </xsl:text>
																		</fo:inline>
																		<fo:block />
																		<fo:inline>
																			<xsl:text>&#160; </xsl:text>
																		</fo:inline>
																		<fo:block />
																		<fo:inline>
																			<xsl:text>&#160;</xsl:text>
																		</fo:inline>
																		<fo:block />
																		<fo:inline>
																			<xsl:text>&#160; </xsl:text>
																		</fo:inline>
																		<fo:block />
																		<fo:inline>
																			<xsl:text>&#160;</xsl:text>
																		</fo:inline>
																		<fo:block />
																		<fo:block text-align="center">
																			<fo:leader leader-pattern="rule"
																				rule-thickness="1" leader-length="100%" color="black" />
																		</fo:block>
																		<fo:inline font-weight="bold">
																			<xsl:text>Signed</xsl:text>
																		</fo:inline>
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell padding-right="45pt"
																	padding="2pt" text-align="center" display-align="center">
																	<fo:block>
																		<fo:inline>
																			<xsl:text>&#160; </xsl:text>
																		</fo:inline>
																		<fo:block />
																		<fo:inline>
																			<xsl:text>&#160;</xsl:text>
																		</fo:inline>
																		<fo:block />
																		<fo:inline>
																			<xsl:text>&#160;</xsl:text>
																		</fo:inline>
																		<fo:block />
																		<fo:inline>
																			<xsl:text>&#160; </xsl:text>
																		</fo:inline>
																		<fo:block />
																		<fo:inline>
																			<xsl:text>&#160;</xsl:text>
																		</fo:inline>
																		<fo:block />
																		<fo:block text-align="center">
																			<fo:leader leader-pattern="rule"
																				rule-thickness="1" leader-length="100%" color="black" />
																		</fo:block>
																		<fo:inline font-weight="bold">
																			<xsl:text>Date</xsl:text>
																		</fo:inline>
																	</fo:block>
																</fo:table-cell>
															</fo:table-row>
															<fo:table-row>
																<fo:table-cell padding="2pt" text-align="right"
																	display-align="center">
																	<fo:block>
																		<fo:inline font-weight="bold">
																			<xsl:text>Follow-up date:</xsl:text>
																		</fo:inline>
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell padding-right="30pt"
																	padding="2pt" text-align="center" display-align="after">
																	<fo:block>
																		<fo:inline>
																			<xsl:text>&#160; </xsl:text>
																		</fo:inline>
																		<fo:block />
																		<fo:inline>
																			<xsl:text>&#160;&#160; </xsl:text>
																		</fo:inline>
																		<fo:block />
																		<fo:block />
																		<fo:block />
																		<fo:block text-align="center">
																			<fo:leader leader-pattern="rule"
																				rule-thickness="1" leader-length="100%" color="black" />
																		</fo:block>
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell padding="2pt"
																	display-align="center">
																	<fo:block />
																</fo:table-cell>
															</fo:table-row>
														</fo:table-body>
													</fo:table>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
									</fo:table-body>
								</fo:table>
								<fo:block break-after="page">
									<fo:leader leader-pattern="space" />
								</fo:block>
							</xsl:if>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x2029;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:block text-align="center" margin="0pt">
								<fo:block>
									<fo:inline-container>
										<fo:block>
											<xsl:text>&#x2029;</xsl:text>
										</fo:block>
									</fo:inline-container>
									<fo:block font-size="large" font-weight="bold" margin="0pt">
										<fo:block>
											<xsl:for-each select="AwardNotice">
												<xsl:for-each select="SchoolInfo">
													<xsl:for-each select="SchoolName">
														<xsl:variable name="value-of-template">
															<xsl:apply-templates />
														</xsl:variable>
														<xsl:choose>
															<xsl:when
																test="contains(string($value-of-template),'&#x2029;')">
																<fo:block font-family="Arial">
																	<xsl:copy-of select="$value-of-template" />
																</fo:block>
															</xsl:when>
															<xsl:otherwise>
																<fo:inline font-family="Arial">
																	<xsl:copy-of select="$value-of-template" />
																</fo:inline>
															</xsl:otherwise>
														</xsl:choose>
													</xsl:for-each>
												</xsl:for-each>
											</xsl:for-each>
										</fo:block>
									</fo:block>
								</fo:block>
							</fo:block>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x2029;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:block font-family="Arial" text-align="center"
								margin="0pt">
								<fo:block>
									<fo:inline-container>
										<fo:block>
											<xsl:text>&#x2029;</xsl:text>
										</fo:block>
									</fo:inline-container>
									<fo:block font-size="medium" font-weight="bold"
										margin="0pt">
										<fo:block>
											<fo:inline font-family="Arial">
												<xsl:text>Award Notice</xsl:text>
											</fo:inline>
										</fo:block>
									</fo:block>
								</fo:block>
							</fo:block>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x2029;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:table font-family="Arial" font-size="9pt"
								font-weight="normal" table-layout="fixed" width="100%"
								border-spacing="2pt">
								<fo:table-column column-width="proportional-column-width(1)" />
								<fo:table-column column-width="proportional-column-width(1)" />
								<fo:table-column column-width="proportional-column-width(1)" />
								<fo:table-column column-width="proportional-column-width(1)" />
								<fo:table-column column-width="16%" />
								<fo:table-column column-width="23%" />
								<fo:table-body font-family="Arial" font-size="9pt"
									font-weight="normal" start-indent="0pt">
									<fo:table-row font-family="Arial" font-size="9pt"
										font-weight="normal">
										<fo:table-cell font-family="Arial" font-size="9pt"
											font-weight="bold" padding="2pt" display-align="center">
											<fo:block>
												<fo:block>
													<fo:leader leader-pattern="space" />
												</fo:block>
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:block margin="0pt">
													<fo:block>
														<fo:inline>
															<xsl:text>Account:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:block>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell font-family="Arial" font-size="9pt"
											font-weight="normal" padding="2pt" display-align="after">
											<fo:block>
												<xsl:for-each select="AwardNotice">
													<xsl:for-each select="Award">
														<xsl:for-each select="AwardDetails">
															<xsl:for-each select="AwardHeader">
																<xsl:for-each select="AccountNumber">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates />
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when
																			test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template" />
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template" />
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell font-family="Arial" font-size="9pt"
											font-weight="bold" padding="2pt" text-align="left"
											display-align="center">
											<fo:block>
												<fo:block>
													<fo:leader leader-pattern="space" />
												</fo:block>
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:block margin="0pt">
													<fo:block>
														<fo:inline>
															<xsl:text>Award ID:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:block>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell padding="2pt" text-align="left"
											display-align="after">
											<fo:block>
												<xsl:for-each select="AwardNotice">
													<xsl:for-each select="Award">
														<xsl:for-each select="AwardDetails">
															<xsl:for-each select="AwardHeader">
																<xsl:for-each select="AwardNumber">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates />
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when
																			test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template" />
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template" />
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell font-family="Arial" font-size="9pt"
											font-weight="bold" padding="2pt" text-align="left"
											display-align="after">
											<fo:block>
												<fo:inline>
													<xsl:text>Award Status:</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell padding="2pt" text-align="left"
											display-align="after">
											<fo:block>
												<xsl:for-each select="AwardNotice">
													<xsl:for-each select="Award">
														<xsl:for-each select="AwardDetails">
															<xsl:for-each select="AwardHeader">
																<xsl:for-each select="StatusDescription">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates />
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when
																			test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template" />
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template" />
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell font-family="Arial" font-size="9pt"
											font-weight="bold" padding="2pt" display-align="center">
											<fo:block>
												<fo:inline font-weight="bold">
																	<xsl:text>Award Updated:</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell font-family="Arial" font-size="9pt"
											font-weight="normal" padding="2pt" display-align="center">
											<fo:block>
											   <fo:block>
												<xsl:for-each select="AwardNotice">
													<xsl:for-each select="Award">
														<xsl:for-each select="AwardDetails">
															<xsl:for-each select="OtherHeaderDetails">
																<xsl:for-each select="LastUpdate">
																	<fo:inline>
																		<xsl:value-of
																			select="format-number(number(substring(string(string(.)), 6, 2)), '00')" />
																		<xsl:text>/</xsl:text>
																		<xsl:value-of
																			select="format-number(number(substring(string(string(.)), 9, 2)), '00')" />
																		<xsl:text>/</xsl:text>
																		<xsl:value-of
																			select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')" />
																	</fo:inline>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</fo:block>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell font-family="Arial" font-size="9pt"
											font-weight="bold" padding="2pt" display-align="center">
											<fo:block>
												<fo:inline font-weight="bold">
													<xsl:text>by</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell font-family="Arial" font-size="9pt"
											font-weight="normal" padding="2pt" display-align="center">
											<fo:block>											
												<xsl:for-each select="AwardNotice">
													<xsl:for-each select="Award">
														<xsl:for-each select="AwardDetails">
															<xsl:for-each select="OtherHeaderDetails">
																<xsl:for-each select="UpdateUser">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates />
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when
																			test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template" />
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template" />
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</fo:block>											
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell font-family="Arial" font-size="9pt"
											font-weight="bold" padding="2pt" display-align="center">
											<fo:block>
												<fo:inline font-weight="bold">
													<xsl:text>Transaction Type:</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell font-family="Arial" font-size="9pt"
											font-weight="normal" padding="2pt" display-align="center">
											<fo:block>
												<xsl:for-each select="AwardNotice">
													<xsl:for-each select="Award">
														<xsl:for-each select="AwardTransactionInfo">
															<xsl:for-each select="TransactionInfo">
																<xsl:for-each select="TransactionTypeDesc">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates />
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when
																			test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template" />
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template" />
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell font-family="Arial" font-size="9pt"
											font-weight="bold" padding="2pt" display-align="center">
											<fo:block>
												<fo:inline font-weight="bold">
													<xsl:text>Notice Date:</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell font-family="Arial" font-size="9pt"
											font-weight="normal" padding="2pt" display-align="center">
											<fo:block>
												<xsl:for-each select="AwardNotice">
													<xsl:for-each select="Award">
														<xsl:for-each select="AwardTransactionInfo">
															<xsl:for-each select="TransactionInfo">
																<xsl:for-each select="NoticeDate">
																	<fo:inline>
																		<xsl:value-of
																			select="format-number(number(substring(string(string(.)), 6, 2)), '00')" />
																		<xsl:text>/</xsl:text>
																		<xsl:value-of
																			select="format-number(number(substring(string(string(.)), 9, 2)), '00')" />
																		<xsl:text>/</xsl:text>
																		<xsl:value-of
																			select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')" />
																	</fo:inline>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell font-family="Arial" font-size="9pt"
											font-weight="bold" padding="2pt" display-align="center">
											<fo:block>
												<fo:inline font-weight="bold">
													<xsl:text>Comments:</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell font-family="Arial" font-size="9pt"
											font-weight="normal" padding="2pt" display-align="center">
											<fo:block>
												<xsl:for-each select="AwardNotice">
													<xsl:for-each select="Award">
														<xsl:for-each select="AwardTransactionInfo">
															<xsl:for-each select="TransactionInfo">
																<xsl:for-each select="Comments">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates />
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when
																			test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template" />
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template" />
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>

								</fo:table-body>
							</fo:table>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x2029;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<xsl:if test="AwardNotice/Award/AwardInvestigators/Investigator">
								<fo:table font-family="Arial" table-layout="fixed"
									width="100%" border-spacing="2pt">
									<fo:table-column column-width="181" />
									<fo:table-column column-width="181" />
									<fo:table-column column-width="38%" />
									<fo:table-header start-indent="0pt">
										<fo:table-row>
											<fo:table-cell font-family="Arial" font-size="9pt"
												font-weight="normal" padding="2pt" display-align="center">
												<fo:block>
									              <xsl:text>&#160;</xsl:text>
								                </fo:block>
												<fo:block>
													<fo:inline font-family="Arial" font-size="9pt"
														font-weight="bold">
														<xsl:text>Investigator:</xsl:text>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell padding="2pt" display-align="center">
												<fo:block>
													<fo:inline font-family="Arial" font-size="9pt"
														font-weight="bold">
														<xsl:text>Address:</xsl:text>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell padding-left="0pt" padding="2pt"
												text-align="left" display-align="center">
												<fo:block>
													<fo:inline font-family="Arial" font-size="9pt"
														font-weight="bold">
														<xsl:text>Unit:</xsl:text>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
									</fo:table-header>
									<fo:table-body start-indent="0pt">
										<xsl:for-each select="AwardNotice">
											<xsl:for-each select="Award">
												<xsl:for-each select="AwardInvestigators">
													<xsl:for-each select="Investigator">
														<fo:table-row>
															<fo:table-cell font-family="Arial"
																font-size="9pt" font-weight="normal" padding-left="10pt"
																padding="2pt" display-align="before">
																<fo:block>
																	<xsl:for-each select="PersonName">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates />
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when
																				test="contains(string($value-of-template),'&#x2029;')">
																				<fo:block font-family="Arial" font-size="9pt">
																					<xsl:copy-of select="$value-of-template" />
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline font-family="Arial" font-size="9pt">
																					<xsl:copy-of select="$value-of-template" />
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																		<fo:inline font-family="Arial" font-size="9pt">
																			<xsl:text>&#160;</xsl:text>
																		</fo:inline>
																		<xsl:if
																			test="../PrincipalInvestigator  =  1 or ../PrincipalInvestigator = &apos;true&apos;">
																			<fo:inline font-family="Arial" font-size="9pt">
																				<xsl:text>(PI)</xsl:text>
																			</fo:inline>
																		</xsl:if>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell font-family="Arial"
																font-size="9pt" font-weight="normal" padding="2pt"
																display-align="before">
																<fo:block>
																	<xsl:for-each select="PersonAddress">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates />
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when
																				test="contains(string($value-of-template),'&#x2029;')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template" />
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template" />
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell font-family="Arial"
																font-size="9pt" font-weight="normal" padding="2pt"
																display-align="before">
																<fo:block>
																	<xsl:for-each select="InvestigatorUnit">
																		<fo:block />
																		<xsl:for-each select="UnitNumber">
																			<xsl:variable name="value-of-template">
																				<xsl:apply-templates />
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when
																					test="contains(string($value-of-template),'&#x2029;')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template" />
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template" />
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																		<fo:inline>
																		    <xsl:text>:</xsl:text>
																			<xsl:text>&#160; </xsl:text>
																		</fo:inline>
																		<xsl:for-each select="UnitName">
																			<xsl:variable name="value-of-template">
																				<xsl:apply-templates />
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when
																					test="contains(string($value-of-template),'&#x2029;')">
																					<fo:block font-family="Arial" font-size="9pt">
																						<xsl:copy-of select="$value-of-template" />
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline font-family="Arial" font-size="9pt">
																						<xsl:copy-of select="$value-of-template" />
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																			<fo:inline font-family="Arial" font-size="9pt">
																				<xsl:text>&#160;</xsl:text>
																			</fo:inline>
																			<xsl:if
																				test="../LeadUnit  = 1 or ../LeadUnit = &apos;true&apos;">
																				<fo:inline font-family="Arial" font-size="9pt"
																					padding-left="0pt">
																					<xsl:text>(LU) </xsl:text>
																				</fo:inline>
																			</xsl:if>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</xsl:for-each>
												</xsl:for-each>
											</xsl:for-each>
										</xsl:for-each>
									</fo:table-body>
								</fo:table>
							</xsl:if>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x2029;</xsl:text>
								</fo:block>
							</fo:inline-container>
							    <fo:block>
									<xsl:text>&#160;</xsl:text>
								</fo:block>
							<fo:table font-family="Arial" font-size="9pt"
								table-layout="fixed" width="100%" border-spacing="2pt">
								<fo:table-column column-width="15%" />
								<fo:table-column column-width="proportional-column-width(1)" />
								<fo:table-column column-width="proportional-column-width(1)" />
								<fo:table-column column-width="proportional-column-width(1)" />
								<fo:table-body start-indent="0pt">
									<fo:table-row>
										<fo:table-cell font-family="Arial" font-size="9pt"
											font-weight="bold" padding="2pt" display-align="center">
											<fo:block>
												<fo:inline>
													<xsl:text>Sponsor:</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell font-family="Arial" font-size="9pt"
											font-weight="normal" padding-right="20pt"
											number-columns-spanned="3" padding="2pt" text-align="left"
											display-align="center">
											<fo:block>
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:block white-space="pre" white-space-collapse="false"
													wrap-option="wrap" white-space-treatment="ignore-if-surrounding-linefeed"
													margin="0pt">
													<fo:block>
														<xsl:for-each select="AwardNotice">
															<xsl:for-each select="Award">
																<xsl:for-each select="AwardDetails">
																	<xsl:for-each select="AwardHeader">
																		<xsl:for-each select="SponsorCode">
																			<xsl:variable name="value-of-template">
																				<xsl:apply-templates />
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when
																					test="contains(string($value-of-template),'&#x2029;')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template" />
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template" />
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																		<fo:inline>
																			<xsl:text> - </xsl:text>
																		</fo:inline>
																		<xsl:for-each select="SponsorDescription">
																			<xsl:variable name="value-of-template">
																				<xsl:apply-templates />
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when
																					test="contains(string($value-of-template),'&#x2029;')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template" />
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template" />
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:block>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x2029;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:table table-layout="fixed" width="100%"
								border-spacing="2pt">
								<fo:table-column column-width="15%" />
								<fo:table-column column-width="46%" />
								<fo:table-column column-width="16%" />
								<fo:table-column column-width="23%" />
								<fo:table-body start-indent="0pt">
									<fo:table-row>
										<fo:table-cell font-family="Arial" font-size="9pt"
											font-weight="bold" padding="2pt" display-align="center">
											<fo:block>
												<fo:inline>
													<xsl:text>Sponsor Award ID:</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell font-family="Arial" font-size="9pt"
											font-weight="normal" padding-right="20pt" padding="2pt"
											text-align="left" display-align="center">
											<fo:block>
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:block white-space="pre" white-space-collapse="false"
													wrap-option="wrap" white-space-treatment="ignore-if-surrounding-linefeed"
													margin="0pt">
													<fo:block>
														<xsl:for-each select="AwardNotice">
															<xsl:for-each select="Award">
																<xsl:for-each select="AwardDetails">
																	<xsl:for-each select="AwardHeader">
																		<xsl:for-each select="SponsorAwardNumber">
																			<xsl:variable name="value-of-template">
																				<xsl:apply-templates />
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when
																					test="contains(string($value-of-template),'&#x2029;')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template" />
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template" />
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:block>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell font-family="Arial" font-size="9pt"
											font-weight="bold" padding-right="20pt" padding="2pt"
											display-align="center">
											<fo:block>
												<fo:inline>
													<xsl:text> Modification ID:</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell font-family="Arial" font-size="9pt"
											padding-right="20pt" padding="2pt" text-align="left"
											display-align="center">
											<fo:block>
												<xsl:for-each select="AwardNotice">
													<xsl:for-each select="Award">
														<xsl:for-each select="AwardDetails">
															<xsl:for-each select="AwardHeader">
																<xsl:for-each select="ModificationNumber">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates />
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when
																			test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template" />
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template" />
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x2029;</xsl:text>
								</fo:block>
								</fo:inline-container>	
							<fo:table font-family="Arial" font-size="9pt"
								table-layout="fixed" width="100%" border-spacing="2pt">
								<fo:table-column column-width="15%" />
								<fo:table-column column-width="85%" />
								<fo:table-body start-indent="0pt">
									<fo:table-row>
										<fo:table-cell font-family="Arial" font-size="9pt"
											font-weight="bold" padding="2pt" display-align="center">
											<fo:block>
												<fo:inline>
													<xsl:text>CFDA Number:</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell font-family="Arial" font-size="9pt"
											font-weight="normal" padding="2pt" display-align="center">
											<fo:block>
												<xsl:for-each select="AwardNotice">
													<xsl:for-each select="Award">
														<xsl:for-each select="AwardDetails">
															<xsl:for-each select="OtherHeaderDetails">
																<xsl:for-each select="CFDANumber">
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<fo:block white-space="pre"
																		white-space-collapse="false" wrap-option="wrap"
																		white-space-treatment="ignore-if-surrounding-linefeed"
																		margin="0pt">
																		<fo:block>
																			<xsl:variable name="value-of-template">
																				<xsl:apply-templates />
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when
																					test="contains(string($value-of-template),'&#x2029;')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template" />
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template" />
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</fo:block>
																	</fo:block>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>							
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x2029;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:table table-layout="fixed" width="100%"
								border-spacing="2pt">
								<fo:table-column column-width="15%" />
								<fo:table-column column-width="85%" />
								<fo:table-body start-indent="0pt">
									<fo:table-row>
										<fo:table-cell font-family="Arial" font-size="9pt"
											font-weight="bold" padding="2pt" display-align="center">
											<fo:block>
												<fo:inline>
													<xsl:text>Execution Date:</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell font-family="Arial" font-size="9pt"
											font-weight="normal" padding-right="20pt" padding="2pt"
											text-align="left" display-align="after">
											<fo:block>
												<xsl:for-each select="AwardNotice">
													<xsl:for-each select="Award">
														<xsl:for-each select="AwardDetails">
															<xsl:for-each select="ExecutionDate">
																<fo:inline>
																	<xsl:value-of
																		select="format-number(number(substring(string(string(.)), 6, 2)), '00')" />
																	<xsl:text>/</xsl:text>
																	<xsl:value-of
																		select="format-number(number(substring(string(string(.)), 9, 2)), '00')" />
																	<xsl:text>/</xsl:text>
																	<xsl:value-of
																		select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')" />
																</fo:inline>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell font-family="Arial" font-size="9pt"
											font-weight="bold" padding="2pt" display-align="center">
											<fo:block>
												<fo:inline>
													<xsl:text>NSF Science Code:</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell font-family="Arial" font-size="9pt"
											font-weight="normal" padding-right="20pt" padding="2pt"
											text-align="left" display-align="after">
											<fo:block>
												<xsl:for-each select="AwardNotice">
													<xsl:for-each select="Award">
														<xsl:for-each select="AwardDetails">
															<xsl:for-each select="AwardHeader">
																<xsl:for-each select="NSFDescription">
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<fo:block white-space="pre"
																		white-space-collapse="false" wrap-option="wrap"
																		white-space-treatment="ignore-if-surrounding-linefeed"
																		margin="0pt">
																		<fo:block>
																			<xsl:variable name="value-of-template">
																				<xsl:apply-templates />
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when
																					test="contains(string($value-of-template),'&#x2029;')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template" />
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template" />
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</fo:block>
																	</fo:block>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x2029;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:table font-family="Arial" font-size="9pt"
								table-layout="fixed" width="100%" border-spacing="2pt">
								<fo:table-column column-width="15%" />
								<fo:table-column column-width="85%" />
								<fo:table-body start-indent="0pt">
									<fo:table-row>
										<fo:table-cell font-family="Arial" font-size="9pt"
											font-weight="bold" padding="2pt" display-align="center">
											<fo:block>
												<fo:inline>
													<xsl:text>Title:</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell font-family="Arial" font-size="9pt"
											font-weight="normal" padding="2pt" display-align="center">
											<fo:block>
												<xsl:for-each select="AwardNotice">
													<xsl:for-each select="Award">
														<xsl:for-each select="AwardDetails">
															<xsl:for-each select="AwardHeader">
																<xsl:for-each select="Title">
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<fo:block white-space="pre"
																		white-space-collapse="false" wrap-option="wrap"
																		white-space-treatment="ignore-if-surrounding-linefeed"
																		margin="0pt">
																		<fo:block>
																			<xsl:variable name="value-of-template">
																				<xsl:apply-templates />
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when
																					test="contains(string($value-of-template),'&#x2029;')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template" />
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template" />
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</fo:block>
																	</fo:block>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>
							<fo:block>
								<fo:leader leader-pattern="space" />
							</fo:block>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x2029;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:block margin="0pt">
								<fo:block />
							</fo:block>
							<xsl:choose>
								<xsl:when
									test="AwardNotice/PrintRequirement/SignatureRequired  =  &quot;0&quot;" />
								<xsl:when
									test="AwardNotice/PrintRequirement/SignatureRequired  =   true()">
									<fo:inline-container>
										<fo:block>
											<xsl:text>&#x2029;</xsl:text>
										</fo:block>
									</fo:inline-container>
									<fo:table table-layout="fixed" width="100%" border="solid 1pt gray"
										border-spacing="2pt">
										<fo:table-column column-width="proportional-column-width(1)" />
										<fo:table-column column-width="proportional-column-width(1)" />
										<fo:table-column column-width="proportional-column-width(1)" />
										<fo:table-column column-width="proportional-column-width(1)" />
										<fo:table-body start-indent="0pt">
											<fo:table-row>
												<fo:table-cell font-family="Arial"
													line-height="13pt" padding="6pt" number-columns-spanned="4"
													border="solid 1pt gray" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="9pt"
															font-weight="bold">
															<xsl:text>Signatures on Notice of Award REQUIRED.&#160; Please indicate your approval of the terms and conditions identified in the document and return this notice to </xsl:text>
														</fo:inline>
														<xsl:for-each select="AwardNotice">
															<xsl:for-each select="Award">
																<xsl:for-each select="AwardDetails">
																	<xsl:for-each select="OtherHeaderDetails">
																		<xsl:for-each select="FellowshipAdminName">
																			<xsl:variable name="value-of-template">
																				<xsl:apply-templates />
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when
																					test="contains(string($value-of-template),'&#x2029;')">
																					<fo:block font-family="Arial" font-size="9pt"
																						font-weight="bold">
																						<xsl:copy-of select="$value-of-template" />
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline font-family="Arial" font-size="9pt"
																						font-weight="bold">
																						<xsl:copy-of select="$value-of-template" />
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
														<fo:inline font-family="Arial" font-size="9pt"
															font-weight="bold">
															<xsl:text>, E19-750. Any attachments may be kept for your records.</xsl:text>
														</fo:inline>
														<fo:inline-container>
															<fo:block>
																<xsl:text>&#x2029;</xsl:text>
															</fo:block>
														</fo:inline-container>
														<fo:table border-collapse="separate"
															table-layout="fixed" width="100%" border-spacing="2pt">
															<fo:table-column column-width="20%" />
															<fo:table-column column-width="50%" />
															<fo:table-column column-width="10%" />
															<fo:table-column column-width="20%" />
															<fo:table-body start-indent="0pt">
																<fo:table-row>
																	<fo:table-cell font-family="Arial"
																		line-height="13pt" padding-left="36pt" padding="2pt"
																		text-align="left" display-align="center">
																		<fo:block>
																			<fo:inline font-family="Arial" font-size="9pt"
																				font-weight="bold">
																				<xsl:text>PI Signature :</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell font-family="Arial"
																		line-height="13pt" padding="2pt" text-align="center"
																		display-align="after">
																		<fo:block>
																			<fo:inline font-family="Arial" font-size="9pt"
																				font-weight="bold">
																				<xsl:text>______________________________</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell font-family="Arial"
																		line-height="13pt" padding="2pt" display-align="center">
																		<fo:block>
																			<fo:inline font-family="Arial" font-size="9pt"
																				font-weight="bold">
																				<xsl:text>Date:</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell font-family="Arial"
																		line-height="13pt" padding="2pt" display-align="center">
																		<fo:block>
																			<fo:inline font-family="Arial" font-size="9pt"
																				font-weight="bold">
																				<xsl:text>_______________</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:table-cell>
																</fo:table-row>
																<fo:table-row>
																	<fo:table-cell font-family="Arial"
																		line-height="13pt" padding-left="36pt" padding="2pt"
																		text-align="left" display-align="center">
																		<fo:block>
																			<fo:inline font-family="Arial" font-size="9pt"
																				font-weight="bold">
																				<xsl:text>AO Signature :</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell font-family="Arial"
																		line-height="13pt" padding="2pt" text-align="center"
																		display-align="center">
																		<fo:block>
																			<fo:inline font-family="Arial" font-size="9pt"
																				font-weight="bold">
																				<xsl:text>______________________________</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell font-family="Arial"
																		line-height="13pt" padding="2pt" display-align="center">
																		<fo:block>
																			<fo:inline font-family="Arial" font-size="9pt"
																				font-weight="bold">
																				<xsl:text>Date:</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell font-family="Arial"
																		line-height="13pt" padding="2pt" display-align="center">
																		<fo:block>
																			<fo:inline font-family="Arial" font-size="9pt"
																				font-weight="bold">
																				<xsl:text>_______________</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:table-cell>
																</fo:table-row>
																<fo:table-row>
																	<fo:table-cell font-family="Arial"
																		line-height="13pt" padding-left="36pt" padding="2pt"
																		text-align="left" display-align="center">
																		<fo:block>
																			<fo:inline font-family="Arial" font-size="9pt"
																				font-weight="bold">
																				<xsl:text>OSP Signature :</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell font-family="Arial"
																		line-height="13pt" padding="2pt" text-align="center"
																		display-align="center">
																		<fo:block>
																			<fo:inline font-family="Arial" font-size="9pt"
																				font-weight="bold">
																				<xsl:text>______________________________</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell font-family="Arial"
																		line-height="13pt" padding="2pt" display-align="center">
																		<fo:block>
																			<fo:inline font-family="Arial" font-size="9pt"
																				font-weight="bold">
																				<xsl:text>Date:</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell font-family="Arial"
																		line-height="13pt" padding="2pt" display-align="center">
																		<fo:block>
																			<fo:inline font-family="Arial" font-size="9pt"
																				font-weight="bold">
																				<xsl:text>_______________</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:table-cell>
																</fo:table-row>
															</fo:table-body>
														</fo:table>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-body>
									</fo:table>
								</xsl:when>
							</xsl:choose>
							<xsl:if
								test="AwardNotice/PrintRequirement/SignatureRequired  =  &quot;0&quot;">
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:table color="black" font-family="Arial"
									table-layout="fixed" width="100%" border="solid 1pt gray"
									border-spacing="2pt">
									<fo:table-column column-width="proportional-column-width(1)" />
									<fo:table-body start-indent="0pt">
										<fo:table-row>
											<fo:table-cell font-family="Arial" border="solid 1pt gray"
												padding="2pt" display-align="center">
												<fo:block>
													<fo:inline font-family="Arial" font-size="9pt"
														font-weight="bold">
														<xsl:text>Signatures on Notice of Award NOT REQUIRED.&#160; Expenditure of funds signifies agreement with terms and conditions of award.</xsl:text>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
									</fo:table-body>
								</fo:table>
							</xsl:if>
							<fo:block />
							<fo:block>
								<fo:leader leader-pattern="space" />
							</fo:block>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x2029;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:block margin="0pt">
								<fo:block />
							</fo:block>
							<fo:block />
							









							<fo:table font-family="Arial" table-layout="fixed"

































































































































































































									width="100%" border-spacing="2pt">
									<fo:table-column column-width="20%" />
									<fo:table-column column-width="30%" />	
									<fo:table-column column-width="20%" />
									<fo:table-column column-width="30%" />								
									<fo:table-header start-indent="0pt">
										<fo:table-row>
											<fo:table-cell font-family="Arial" font-size="9pt"
												font-weight="normal" padding="2pt" display-align="center">
												<fo:block>
									              <xsl:text>&#160;</xsl:text>
								                </fo:block>
												<fo:block>
													<fo:inline font-family="Arial" font-size="12pt"
														font-weight="bold">


														<xsl:text>Anticipated</xsl:text>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell >
												<fo:block>
									              <xsl:text>&#160;</xsl:text>
								                </fo:block>												
											</fo:table-cell>											
											<fo:table-cell padding-left="0pt" padding="2pt"
												text-align="left" display-align="center">
												<fo:block>
													<fo:inline font-family="Arial" font-size="12pt"
														font-weight="bold">
														<xsl:text>Obligated</xsl:text>
























													</fo:inline>












												</fo:block>
											</fo:table-cell>
											<fo:table-cell >
												<fo:block>
									              <xsl:text>&#160;</xsl:text>
								                </fo:block>												
											</fo:table-cell>
										</fo:table-row>
									</fo:table-header>
									<fo:table-body start-indent="0pt">
														<fo:table-row>
														   <fo:table-cell padding-left="0pt" padding="2pt"
												               text-align="left" display-align="center">
												                <fo:block>
													            <fo:inline font-family="Arial" font-size="9pt"
														              font-weight="bold">
														          <xsl:text>Project Start Date:</xsl:text>
													            </fo:inline>
												                </fo:block>
											                </fo:table-cell>															


















															<fo:table-cell font-family="Arial" font-size="9pt"		
											                       font-weight="normal" padding="2pt" display-align="center">
											  					<fo:block>											  					  
																	<xsl:for-each select="AwardNotice">
																		<xsl:for-each select="Award">
																			<xsl:for-each select="AwardDetails">
																				<xsl:for-each select="EffectiveDate">
																					<fo:inline>
																					<xsl:value-of
																						select="format-number(number(substring(string(string(.)), 6, 2)), '00')" />
																						<xsl:text>/</xsl:text>
																					<xsl:value-of
																						select="format-number(number(substring(string(string(.)), 9, 2)), '00')" />
																						<xsl:text>/</xsl:text>
																					<xsl:value-of
																						select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')" />
																					</fo:inline>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
															</fo:block>
															</fo:table-cell>
															 <fo:table-cell padding-left="0pt" padding="2pt"












												               text-align="left" display-align="center">
												                <fo:block>
													            <fo:inline font-family="Arial" font-size="9pt"
														              font-weight="bold">
														          <xsl:text>Obligation Start Date:</xsl:text>
													            </fo:inline>
												                </fo:block>
											                </fo:table-cell>													












																<fo:table-cell font-family="Arial" font-size="9pt"
												                      font-weight="normal" padding="2pt" display-align="center">
												                <fo:block>
																	<xsl:for-each select="$XML">


																		<xsl:for-each select="AwardNotice">
																			<xsl:for-each select="Award">
																				<xsl:for-each select="AwardAmountInfo">
																					<xsl:for-each select="AmountInfo">
																						<xsl:for-each select="CurrentFundEffectiveDate">
																						<fo:inline>
																						<xsl:value-of
																							select="format-number(number(substring(string(string(.)), 6, 2)), '00')" />




																						<xsl:text>/</xsl:text>
																						<xsl:value-of
																							select="format-number(number(substring(string(string(.)), 9, 2)), '00')" />
																						<xsl:text>/</xsl:text>




																						<xsl:value-of
																							select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')" />
																						</fo:inline>
																						</xsl:for-each>
																					</xsl:for-each>
																				</xsl:for-each>
																			</xsl:for-each>


																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>








															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
														   <fo:table-cell padding-left="0pt" padding="2pt"


												               text-align="left" display-align="center">
												                <fo:block>
													            <fo:inline font-family="Arial" font-size="9pt"
														              font-weight="bold">




														          <xsl:text>Project End Date:</xsl:text>
													            </fo:inline>
												                </fo:block>
											                </fo:table-cell>															






															<fo:table-cell font-family="Arial" font-size="9pt"
																font-weight="normal" padding="2pt" display-align="center">
																<fo:block>
																   <xsl:for-each select="$XML">
																	<xsl:for-each select="AwardNotice">
																		<xsl:for-each select="Award">
																			<xsl:for-each select="AwardAmountInfo">
																				<xsl:for-each select="AmountInfo">
																					<xsl:for-each select="FinalExpirationDate">
																						<fo:inline>
																							<xsl:value-of
																								select="format-number(number(substring(string(string(.)), 6, 2)), '00')" />


																								<xsl:text>/</xsl:text>
																							<xsl:value-of
																								select="format-number(number(substring(string(string(.)), 9, 2)), '00')" />
																								<xsl:text>/</xsl:text>




																							<xsl:value-of
																								select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')" />
																						</fo:inline>
																					</xsl:for-each>
																				</xsl:for-each>
																			</xsl:for-each>


																		</xsl:for-each>
																	</xsl:for-each>
																 </xsl:for-each>




																</fo:block>
															</fo:table-cell>
															 <fo:table-cell padding-left="0pt" padding="2pt"
												               text-align="left" display-align="center">
												                <fo:block>
													            <fo:inline font-family="Arial" font-size="9pt"










































































														              font-weight="bold">




														          <xsl:text>Obligation End Date:</xsl:text>
													            </fo:inline>
												                </fo:block>
											                </fo:table-cell>													






															<fo:table-cell font-family="Arial" font-size="9pt"
																font-weight="normal" padding="2pt" display-align="center">
																<fo:block>
																   <xsl:for-each select="$XML">
																	<xsl:for-each select="AwardNotice">
																		<xsl:for-each select="Award">
																			<xsl:for-each select="AwardAmountInfo">
																				<xsl:for-each select="AmountInfo">
																					<xsl:for-each select="ObligationExpirationDate">
																						<fo:inline>




																						<xsl:value-of
																							select="format-number(number(substring(string(string(.)), 6, 2)), '00')" />
																							<xsl:text>/</xsl:text>
																						<xsl:value-of
																							select="format-number(number(substring(string(string(.)), 9, 2)), '00')" />
																							<xsl:text>/</xsl:text>
																						<xsl:value-of
																							select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')" />
																						</fo:inline>
																					</xsl:for-each>
																				</xsl:for-each>
																			</xsl:for-each>


																		</xsl:for-each>
																	</xsl:for-each>
																  </xsl:for-each>
																</fo:block>








															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
														   <fo:table-cell padding-left="0pt" padding="2pt"


												               text-align="left" display-align="center">
												                <fo:block>
													            <fo:inline font-family="Arial" font-size="9pt"
														              font-weight="bold">
														          <xsl:text>Anticipated Total Direct:</xsl:text>
													            </fo:inline>
												                </fo:block>
											                </fo:table-cell>															












															<fo:table-cell font-family="Arial" font-size="9pt"
																font-weight="normal" padding="2pt" display-align="center">
																<fo:block>
																	<xsl:for-each select="$XML">
																		<xsl:for-each select="AwardNotice">
																			<xsl:for-each select="Award">
																				<xsl:for-each select="AwardAmountInfo">
																					<xsl:for-each select="AmountInfo">
																						<xsl:for-each select="AnticipatedTotalDirect">
																							<fo:inline>
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline>








																								<xsl:value-of
																								select="format-number(number(string(.)), '#,###,###,##0.00')" />
																							</fo:inline>
																						</xsl:for-each>
																					</xsl:for-each>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>








																	</xsl:for-each>
																</fo:block>










															</fo:table-cell>
															 <fo:table-cell padding-left="0pt" padding="2pt"
												               text-align="left" display-align="center">
												                <fo:block>
































													            <fo:inline font-family="Arial" font-size="9pt"
														              font-weight="bold">




														          <xsl:text>Obligated Total Direct:</xsl:text>
													            </fo:inline>
												                </fo:block>
											                </fo:table-cell>													






															<fo:table-cell font-family="Arial" font-size="9pt"
																font-weight="normal" padding="2pt" display-align="center">
																<fo:block>
																  <xsl:for-each select="$XML">
																	<xsl:for-each select="AwardNotice">
																		<xsl:for-each select="Award">
																			<xsl:for-each select="AwardAmountInfo">
																				<xsl:for-each select="AmountInfo">
																					<xsl:for-each select="ObligatedTotalDirect">
																						<fo:inline>


																							<xsl:text>$</xsl:text>
																						</fo:inline>
																						<fo:inline>


																							<xsl:value-of
																							select="format-number(number(string(.)), '###,###,###,###,##0.00')" />
																						</fo:inline>
																					</xsl:for-each>
																				</xsl:for-each>
																			</xsl:for-each>


																		</xsl:for-each>
																	</xsl:for-each>
																  </xsl:for-each>	
																</fo:block>






															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
														   <fo:table-cell padding-left="0pt" padding="2pt"


												               text-align="left" display-align="center">
												                <fo:block>
													            <fo:inline font-family="Arial" font-size="9pt"
														              font-weight="bold">




														          <xsl:text>Anticipated FA:</xsl:text>
													            </fo:inline>
												                </fo:block>
											                </fo:table-cell>															






															<fo:table-cell font-family="Arial" font-size="9pt"
																font-weight="normal" padding="2pt" display-align="center">
																<fo:block>
																	<xsl:for-each select="$XML">
																		<xsl:for-each select="AwardNotice">
																			<xsl:for-each select="Award">
																				<xsl:for-each select="AwardAmountInfo">
																					<xsl:for-each select="AmountInfo">
																						<xsl:for-each select="AnticipatedTotalIndirect">
																							<fo:inline>




																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline>


																								<xsl:value-of
																								select="format-number(number(string(.)), '#,###,###,##0.00')" />
																							</fo:inline>
																						</xsl:for-each>
																					</xsl:for-each>
																				</xsl:for-each>
																			</xsl:for-each>


																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>








															</fo:table-cell>
															 <fo:table-cell padding-left="0pt" padding="2pt"
												               text-align="left" display-align="center">
												                <fo:block>






























													            <fo:inline font-family="Arial" font-size="9pt"
														              font-weight="bold">




														          <xsl:text>Obligated FA:</xsl:text>
													            </fo:inline>
												                </fo:block>
											                </fo:table-cell>													






															<fo:table-cell font-family="Arial" font-size="9pt"
																font-weight="normal" padding="2pt" display-align="center">
																<fo:block>
																  <xsl:for-each select="$XML">
																	<xsl:for-each select="AwardNotice">
																		<xsl:for-each select="Award">
																			<xsl:for-each select="AwardAmountInfo">
																				<xsl:for-each select="AmountInfo">
																					<xsl:for-each select="ObligatedTotalIndirect">
																						<fo:inline>


																							<xsl:text>$</xsl:text>
																						</fo:inline>
																						<fo:inline>


																							<xsl:value-of
																							select="format-number(number(string(.)), '###,###,###,###,##0.00')" />
																						</fo:inline>
																					</xsl:for-each>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>


																	</xsl:for-each>
																  </xsl:for-each>	
																</fo:block>








															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
														   <fo:table-cell padding-left="0pt" padding="2pt"
												               text-align="left" display-align="center">
												                <fo:block>




























													            <fo:inline font-family="Arial" font-size="9pt"
														              font-weight="bold">
														          <xsl:text>Anticipated Total Award:</xsl:text>
													            </fo:inline>
												                </fo:block>
											                </fo:table-cell>															












															<fo:table-cell font-family="Arial" font-size="9pt"
																font-weight="normal" padding="2pt" display-align="center">
																<fo:block>
																	<xsl:for-each select="$XML">
																		<xsl:for-each select="AwardNotice">
																			<xsl:for-each select="Award">
																				<xsl:for-each select="AwardAmountInfo">
																					<xsl:for-each select="AmountInfo">
																						<xsl:for-each select="AnticipatedTotalAmt">
																							<fo:inline>


																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline>


																								<xsl:value-of
																								select="format-number(number(string(.)), '#,###,###,##0.00')" />
																							</fo:inline>
																						</xsl:for-each>
																					</xsl:for-each>
																				</xsl:for-each>
																			</xsl:for-each>


																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>








															</fo:table-cell>
															 <fo:table-cell padding-left="0pt" padding="2pt"






												               text-align="left" display-align="center">
												                <fo:block>
													            <fo:inline font-family="Arial" font-size="9pt"
														              font-weight="bold">
														          <xsl:text>Obligated Total Award:</xsl:text>
													            </fo:inline>
												                </fo:block>
											                </fo:table-cell>													












															<fo:table-cell font-family="Arial" font-size="9pt"
																font-weight="normal" padding="2pt" display-align="center">
																<fo:block>
																  <xsl:for-each select="$XML">
																	<xsl:for-each select="AwardNotice">
																		<xsl:for-each select="Award">
																			<xsl:for-each select="AwardAmountInfo">
																				<xsl:for-each select="AmountInfo">
																					<xsl:for-each select="AmtObligatedToDate">
																						<fo:inline>


																							<xsl:text>$</xsl:text>
																						</fo:inline>
																						<fo:inline>


																							<xsl:value-of
																							select="format-number(number(string(.)), '###,###,###,###,##0.00')" />
																						</fo:inline>
																					</xsl:for-each>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																  </xsl:for-each>	
																</fo:block>



															</fo:table-cell>
														</fo:table-row>		
									             </fo:table-body>
								          </fo:table>		


							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x2029;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:block>
									<xsl:text>&#160;</xsl:text>
							</fo:block>
							<fo:table table-layout="fixed" width="100%"
								border-spacing="2pt">
							    <fo:table-column column-width="15%" />
								<fo:table-column column-width="41%" />
								<fo:table-column column-width="17%" />
								<fo:table-column column-width="27%" />								<fo:table-body start-indent="0pt">
									<fo:table-row>
										<fo:table-cell font-family="Arial" font-size="9pt"
											font-weight="bold" padding="2pt" display-align="center">
											<fo:block>
												<fo:inline font-weight="bold">
													<xsl:text>Activity Type:</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell font-family="Arial" font-size="9pt"
											font-weight="normal" number-columns-spanned="3" padding="2pt"
											display-align="center">
											<fo:block>
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:block white-space="pre" white-space-collapse="false"
													wrap-option="wrap" white-space-treatment="ignore-if-surrounding-linefeed"
													margin="0pt">
													<fo:block>
														<xsl:for-each select="AwardNotice">
															<xsl:for-each select="Award">
																<xsl:for-each select="AwardDetails">
																	<xsl:for-each select="OtherHeaderDetails">
																		<xsl:for-each select="ActivityTypeDesc">
																			<xsl:variable name="value-of-template">
																				<xsl:apply-templates />
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when
																					test="contains(string($value-of-template),'&#x2029;')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template" />
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template" />
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:block>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell font-family="Arial" font-size="9pt"
											font-weight="bold" padding="2pt" display-align="center">
											<fo:block>
												<fo:inline font-weight="bold">
													<xsl:text>Award Type:</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell font-family="Arial" font-size="9pt"
											font-weight="normal" number-columns-spanned="3" padding="2pt"
											display-align="center">
											<fo:block>
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:block white-space="pre" white-space-collapse="false"
													wrap-option="wrap" white-space-treatment="ignore-if-surrounding-linefeed"
													margin="0pt">
													<fo:block>
														<xsl:for-each select="AwardNotice">
															<xsl:for-each select="Award">
																<xsl:for-each select="AwardDetails">
																	<xsl:for-each select="OtherHeaderDetails">
																		<xsl:for-each select="AwardTypeDesc">
																			<xsl:variable name="value-of-template">
																				<xsl:apply-templates />
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when
																					test="contains(string($value-of-template),'&#x2029;')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template" />
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template" />
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:block>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell font-family="Arial" font-size="9pt"
											font-weight="bold" padding="2pt" display-align="center">
											<fo:block>
												<fo:inline font-weight="bold">
													<xsl:text>Account Type:</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell font-family="Arial" font-size="9pt"
											font-weight="normal" padding="2pt" display-align="center">
											<fo:block>
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:block white-space="pre" white-space-collapse="false"
													wrap-option="wrap" white-space-treatment="ignore-if-surrounding-linefeed"
													margin="0pt">
													<fo:block>
														<xsl:for-each select="AwardNotice">
															<xsl:for-each select="Award">
																<xsl:for-each select="AwardDetails">
																	<xsl:for-each select="OtherHeaderDetails">
																		<xsl:for-each select="AccountTypeDesc">
																			<xsl:variable name="value-of-template">
																				<xsl:apply-templates />
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when
																					test="contains(string($value-of-template),'&#x2029;')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template" />
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template" />
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:block>
											</fo:block>																				
										</fo:table-cell>
										<fo:table-cell font-family="Arial" font-size="9pt"
											font-weight="bold" padding="2pt" display-align="center">
											<fo:block>
												<xsl:if
													test="substring(AwardNotice/Award/AwardDetails/AwardHeader/AwardNumber ,8)!=&quot;001&quot;">
													<fo:inline font-weight="bold">
														<xsl:text>Root Account ID:</xsl:text>
													</fo:inline>
													<fo:inline>
														<xsl:text>&#160;</xsl:text>
													</fo:inline>
												</xsl:if>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell font-family="Arial" font-size="9pt"
											font-weight="bold" padding="2pt" display-align="center">
											<fo:block>
												<xsl:if
													test="substring(AwardNotice/Award/AwardDetails/AwardHeader/AwardNumber ,8)!=&quot;001&quot;">
													<fo:block />
													<xsl:for-each select="AwardNotice">
														<xsl:for-each select="Award">
															<xsl:for-each select="AwardDetails">
																<xsl:for-each select="OtherHeaderDetails">
																	<xsl:for-each select="RootAccountNumber">
																		<fo:inline-container>
																			<fo:block>
																				<xsl:text>&#x2029;</xsl:text>
																			</fo:block>
																		</fo:inline-container>
																		<fo:block white-space="pre"
																			white-space-collapse="false" wrap-option="wrap"
																			white-space-treatment="ignore-if-surrounding-linefeed"
																			margin="0pt">
																			<fo:block>
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates />
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when
																						test="contains(string($value-of-template),'&#x2029;')">
																						<fo:block font-weight="normal">
																							<xsl:copy-of select="$value-of-template" />
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline font-weight="normal">
																							<xsl:copy-of select="$value-of-template" />
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</fo:block>
																		</fo:block>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:if>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>
							<fo:block />
							<fo:block>
							  <xsl:text>&#160;</xsl:text>
							</fo:block>	
							<xsl:if
								test="(boolean( AwardNotice/Award/AwardDetails/OtherHeaderDetails/PreAwardAuthorizedAmt )  =  true() and  number(AwardNotice/Award/AwardDetails/OtherHeaderDetails/PreAwardAuthorizedAmt) &gt;0 ) or boolean( AwardNotice/Award/AwardDetails/OtherHeaderDetails/PreAwardEffectiveDate )">
								<fo:inline font-family="Arial" font-size="12pt"
									font-weight="bold">
									<xsl:text>Preaward Authorizations:</xsl:text>
								</fo:inline>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:table font-family="Arial" font-weight="normal"
									table-layout="fixed" width="100%" border-spacing="2pt">
									<fo:table-column column-width="31%" />
									<fo:table-column column-width="25%" />
								    <fo:table-column column-width="17%" />
								    <fo:table-column column-width="27%" />
									<fo:table-body font-weight="normal" start-indent="0pt">
										<fo:table-row font-weight="normal">
											<fo:table-cell font-family="Arial" font-size="9pt"
												font-weight="bold" padding="2pt" display-align="center">
												<fo:block>
													<fo:inline font-family="Arial" font-size="9pt"
														font-weight="bold">
														<xsl:text>Sponsor Authorized Amount:</xsl:text>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell font-family="Arial" font-size="9pt"
												font-weight="normal" padding-left="4pt" padding="2pt"
												display-align="center">
												<fo:block>
													<xsl:for-each select="AwardNotice">
														<xsl:for-each select="Award">
															<xsl:for-each select="AwardDetails">
																<xsl:for-each select="OtherHeaderDetails">
																	<xsl:for-each select="PreAwardAuthorizedAmt">
																		<fo:inline>
																			<xsl:text>$</xsl:text>
																		</fo:inline>
																		<fo:inline font-family="Arial" font-size="9pt">
																			<xsl:value-of
																				select="format-number(number(string(.)), '#,###,###,##0.00')" />
																		</fo:inline>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</fo:block>
											</fo:table-cell>	
											<fo:table-cell font-family="Arial" font-size="9pt"
												font-weight="bold" padding="2pt" display-align="center">
												<fo:block>
													<fo:inline font-family="Arial" font-size="9pt"
														font-weight="bold">
														<xsl:text>Effective Date:</xsl:text>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell font-family="Arial" font-size="9pt"
												font-weight="normal" padding-left="4pt" padding="2pt"
												display-align="center">
												<fo:block>
													<xsl:for-each select="AwardNotice">
														<xsl:for-each select="Award">
															<xsl:for-each select="AwardDetails">
																<xsl:for-each select="OtherHeaderDetails">
																	<xsl:for-each select="PreAwardEffectiveDate">
																		<fo:inline font-family="Arial" font-size="9pt">
																			<xsl:value-of
																				select="format-number(number(substring(string(string(.)), 6, 2)), '00')" />
																			<xsl:text>/</xsl:text>
																			<xsl:value-of
																				select="format-number(number(substring(string(string(.)), 9, 2)), '00')" />
																			<xsl:text>/</xsl:text>
																			<xsl:value-of
																				select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')" />
																		</fo:inline>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
										<fo:table-row>
											<fo:table-cell font-family="Arial" font-size="9pt"
												font-weight="bold" padding="2pt" display-align="center">
												<fo:block>
													<fo:inline font-family="Arial" font-size="9pt"
														font-weight="bold">
														<xsl:text>Comments:</xsl:text>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell font-family="Arial" font-size="9pt"
											font-weight="normal" number-columns-spanned="3" padding="2pt"
											display-align="center">
											<fo:block>
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:block white-space="pre" white-space-collapse="false"
													wrap-option="wrap" white-space-treatment="ignore-if-surrounding-linefeed"
													margin="0pt">
													<fo:block>		
                                                            <xsl:if
												                  test="count( AwardNotice/Award/AwardComments/Comment [CommentDetails/CommentCode  &gt; 0  and  string-length(CommentDetails/Comments ) &gt;= 1] )  &gt; 0">
												      			  <xsl:for-each select="AwardNotice">
												       				<xsl:for-each select="Award">
												      		   			 <xsl:for-each select="AwardComments">
												      		   				<xsl:for-each select="Comment">
												      		   		       		<xsl:if
															                		 test="CommentDetails/CommentCode  =18  and  string-length(CommentDetails/Comments ) &gt;= 1">
												      		      						<xsl:for-each select="CommentDetails">
																							<xsl:for-each select="Comments">
																								<fo:inline-container>
																									<fo:block>
																										<xsl:text>&#x2029;</xsl:text>
																									</fo:block>
																									</fo:inline-container>
																									<fo:block white-space="pre"
																										white-space-collapse="false" wrap-option="wrap"
																										white-space-treatment="ignore-if-surrounding-linefeed"
																										margin="0pt">
																									<fo:block>
																										<xsl:variable name="value-of-template">
																											<xsl:apply-templates />
																										</xsl:variable>
																											<xsl:choose>
																												<xsl:when
																													test="contains(string($value-of-template),'&#x2029;')">
																													<fo:block line-height="9pt">
																														<xsl:copy-of select="$value-of-template" />
																													</fo:block>
																												</xsl:when>
																												<xsl:otherwise>
																												<fo:inline line-height="9pt">
																													<xsl:copy-of select="$value-of-template" />
																												</fo:inline>
																												</xsl:otherwise>
																											</xsl:choose>
																									</fo:block>
																									</fo:block>
																							</xsl:for-each>
																						</xsl:for-each>
												      		      					</xsl:if>
												              					 </xsl:for-each>
												             				</xsl:for-each>
												          			</xsl:for-each>  
												      			</xsl:for-each>
															</xsl:if>
													</fo:block>
												</fo:block>
											</fo:block>
										</fo:table-cell>
										</fo:table-row>
										<fo:table-row font-weight="normal">
											<fo:table-cell font-family="Arial" font-size="9pt"
												font-weight="bold" padding="2pt" display-align="center">
												<fo:block>
													<fo:inline font-family="Arial" font-size="9pt"
														font-weight="bold">
														<xsl:text>Institutional Authorized Amount:</xsl:text>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell font-family="Arial" font-size="9pt"
												font-weight="normal" padding-left="4pt" padding="2pt"
												display-align="center">
												<fo:block>
													<xsl:for-each select="AwardNotice">
														<xsl:for-each select="Award">
															<xsl:for-each select="AwardDetails">
																<xsl:for-each select="OtherHeaderDetails">
																	<xsl:for-each select="PreAwardAuthorizedAmtModifeid">
																		<fo:inline>
																			<xsl:text>$</xsl:text>
																		</fo:inline>
																		<fo:inline font-family="Arial" font-size="9pt">
																			<xsl:value-of
																				select="format-number(number(string(.)), '#,###,###,##0.00')" />
																		</fo:inline>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell font-family="Arial" font-size="9pt"
												font-weight="bold" padding="2pt" display-align="center">
												<fo:block>
													<fo:inline font-family="Arial" font-size="9pt"
														font-weight="bold">
														<xsl:text>Effective Date:</xsl:text>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell font-family="Arial" font-size="9pt"
												font-weight="normal" padding-left="4pt" padding="2pt"
												display-align="center">
												<fo:block>
													<xsl:for-each select="AwardNotice">
														<xsl:for-each select="Award">
															<xsl:for-each select="AwardDetails">
																<xsl:for-each select="OtherHeaderDetails">
																	<xsl:for-each select="PreAwardEffectiveDateModifeid">
																		<xsl:variable name="value-of-template">
																				<xsl:apply-templates />
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when
																					test="contains(string($value-of-template),'&#x2029;')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template" />
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template" />
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
										<fo:table-row>
											<fo:table-cell font-family="Arial" font-size="9pt"
												font-weight="bold" padding="2pt" display-align="center">
												<fo:block>
													<fo:inline font-family="Arial" font-size="9pt"
														font-weight="bold">
														<xsl:text>Comments:</xsl:text>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell font-family="Arial" font-size="9pt"
											font-weight="normal" number-columns-spanned="3" padding="2pt"
											display-align="center">
											<fo:block>
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:block white-space="pre" white-space-collapse="false"
													wrap-option="wrap" white-space-treatment="ignore-if-surrounding-linefeed"
													margin="0pt">
													<fo:block>		
                                                            <xsl:if
												                  test="count( AwardNotice/Award/AwardComments/Comment [CommentDetails/CommentCode  &gt; 0  and  string-length(CommentDetails/Comments ) &gt;= 1] )  &gt; 0">
												      			  <xsl:for-each select="AwardNotice">
												       				<xsl:for-each select="Award">
												      		   			 <xsl:for-each select="AwardComments">
												      		   				<xsl:for-each select="Comment">
												      		   		       		<xsl:if
															                		 test="CommentDetails/CommentCode  =19  and  string-length(CommentDetails/Comments ) &gt;= 1">
												      		      						<xsl:for-each select="CommentDetails">
																							<xsl:for-each select="Comments">
																								<fo:inline-container>
																									<fo:block>
																										<xsl:text>&#x2029;</xsl:text>
																									</fo:block>
																									</fo:inline-container>
																									<fo:block white-space="pre"
																										white-space-collapse="false" wrap-option="wrap"
																										white-space-treatment="ignore-if-surrounding-linefeed"
																										margin="0pt">
																									<fo:block>
																										<xsl:variable name="value-of-template">
																											<xsl:apply-templates />
																										</xsl:variable>
																											<xsl:choose>
																												<xsl:when
																													test="contains(string($value-of-template),'&#x2029;')">
																													<fo:block line-height="9pt">
																														<xsl:copy-of select="$value-of-template" />
																													</fo:block>
																												</xsl:when>
																												<xsl:otherwise>
																												<fo:inline line-height="9pt">
																													<xsl:copy-of select="$value-of-template" />
																												</fo:inline>
																												</xsl:otherwise>
																											</xsl:choose>
																									</fo:block>
																									</fo:block>
																							</xsl:for-each>
																						</xsl:for-each>
												      		      					</xsl:if>
												              					 </xsl:for-each>
												             				</xsl:for-each>
												          			</xsl:for-each>  
												      			</xsl:for-each>
															</xsl:if>
													</fo:block>
												</fo:block>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									</fo:table-body>
								</fo:table>
							</xsl:if>
							<xsl:for-each select="AwardNotice">
								<fo:block />
								<xsl:for-each select="Award">
									<fo:inline-container>
										<fo:block>
											<xsl:text>&#x2029;</xsl:text>
										</fo:block>
									</fo:inline-container>									
									<fo:table table-layout="fixed" width="100%"
										border-spacing="2pt">
										<fo:table-column column-width="proportional-column-width(1)" />
										<fo:table-body start-indent="0pt">
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block />
												</fo:table-cell>
											</fo:table-row>
										</fo:table-body>
									</fo:table>
									<fo:block />
									<xsl:for-each select="AwardDetails">
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:table font-family="Arial" table-layout="fixed"
											width="100%" border-spacing="2pt">
											<fo:table-column column-width="20%" />
											<fo:table-column column-width="36%" />
											<fo:table-column column-width="10%" />
											<fo:table-column column-width="34%" />
											<fo:table-body start-indent="0pt">
												<fo:table-row font-family="Arial">
													<fo:table-cell font-family="Arial" font-size="9pt"
														font-weight="bold" padding="2pt" display-align="center">
														<fo:block>
															<fo:inline font-weight="bold">
																<xsl:text>Administrative Officer:</xsl:text>
															
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="9pt"
														font-weight="bold" padding="2pt" display-align="center">
														<fo:block>
															<xsl:for-each select="$XML">
																<fo:inline-container>
																	<fo:block>
																		<xsl:text>&#x2029;</xsl:text>
																	</fo:block>
																</fo:inline-container>
																<fo:block white-space="pre"
																	white-space-collapse="false" wrap-option="wrap"
																	white-space-treatment="ignore-if-surrounding-linefeed"
																	margin="0pt">
																	<fo:block>
																		<xsl:for-each select="AwardNotice">
																			<xsl:for-each select="AODetails">
																				<xsl:for-each select="AOName">
																					<xsl:variable name="value-of-template">
																						<xsl:apply-templates />
																					</xsl:variable>
																					<xsl:choose>
																						<xsl:when
																							test="contains(string($value-of-template),'&#x2029;')">
																							<fo:block font-family="Arial" font-size="9pt"
																								font-weight="normal">
																								<xsl:copy-of select="$value-of-template" />
																							</fo:block>
																						</xsl:when>
																						<xsl:otherwise>
																							<fo:inline font-family="Arial"
																								font-size="9pt" font-weight="normal">
																								<xsl:copy-of select="$value-of-template" />
																							</fo:inline>
																						</xsl:otherwise>
																					</xsl:choose>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</fo:block>
																</fo:block>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="9pt"
														font-weight="bold" padding="2pt" display-align="center">
														<fo:block>
															<fo:inline font-weight="bold">
																<xsl:text>Address:</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="9pt"
														font-weight="bold" padding="2pt" display-align="center">
														<fo:block>
															<xsl:for-each select="$XML">
																<fo:inline-container>
																	<fo:block>
																		<xsl:text>&#x2029;</xsl:text>
																	</fo:block>
																</fo:inline-container>
																<fo:block white-space="pre"
																	white-space-collapse="false" wrap-option="wrap"
																	white-space-treatment="ignore-if-surrounding-linefeed"
																	margin="0pt">
																	<fo:block>
																		<xsl:for-each select="AwardNotice">
																			<xsl:for-each select="AODetails">
																				<xsl:for-each select="AOAddress">
																					<xsl:variable name="value-of-template">
																						<xsl:apply-templates />
																					</xsl:variable>
																					<xsl:choose>
																						<xsl:when
																							test="contains(string($value-of-template),'&#x2029;')">
																							<fo:block font-family="Arial" font-size="9pt"
																								font-weight="normal">
																								<xsl:copy-of select="$value-of-template" />
																							</fo:block>
																						</xsl:when>
																						<xsl:otherwise>
																							<fo:inline font-family="Arial"
																								font-size="9pt" font-weight="normal">
																								<xsl:copy-of select="$value-of-template" />
																							</fo:inline>
																						</xsl:otherwise>
																					</xsl:choose>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</fo:block>
																</fo:block>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</xsl:for-each>
									<fo:inline-container>
										<fo:block>
											<xsl:text>&#x2029;</xsl:text>
										</fo:block>
										<fo:block>
											<xsl:text>&#160;</xsl:text>											
										</fo:block>										
									</fo:inline-container>
									<fo:block>
											<xsl:text>&#160;</xsl:text>											
									</fo:block>	
									<fo:block>
											<xsl:text>&#160;</xsl:text>											
									</fo:block>
									<fo:block break-after="page">
										<fo:leader leader-pattern="space" />
									</fo:block>
									<fo:block>
									<xsl:text>The following articles are provided for your information and do not require unit approval.</xsl:text>
									</fo:block>
									<xsl:if
										test="../PrintRequirement/AddressListRequired = 1 or  ../PrintRequirement/CloseoutRequired = 1 or  ../PrintRequirement/CommentsRequired = 1 or  ../PrintRequirement/CostSharingRequired = 1 or  ../PrintRequirement/EquipmentRequired = 1 or  ../PrintRequirement/FlowThruRequired = 1 or  ../PrintRequirement/ForeignTravelRequired = 1 or  ../PrintRequirement/HierarchyInfoRequired = 1 or  ../PrintRequirement/CurrentDate = 1 or  ../PrintRequirement/IndirectCostRequired = 1 or  ../PrintRequirement/PaymentRequired = 1 or  ../PrintRequirement/ProposalDueRequired = 1 or  ../PrintRequirement/ReportingRequired = 1 or  ../PrintRequirement/ScienceCodeRequired = 1 or  ../PrintRequirement/SpecialReviewRequired = 1 or  ../PrintRequirement/SubcontractRequired = 1 or  ../PrintRequirement/TechnicalReportingRequired = 1 or  ../PrintRequirement/TermsRequired = 1 or  ../PrintRequirement/OtherDataRequired  = 1">
										<fo:block />

										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:table table-layout="fixed" width="100%"
											border-spacing="2pt">
											<fo:table-column column-width="100%" />
											<fo:table-body start-indent="0pt">
												<fo:table-row font-family="Arial" font-size="12pt"
													font-weight="bold">
													<fo:table-cell font-family="Arial" font-size="12pt"
														padding="2pt" display-align="center">
														<fo:block>
															<xsl:if
																test="../PrintRequirement/TermsRequired  = &quot;1&quot;">
																<xsl:if test="count(  AwardTermsDetails/Term  )  &gt; 0">
																	<fo:inline font-family="Arial" font-size="12pt"
																		font-weight="bold">
																		<xsl:text>Terms:</xsl:text>
																	</fo:inline>
																	<fo:block />
																	<xsl:for-each select="AwardTermsDetails">
																		<fo:block />
																		<xsl:for-each select="Term">
																			<fo:inline-container>
																				<fo:block>
																					<xsl:text>&#x2029;</xsl:text>
																				</fo:block>
																			</fo:inline-container>
																			<fo:table table-layout="fixed" width="100%"
																				border-spacing="2pt">
																				<fo:table-column column-width="581" />
																				<fo:table-body start-indent="0pt">
																					<fo:table-row font-family="Arial"
																						font-size="9pt" font-weight="bold">
																						<fo:table-cell font-family="Arial"
																							font-size="9pt" padding="2pt" display-align="center">
																							<fo:block>
																								<xsl:if test="TermDetails/TermCode  != &quot;1&quot;">
																									<xsl:for-each select="Description">
																										<xsl:variable name="value-of-template">
																											<xsl:apply-templates />
																										</xsl:variable>
																										<xsl:choose>
																											<xsl:when
																												test="contains(string($value-of-template),'&#x2029;')">
																												<fo:block font-weight="bold">
																													<xsl:copy-of select="$value-of-template" />
																												</fo:block>
																											</xsl:when>
																											<xsl:otherwise>
																												<fo:inline font-weight="bold">
																													<xsl:copy-of select="$value-of-template" />
																												</fo:inline>
																											</xsl:otherwise>
																										</xsl:choose>
																									</xsl:for-each>
																									<fo:inline font-weight="bold">
																										<xsl:text>:</xsl:text>
																									</fo:inline>
																								</xsl:if>
																							</fo:block>
																						</fo:table-cell>
																					</fo:table-row>
																				</fo:table-body>
																			</fo:table>
																			<xsl:if test="TermDetails/TermCode != &quot;1&quot;">
																				<fo:inline-container>
																					<fo:block>
																						<xsl:text>&#x2029;</xsl:text>
																					</fo:block>
																				</fo:inline-container>
																				<fo:table font-family="Arial" padding-left="10pt"
																					table-layout="fixed" width="100%" border-spacing="2pt">
																					<fo:table-column column-width="5%" />
																					<fo:table-column column-width="95%" />
																					<fo:table-body start-indent="0pt">
																						<fo:table-row>
																							<fo:table-cell font-family="Arial"
																								font-size="9pt" font-weight="normal" padding="2pt"
																								display-align="center">
																								<fo:block />
																							</fo:table-cell>
																							<fo:table-cell font-family="Arial"
																								font-size="9pt" font-weight="normal" padding="2pt"
																								display-align="center">
																								<fo:block>
																									<xsl:for-each select="TermDetails">
																										<fo:inline-container>
																											<fo:block>
																												<xsl:text>&#x2029;</xsl:text>
																											</fo:block>
																										</fo:inline-container>
																										<fo:block white-space="pre"
																											white-space-collapse="false" wrap-option="wrap"
																											white-space-treatment="ignore-if-surrounding-linefeed"
																											margin="0pt">
																											<fo:block>
																												<xsl:for-each select="TermDescription">
																													<fo:inline>
																														<xsl:text>-</xsl:text>
																													</fo:inline>
																													<xsl:variable name="value-of-template">
																														<xsl:apply-templates />
																													</xsl:variable>
																													<xsl:choose>
																														<xsl:when
																															test="contains(string($value-of-template),'&#x2029;')">
																															<fo:block>
																																<xsl:copy-of select="$value-of-template" />
																															</fo:block>
																														</xsl:when>
																														<xsl:otherwise>
																															<fo:inline>
																																<xsl:copy-of select="$value-of-template" />
																															</fo:inline>
																														</xsl:otherwise>
																													</xsl:choose>
																												</xsl:for-each>
																											</fo:block>
																										</fo:block>
																									</xsl:for-each>
																								</fo:block>
																							</fo:table-cell>
																						</fo:table-row>
																					</fo:table-body>
																				</fo:table>
																			</xsl:if>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:if>
															</xsl:if>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
										<xsl:if	test="../PrintRequirement/SpecialReviewRequired = &quot;1&quot;">
											<fo:inline font-family="Arial" font-size="12pt"
												font-weight="bold">
												<fo:block>
												<xsl:text>Compliance:</xsl:text>
												</fo:block>
											</fo:inline>
											<xsl:if	test=" starts-with(  AwardDetails/SpecialReviewIndicator  , &quot;P&quot;)">
											<fo:block />
											<xsl:for-each select="AwardSpecialReviews">
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<xsl:if test="SpecialReview">
													<fo:table table-layout="fixed" width="100%"
														border-spacing="2pt">
														<fo:table-column column-width="20" />
														<fo:table-column column-width="proportional-column-width(1)" />
														<fo:table-column column-width="proportional-column-width(1)" />
														<fo:table-column column-width="proportional-column-width(1)" />
														<fo:table-column column-width="proportional-column-width(1)" />
														<fo:table-column column-width="proportional-column-width(1)" />
														<fo:table-header start-indent="0pt">
															<fo:table-row font-family="Arial" font-size="9pt"
																font-weight="bold">
																<fo:table-cell padding="2pt"
																	display-align="center">
																	<fo:block />
																</fo:table-cell>
																<fo:table-cell padding="2pt"
																	display-align="center">
																	<fo:block>
																		<fo:inline font-weight="bold">
																			<xsl:text>Compliance Type</xsl:text>
																		</fo:inline>
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell padding="2pt"
																	display-align="center">
																	<fo:block>
																		<fo:inline font-weight="bold">
																			<xsl:text>Approval Status</xsl:text>
																		</fo:inline>
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell padding="2pt"
																	display-align="center">
																	<fo:block>
																		<fo:inline font-weight="bold">
																			<xsl:text>Protocol Number</xsl:text>
																		</fo:inline>
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell padding="2pt"
																	display-align="center">
																	<fo:block>
																		<fo:inline font-weight="bold">
																			<xsl:text>Application Date</xsl:text>
																		</fo:inline>
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell padding="2pt"
																	display-align="center">
																	<fo:block>
																		<fo:inline font-weight="bold">
																			<xsl:text>Approval Date</xsl:text>
																		</fo:inline>
																	</fo:block>
																</fo:table-cell>
															</fo:table-row>
														</fo:table-header>
														<fo:table-body start-indent="0pt">
															<xsl:for-each select="SpecialReview">
																<fo:table-row font-family="Arial"
																	font-size="9pt" font-weight="normal">
																	<fo:table-cell padding-bottom="0"
																		padding-top="0" padding="2pt" display-align="center">
																		<fo:block />
																	</fo:table-cell>
																	<fo:table-cell padding-bottom="0"
																		padding-top="0" padding="2pt" display-align="center">
																		<fo:block>
																			<xsl:for-each select="ReviewTypeDesc">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates />
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when
																						test="contains(string($value-of-template),'&#x2029;')">
																						<fo:block>
																							<xsl:copy-of select="$value-of-template" />
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline>
																							<xsl:copy-of select="$value-of-template" />
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell padding-bottom="0"
																		padding-top="0" padding="2pt" display-align="center">
																		<fo:block>
																			<xsl:for-each select="ApprovalTypeDesc">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates />
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when
																						test="contains(string($value-of-template),'&#x2029;')">
																						<fo:block>
																							<xsl:copy-of select="$value-of-template" />
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline>
																							<xsl:copy-of select="$value-of-template" />
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell padding-bottom="0"
																		padding-top="0" padding="2pt" display-align="center">
																		<fo:block>
																			<xsl:for-each select="ProtocolNumber">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates />
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when
																						test="contains(string($value-of-template),'&#x2029;')">
																						<fo:block>
																							<xsl:copy-of select="$value-of-template" />
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline>
																							<xsl:copy-of select="$value-of-template" />
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell font-size="9pt"
																		padding-bottom="0" padding-top="0" padding="2pt"
																		display-align="center">
																		<fo:block>
																			<xsl:for-each select="ApplicationDate">
																				<fo:inline>
																					<xsl:value-of
																						select="format-number(number(substring(string(string(.)), 6, 2)), '00')" />
																					<xsl:text>/</xsl:text>
																					<xsl:value-of
																						select="format-number(number(substring(string(string(.)), 9, 2)), '00')" />
																					<xsl:text>/</xsl:text>
																					<xsl:value-of
																						select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')" />
																				</fo:inline>
																			</xsl:for-each>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell font-size="9pt" padding="2pt"
																		display-align="center">
																		<fo:block>
																			<xsl:for-each select="ApprovalDate">
																				<fo:inline>
																					<xsl:value-of
																						select="format-number(number(substring(string(string(.)), 6, 2)), '00')" />
																					<xsl:text>/</xsl:text>
																					<xsl:value-of
																						select="format-number(number(substring(string(string(.)), 9, 2)), '00')" />
																					<xsl:text>/</xsl:text>
																					<xsl:value-of
																						select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')" />
																				</fo:inline>
																			</xsl:for-each>
																		</fo:block>
																	</fo:table-cell>
																</fo:table-row>
																<fo:table-row>
																	<fo:table-cell padding="2pt"
																		display-align="center">
																		<fo:block />
																	</fo:table-cell>
																	<fo:table-cell font-family="Arial"
																		font-size="9pt" font-weight="bold" padding="2pt"
																		display-align="before">
																		<fo:block>
																			<fo:inline font-size="12pt">
																				<xsl:text>&#160; </xsl:text>
																			</fo:inline>
																			<xsl:if test="string-length()  &gt; 0">
																				<fo:inline font-family="Arial" font-size="9pt"
																					font-weight="bold">
																					<xsl:text>Comments</xsl:text>
																				</fo:inline>
																				<fo:inline font-weight="bold">
																					<xsl:text>:</xsl:text>
																				</fo:inline>
																			</xsl:if>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell font-family="Arial"
																		font-size="9pt" font-weight="normal"
																		number-columns-spanned="4" padding="2pt"
																		display-align="before">
																		<fo:block>
																			<xsl:for-each select="Comments">
																				<xsl:if test="string-length()  &gt; 0">
																					<fo:inline-container>
																						<fo:block>
																							<xsl:text>&#x2029;</xsl:text>
																						</fo:block>
																					</fo:inline-container>
																					<fo:block white-space="pre"
																						white-space-collapse="false" wrap-option="wrap"
																						white-space-treatment="ignore-if-surrounding-linefeed"
																						margin="0pt">
																						<fo:block>
																							<xsl:variable name="value-of-template">
																								<xsl:apply-templates />
																							</xsl:variable>
																							<xsl:choose>
																								<xsl:when
																									test="contains(string($value-of-template),'&#x2029;')">
																									<fo:block font-family="Arial"
																										font-size="9pt" font-weight="normal"
																										line-height="9pt">
																										<xsl:copy-of select="$value-of-template" />
																									</fo:block>
																								</xsl:when>
																								<xsl:otherwise>
																									<fo:inline font-family="Arial"
																										font-size="9pt" font-weight="normal"
																										line-height="9pt">
																										<xsl:copy-of select="$value-of-template" />
																									</fo:inline>
																								</xsl:otherwise>
																							</xsl:choose>
																						</fo:block>
																					</fo:block>
																				</xsl:if>
																			</xsl:for-each>
																		</fo:block>
																	</fo:table-cell>
																</fo:table-row>
															</xsl:for-each>
														</fo:table-body>
													</fo:table>
												</xsl:if>
											</xsl:for-each>
										</xsl:if>
									</xsl:if>
									<xsl:if test="(../PrintRequirement/EquipmentRequired =1 )
													or  (../PrintRequirement/ForeignTravelRequired = 1 )
													or ( ../PrintRequirement/SubcontractRequired  = 1 )">
											<fo:inline font-family="Arial" font-size="12pt"
												font-weight="bold">
												<xsl:text>Approved Special Items:</xsl:text>
											</fo:inline>
											<fo:inline-container>
												<fo:block>
													<xsl:text>&#x2029;</xsl:text>
												</fo:block>
											</fo:inline-container>
											<fo:table font-family="Arial" table-layout="fixed"
												width="100%" border-spacing="2pt">
												<fo:table-column column-width="proportional-column-width(1)" />
												<fo:table-body start-indent="0pt">
													<fo:table-row>
														<fo:table-cell padding="2pt" display-align="center">
															<fo:block>
																<xsl:if
																	test="(../PrintRequirement/EquipmentRequired = 1 )">
																	<fo:inline font-family="Arial" font-size="9pt"
																		font-weight="bold">
																		<xsl:text>Equipment:</xsl:text>
																	</fo:inline>
																	<xsl:if
																	test="starts-with( AwardDetails/ApprvdEquipmentIndicator , &quot;P&quot; )">
																	<fo:block />
																	<xsl:for-each select="AwardSpecialItems">
																		<fo:inline-container>
																			<fo:block>
																				<xsl:text>&#x2029;</xsl:text>
																			</fo:block>
																		</fo:inline-container>
																		<xsl:if test="Equipment">
																			<fo:table table-layout="fixed" width="100%"
																				border-spacing="2pt">
																				<fo:table-column column-width="1%" />
																				<fo:table-column column-width="32%" />
																				<fo:table-column column-width="25%" />
																				<fo:table-column column-width="27%" />
																				<fo:table-column column-width="15%" />
																				<fo:table-header start-indent="0pt">
																					<fo:table-row font-family="Arial"
																						font-size="9pt" font-weight="bold">
																						<fo:table-cell padding="2pt"
																							display-align="center">
																							<fo:block />
																						</fo:table-cell>
																						<fo:table-cell padding="2pt"
																							display-align="center">
																							<fo:block>
																								<fo:inline font-weight="bold">
																									<xsl:text>Item</xsl:text>
																								</fo:inline>
																							</fo:block>
																						</fo:table-cell>
																						<fo:table-cell padding="2pt"
																							display-align="center">
																							<fo:block>
																								<fo:inline font-weight="bold">
																									<xsl:text>Vendor</xsl:text>
																								</fo:inline>
																							</fo:block>
																						</fo:table-cell>
																						<fo:table-cell padding="2pt"
																							display-align="center">
																							<fo:block>
																								<fo:inline font-weight="bold">
																									<xsl:text>Model</xsl:text>
																								</fo:inline>
																							</fo:block>
																						</fo:table-cell>
																						<fo:table-cell padding="2pt"
																							display-align="center">
																							<fo:block>
																								<fo:inline font-weight="bold">
																									<xsl:text>Amount</xsl:text>
																								</fo:inline>
																							</fo:block>
																						</fo:table-cell>
																					</fo:table-row>
																				</fo:table-header>
																				<fo:table-body start-indent="0pt">
																					<xsl:for-each select="Equipment">
																						<fo:table-row font-family="Arial"
																							font-size="9pt" font-weight="normal">
																							<fo:table-cell padding="2pt"
																								display-align="center">
																								<fo:block />
																							</fo:table-cell>
																							<fo:table-cell padding="2pt"
																								display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:block white-space="pre"
																										white-space-collapse="false" wrap-option="wrap"
																										white-space-treatment="ignore-if-surrounding-linefeed"
																										margin="0pt">
																										<fo:block>
																											<xsl:for-each select="Item">
																												<xsl:variable name="value-of-template">
																													<xsl:apply-templates />
																												</xsl:variable>
																												<xsl:choose>
																													<xsl:when
																														test="contains(string($value-of-template),'&#x2029;')">
																														<fo:block>
																															<xsl:copy-of select="$value-of-template" />
																														</fo:block>
																													</xsl:when>
																													<xsl:otherwise>
																														<fo:inline>
																															<xsl:copy-of select="$value-of-template" />
																														</fo:inline>
																													</xsl:otherwise>
																												</xsl:choose>
																											</xsl:for-each>
																										</fo:block>
																									</fo:block>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt"
																								display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:block white-space="pre"
																										white-space-collapse="false" wrap-option="wrap"
																										white-space-treatment="ignore-if-surrounding-linefeed"
																										margin="0pt">
																										<fo:block>
																											<xsl:for-each select="Vendor">
																												<xsl:variable name="value-of-template">
																													<xsl:apply-templates />
																												</xsl:variable>
																												<xsl:choose>
																													<xsl:when
																														test="contains(string($value-of-template),'&#x2029;')">
																														<fo:block>
																															<xsl:copy-of select="$value-of-template" />
																														</fo:block>
																													</xsl:when>
																													<xsl:otherwise>
																														<fo:inline>
																															<xsl:copy-of select="$value-of-template" />
																														</fo:inline>
																													</xsl:otherwise>
																												</xsl:choose>
																											</xsl:for-each>
																										</fo:block>
																									</fo:block>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt"
																								display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:block white-space="pre"
																										white-space-collapse="false" wrap-option="wrap"
																										white-space-treatment="ignore-if-surrounding-linefeed"
																										margin="0pt">
																										<fo:block>
																											<xsl:for-each select="Model">
																												<xsl:variable name="value-of-template">
																													<xsl:apply-templates />
																												</xsl:variable>
																												<xsl:choose>
																													<xsl:when
																														test="contains(string($value-of-template),'&#x2029;')">
																														<fo:block>
																															<xsl:copy-of select="$value-of-template" />
																														</fo:block>
																													</xsl:when>
																													<xsl:otherwise>
																														<fo:inline>
																															<xsl:copy-of select="$value-of-template" />
																														</fo:inline>
																													</xsl:otherwise>
																												</xsl:choose>
																											</xsl:for-each>
																										</fo:block>
																									</fo:block>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell font-size="9pt"
																								padding="2pt" display-align="center">
																								<fo:block>
																									<xsl:for-each select="Amount">
																										<fo:inline>
																											<xsl:text>$</xsl:text>
																										</fo:inline>
																										<fo:inline>
																											<xsl:value-of
																												select="format-number(number(string(.)), '#,###,###,##0.00')" />
																										</fo:inline>
																									</xsl:for-each>
																								</fo:block>
																							</fo:table-cell>
																						</fo:table-row>
																					</xsl:for-each>
																				</fo:table-body>
																			</fo:table>
																		</xsl:if>
																	</xsl:for-each>
																</xsl:if>
																</xsl:if>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell padding="2pt" display-align="center">
															<fo:block>
																<xsl:if
																	test="../PrintRequirement/ForeignTravelRequired = &quot;1&quot;">
																	<fo:inline font-family="Arial" font-size="9pt"
																		font-weight="bold">
																		<xsl:text>Foreign Travel:</xsl:text>
																	</fo:inline>
																	<xsl:if
																	test="starts-with(  AwardDetails/ApprvdForeginTripIndicator , &quot;P&quot; )">
																	<fo:block />
																	<xsl:for-each select="AwardSpecialItems">
																		<fo:inline-container>
																			<fo:block>
																				<xsl:text>&#x2029;</xsl:text>
																			</fo:block>
																		</fo:inline-container>
																		<xsl:if test="ForeignTravel">
																			<fo:table table-layout="fixed" width="100%"
																				border-spacing="2pt">
																				<fo:table-column column-width="10" />
																				<fo:table-column column-width="proportional-column-width(1)" />
																				<fo:table-column column-width="proportional-column-width(1)" />
																				<fo:table-column column-width="proportional-column-width(1)" />
																				<fo:table-column column-width="proportional-column-width(1)" />
																				<fo:table-column column-width="proportional-column-width(1)" />
																				<fo:table-header start-indent="0pt">
																					<fo:table-row font-family="Arial"
																						font-size="9pt" font-weight="bold">
																						<fo:table-cell padding="2pt"
																							display-align="center">
																							<fo:block />
																						</fo:table-cell>
																						<fo:table-cell padding="2pt"
																							display-align="center">
																							<fo:block>
																								<fo:inline font-weight="bold">
																									<xsl:text>Name of Traveller</xsl:text>
																								</fo:inline>
																							</fo:block>
																						</fo:table-cell>
																						<fo:table-cell padding="2pt"
																							display-align="center">
																							<fo:block>
																								<fo:inline font-weight="bold">
																									<xsl:text>Destination</xsl:text>
																								</fo:inline>
																							</fo:block>
																						</fo:table-cell>
																						<fo:table-cell padding="2pt"
																							display-align="center">
																							<fo:block>
																								<fo:inline font-weight="bold">
																									<xsl:text>Date From</xsl:text>
																								</fo:inline>
																							</fo:block>
																						</fo:table-cell>
																						<fo:table-cell padding="2pt"
																							display-align="center">
																							<fo:block>
																								<fo:inline font-weight="bold">
																									<xsl:text>Date To</xsl:text>
																								</fo:inline>
																							</fo:block>
																						</fo:table-cell>
																						<fo:table-cell padding="2pt"
																							display-align="center">
																							<fo:block>
																								<fo:inline font-weight="bold">
																									<xsl:text>Amount</xsl:text>
																								</fo:inline>
																							</fo:block>
																						</fo:table-cell>
																					</fo:table-row>
																				</fo:table-header>
																				<fo:table-body start-indent="0pt">
																					<xsl:for-each select="ForeignTravel">
																						<fo:table-row font-family="Arial"
																							font-size="9pt" font-weight="normal">
																							<fo:table-cell padding="2pt"
																								display-align="center">
																								<fo:block />
																							</fo:table-cell>
																							<fo:table-cell padding="2pt"
																								display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:block white-space="pre"
																										white-space-collapse="false" wrap-option="wrap"
																										white-space-treatment="ignore-if-surrounding-linefeed"
																										margin="0pt">
																										<fo:block>
																											<xsl:for-each select="PersonName">
																												<xsl:variable name="value-of-template">
																													<xsl:apply-templates />
																												</xsl:variable>
																												<xsl:choose>
																													<xsl:when
																														test="contains(string($value-of-template),'&#x2029;')">
																														<fo:block>
																															<xsl:copy-of select="$value-of-template" />
																														</fo:block>
																													</xsl:when>
																													<xsl:otherwise>
																														<fo:inline>
																															<xsl:copy-of select="$value-of-template" />
																														</fo:inline>
																													</xsl:otherwise>
																												</xsl:choose>
																											</xsl:for-each>
																										</fo:block>
																									</fo:block>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt"
																								display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:block white-space="pre"
																										white-space-collapse="false" wrap-option="wrap"
																										white-space-treatment="ignore-if-surrounding-linefeed"
																										margin="0pt">
																										<fo:block>
																											<xsl:for-each select="Destination">
																												<xsl:variable name="value-of-template">
																													<xsl:apply-templates />
																												</xsl:variable>
																												<xsl:choose>
																													<xsl:when
																														test="contains(string($value-of-template),'&#x2029;')">
																														<fo:block>
																															<xsl:copy-of select="$value-of-template" />
																														</fo:block>
																													</xsl:when>
																													<xsl:otherwise>
																														<fo:inline>
																															<xsl:copy-of select="$value-of-template" />
																														</fo:inline>
																													</xsl:otherwise>
																												</xsl:choose>
																											</xsl:for-each>
																										</fo:block>
																									</fo:block>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell font-size="9pt"
																								padding="2pt" display-align="center">
																								<fo:block>
																									<xsl:for-each select="DateFrom">
																										<fo:inline>
																											<xsl:value-of
																												select="format-number(number(substring(string(string(.)), 6, 2)), '00')" />
																											<xsl:text>/</xsl:text>
																											<xsl:value-of
																												select="format-number(number(substring(string(string(.)), 9, 2)), '00')" />
																											<xsl:text>/</xsl:text>
																											<xsl:value-of
																												select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')" />
																										</fo:inline>
																									</xsl:for-each>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell font-size="9pt"
																								padding="2pt" display-align="center">
																								<fo:block>
																									<xsl:for-each select="DateTo">
																										<fo:inline>
																											<xsl:value-of
																												select="format-number(number(substring(string(string(.)), 6, 2)), '00')" />
																											<xsl:text>/</xsl:text>
																											<xsl:value-of
																												select="format-number(number(substring(string(string(.)), 9, 2)), '00')" />
																											<xsl:text>/</xsl:text>
																											<xsl:value-of
																												select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')" />
																										</fo:inline>
																									</xsl:for-each>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell font-size="9pt"
																								padding="2pt" display-align="center">
																								<fo:block>
																									<xsl:for-each select="Amount">
																										<fo:inline>
																											<xsl:text>$</xsl:text>
																										</fo:inline>
																										<fo:inline>
																											<xsl:value-of
																												select="format-number(number(string(.)), '#,###,###,##0.00')" />
																										</fo:inline>
																									</xsl:for-each>
																								</fo:block>
																							</fo:table-cell>
																						</fo:table-row>
																					</xsl:for-each>
																				</fo:table-body>
																			</fo:table>
																		</xsl:if>
																	</xsl:for-each>
																</xsl:if>
																</xsl:if>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row font-family="Arial" font-size="9pt"
														font-weight="bold">
														<fo:table-cell padding="2pt" display-align="center">
															<fo:block>
																<xsl:if
																	test="( ../PrintRequirement/SubcontractRequired  =&quot;1&quot; )">
																	<fo:inline font-weight="bold">
																		<xsl:text>Subcontracts:</xsl:text>
																	</fo:inline>
																	<xsl:if
																	test="(starts-with(  AwardDetails/ApprvdSubcontractIndicator , &quot;P&quot; ) )">
																	<fo:block />
																	<xsl:for-each select="AwardSpecialItems">
																		<fo:inline-container>
																			<fo:block>
																				<xsl:text>&#x2029;</xsl:text>
																			</fo:block>
																		</fo:inline-container>
																		<xsl:if test="Subcontract">
																			<fo:table font-family="Arial" table-layout="fixed"
																				width="100%" border-spacing="2pt">
																				<fo:table-column column-width="10" />
																				<fo:table-column column-width="150" />
																				<fo:table-column column-width="proportional-column-width(1)" />
																				<fo:table-header start-indent="0pt">
																					<fo:table-row font-family="Arial"
																						font-size="9pt" font-weight="bold">
																						<fo:table-cell padding="2pt"
																							display-align="center">
																							<fo:block />
																						</fo:table-cell>
																						<fo:table-cell padding="2pt"
																							display-align="center">
																							<fo:block>
																								<fo:inline font-weight="bold">
																									<xsl:text>Amount</xsl:text>
																								</fo:inline>
																							</fo:block>
																						</fo:table-cell>
																						<fo:table-cell padding="2pt"
																							display-align="center">
																							<fo:block>
																								<fo:inline font-weight="bold">
																									<xsl:text>Subcontractor Name</xsl:text>
																								</fo:inline>
																							</fo:block>
																						</fo:table-cell>
																					</fo:table-row>
																				</fo:table-header>
																				<fo:table-body start-indent="0pt">
																					<xsl:for-each select="Subcontract">
																						<fo:table-row font-family="Arial"
																							font-size="9pt" font-weight="normal">
																							<fo:table-cell padding="2pt"
																								display-align="center">
																								<fo:block />
																							</fo:table-cell>
																							<fo:table-cell font-size="9pt"
																								padding="2pt" display-align="center">
																								<fo:block>
																									<xsl:for-each select="Amount">
																										<fo:inline>
																											<xsl:text>$</xsl:text>
																										</fo:inline>
																										<fo:inline>
																											<xsl:value-of
																												select="format-number(number(string(.)), '#,###,###,##0.00')" />
																										</fo:inline>
																									</xsl:for-each>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt"
																								display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:block white-space="pre"
																										white-space-collapse="false" wrap-option="wrap"
																										white-space-treatment="ignore-if-surrounding-linefeed"
																										margin="0pt">
																										<fo:block>
																											<xsl:for-each select="SubcontractorName">
																												<xsl:variable name="value-of-template">
																													<xsl:apply-templates />
																												</xsl:variable>
																												<xsl:choose>
																													<xsl:when
																														test="contains(string($value-of-template),'&#x2029;')">
																														<fo:block>
																															<xsl:copy-of select="$value-of-template" />
																														</fo:block>
																													</xsl:when>
																													<xsl:otherwise>
																														<fo:inline>
																															<xsl:copy-of select="$value-of-template" />
																														</fo:inline>
																													</xsl:otherwise>
																												</xsl:choose>
																											</xsl:for-each>
																										</fo:block>
																									</fo:block>
																								</fo:block>
																							</fo:table-cell>
																						</fo:table-row>
																					</xsl:for-each>
																				</fo:table-body>
																			</fo:table>
																		</xsl:if>
																	</xsl:for-each>
																</xsl:if>
																</xsl:if>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</fo:table-body>
											</fo:table>
										</xsl:if>
										<xsl:if	test="../PrintRequirement/CostSharingRequired   = &quot;1&quot; ">
											<fo:inline font-family="Arial" font-size="12pt"
												font-weight="bold">
												<fo:block>
												<xsl:text>Cost Sharing:</xsl:text>
												</fo:block>
											</fo:inline>
											<xsl:if	test="count(  AwardCostSharing  ) &gt; 0 
															and not (starts-with( AwardDetails/CostSharingIndicator , &quot;N&quot; )  
															and   string-length(AwardCostSharing/Comments) &lt;= 1  )">
											<fo:block />
											<xsl:for-each select="AwardCostSharing">
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:table table-layout="fixed" width="100%"
													border-spacing="2pt">
													<fo:table-column column-width="proportional-column-width(1)" />
													<fo:table-column column-width="75%" />
													<fo:table-body start-indent="0pt">
														<fo:table-row>
															<fo:table-cell number-columns-spanned="2"
																padding="2pt" display-align="center">
																<fo:block>
																	<xsl:if
																		test="starts-with(../AwardDetails/CostSharingIndicator  , &quot;P&quot; )">
																		<fo:inline-container>
																			<fo:block>
																				<xsl:text>&#x2029;</xsl:text>
																			</fo:block>
																		</fo:inline-container>
																		<xsl:if test="CostSharingItem">
																			<fo:table table-layout="fixed" width="100%"
																				border-spacing="0">
																				<fo:table-column column-width="62" />
																				<fo:table-column column-width="proportional-column-width(1)" />
																				<fo:table-column column-width="65" />
																				<fo:table-column column-width="94" />
																				<fo:table-column column-width="proportional-column-width(1)" />
																				<fo:table-column column-width="proportional-column-width(1)" />
																				<fo:table-header start-indent="0pt">
																					<fo:table-row font-family="Arial"
																						font-size="9pt" font-weight="bold">
																						<fo:table-cell padding="2pt"
																							display-align="center">
																							<fo:block>
																								<fo:inline font-weight="bold">
																									<xsl:text>%</xsl:text>
																								</fo:inline>
																							</fo:block>
																						</fo:table-cell>
																						<fo:table-cell padding="2pt"
																							display-align="center">
																							<fo:block>
																								<fo:inline font-weight="bold">
																									<xsl:text>Type</xsl:text>
																								</fo:inline>
																							</fo:block>
																						</fo:table-cell>
																						<fo:table-cell padding="2pt"
																							display-align="center">
																							<fo:block>
																								<fo:inline font-weight="bold">
																									<xsl:value-of select="/AwardNotice/Award/AwardDetails/CostSharingProjectPeriodFieldDescription"/>
																								</fo:inline>
																							</fo:block>
																						</fo:table-cell>
																						<fo:table-cell padding="2pt"
																							display-align="center">
																							<fo:block>
																								<fo:inline font-weight="bold">
																									<xsl:text>Source Acct</xsl:text>
																								</fo:inline>
																							</fo:block>
																						</fo:table-cell>
																						<fo:table-cell padding="2pt"
																							display-align="center">
																							<fo:block>
																								<fo:inline font-weight="bold">
																									<xsl:text>Destination Acct</xsl:text>
																								</fo:inline>
																							</fo:block>
																						</fo:table-cell>
																						<fo:table-cell padding="2pt"
																							display-align="center">
																							<fo:block>
																								<fo:inline font-weight="bold">
																									<xsl:text>Amount</xsl:text>
																								</fo:inline>
																							</fo:block>
																						</fo:table-cell>
																					</fo:table-row>
																				</fo:table-header>
																				<fo:table-body start-indent="0pt">
																					<xsl:for-each select="CostSharingItem">
																						<fo:table-row font-family="Arial"
																							font-size="9pt" font-weight="normal">
																							<fo:table-cell font-size="9pt"
																								padding="2pt" display-align="before">
																								<fo:block>
																									<xsl:for-each select="Percentage">
																										<fo:inline>
																											<xsl:value-of
																												select="format-number(number(string(.)), '##0.00')" />
																										</fo:inline>
																									</xsl:for-each>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt"
																								display-align="before">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:block white-space="pre"
																										white-space-collapse="false" wrap-option="wrap"
																										white-space-treatment="ignore-if-surrounding-linefeed"
																										margin="0pt">
																										<fo:block>
																											<xsl:for-each select="CostSharingDescription">
																												<xsl:variable name="value-of-template">
																													<xsl:apply-templates />
																												</xsl:variable>
																												<xsl:choose>
																													<xsl:when
																														test="contains(string($value-of-template),'&#x2029;')">
																														<fo:block>
																															<xsl:copy-of select="$value-of-template" />
																														</fo:block>
																													</xsl:when>
																													<xsl:otherwise>
																														<fo:inline>
																															<xsl:copy-of select="$value-of-template" />
																														</fo:inline>
																													</xsl:otherwise>
																												</xsl:choose>
																											</xsl:for-each>
																										</fo:block>
																									</fo:block>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt"
																								display-align="before">
																								<fo:block>
																									<xsl:for-each select="FiscalYear">
																										<xsl:variable name="value-of-template">
																											<xsl:apply-templates />
																										</xsl:variable>
																										<xsl:choose>
																											<xsl:when
																												test="contains(string($value-of-template),'&#x2029;')">
																												<fo:block>
																													<xsl:copy-of select="$value-of-template" />
																												</fo:block>
																											</xsl:when>
																											<xsl:otherwise>
																												<fo:inline>
																													<xsl:copy-of select="$value-of-template" />
																												</fo:inline>
																											</xsl:otherwise>
																										</xsl:choose>
																									</xsl:for-each>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt"
																								display-align="before">
																								<fo:block>
																									<xsl:for-each select="SourceAccount">
																										<fo:inline-container>
																											<fo:block>
																												<xsl:text>&#x2029;</xsl:text>
																											</fo:block>
																										</fo:inline-container>
																										<fo:block white-space="pre"
																											white-space-collapse="false" wrap-option="wrap"
																											white-space-treatment="ignore-if-surrounding-linefeed"
																											margin="0pt">
																											<fo:block>
																												<xsl:variable name="value-of-template">
																													<xsl:apply-templates />
																												</xsl:variable>
																												<xsl:choose>
																													<xsl:when
																														test="contains(string($value-of-template),'&#x2029;')">
																														<fo:block>
																															<xsl:copy-of select="$value-of-template" />
																														</fo:block>
																													</xsl:when>
																													<xsl:otherwise>
																														<fo:inline>
																															<xsl:copy-of select="$value-of-template" />
																														</fo:inline>
																													</xsl:otherwise>
																												</xsl:choose>
																											</fo:block>
																										</fo:block>
																									</xsl:for-each>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt"
																								display-align="before">
																								<fo:block>
																									<xsl:for-each select="DestinationAccount">
																										<fo:inline-container>
																											<fo:block>
																												<xsl:text>&#x2029;</xsl:text>
																											</fo:block>
																										</fo:inline-container>
																										<fo:block white-space="pre"
																											white-space-collapse="false" wrap-option="wrap"
																											white-space-treatment="ignore-if-surrounding-linefeed"
																											margin="0pt">
																											<fo:block>
																												<xsl:variable name="value-of-template">
																													<xsl:apply-templates />
																												</xsl:variable>
																												<xsl:choose>
																													<xsl:when
																														test="contains(string($value-of-template),'&#x2029;')">
																														<fo:block>
																															<xsl:copy-of select="$value-of-template" />
																														</fo:block>
																													</xsl:when>
																													<xsl:otherwise>
																														<fo:inline>
																															<xsl:copy-of select="$value-of-template" />
																														</fo:inline>
																													</xsl:otherwise>
																												</xsl:choose>
																											</fo:block>
																										</fo:block>
																									</xsl:for-each>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell font-size="9pt"
																								padding="2pt" display-align="before">
																								<fo:block>
																									<xsl:for-each select="Amount">
																										<fo:inline>
																											<xsl:text>$</xsl:text>
																										</fo:inline>
																										<fo:inline>
																											<xsl:value-of
																												select="format-number(number(string(.)), '#,###,###,##0.00')" />
																										</fo:inline>
																									</xsl:for-each>
																								</fo:block>
																							</fo:table-cell>
																						</fo:table-row>
																					</xsl:for-each>
																					<fo:table-row font-family="Arial" font-size="9pt" font-weight="normal">
																						<fo:table-cell font-size="9pt" padding="2pt" display-align="before">
																							<fo:block/>
																						</fo:table-cell>
																						<fo:table-cell padding="2pt" display-align="before">
																							<fo:block/>
																						</fo:table-cell>
																						<fo:table-cell padding="2pt" display-align="before">
																							<fo:block/>
																						</fo:table-cell>
																						<fo:table-cell padding="2pt" display-align="before">
																							<fo:block/>
																						</fo:table-cell>
																						<fo:table-cell padding="2pt" display-align="before">
																							<fo:block/>
																						</fo:table-cell>
																						<fo:table-cell padding="2pt" height="10" display-align="before">
																							<fo:block>
																								<fo:block text-align="center">
																									<fo:leader leader-pattern="rule" rule-thickness="1" leader-length="100%" color="black"/>
																								</fo:block>
																							</fo:block>
																						</fo:table-cell>
																					</fo:table-row>
																					<fo:table-row font-family="Arial" font-size="9pt" font-weight="normal">
																						<fo:table-cell font-size="9pt" padding="2pt" display-align="before">
																							<fo:block/>
																						</fo:table-cell>
																						<fo:table-cell padding="2pt" display-align="before">
																							<fo:block/>
																						</fo:table-cell>
																						<fo:table-cell padding="2pt" display-align="before">
																							<fo:block/>
																						</fo:table-cell>
																						<fo:table-cell padding="2pt" display-align="before">
																							<fo:block/>
																						</fo:table-cell>
																						<fo:table-cell font-family="Arial" font-size="9pt" font-weight="bold" padding="2pt" text-align="right" display-align="before">
																							<fo:block>
																								<fo:inline>
																									<xsl:text>Total:</xsl:text>
																								</fo:inline>
																							</fo:block>
																						</fo:table-cell>
																						<fo:table-cell font-size="9pt" padding="2pt" display-align="before">
																							<fo:block>
																								<fo:inline>
																									<xsl:text>$</xsl:text>
																								</fo:inline>
																								<fo:inline>
																									<xsl:value-of select="format-number(number(sum(  CostSharingItem/Amount  )), '###,##0.00')"/>
																								</fo:inline>
																							</fo:block>
																						</fo:table-cell>
																					</fo:table-row>
																					<fo:table-row font-family="Arial" font-size="9pt" font-weight="normal">
																						<fo:table-cell font-size="9pt" padding="2pt" display-align="before">
																							<fo:block/>
																						</fo:table-cell>
																						<fo:table-cell padding="2pt" display-align="before">
																							<fo:block/>
																						</fo:table-cell>
																						<fo:table-cell padding="2pt" display-align="before">
																							<fo:block/>
																						</fo:table-cell>
																						<fo:table-cell padding="2pt" display-align="before">
																							<fo:block/>
																						</fo:table-cell>
																						<fo:table-cell padding="2pt" display-align="before">
																							<fo:block/>
																						</fo:table-cell>
																						<fo:table-cell padding="2pt" height="10" display-align="before">
																							<fo:block>
																								<fo:block text-align="center">
																									<fo:leader leader-pattern="rule" rule-thickness="1" leader-length="100%" color="black"/>
																								</fo:block>
																							</fo:block>
																						</fo:table-cell>
																					</fo:table-row>																					
																				</fo:table-body>
																			</fo:table>
																		</xsl:if>
																	</xsl:if>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell font-family="Arial"
																font-size="9pt" font-weight="bold" padding="2pt"
																display-align="before">
																<fo:block>
																	<fo:inline font-weight="bold">
																		<xsl:text>Comments:</xsl:text>
																	</fo:inline>
																	<fo:inline font-size="12pt">
																		<xsl:text>&#160;</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell font-family="Arial"
																font-size="9pt" font-weight="normal" padding="2pt"
																display-align="before">
																<fo:block>
																	<xsl:for-each select="Comments">
																		<fo:inline-container>
																			<fo:block>
																				<xsl:text>&#x2029;</xsl:text>
																			</fo:block>
																		</fo:inline-container>
																		<fo:block white-space="pre"
																			white-space-collapse="false" wrap-option="wrap"
																			white-space-treatment="ignore-if-surrounding-linefeed"
																			margin="0pt">
																			<fo:block>
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates />
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when
																						test="contains(string($value-of-template),'&#x2029;')">
																						<fo:block line-height="9pt">
																							<xsl:copy-of select="$value-of-template" />
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline line-height="9pt">
																							<xsl:copy-of select="$value-of-template" />
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</fo:block>
																		</fo:block>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</fo:table-body>
												</fo:table>
											</xsl:for-each>
										</xsl:if>
										</xsl:if>
										<xsl:if
											test="../PrintRequirement/IndirectCostRequired = &quot;1&quot;and  count(  AwardIndirectCosts  )  &gt; 0">
											    <fo:inline font-family="Arial" font-size="12pt"
													font-weight="bold">													
													<fo:block>
													 <xsl:text>Rates:</xsl:text>
												    </fo:block>
												    <fo:block>
														<xsl:text>&#160;</xsl:text>
													</fo:block>
												</fo:inline>
											<xsl:if
												test="AwardDetails/OtherHeaderDetails/SpecialEBRateOffCampus &gt; 0.0 or  AwardDetails/OtherHeaderDetails/SpecialEBRateOnCampus &gt; 0.0 or   string-length( AwardDetails/OtherHeaderDetails/SpecialRateComments )  &gt;=  1">
												<fo:inline font-family="Arial" font-size="12pt"
													font-weight="bold">													
													 <xsl:text>Benefits Rates:</xsl:text>
												</fo:inline>
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:table table-layout="fixed" width="100%"
													border-spacing="2pt">
													<fo:table-column column-width="proportional-column-width(1)" />
													<fo:table-body start-indent="0pt">
														<fo:table-row>
															<fo:table-cell padding="2pt" display-align="center">
																<fo:block>
																	<xsl:if
																		test="AwardDetails/OtherHeaderDetails/SpecialEBRateOffCampus &gt; 0.0  or  AwardDetails/OtherHeaderDetails/SpecialEBRateOnCampus &gt; 0.0">
																		<fo:inline-container>
																			<fo:block>
																				<xsl:text>&#x2029;</xsl:text>
																			</fo:block>
																		</fo:inline-container>
																		<fo:table table-layout="fixed" width="100%"
																			border-spacing="2pt">																			
																			<fo:table-column column-width="90" />
																			<fo:table-column column-width="87" />
																			<fo:table-column column-width="96" />
																			<fo:table-column column-width="proportional-column-width(1)" />
																			<fo:table-body start-indent="0pt">
																				<fo:table-row>																					
																					<fo:table-cell font-family="Arial"
																						font-size="9pt" font-weight="bold" padding="2pt"
																						display-align="center">
																						<fo:block>
																							<fo:inline font-weight="bold">
																								<xsl:text>On-Campus</xsl:text>
																							</fo:inline>
																						</fo:block>
																					</fo:table-cell>
																					<fo:table-cell font-family="Arial"
																						font-size="9pt" font-weight="normal" padding="2pt"
																						display-align="center">
																						<fo:block>
																							<xsl:for-each select="AwardDetails">
																								<xsl:for-each select="OtherHeaderDetails">
																									<xsl:for-each select="SpecialEBRateOnCampus">
																										<fo:inline>
																											<xsl:value-of
																												select="format-number(number(string(.)), '##0.00')" />
																										</fo:inline>
																									</xsl:for-each>
																								</xsl:for-each>
																							</xsl:for-each>
																						</fo:block>
																					</fo:table-cell>
																					<fo:table-cell font-family="Arial"
																						font-size="9pt" font-weight="bold" padding="2pt"
																						display-align="center">
																						<fo:block>
																							<fo:inline font-weight="bold">
																								<xsl:text>Off-Campus</xsl:text>
																							</fo:inline>
																						</fo:block>
																					</fo:table-cell>
																					<fo:table-cell font-family="Arial"
																						font-size="9pt" font-weight="normal" padding="2pt"
																						display-align="center">
																						<fo:block>
																							<xsl:for-each select="AwardDetails">
																								<xsl:for-each select="OtherHeaderDetails">
																									<xsl:for-each select="SpecialEBRateOffCampus">
																										<fo:inline>
																											<xsl:value-of
																												select="format-number(number(string(.)), '##0.00')" />
																										</fo:inline>
																									</xsl:for-each>
																								</xsl:for-each>
																							</xsl:for-each>
																						</fo:block>
																					</fo:table-cell>
																				</fo:table-row>
																			</fo:table-body>
																		</fo:table>
																	</xsl:if>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell padding="2pt" display-align="center">
																<fo:block>
																	<xsl:if
																		test="string-length( AwardDetails/OtherHeaderDetails/SpecialRateComments )  &gt; 0">
																		<fo:inline-container>
																			<fo:block>
																				<xsl:text>&#x2029;</xsl:text>
																			</fo:block>
																		</fo:inline-container>
																		<fo:table table-layout="fixed" width="100%"
																			border-spacing="2pt">
																			<fo:table-column column-width="15%" />
																			<fo:table-column column-width="85%" />
																			<fo:table-body start-indent="0pt">
																				<fo:table-row>
																					<fo:table-cell font-family="Arial"
																						font-size="9pt" font-weight="bold" padding="2pt"
																						display-align="before">
																						<fo:block>
																							<fo:inline font-weight="bold">
																								<xsl:text>Comments:</xsl:text>
																							</fo:inline>
																						</fo:block>
																					</fo:table-cell>
																					<fo:table-cell font-family="Arial"
																						font-size="9pt" font-weight="normal" padding="2pt"
																						display-align="before">
																						<fo:block>
																							<xsl:for-each select="AwardDetails">
																								<xsl:for-each select="OtherHeaderDetails">
																									<xsl:for-each select="SpecialRateComments">
																										<fo:inline-container>
																											<fo:block>
																												<xsl:text>&#x2029;</xsl:text>
																											</fo:block>
																										</fo:inline-container>
																										<fo:block font-family="Arial"
																											white-space="pre" white-space-collapse="false"
																											wrap-option="wrap" white-space-treatment="ignore-if-surrounding-linefeed"
																											margin="0pt">
																											<fo:block>
																												<xsl:variable name="value-of-template">
																													<xsl:apply-templates />
																												</xsl:variable>
																												<xsl:choose>
																													<xsl:when
																														test="contains(string($value-of-template),'&#x2029;')">
																														<fo:block line-height="9pt">
																															<xsl:copy-of select="$value-of-template" />
																														</fo:block>
																													</xsl:when>
																													<xsl:otherwise>
																														<fo:inline line-height="9pt">
																															<xsl:copy-of select="$value-of-template" />
																														</fo:inline>
																													</xsl:otherwise>
																												</xsl:choose>
																											</fo:block>
																										</fo:block>
																									</xsl:for-each>
																								</xsl:for-each>
																							</xsl:for-each>
																						</fo:block>
																					</fo:table-cell>
																				</fo:table-row>
																			</fo:table-body>
																		</fo:table>
																	</xsl:if>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</fo:table-body>
												</fo:table>
											</xsl:if>
											<fo:inline-container>
												<fo:block>
													<xsl:text>&#x2029;</xsl:text>
												</fo:block>
											</fo:inline-container>
											<fo:table table-layout="fixed" width="100%"
												border-spacing="2pt">
												<fo:table-column column-width="proportional-column-width(1)" />
												<fo:table-body start-indent="0pt">
													<fo:table-row>
														<fo:table-cell padding="2pt" display-align="center">
															<fo:block />
														</fo:table-cell>
													</fo:table-row>
												</fo:table-body>
											</fo:table>
											<fo:block />
											<xsl:if
												test="starts-with( AwardDetails/IDCIndicator , &quot;P&quot; )  or  (count(  AwardIndirectCosts/Comments  )  &gt; 0  and  string-length(  AwardIndirectCosts/Comments  )  &gt; 0 )">
												<fo:inline font-family="Arial" font-size="12pt"
													font-weight="bold">
													<xsl:text>F&amp;A Rates:</xsl:text>
												</fo:inline>
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:table table-layout="fixed" width="100%"
													border-spacing="2pt">
													<fo:table-column column-width="proportional-column-width(1)" />
													<fo:table-column column-width="proportional-column-width(1)" />
													<fo:table-body start-indent="0pt">
														<fo:table-row>
															<fo:table-cell number-columns-spanned="2"
																padding="2pt" display-align="before">
																<fo:block>
																	<xsl:if
																		test="starts-with( AwardDetails/IDCIndicator , &quot;P&quot; )">
																		<xsl:for-each select="AwardIndirectCosts">
																			<fo:inline-container>
																				<fo:block>
																					<xsl:text>&#x2029;</xsl:text>
																				</fo:block>
																			</fo:inline-container>
																			<xsl:if test="IndirectCostSharingItem">
																				<fo:table table-layout="fixed" width="100%"
																					border-spacing="2pt">
																					<fo:table-column column-width="55" />
																					<fo:table-column column-width="80" />
																					<fo:table-column column-width="38" />
																					<fo:table-column column-width="65" />
																					<fo:table-column column-width="65" />
																					<fo:table-column column-width="60" />
																					<fo:table-column column-width="80" />
																					<fo:table-column column-width="65" />
																					<fo:table-column column-width="70" />
																					<fo:table-header start-indent="0pt">
																						<fo:table-row font-family="Arial"
																							font-size="9pt" font-weight="bold">
																							<fo:table-cell padding-left="20pt"
																								padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline font-weight="bold">
																										<xsl:text>Rate</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding-left="6pt"
																								padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline font-weight="bold">
																										<xsl:text>Type</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt"
																								display-align="center">
																								<fo:block>
																									<fo:inline font-weight="bold">
																										<xsl:text>Fiscal Year</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt"
																								display-align="center">
																								<fo:block>
																									<fo:inline font-weight="bold">
																										<xsl:text>Start Date</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt"
																								display-align="center">
																								<fo:block>
																									<fo:inline font-weight="bold">
																										<xsl:text>End Date</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt"
																								display-align="center">
																								<fo:block>
																									<fo:inline font-weight="bold">
																										<xsl:text>Campus</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>																							
																							<fo:table-cell padding="2pt"
																								display-align="center">
																								<fo:block>
																									<fo:inline font-weight="bold">
																										<xsl:text>Source</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt"
																								display-align="center">
																								<fo:block>
																									<fo:inline font-weight="bold">
																										<xsl:text>Destination</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt"
																								display-align="center">
																								<fo:block>
																									<fo:inline font-weight="bold">
																										<xsl:text>Unreceived F&amp;A</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																						</fo:table-row>
																					</fo:table-header>
																					<fo:table-body start-indent="0pt">
																						<xsl:for-each select="IndirectCostSharingItem">
																							<fo:table-row font-family="Arial"
																								font-size="9pt" font-weight="normal">
																								<fo:table-cell padding-bottom="0"
																									padding-left="20pt" padding-top="0" padding="2pt"
																									display-align="before">
																									<fo:block>
																										<xsl:for-each select="ApplicableRate">
																											<fo:inline>
																												<xsl:value-of
																													select="format-number(number(string(.)), '##0.00')" />
																											</fo:inline>
																										</xsl:for-each>
																									</fo:block>
																								</fo:table-cell>
																								<fo:table-cell padding-bottom="0"
																									padding-left="6pt" padding-top="0" padding="2pt"
																									display-align="before">
																									<fo:block>
																										<xsl:for-each select="IDCRateDescription">
																											<xsl:variable name="value-of-template">
																												<xsl:apply-templates />
																											</xsl:variable>
																											<xsl:choose>
																												<xsl:when
																													test="contains(string($value-of-template),'&#x2029;')">
																													<fo:block>
																														<xsl:copy-of select="$value-of-template" />
																													</fo:block>
																												</xsl:when>
																												<xsl:otherwise>
																													<fo:inline>
																														<xsl:copy-of select="$value-of-template" />
																													</fo:inline>
																												</xsl:otherwise>
																											</xsl:choose>
																										</xsl:for-each>
																									</fo:block>
																								</fo:table-cell>
																								<fo:table-cell padding-bottom="0"
																									padding-top="0" padding="2pt" display-align="before">
																									<fo:block>
																										<xsl:for-each select="FiscalYear">
																											<xsl:variable name="value-of-template">
																												<xsl:apply-templates />
																											</xsl:variable>
																											<xsl:choose>
																												<xsl:when
																													test="contains(string($value-of-template),'&#x2029;')">
																													<fo:block>
																														<xsl:copy-of select="$value-of-template" />
																													</fo:block>
																												</xsl:when>
																												<xsl:otherwise>
																													<fo:inline>
																														<xsl:copy-of select="$value-of-template" />
																													</fo:inline>
																												</xsl:otherwise>
																											</xsl:choose>
																										</xsl:for-each>
																									</fo:block>
																								</fo:table-cell>
																								<fo:table-cell font-size="9pt"
																									padding-bottom="0" padding-top="0" padding="2pt"
																									display-align="before">
																									<fo:block>
																										<xsl:for-each select="StartDate">
																											<fo:inline>
																												<xsl:value-of
																													select="format-number(number(substring(string(string(.)), 6, 2)), '00')" />
																												<xsl:text>/</xsl:text>
																												<xsl:value-of
																													select="format-number(number(substring(string(string(.)), 9, 2)), '00')" />
																												<xsl:text>/</xsl:text>
																												<xsl:value-of
																													select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')" />
																											</fo:inline>
																										</xsl:for-each>
																									</fo:block>
																								</fo:table-cell>
																								<fo:table-cell font-size="9pt"
																									padding-bottom="0" padding-top="0" padding="2pt"
																									display-align="before">
																									<fo:block>
																										<xsl:for-each select="EndDate">
																											<fo:inline>
																												<xsl:value-of
																													select="format-number(number(substring(string(string(.)), 6, 2)), '00')" />
																												<xsl:text>/</xsl:text>
																												<xsl:value-of
																													select="format-number(number(substring(string(string(.)), 9, 2)), '00')" />
																												<xsl:text>/</xsl:text>
																												<xsl:value-of
																													select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')" />
																											</fo:inline>
																										</xsl:for-each>
																									</fo:block>
																								</fo:table-cell>
																								<fo:table-cell padding-bottom="0"
																									padding-top="0" padding="2pt" display-align="before">
																									<fo:block>
																										<xsl:for-each select="Campus">
																											<xsl:choose>
																												<xsl:when test=". = &apos;true&apos;">
																													<fo:inline>
																														<xsl:text>Yes</xsl:text>
																													</fo:inline>
																												</xsl:when>
																												<xsl:otherwise>
																													<fo:inline>
																														<xsl:text>No</xsl:text>
																													</fo:inline>
																												</xsl:otherwise>
																											</xsl:choose>
																										</xsl:for-each>
																									</fo:block>
																								</fo:table-cell>																								
																								<fo:table-cell padding-bottom="0"
																									padding-top="0" padding="2pt" display-align="before">
																									<fo:block>
																										<xsl:for-each select="SourceAccount">
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:block white-space="pre"
																												white-space-collapse="false" wrap-option="wrap"
																												white-space-treatment="ignore-if-surrounding-linefeed"
																												margin="0pt">
																												<fo:block>
																													<xsl:variable name="value-of-template">
																														<xsl:apply-templates />
																													</xsl:variable>
																													<xsl:choose>
																														<xsl:when
																															test="contains(string($value-of-template),'&#x2029;')">
																															<fo:block>
																																<xsl:copy-of select="$value-of-template" />
																															</fo:block>
																														</xsl:when>
																														<xsl:otherwise>
																															<fo:inline>
																																<xsl:copy-of select="$value-of-template" />
																															</fo:inline>
																														</xsl:otherwise>
																													</xsl:choose>
																												</fo:block>
																											</fo:block>
																										</xsl:for-each>
																									</fo:block>
																								</fo:table-cell>
																								<fo:table-cell padding-bottom="0"
																									padding-top="0" padding="2pt" display-align="before">
																									<fo:block>
																										<xsl:for-each select="DestinationAccount">
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:block white-space="pre"
																												white-space-collapse="false" wrap-option="wrap"
																												white-space-treatment="ignore-if-surrounding-linefeed"
																												margin="0pt">
																												<fo:block>
																													<xsl:variable name="value-of-template">
																														<xsl:apply-templates />
																													</xsl:variable>
																													<xsl:choose>
																														<xsl:when
																															test="contains(string($value-of-template),'&#x2029;')">
																															<fo:block>
																																<xsl:copy-of select="$value-of-template" />
																															</fo:block>
																														</xsl:when>
																														<xsl:otherwise>
																															<fo:inline>
																																<xsl:copy-of select="$value-of-template" />
																															</fo:inline>
																														</xsl:otherwise>
																													</xsl:choose>
																												</fo:block>
																											</fo:block>
																										</xsl:for-each>
																									</fo:block>
																								</fo:table-cell>
																								<fo:table-cell font-size="9pt"
																									padding-bottom="0" padding-top="0" padding="2pt"
																									display-align="before">
																									<fo:block>
																										<xsl:for-each select="UnderRecoveryAmount">
																											<fo:inline>
																												<xsl:text>$</xsl:text>
																											</fo:inline>
																											<fo:inline>
																												<xsl:value-of
																													select="format-number(number(string(.)), '#,###,###,##0.00')" />
																											</fo:inline>
																										</xsl:for-each>
																									</fo:block>
																								</fo:table-cell>
																							</fo:table-row>
																						</xsl:for-each>
																						<fo:table-row font-family="Arial" font-size="9pt" font-weight="normal">
																							<fo:table-cell padding-bottom="0" padding-left="20pt" padding-top="0" padding="2pt" display-align="before">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding-bottom="0" padding-left="6pt" padding-top="0" padding="2pt" display-align="before">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding-bottom="0" padding-top="0" padding="2pt" display-align="before">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell font-size="9pt" padding-bottom="0" padding-top="0" padding="2pt" display-align="before">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell font-size="9pt" padding-bottom="0" padding-top="0" padding="2pt" display-align="before">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding-bottom="0" padding-top="0" padding="2pt" display-align="before">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding-bottom="0" padding-top="0" padding="2pt" display-align="before">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding-bottom="0" padding-top="0" padding="2pt" display-align="before">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding-bottom="0" padding-top="0" padding="2pt" display-align="before">
																								<fo:block>
																									<fo:block text-align="center">
																										<fo:leader leader-pattern="rule" rule-thickness="1" leader-length="100%" color="black"/>
																									</fo:block>
																								</fo:block>
																							</fo:table-cell>																							
																						</fo:table-row>
																						<fo:table-row font-family="Arial" font-size="9pt" font-weight="normal">
																							<fo:table-cell padding-bottom="0" padding-left="20pt" padding-top="0" padding="2pt" display-align="before">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding-bottom="0" padding-left="6pt" padding-top="0" padding="2pt" display-align="before">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding-bottom="0" padding-top="0" padding="2pt" display-align="before">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell font-size="9pt" padding-bottom="0" padding-top="0" padding="2pt" display-align="before">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell font-size="9pt" padding-bottom="0" padding-top="0" padding="2pt" display-align="before">
																								<fo:block/>
																							</fo:table-cell>																							
																							<fo:table-cell padding-bottom="0" padding-top="0" padding="2pt" display-align="before">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding-bottom="0" padding-top="0" padding="2pt" display-align="before">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell font-family="Arial" font-size="9pt" font-weight="bold" padding="2pt" text-align="right" display-align="before">
																								<fo:block>
																									<fo:inline>
																										<xsl:text>Total:</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell font-size="9pt" padding-bottom="0" padding-top="0" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline>
																										<xsl:text>$</xsl:text>
																									</fo:inline>
																									<fo:inline>
																										<xsl:value-of select="format-number(number(sum(  IndirectCostSharingItem/UnderRecoveryAmount  )), '###,##0.00')"/>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>																							
																						</fo:table-row>
																						<fo:table-row font-family="Arial" font-size="9pt" font-weight="normal">
																							<fo:table-cell padding-bottom="0" padding-left="20pt" padding-top="0" padding="2pt" display-align="before">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding-bottom="0" padding-left="6pt" padding-top="0" padding="2pt" display-align="before">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding-bottom="0" padding-top="0" padding="2pt" display-align="before">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell font-size="9pt" padding-bottom="0" padding-top="0" padding="2pt" display-align="before">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell font-size="9pt" padding-bottom="0" padding-top="0" padding="2pt" display-align="before">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding-bottom="0" padding-top="0" padding="2pt" display-align="before">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding-bottom="0" padding-top="0" padding="2pt" display-align="before">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding-bottom="0" padding-top="0" padding="2pt" display-align="before">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding-bottom="0" padding-top="0" padding="2pt" display-align="before">
																								<fo:block>
																									<fo:block text-align="center">
																										<fo:leader leader-pattern="rule" rule-thickness="1" leader-length="100%" color="black"/>
																									</fo:block>
																								</fo:block>
																							</fo:table-cell>																							
																						</fo:table-row>
																					</fo:table-body>
																				</fo:table>
																			</xsl:if>
																		</xsl:for-each>
																	</xsl:if>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</fo:table-body>
												</fo:table>
												<xsl:if
													test="count(  AwardIndirectCosts/Comments  )  &gt; 0  and  string-length(  AwardIndirectCosts/Comments  )  &gt; 0">
													<fo:inline-container>
														<fo:block>
															<xsl:text>&#x2029;</xsl:text>
														</fo:block>
													</fo:inline-container>
													<fo:table table-layout="fixed" width="100%"
														border-spacing="2pt">
														<fo:table-column column-width="proportional-column-width(1)" />
														<fo:table-body start-indent="0pt">
															<fo:table-row>
																<fo:table-cell padding="2pt"
																	display-align="center">
																	<fo:block>
																		<fo:inline-container>
																			<fo:block>
																				<xsl:text>&#x2029;</xsl:text>
																			</fo:block>
																		</fo:inline-container>
																		<fo:table table-layout="fixed" width="100%"
																			border-spacing="2pt">
																			<fo:table-column column-width="15%" />
																			<fo:table-column column-width="85%" />
																			<fo:table-body start-indent="0pt">
																				<fo:table-row>
																					<fo:table-cell font-family="Arial"
																						font-size="9pt" font-weight="bold" padding="2pt"
																						display-align="before">
																						<fo:block>
																							<fo:inline font-weight="bold">
																								<xsl:text>Comments:</xsl:text>
																							</fo:inline>
																						</fo:block>
																					</fo:table-cell>
																					<fo:table-cell font-family="Arial"
																						font-size="9pt" font-weight="normal" padding="2pt"
																						display-align="before">
																						<fo:block>
																							<xsl:for-each select="AwardIndirectCosts">
																								<xsl:for-each select="Comments">
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:block white-space="pre"
																										white-space-collapse="false" wrap-option="wrap"
																										white-space-treatment="ignore-if-surrounding-linefeed"
																										margin="0pt">
																										<fo:block>
																											<xsl:variable name="value-of-template">
																												<xsl:apply-templates />
																											</xsl:variable>
																											<xsl:choose>
																												<xsl:when
																													test="contains(string($value-of-template),'&#x2029;')">
																													<fo:block line-height="9pt">
																														<xsl:copy-of select="$value-of-template" />
																													</fo:block>
																												</xsl:when>
																												<xsl:otherwise>
																													<fo:inline line-height="9pt">
																														<xsl:copy-of select="$value-of-template" />
																													</fo:inline>
																												</xsl:otherwise>
																											</xsl:choose>
																										</fo:block>
																									</fo:block>
																								</xsl:for-each>
																							</xsl:for-each>
																						</fo:block>
																					</fo:table-cell>
																				</fo:table-row>
																			</fo:table-body>
																		</fo:table>
																	</fo:block>
																</fo:table-cell>
															</fo:table-row>
														</fo:table-body>
													</fo:table>
												</xsl:if>
											</xsl:if>
										</xsl:if>
										<xsl:if test="../PrintRequirement/FlowThruRequired = &quot;1&quot; ">
											<fo:inline font-family="Arial" font-size="12pt"
												font-weight="bold" padding-top="10pt">
												<fo:block>
												<xsl:text>Flow Thru:</xsl:text>
												</fo:block>
											</fo:inline>
											<xsl:if test="not ( (starts-with( AwardDetails/TransferSponsorIndicator , &quot;N&quot; ) and  string-length(AwardDetails/OtherHeaderDetails/PrimeSponsorCode) &lt;= 0 ))">
											<fo:block />
											<xsl:if
												test="string-length(AwardDetails/OtherHeaderDetails/PrimeSponsorCode) &gt; 0">
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:table table-layout="fixed" width="100%"
													border-spacing="2pt">
													<fo:table-column column-width="160" />
													<fo:table-column column-width="proportional-column-width(1)" />
													<fo:table-body start-indent="0pt">
														<fo:table-row>
															<fo:table-cell padding="2pt" display-align="center">
																<fo:block>
																	<fo:inline font-family="Arial" font-size="9pt"
																		font-weight="bold">
																		<xsl:text>Prime Sponsor:</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell padding="2pt" display-align="center">
																<fo:block>
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<fo:block white-space="pre"
																		white-space-collapse="false" wrap-option="wrap"
																		white-space-treatment="ignore-if-surrounding-linefeed"
																		margin="0pt">
																		<fo:block>
																			<xsl:for-each select="AwardDetails">
																				<xsl:for-each select="OtherHeaderDetails">
																					<xsl:for-each select="PrimeSponsorCode">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates />
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when
																								test="contains(string($value-of-template),'&#x2029;')">
																								<fo:block font-family="Arial"
																									font-size="9pt" font-weight="normal">
																									<xsl:copy-of select="$value-of-template" />
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline font-family="Arial"
																									font-size="9pt" font-weight="normal">
																									<xsl:copy-of select="$value-of-template" />
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:for-each>
																					<fo:inline font-size="12pt" font-weight="bold">
																						<xsl:text>&#160;</xsl:text>
																					</fo:inline>
																					<fo:inline font-family="Arial" font-size="12pt"
																						font-weight="bold">
																						<xsl:text>:</xsl:text>
																					</fo:inline>
																					<fo:inline font-size="12pt" font-weight="bold">
																						<xsl:text>&#160;</xsl:text>
																					</fo:inline>
																					<xsl:for-each select="PrimeSponsorDescription">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates />
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when
																								test="contains(string($value-of-template),'&#x2029;')">
																								<fo:block font-family="Arial"
																									font-size="9pt" font-weight="normal">
																									<xsl:copy-of select="$value-of-template" />
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline font-family="Arial"
																									font-size="9pt" font-weight="normal">
																									<xsl:copy-of select="$value-of-template" />
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:for-each>
																				</xsl:for-each>
																			</xsl:for-each>
																		</fo:block>
																	</fo:block>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</fo:table-body>
												</fo:table>
											</xsl:if>
											<fo:inline-container>
												<fo:block>
													<xsl:text>&#x2029;</xsl:text>
												</fo:block>
											</fo:inline-container>
											<fo:table table-layout="fixed" width="100%"
												border-spacing="2pt">
												<fo:table-column column-width="proportional-column-width(1)" />
												<fo:table-column column-width="proportional-column-width(1)" />
												<fo:table-body start-indent="0pt">
													<fo:table-row>
														<fo:table-cell font-family="Arial"
															font-size="9pt" font-weight="normal" padding="0"
															number-columns-spanned="2" display-align="center">
															<fo:block>
																<xsl:if
																	test="not (starts-with( AwardDetails/TransferSponsorIndicator , &quot;N&quot;)) and count(  AwardTransferringSponsors/TransferringSponsor  )  &gt; 0">
																	<fo:inline font-family="Arial" font-size="9pt"
																		font-weight="bold">
																		<xsl:text>Sponsor Funding Transfered:</xsl:text>
																	</fo:inline>
																	<xsl:for-each select="AwardTransferringSponsors">
																		<fo:inline-container>
																			<fo:block>
																				<xsl:text>&#x2029;</xsl:text>
																			</fo:block>
																		</fo:inline-container>
																		<xsl:if test="TransferringSponsor">
																			<fo:table table-layout="fixed" width="100%"
																				border-spacing="2pt">
																				<fo:table-column column-width="20" />
																				<fo:table-column column-width="29" />
																				<fo:table-column column-width="proportional-column-width(1)" />
																				<fo:table-header start-indent="0pt">
																					<fo:table-row font-family="Arial"
																						font-size="9pt" font-weight="bold">
																						<fo:table-cell padding-bottom="0"
																							padding-top="0" padding="2pt" display-align="center">
																							<fo:block />
																						</fo:table-cell>
																						<fo:table-cell padding-bottom="0"
																							padding-top="0" padding="2pt" text-align="right"
																							display-align="center">
																							<fo:block>
																								<fo:inline>
																									<xsl:text>&#160;</xsl:text>
																								</fo:inline>
																							</fo:block>
																						</fo:table-cell>
																						<fo:table-cell font-family="Arial"
																							font-size="9pt" font-weight="normal"
																							padding-bottom="0" padding-left="0" padding-top="0"
																							padding="2pt" display-align="center">
																							<fo:block>
																								<fo:inline font-weight="bold">
																									<xsl:text>Sponsor Name</xsl:text>
																								</fo:inline>
																							</fo:block>
																						</fo:table-cell>
																					</fo:table-row>
																				</fo:table-header>
																				<fo:table-body start-indent="0pt">
																					<xsl:for-each select="TransferringSponsor">
																						<fo:table-row>
																							<fo:table-cell padding="2pt"
																								display-align="center">
																								<fo:block />
																							</fo:table-cell>
																							<fo:table-cell padding-bottom="0"
																								padding-top="0" padding="2pt" text-align="right"
																								display-align="before">
																								<fo:block>
																									<fo:inline>
																										<xsl:text>&#160;</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell font-family="Arial"
																								font-size="9pt" font-weight="normal"
																								padding-bottom="0" padding-left="0" padding-top="0"
																								padding="2pt" display-align="before">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:block white-space="pre"
																										white-space-collapse="false" wrap-option="wrap"
																										white-space-treatment="ignore-if-surrounding-linefeed"
																										margin="0pt">
																										<fo:block>
																											<xsl:for-each select="SponsorCode">
																												<xsl:variable name="value-of-template">
																													<xsl:apply-templates />
																												</xsl:variable>
																												<xsl:choose>
																													<xsl:when
																														test="contains(string($value-of-template),'&#x2029;')">
																														<fo:block>
																															<xsl:copy-of select="$value-of-template" />
																														</fo:block>
																													</xsl:when>
																													<xsl:otherwise>
																														<fo:inline>
																															<xsl:copy-of select="$value-of-template" />
																														</fo:inline>
																													</xsl:otherwise>
																												</xsl:choose>
																											</xsl:for-each>
																											<fo:inline>
																												<xsl:text> : </xsl:text>
																											</fo:inline>
																											<xsl:for-each select="SponsorDescription">
																												<xsl:variable name="value-of-template">
																													<xsl:apply-templates />
																												</xsl:variable>
																												<xsl:choose>
																													<xsl:when
																														test="contains(string($value-of-template),'&#x2029;')">
																														<fo:block>
																															<xsl:copy-of select="$value-of-template" />
																														</fo:block>
																													</xsl:when>
																													<xsl:otherwise>
																														<fo:inline>
																															<xsl:copy-of select="$value-of-template" />
																														</fo:inline>
																													</xsl:otherwise>
																												</xsl:choose>
																											</xsl:for-each>
																										</fo:block>
																									</fo:block>
																								</fo:block>
																							</fo:table-cell>
																						</fo:table-row>
																					</xsl:for-each>
																				</fo:table-body>
																			</fo:table>
																		</xsl:if>
																	</xsl:for-each>
																</xsl:if>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</fo:table-body>
											</fo:table>
											</xsl:if>
										</xsl:if>
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:table table-layout="fixed" width="100%"
											border-spacing="2pt">
											<fo:table-column column-width="proportional-column-width(1)" />
											<fo:table-body start-indent="0pt">
												<fo:table-row>
													<fo:table-cell padding="2pt" display-align="center">
														<fo:block />
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
										<xsl:if test="../PrintRequirement/CommentsRequired = &quot;1&quot;">
												<fo:inline font-family="Arial" font-size="12pt"
													font-weight="bold">
													<xsl:text>Comments:</xsl:text>
												</fo:inline>
												<fo:block />
												<xsl:if
												test="count(  AwardComments/Comment [CommentDetails/CommentCode  &gt; 0  and  string-length(CommentDetails/Comments ) &gt;= 1] )  &gt; 0">
												<xsl:for-each select="AwardComments">
													<fo:block />
													<xsl:for-each select="Comment">
														<fo:block />
														<xsl:if
															test="CommentDetails/CommentCode  &gt;0  and  string-length(CommentDetails/Comments ) &gt;= 1">
															<fo:inline-container>
																<fo:block>
																	<xsl:text>&#x2029;</xsl:text>
																</fo:block>
															</fo:inline-container>
															<fo:table table-layout="fixed" width="100%"
																border-spacing="2pt">
																<fo:table-column column-width="20%" />
																<fo:table-column column-width="80%" />
																<fo:table-body start-indent="0pt">
																	<fo:table-row>
																		<fo:table-cell font-family="Arial"
																			font-size="9pt" font-weight="bold" padding="2pt"
																			display-align="before">
																			<fo:block>
																				<xsl:for-each select="Description">
																					<xsl:variable name="value-of-template">
																						<xsl:apply-templates />
																					</xsl:variable>
																					<xsl:choose>
																						<xsl:when
																							test="contains(string($value-of-template),'&#x2029;')">
																							<fo:block font-weight="bold">
																								<xsl:copy-of select="$value-of-template" />
																							</fo:block>
																						</xsl:when>
																						<xsl:otherwise>
																							<fo:inline font-weight="bold">
																								<xsl:copy-of select="$value-of-template" />
																							</fo:inline>
																						</xsl:otherwise>
																					</xsl:choose>
																				</xsl:for-each>
																				<fo:inline font-weight="bold">
																					<xsl:text>:</xsl:text>
																				</fo:inline>
																			</fo:block>
																		</fo:table-cell>
																		<fo:table-cell font-family="Arial"
																			font-size="9pt" font-weight="normal" padding="2pt"
																			display-align="before">
																			<fo:block>
																				<xsl:for-each select="CommentDetails">
																					<xsl:for-each select="Comments">
																						<fo:inline-container>
																							<fo:block>
																								<xsl:text>&#x2029;</xsl:text>
																							</fo:block>
																						</fo:inline-container>
																						<fo:block white-space="pre"
																							white-space-collapse="false" wrap-option="wrap"
																							white-space-treatment="ignore-if-surrounding-linefeed"
																							margin="0pt">
																							<fo:block>
																								<xsl:variable name="value-of-template">
																									<xsl:apply-templates />
																								</xsl:variable>
																								<xsl:choose>
																									<xsl:when
																										test="contains(string($value-of-template),'&#x2029;')">
																										<fo:block line-height="9pt">
																											<xsl:copy-of select="$value-of-template" />
																										</fo:block>
																									</xsl:when>
																									<xsl:otherwise>
																										<fo:inline line-height="9pt">
																											<xsl:copy-of select="$value-of-template" />
																										</fo:inline>
																									</xsl:otherwise>
																								</xsl:choose>
																							</fo:block>
																						</fo:block>
																					</xsl:for-each>
																				</xsl:for-each>
																			</fo:block>
																		</fo:table-cell>
																	</fo:table-row>
																</fo:table-body>
															</fo:table>
														</xsl:if>
													</xsl:for-each>
												</xsl:for-each>
											</xsl:if>
										</xsl:if>
										<xsl:if
											test="../PrintRequirement/FundingSummaryRequired  = &quot;1&quot;">
											<fo:inline font-family="Arial" font-size="12pt"
												font-weight="bold">
												<xsl:text>Funding Summary:</xsl:text>
											</fo:inline>
											<xsl:for-each select="AwardFundingSummary">
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:table table-layout="fixed" width="100%"
													border-spacing="2pt">
													<fo:table-column column-width="200" />
													<fo:table-column column-width="150" />
													<fo:table-column column-width="150" />
													<fo:table-column column-width="proportional-column-width(1)" />
													<fo:table-body start-indent="0pt">
														<fo:table-row font-family="Arial" font-size="9pt"
															font-weight="bold">
															<fo:table-cell padding="2pt" display-align="center">
																<fo:block />
															</fo:table-cell>
															<fo:table-cell padding="2pt" display-align="center">
																<fo:block>
																	<fo:inline font-weight="bold">
																		<xsl:text>Start Date</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell padding="2pt" display-align="center">
																<fo:block>
																	<fo:inline font-weight="bold">
																		<xsl:text>End Date</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell padding="2pt" display-align="center">
																<fo:block>
																	<fo:inline font-weight="bold">
																		<xsl:text>Total</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</fo:table-body>
												</fo:table>
												<fo:block text-align="center">
													<fo:leader leader-pattern="rule" rule-thickness="1"
														leader-length="100%" color="black" />
												</fo:block>
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
													<fo:table-column column-width="200"/>
													<fo:table-column column-width="150"/>
													<fo:table-column column-width="150"/>
													<fo:table-column column-width="proportional-column-width(1)"/>
													<fo:table-body start-indent="0pt">
														<fo:table-row font-family="Arial" font-size="9pt">
															<fo:table-cell padding="2pt" display-align="center">
																<fo:block>
																	<fo:inline font-family="Arial" font-size="9pt" font-weight="bold">
																		<xsl:text>Total Project Period:</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell padding="2pt" display-align="center">
																<fo:block>
																	<xsl:for-each select="FundingSummary">
																		<xsl:for-each select="TotalStartDate">
																			<fo:inline>
																				<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
																				<xsl:text>/</xsl:text>
																				<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
																				<xsl:text>/</xsl:text>
																				<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
																			</fo:inline>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell padding="2pt" display-align="center">
																<fo:block>
																	<xsl:for-each select="FundingSummary">
																		<xsl:for-each select="TotalEndDate">
																			<fo:inline>
																				<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
																				<xsl:text>/</xsl:text>
																				<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
																				<xsl:text>/</xsl:text>
																				<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
																			</fo:inline>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell padding="2pt" display-align="center">
																<fo:block>
																	<fo:inline>
																		<xsl:text>$</xsl:text>
																	</fo:inline>
																	<fo:inline>
																		<xsl:value-of select="format-number(number(FundingSummary/AnticipatedTotalAmt), '#,###,###,##0.00')"/>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</fo:table-body>
												</fo:table>
												<fo:block text-align="center">
													<fo:leader leader-pattern="rule" rule-thickness="1"
														leader-length="100%" color="black" />
												</fo:block>
												<xsl:for-each select="FundingSummary">
													<fo:inline-container>
														<fo:block>
															<xsl:text>&#x2029;</xsl:text>
														</fo:block>
													</fo:inline-container>
													<fo:table font-family="Arial" font-size="9pt"
														table-layout="fixed" width="100%" border-spacing="2pt">
														<fo:table-column column-width="200" />
														<fo:table-column column-width="150" />
														<fo:table-column column-width="150" />
														<fo:table-column column-width="proportional-column-width(1)" />
														<fo:table-body start-indent="0pt">
															<fo:table-row>
																<fo:table-cell padding="2pt"
																	display-align="center">
																	<fo:block>
																		<fo:inline>
																			<xsl:text>Seq.</xsl:text>
																		</fo:inline>
																		<xsl:for-each select="SequenceNumber">
																			<xsl:variable name="value-of-template">
																				<xsl:apply-templates />
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when
																					test="contains(string($value-of-template),'&#x2029;')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template" />
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template" />
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell padding="2pt"
																	display-align="center">
																	<fo:block>
																		<xsl:for-each select="CurrentFundEffectiveDate">
																			<fo:inline font-family="Arial" font-size="9pt"
																				font-weight="normal">
																				<xsl:value-of
																					select="format-number(number(substring(string(string(.)), 6, 2)), '00')" />
																				<xsl:text>/</xsl:text>
																				<xsl:value-of
																					select="format-number(number(substring(string(string(.)), 9, 2)), '00')" />
																				<xsl:text>/</xsl:text>
																				<xsl:value-of
																					select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')" />
																			</fo:inline>
																		</xsl:for-each>
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell padding="2pt"
																	display-align="center">
																	<fo:block>
																		<xsl:for-each select="ObligationExpirationDate">
																			<fo:inline>
																				<xsl:value-of
																					select="format-number(number(substring(string(string(.)), 6, 2)), '00')" />
																				<xsl:text>/</xsl:text>
																				<xsl:value-of
																					select="format-number(number(substring(string(string(.)), 9, 2)), '00')" />
																				<xsl:text>/</xsl:text>
																				<xsl:value-of
																					select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')" />
																			</fo:inline>
																		</xsl:for-each>
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell padding="2pt"
																	display-align="center">
																	<fo:block>
																		<fo:inline>
																			<xsl:text>$</xsl:text>
																		</fo:inline>
																		<fo:inline>
																			<xsl:value-of
																				select="format-number(number(sum( ObligatedChange)), '#,###,###,##0.00')" />
																		</fo:inline>
																	</fo:block>
																</fo:table-cell>
															</fo:table-row>
														</fo:table-body>
													</fo:table>
												</xsl:for-each>
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:table table-layout="fixed" width="100%"
													border-spacing="2pt">
													<fo:table-column column-width="200" />
													<fo:table-column column-width="proportional-column-width(1)" />
													<fo:table-body start-indent="0pt">
														<fo:table-row>
															<fo:table-cell padding="2pt" height="10"
																display-align="center">
																<fo:block />
															</fo:table-cell>
															<fo:table-cell padding="2pt" height="10"
																display-align="center">
																<fo:block>
																	<fo:block text-align="center">
																		<fo:leader leader-pattern="rule"
																			rule-thickness="1" leader-length="100%" color="black" />
																	</fo:block>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</fo:table-body>
												</fo:table>
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:table table-layout="fixed" width="100%"
													border-spacing="2pt">
													<fo:table-column column-width="200" />
													<fo:table-column column-width="100" />
													<fo:table-column column-width="200" />
													<fo:table-column column-width="proportional-column-width(1)" />
													<fo:table-body start-indent="0pt">
														<fo:table-row>
															<fo:table-cell padding="2pt" height="24"
																display-align="center">
																<fo:block />
															</fo:table-cell>
															<fo:table-cell padding="2pt" height="24"
																display-align="center">
																<fo:block />
															</fo:table-cell>
															<fo:table-cell font-family="Arial"
																font-size="9pt" font-weight="bold" padding="2pt" height="24"
																display-align="center">
																<fo:block>
																	<fo:inline font-family="Arial" font-size="9pt"
																		font-weight="bold">
																		<xsl:text>Total Obligated:</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell font-family="Arial"
																font-size="9pt" font-weight="normal" padding="2pt"
																height="24" display-align="center">
																<fo:block>
																	<fo:inline>
																		<xsl:text>$</xsl:text>
																	</fo:inline>
																	<fo:inline>
																		<xsl:value-of
																			select="format-number(number(FundingSummary/AmtObligatedToDate), '#,###,###,##0.00')" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell padding="2pt" display-align="center">
																<fo:block />
															</fo:table-cell>
															<fo:table-cell padding="2pt" display-align="center">
																<fo:block />
															</fo:table-cell>
															<fo:table-cell font-family="Arial"
																font-size="9pt" font-weight="bold" padding="2pt"
																display-align="center">
																<fo:block>
																	<fo:inline font-family="Arial" font-size="9pt"
																		font-weight="bold">
																		<xsl:text>Amount for </xsl:text>
																	</fo:inline>
																	<xsl:for-each select="FundingSummary">
																		<xsl:for-each select="AwardNumber">
																			<xsl:variable name="value-of-template">
																				<xsl:apply-templates />
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when
																					test="contains(string($value-of-template),'&#x2029;')">
																					<fo:block font-family="Arial" font-size="9pt"
																						font-weight="normal">
																						<xsl:copy-of select="$value-of-template" />
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline font-family="Arial" font-size="9pt"
																						font-weight="normal">
																						<xsl:copy-of select="$value-of-template" />
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell font-family="Arial"
																font-size="9pt" font-weight="normal" padding="2pt"
																display-align="center">
																<fo:block>
																	<fo:inline>
																		<xsl:text>$</xsl:text>
																	</fo:inline>
																	<fo:inline>
																		<xsl:value-of
																			select="format-number(number(FundingSummary/ObligatedDistributableAmt), '#,###,###,##0.00')" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell padding="2pt" display-align="center">
																<fo:block />
															</fo:table-cell>
															<fo:table-cell padding="2pt" display-align="center">
																<fo:block />
															</fo:table-cell>
															<fo:table-cell font-family="Arial"
																font-size="9pt" font-weight="bold" padding="2pt"
																display-align="center">
																<fo:block>
																	<fo:inline font-family="Arial" font-size="9pt"
																		font-weight="bold">
																		<xsl:text>Child Proj/Grant Total: </xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell font-family="Arial"
																font-size="9pt" font-weight="normal" padding="2pt"
																display-align="center">
																<fo:block>
																	<fo:inline>
																		<xsl:text>$</xsl:text>
																	</fo:inline>
																	<fo:inline>
																		<xsl:value-of
																			select="format-number(number(FundingSummary/AmtObligatedToDate   -   FundingSummary/ObligatedDistributableAmt), '#,###,###,##0.00')" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell padding="2pt" display-align="center">
																<fo:block />
															</fo:table-cell>
															<fo:table-cell padding="2pt" display-align="center">
																<fo:block />
															</fo:table-cell>
															<fo:table-cell font-family="Arial"
																font-size="9pt" font-weight="bold" padding="2pt"
																display-align="center">
																<fo:block>
																	<fo:inline font-family="Arial" font-size="9pt"
																		font-weight="bold">
																		<xsl:text>Remaining Anticipated:</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell font-family="Arial"
																font-size="9pt" font-weight="normal" padding="2pt"
																display-align="center">
																<fo:block>
																	<fo:inline>
																		<xsl:text>$</xsl:text>
																	</fo:inline>
																	<fo:inline>
																		<xsl:value-of
																			select="format-number(number(FundingSummary/AnticipatedTotalAmt -   FundingSummary/AmtObligatedToDate), '#,###,###,##0.00')" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</fo:table-body>
												</fo:table>
												<fo:block />
												<fo:block text-align="center">
													<fo:leader leader-pattern="rule" rule-thickness="1"
														leader-length="100%" color="black" />
												</fo:block>
											</xsl:for-each>
										</xsl:if>	
										<xsl:if	test="../PrintRequirement/HierarchyInfoRequired   = &quot;1&quot;">
												<fo:inline font-family="Arial" font-size="12pt"
													font-weight="bold">
													<xsl:text>Hierarchy Distributions:</xsl:text>
												</fo:inline>
												<fo:block />
												<xsl:if test="count(    ChildAwardDetails/ChildAward )  &gt; 0">
												<xsl:for-each select="ChildAwardDetails">
													<fo:inline-container>
														<fo:block>
															<xsl:text>&#x2029;</xsl:text>
														</fo:block>
													</fo:inline-container>
													<xsl:if test="ChildAward">
														<fo:table font-family="Arial" table-layout="fixed"
															width="100%" border-spacing="2pt">
															<fo:table-column column-width="proportional-column-width(1)" />
															<fo:table-column column-width="proportional-column-width(1)" />
															<fo:table-column column-width="proportional-column-width(1)" />
															<fo:table-column column-width="proportional-column-width(1)" />
															<fo:table-column column-width="proportional-column-width(1)" />
															<fo:table-header start-indent="0pt">
																<fo:table-row font-family="Arial"
																	font-size="9pt" font-weight="bold">
																	<fo:table-cell padding="2pt"
																		display-align="center">
																		<fo:block>
																			<fo:inline font-weight="bold">
																				<xsl:text>PI</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell padding="2pt"
																		display-align="center">
																		<fo:block>
																			<fo:inline font-weight="bold">
																				<xsl:text>Account ID</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell padding="2pt"
																		display-align="center">
																		<fo:block>
																			<fo:inline font-weight="bold">
																				<xsl:text>Obligation Start</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell padding="2pt"
																		display-align="center">
																		<fo:block>
																			<fo:inline font-weight="bold">
																				<xsl:text>Obligation End</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell padding="2pt"
																		display-align="center">
																		<fo:block>
																			<fo:inline font-weight="bold">
																				<xsl:text>Obligated Total</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:table-cell>
																</fo:table-row>
															</fo:table-header>
															<fo:table-footer start-indent="0pt">
																<fo:table-row>
																	<fo:table-cell padding="2pt" height="22"
																		display-align="center">
																		<fo:block />
																	</fo:table-cell>
																	<fo:table-cell padding="2pt" height="22"
																		display-align="center">
																		<fo:block />
																	</fo:table-cell>
																	<fo:table-cell number-columns-spanned="3"
																		padding="2pt" height="22" display-align="before">
																		<fo:block>
																			<fo:block text-align="center">
																				<fo:leader leader-pattern="rule"
																					rule-thickness="0.3" leader-length="100%" color="black" />
																			</fo:block>
																		</fo:block>
																	</fo:table-cell>
																</fo:table-row>
																<fo:table-row font-family="Arial">
																	<fo:table-cell padding="2pt"
																		display-align="center">
																		<fo:block />
																	</fo:table-cell>
																	<fo:table-cell padding="2pt"
																		display-align="center">
																		<fo:block />
																	</fo:table-cell>
																	<fo:table-cell font-family="Arial"
																		font-size="9pt" font-weight="bold"
																		number-columns-spanned="2" padding="2pt" text-align="center"
																		display-align="center">
																		<fo:block>
																			<fo:inline font-weight="bold">
																				<xsl:text>Total Obligated:</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell font-family="Arial"
																		font-size="9pt" font-weight="normal" padding="2pt"
																		display-align="center">
																		<fo:block>
																			<fo:inline>
																				<xsl:text>$</xsl:text>
																			</fo:inline>
																			<fo:inline font-family="Arial">
																				<xsl:value-of
																					select="format-number(number(sum( ChildAward/AmtObligatedToDate )), '#,###,###,##0.00')" />
																			</fo:inline>
																		</fo:block>
																	</fo:table-cell>
																</fo:table-row>
																<fo:table-row>
																	<fo:table-cell number-columns-spanned="5"
																		padding="2pt" display-align="center">
																		<fo:block>
																			<fo:block text-align="center">
																				<fo:leader leader-pattern="rule"
																					rule-thickness="1" leader-length="100%" color="black" />
																			</fo:block>
																		</fo:block>
																	</fo:table-cell>
																</fo:table-row>
															</fo:table-footer>
															<fo:table-body font-family="Arial"
																start-indent="0pt">
																<xsl:for-each select="ChildAward">
																	<fo:table-row font-family="Arial"
																		font-size="9pt" font-weight="normal">
																		<fo:table-cell padding="2pt"
																			display-align="center">
																			<fo:block>
																				<fo:inline-container>
																					<fo:block>
																						<xsl:text>&#x2029;</xsl:text>
																					</fo:block>
																				</fo:inline-container>
																				<fo:block white-space="pre"
																					white-space-collapse="false" wrap-option="wrap"
																					white-space-treatment="ignore-if-surrounding-linefeed"
																					margin="0pt">
																					<fo:block>
																						<xsl:for-each select="PIName">
																							<xsl:variable name="value-of-template">
																								<xsl:apply-templates />
																							</xsl:variable>
																							<xsl:choose>
																								<xsl:when
																									test="contains(string($value-of-template),'&#x2029;')">
																									<fo:block>
																										<xsl:copy-of select="$value-of-template" />
																									</fo:block>
																								</xsl:when>
																								<xsl:otherwise>
																									<fo:inline>
																										<xsl:copy-of select="$value-of-template" />
																									</fo:inline>
																								</xsl:otherwise>
																							</xsl:choose>
																						</xsl:for-each>
																					</fo:block>
																				</fo:block>
																			</fo:block>
																		</fo:table-cell>
																		<fo:table-cell padding="2pt"
																			display-align="center">
																			<fo:block>
																				<xsl:for-each select="AccountNumber">
																					<xsl:if test=". &gt;0">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates />
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when
																								test="contains(string($value-of-template),'&#x2029;')">
																								<fo:block font-family="Arial">
																									<xsl:copy-of select="$value-of-template" />
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline font-family="Arial">
																									<xsl:copy-of select="$value-of-template" />
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:if>
																				</xsl:for-each>
																			</fo:block>
																		</fo:table-cell>
																		<fo:table-cell font-size="9pt" padding="2pt"
																			display-align="center">
																			<fo:block>
																				<xsl:for-each select="CurrentFundEffectiveDate">
																					<fo:inline>
																						<xsl:value-of
																							select="format-number(number(substring(string(string(.)), 6, 2)), '00')" />
																						<xsl:text>/</xsl:text>
																						<xsl:value-of
																							select="format-number(number(substring(string(string(.)), 9, 2)), '00')" />
																						<xsl:text>/</xsl:text>
																						<xsl:value-of
																							select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')" />
																					</fo:inline>
																				</xsl:for-each>
																			</fo:block>
																		</fo:table-cell>
																		<fo:table-cell font-size="9pt" padding="2pt"
																			display-align="center">
																			<fo:block>
																				<xsl:for-each select="ObligationExpirationDate">
																					<fo:inline>
																						<xsl:value-of
																							select="format-number(number(substring(string(string(.)), 6, 2)), '00')" />
																						<xsl:text>/</xsl:text>
																						<xsl:value-of
																							select="format-number(number(substring(string(string(.)), 9, 2)), '00')" />
																						<xsl:text>/</xsl:text>
																						<xsl:value-of
																							select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')" />
																					</fo:inline>
																				</xsl:for-each>
																			</fo:block>
																		</fo:table-cell>
																		<fo:table-cell font-size="9pt" padding="2pt"
																			display-align="center">
																			<fo:block>
																				<fo:inline>
																					<xsl:text>$</xsl:text>
																				</fo:inline>
																				<xsl:for-each select="AmtObligatedToDate">
																					<fo:inline>
																						<xsl:value-of
																							select="format-number(number(string(.)), '#,###,###,##0.00')" />
																					</fo:inline>
																				</xsl:for-each>
																			</fo:block>
																		</fo:table-cell>
																	</fo:table-row>
																</xsl:for-each>
															</fo:table-body>
														</fo:table>
													</xsl:if>
												</xsl:for-each>
											</xsl:if>
										</xsl:if>
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:table table-layout="fixed" width="100%"
											border-spacing="2pt">
											<fo:table-column column-width="proportional-column-width(1)" />
											<fo:table-body start-indent="0pt">
												<fo:table-row>
													<fo:table-cell padding="2pt" display-align="center">
														<fo:block />
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
										<fo:block />
										<xsl:if	test="../PrintRequirement/TechnicalReportingRequired = &quot;1&quot;">
												<fo:inline font-family="Arial" font-size="12pt"
													font-weight="bold">
													<xsl:text>Technical Reporting Requirements:</xsl:text>
												</fo:inline>
												<xsl:if	test="AwardReportingDetails/ReportDetails/ReportTermDetails/ReportClassCode = 4">
												<xsl:for-each select="AwardReportingDetails">
													<xsl:for-each select="ReportDetails">
														<xsl:for-each select="ReportTermDetails">
															<xsl:if test="ReportClassCode = 4">
																<fo:inline-container>
																	<fo:block>
																		<xsl:text>&#x2029;</xsl:text>
																	</fo:block>
																</fo:inline-container>
																<fo:table font-family="Arial" padding-top="10pt"
																	table-layout="fixed" width="100%" border-spacing="2pt">
																	<fo:table-column column-width="160" />
																	<fo:table-column column-width="proportional-column-width(1)" />
																	<fo:table-body start-indent="0pt">
																		<fo:table-row>
																			<fo:table-cell font-family="Arial"
																				font-size="9pt" font-weight="bold" padding-bottom="1pt"
																				padding="0pt" display-align="center">
																				<fo:block>
																					<fo:block />
																					<fo:inline font-family="Arial">
																						<xsl:text>Type of Report: </xsl:text>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell font-family="Arial"
																				font-size="9pt" font-weight="normal" padding-bottom="1pt"
																				padding="0pt" text-align="left" display-align="center">
																				<fo:block>
																					<fo:inline-container>
																						<fo:block>
																							<xsl:text>&#x2029;</xsl:text>
																						</fo:block>
																					</fo:inline-container>
																					<fo:block white-space="pre"
																						white-space-collapse="false" wrap-option="wrap"
																						white-space-treatment="ignore-if-surrounding-linefeed"
																						margin="0pt">
																						<fo:block>
																							<xsl:for-each select="ReportCodeDesc">
																								<xsl:variable name="value-of-template">
																									<xsl:apply-templates />
																								</xsl:variable>
																								<xsl:choose>
																									<xsl:when
																										test="contains(string($value-of-template),'&#x2029;')">
																										<fo:block>
																											<xsl:copy-of select="$value-of-template" />
																										</fo:block>
																									</xsl:when>
																									<xsl:otherwise>
																										<fo:inline>
																											<xsl:copy-of select="$value-of-template" />
																										</fo:inline>
																									</xsl:otherwise>
																								</xsl:choose>
																							</xsl:for-each>
																						</fo:block>
																					</fo:block>
																				</fo:block>
																			</fo:table-cell>
																		</fo:table-row>
																		<fo:table-row>
																			<fo:table-cell font-family="Arial"
																				font-size="9pt" font-weight="bold" padding-bottom="1pt"
																				padding="0pt" display-align="center">
																				<fo:block>
																					<fo:block />
																					<fo:inline>
																						<xsl:text>Frequency:</xsl:text>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell font-family="Arial"
																				font-size="9pt" font-weight="normal" padding-bottom="1pt"
																				padding="0pt" text-align="left" display-align="center">
																				<fo:block>
																					<fo:inline-container>
																						<fo:block>
																							<xsl:text>&#x2029;</xsl:text>
																						</fo:block>
																					</fo:inline-container>
																					<fo:block white-space="pre"
																						white-space-collapse="false" wrap-option="wrap"
																						white-space-treatment="ignore-if-surrounding-linefeed"
																						margin="0pt">
																						<fo:block>
																							<xsl:for-each select="FrequencyCodeDesc">
																								<xsl:variable name="value-of-template">
																									<xsl:apply-templates />
																								</xsl:variable>
																								<xsl:choose>
																									<xsl:when
																										test="contains(string($value-of-template),'&#x2029;')">
																										<fo:block>
																											<xsl:copy-of select="$value-of-template" />
																										</fo:block>
																									</xsl:when>
																									<xsl:otherwise>
																										<fo:inline>
																											<xsl:copy-of select="$value-of-template" />
																										</fo:inline>
																									</xsl:otherwise>
																								</xsl:choose>
																							</xsl:for-each>
																						</fo:block>
																					</fo:block>
																				</fo:block>
																			</fo:table-cell>
																		</fo:table-row>
																		<fo:table-row>
																			<fo:table-cell font-family="Arial"
																				font-size="9pt" font-weight="bold" padding-bottom="1pt"
																				padding="0pt" display-align="center">
																				<fo:block>
																					<fo:block />
																					<fo:inline>
																						<xsl:text>Frequency Basis</xsl:text>
																					</fo:inline>
																					<fo:inline padding-top="10pt">
																						<xsl:text>: </xsl:text>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell font-family="Arial"
																				font-size="9pt" font-weight="normal" padding-bottom="1pt"
																				padding="0pt" text-align="left" display-align="center">
																				<fo:block>
																					<fo:inline-container>
																						<fo:block>
																							<xsl:text>&#x2029;</xsl:text>
																						</fo:block>
																					</fo:inline-container>
																					<fo:block white-space="pre"
																						white-space-collapse="false" wrap-option="wrap"
																						white-space-treatment="ignore-if-surrounding-linefeed"
																						margin="0pt">
																						<fo:block>
																							<xsl:for-each select="FrequencyBaseDesc">
																								<xsl:variable name="value-of-template">
																									<xsl:apply-templates />
																								</xsl:variable>
																								<xsl:choose>
																									<xsl:when
																										test="contains(string($value-of-template),'&#x2029;')">
																										<fo:block>
																											<xsl:copy-of select="$value-of-template" />
																										</fo:block>
																									</xsl:when>
																									<xsl:otherwise>
																										<fo:inline>
																											<xsl:copy-of select="$value-of-template" />
																										</fo:inline>
																									</xsl:otherwise>
																								</xsl:choose>
																							</xsl:for-each>
																						</fo:block>
																					</fo:block>
																				</fo:block>
																			</fo:table-cell>
																		</fo:table-row>
																		<fo:table-row>
																			<fo:table-cell font-family="Arial"
																				font-size="9pt" font-weight="bold" padding-bottom="1pt"
																				padding="0pt" display-align="center">
																				<fo:block>
																					<fo:block />
																					<xsl:if test="DueDate != &apos;1900-01-01+00:00&apos;">
																						<fo:inline>
																							<xsl:text> Due Date:</xsl:text>
																						</fo:inline>
																					</xsl:if>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell font-family="Arial"
																				font-size="9pt" font-weight="normal" padding-bottom="1pt"
																				padding="0pt" text-align="left" display-align="center">
																				<fo:block>
																					<xsl:if test="DueDate != &apos;1900-01-01+00:00&apos;">
																						<xsl:for-each select="DueDate">
																							<fo:inline>
																								<xsl:value-of
																									select="format-number(number(substring(string(string(.)), 6, 2)), '00')" />
																								<xsl:text>/</xsl:text>
																								<xsl:value-of
																									select="format-number(number(substring(string(string(.)), 9, 2)), '00')" />
																								<xsl:text>/</xsl:text>
																								<xsl:value-of
																									select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')" />
																							</fo:inline>
																						</xsl:for-each>
																					</xsl:if>
																				</fo:block>
																			</fo:table-cell>
																		</fo:table-row>
																		<fo:table-row>
																			<fo:table-cell font-family="Arial"
																				font-size="9pt" font-weight="bold" padding-bottom="1pt"
																				padding="0pt" display-align="center">
																				<fo:block>
																					<fo:block />
																					<fo:inline padding-top="10pt">
																						<xsl:text>OSP Distribution:</xsl:text>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell font-family="Arial"
																				font-size="9pt" font-weight="normal" padding-bottom="1pt"
																				padding="0pt" text-align="left" display-align="center">
																				<fo:block>
																					<fo:inline-container>
																						<fo:block>
																							<xsl:text>&#x2029;</xsl:text>
																						</fo:block>
																					</fo:inline-container>
																					<fo:block white-space="pre"
																						white-space-collapse="false" wrap-option="wrap"
																						white-space-treatment="ignore-if-surrounding-linefeed"
																						margin="0pt">
																						<fo:block>
																							<xsl:for-each select="OSPDistributionDesc">
																								<xsl:variable name="value-of-template">
																									<xsl:apply-templates />
																								</xsl:variable>
																								<xsl:choose>
																									<xsl:when
																										test="contains(string($value-of-template),'&#x2029;')">
																										<fo:block>
																											<xsl:copy-of select="$value-of-template" />
																										</fo:block>
																									</xsl:when>
																									<xsl:otherwise>
																										<fo:inline>
																											<xsl:copy-of select="$value-of-template" />
																										</fo:inline>
																									</xsl:otherwise>
																								</xsl:choose>
																							</xsl:for-each>
																						</fo:block>
																					</fo:block>
																				</fo:block>
																			</fo:table-cell>
																		</fo:table-row>
																		<fo:table-row>
																			<fo:table-cell padding="0"
																				padding-bottom="0" padding-top="0"
																				number-columns-spanned="2" display-align="center">
																				<fo:block>
																					<xsl:if test="MailCopies/NumberOfCopies &gt;0">
																						<fo:inline-container>
																							<fo:block>
																								<xsl:text>&#x2029;</xsl:text>
																							</fo:block>
																						</fo:inline-container>
																						<xsl:if test="MailCopies">
																							<fo:table font-family="Arial"
																								table-layout="fixed" width="100%"
																								border-spacing="2pt">
																								<fo:table-column column-width="proportional-column-width(1)" />
																								<fo:table-column column-width="proportional-column-width(1)" />
																								<fo:table-body start-indent="0pt">
																									<xsl:for-each select="MailCopies">
																										<fo:table-row>
																											<fo:table-cell font-family="Arial"
																												font-size="9pt" font-weight="normal"
																												padding-bottom="0" number-columns-spanned="2"
																												padding="0" display-align="center">
																												<fo:block>
																													<fo:inline-container>
																														<fo:block>
																															<xsl:text>&#x2029;</xsl:text>
																														</fo:block>
																													</fo:inline-container>
																													<fo:block white-space="pre"
																														white-space-collapse="false" wrap-option="wrap"
																														white-space-treatment="ignore-if-surrounding-linefeed"
																														margin="0pt">
																														<fo:block>
																															<fo:inline>
																																<xsl:text>Mail </xsl:text>
																															</fo:inline>
																															<xsl:for-each select="NumberOfCopies">
																																<xsl:variable name="value-of-template">
																																	<xsl:apply-templates />
																																</xsl:variable>
																																<xsl:choose>
																																	<xsl:when
																																		test="contains(string($value-of-template),'&#x2029;')">
																																		<fo:block>
																																			<xsl:copy-of select="$value-of-template" />
																																		</fo:block>
																																	</xsl:when>
																																	<xsl:otherwise>
																																		<fo:inline>
																																			<xsl:copy-of select="$value-of-template" />
																																		</fo:inline>
																																	</xsl:otherwise>
																																</xsl:choose>
																															</xsl:for-each>
																															<fo:inline>
																																<xsl:text>&#160;</xsl:text>
																															</fo:inline>
																															<xsl:choose>
																																<xsl:when test="NumberOfCopies &gt; 1">
																																	<fo:inline>
																																		<xsl:text>copies</xsl:text>
																																	</fo:inline>
																																</xsl:when>
																																<xsl:when test="NumberOfCopies &lt;2">
																																	<fo:inline>
																																		<xsl:text>copy</xsl:text>
																																	</fo:inline>
																																</xsl:when>
																															</xsl:choose>
																															<fo:inline>
																																<xsl:text> to </xsl:text>
																															</fo:inline>
																															<xsl:for-each select="RolodexName">
																																<xsl:variable name="value-of-template">
																																	<xsl:apply-templates />
																																</xsl:variable>
																																<xsl:choose>
																																	<xsl:when
																																		test="contains(string($value-of-template),'&#x2029;')">
																																		<fo:block>
																																			<xsl:copy-of select="$value-of-template" />
																																		</fo:block>
																																	</xsl:when>
																																	<xsl:otherwise>
																																		<fo:inline>
																																			<xsl:copy-of select="$value-of-template" />
																																		</fo:inline>
																																	</xsl:otherwise>
																																</xsl:choose>
																															</xsl:for-each>
																															<fo:inline>
																																<xsl:text>&#160; </xsl:text>
																															</fo:inline>
																															<xsl:for-each select="RolodexOrganization">
																																<xsl:variable name="value-of-template">
																																	<xsl:apply-templates />
																																</xsl:variable>
																																<xsl:choose>
																																	<xsl:when
																																		test="contains(string($value-of-template),'&#x2029;')">
																																		<fo:block>
																																			<xsl:copy-of select="$value-of-template" />
																																		</fo:block>
																																	</xsl:when>
																																	<xsl:otherwise>
																																		<fo:inline>
																																			<xsl:copy-of select="$value-of-template" />
																																		</fo:inline>
																																	</xsl:otherwise>
																																</xsl:choose>
																															</xsl:for-each>
																															<fo:inline>
																																<xsl:text>&#160; (For complete address, see following address page Rolodex ID&#160; </xsl:text>
																															</fo:inline>
																															<xsl:for-each select="RolodexId">
																																<xsl:variable name="value-of-template">
																																	<xsl:apply-templates />
																																</xsl:variable>
																																<xsl:choose>
																																	<xsl:when
																																		test="contains(string($value-of-template),'&#x2029;')">
																																		<fo:block>
																																			<xsl:copy-of select="$value-of-template" />
																																		</fo:block>
																																	</xsl:when>
																																	<xsl:otherwise>
																																		<fo:inline>
																																			<xsl:copy-of select="$value-of-template" />
																																		</fo:inline>
																																	</xsl:otherwise>
																																</xsl:choose>
																															</xsl:for-each>
																															<fo:inline>
																																<xsl:text> )</xsl:text>
																															</fo:inline>
																														</fo:block>
																													</fo:block>
																												</fo:block>
																											</fo:table-cell>
																										</fo:table-row>
																									</xsl:for-each>
																								</fo:table-body>
																							</fo:table>
																						</xsl:if>
																					</xsl:if>
																				</fo:block>
																			</fo:table-cell>
																		</fo:table-row>
																	</fo:table-body>
																</fo:table>
															</xsl:if>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</xsl:if>
										</xsl:if>
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:table table-layout="fixed" width="100%"
											border-spacing="2pt">
											<fo:table-column column-width="proportional-column-width(1)" />
											<fo:table-body start-indent="0pt">
												<fo:table-row>
													<fo:table-cell padding="2pt" display-align="center">
														<fo:block />
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:table table-layout="fixed" width="100%"
											border-spacing="2pt">
											<fo:table-column column-width="681" />
											<fo:table-body start-indent="0pt">
												<fo:table-row>
													<fo:table-cell padding="2pt" display-align="center">
														<fo:block>
															<xsl:if test="../PrintRequirement/ProposalDueRequired = 1">
																<xsl:if
																	test="string-length(  AwardDetails/OtherHeaderDetails/NonCompetingContDesc  ) &gt;0  or  string-length(  AwardDetails/OtherHeaderDetails/CompetingRenewalDesc  )  &gt; 0">
																	<fo:inline font-family="Arial" font-size="12pt"
																		font-weight="bold">
																		<xsl:text>Proposal Due:</xsl:text>
																	</fo:inline>
																	<fo:block />
																	<xsl:if
																		test="string-length(  AwardDetails/OtherHeaderDetails/NonCompetingContDesc  ) &gt;0">
																		<fo:inline-container>
																			<fo:block>
																				<xsl:text>&#x2029;</xsl:text>
																			</fo:block>
																		</fo:inline-container>
																		<fo:table font-family="Arial" table-layout="fixed"
																			width="100%" border-spacing="2pt">
																			<fo:table-column column-width="160" />
																			<fo:table-column column-width="proportional-column-width(1)" />
																			<fo:table-body start-indent="0pt">
																				<fo:table-row>
																					<fo:table-cell font-family="Arial"
																						font-size="9pt" font-weight="bold" padding="2pt"
																						display-align="center">
																						<fo:block>
																							<fo:inline font-weight="bold">
																								<xsl:text>Non Competing Continuation:</xsl:text>
																							</fo:inline>
																						</fo:block>
																					</fo:table-cell>
																					<fo:table-cell font-family="Arial"
																						font-size="9pt" font-weight="normal" padding="2pt"
																						display-align="center">
																						<fo:block>
																							<fo:inline-container>
																								<fo:block>
																									<xsl:text>&#x2029;</xsl:text>
																								</fo:block>
																							</fo:inline-container>
																							<fo:block white-space="pre"
																								white-space-collapse="false" wrap-option="wrap"
																								white-space-treatment="ignore-if-surrounding-linefeed"
																								margin="0pt">
																								<fo:block>
																									<xsl:for-each select="AwardDetails">
																										<xsl:for-each select="OtherHeaderDetails">
																											<xsl:for-each select="NonCompetingContDesc">
																												<xsl:variable name="value-of-template">
																													<xsl:apply-templates />
																												</xsl:variable>
																												<xsl:choose>
																													<xsl:when
																														test="contains(string($value-of-template),'&#x2029;')">
																														<fo:block>
																															<xsl:copy-of select="$value-of-template" />
																														</fo:block>
																													</xsl:when>
																													<xsl:otherwise>
																														<fo:inline>
																															<xsl:copy-of select="$value-of-template" />
																														</fo:inline>
																													</xsl:otherwise>
																												</xsl:choose>
																											</xsl:for-each>
																										</xsl:for-each>
																									</xsl:for-each>
																								</fo:block>
																							</fo:block>
																						</fo:block>
																					</fo:table-cell>
																				</fo:table-row>
																			</fo:table-body>
																		</fo:table>
																	</xsl:if>
																	<xsl:if
																		test="string-length(  AwardDetails/OtherHeaderDetails/CompetingRenewalDesc  )  &gt; 0">
																		<fo:inline-container>
																			<fo:block>
																				<xsl:text>&#x2029;</xsl:text>
																			</fo:block>
																		</fo:inline-container>
																		<fo:table font-family="Arial" table-layout="fixed"
																			width="100%" border-spacing="2pt">
																			<fo:table-column column-width="160" />
																			<fo:table-column column-width="proportional-column-width(1)" />
																			<fo:table-body start-indent="0pt">
																				<fo:table-row>
																					<fo:table-cell font-family="Arial"
																						font-size="9pt" font-weight="bold" padding="2pt"
																						display-align="center">
																						<fo:block>
																							<fo:inline font-weight="bold">
																								<xsl:text>Competing Renewal:</xsl:text>
																							</fo:inline>
																						</fo:block>
																					</fo:table-cell>
																					<fo:table-cell font-family="Arial"
																						font-size="9pt" font-weight="normal" padding="2pt"
																						display-align="center">
																						<fo:block>
																							<fo:inline-container>
																								<fo:block>
																									<xsl:text>&#x2029;</xsl:text>
																								</fo:block>
																							</fo:inline-container>
																							<fo:block white-space="pre"
																								white-space-collapse="false" wrap-option="wrap"
																								white-space-treatment="ignore-if-surrounding-linefeed"
																								margin="0pt">
																								<fo:block>
																									<xsl:for-each select="AwardDetails">
																										<xsl:for-each select="OtherHeaderDetails">
																											<xsl:for-each select="CompetingRenewalDesc">
																												<xsl:variable name="value-of-template">
																													<xsl:apply-templates />
																												</xsl:variable>
																												<xsl:choose>
																													<xsl:when
																														test="contains(string($value-of-template),'&#x2029;')">
																														<fo:block>
																															<xsl:copy-of select="$value-of-template" />
																														</fo:block>
																													</xsl:when>
																													<xsl:otherwise>
																														<fo:inline>
																															<xsl:copy-of select="$value-of-template" />
																														</fo:inline>
																													</xsl:otherwise>
																												</xsl:choose>
																											</xsl:for-each>
																										</xsl:for-each>
																									</xsl:for-each>
																								</fo:block>
																							</fo:block>
																						</fo:block>
																					</fo:table-cell>
																				</fo:table-row>
																			</fo:table-body>
																		</fo:table>
																	</xsl:if>
																</xsl:if>
															</xsl:if>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:table table-layout="fixed" width="100%"
											border-spacing="2pt">
											<fo:table-column column-width="proportional-column-width(1)" />
											<fo:table-body start-indent="0pt">
												<fo:table-row>
													<fo:table-cell padding="2pt" display-align="center">
														<fo:block />
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>

										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:table table-layout="fixed" width="100%"
											border-spacing="2pt">
											<fo:table-column column-width="proportional-column-width(1)" />
											<fo:table-body start-indent="0pt">
												<fo:table-row>
													<fo:table-cell padding="2pt" display-align="center">
														<fo:block />
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>

										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:table table-layout="fixed" width="100%"
											border-spacing="2pt">
											<fo:table-column column-width="proportional-column-width(1)" />
											<fo:table-body start-indent="0pt">
												<fo:table-row>
													<fo:table-cell padding="2pt" display-align="center">
														<fo:block />
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
										<fo:block />

										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:table table-layout="fixed" width="100%"
											border-spacing="2pt">
											<fo:table-column column-width="proportional-column-width(1)" />
											<fo:table-body start-indent="0pt">
												<fo:table-row>
													<fo:table-cell padding="2pt" display-align="center">
														<fo:block />
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>

										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:table table-layout="fixed" width="100%"
											border-spacing="2pt">
											<fo:table-column column-width="731" />
											<fo:table-body start-indent="0pt">
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="12pt"
														font-weight="bold" padding="2pt" display-align="center">
														<fo:block>
															<xsl:if
																test="../PrintRequirement/ReportingRequired = 1 ">
																<fo:inline font-family="Arial" font-size="12pt"
																	font-weight="bold">
																	<xsl:text>Reporting:</xsl:text>
																</fo:inline>
																<xsl:if
																test="AwardReportingDetails/ReportDetails/ReportTermDetails/ReportClassCode  != 4">
																
																<xsl:for-each select="AwardReportingDetails">
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<xsl:if test="ReportDetails">
																		<fo:table table-layout="fixed" width="100%"
																			border-spacing="2pt">
																			<fo:table-column column-width="proportional-column-width(1)" />
																			<fo:table-body start-indent="0pt">
																				<xsl:for-each select="ReportDetails">
																					<fo:table-row>
																						<fo:table-cell font-family="Arial"
																							font-size="12pt" font-weight="bold" padding-top="10pt"
																							padding="2pt" display-align="center">
																							<fo:block>
																								<xsl:if test="ReportTermDetails/ReportClassCode != 4">
																									<xsl:for-each select="Description">
																										<xsl:variable name="value-of-template">
																											<xsl:apply-templates />
																										</xsl:variable>
																										<xsl:choose>
																											<xsl:when
																												test="contains(string($value-of-template),'&#x2029;')">
																												<fo:block font-family="Arial"
																													font-size="12pt" font-weight="bold">
																													<xsl:copy-of select="$value-of-template" />
																												</fo:block>
																											</xsl:when>
																											<xsl:otherwise>
																												<fo:inline font-family="Arial"
																													font-size="12pt" font-weight="bold">
																													<xsl:copy-of select="$value-of-template" />
																												</fo:inline>
																											</xsl:otherwise>
																										</xsl:choose>
																									</xsl:for-each>
																								</xsl:if>
																							</fo:block>
																						</fo:table-cell>
																					</fo:table-row>
																					<fo:table-row>
																						<fo:table-cell font-family="Arial"
																							font-size="12pt" font-weight="bold" padding="0"
																							height="1" display-align="center">
																							<fo:block>
																								<xsl:for-each select="ReportTermDetails">
																									<xsl:if test="ReportClassCode != 4">
																										<fo:inline-container>
																											<fo:block>
																												<xsl:text>&#x2029;</xsl:text>
																											</fo:block>
																										</fo:inline-container>
																										<fo:table table-layout="fixed" width="100%"
																											border-spacing="2pt">
																											<fo:table-column
																												column-width="160" />
																											<fo:table-column
																												column-width="proportional-column-width(1)" />
																											<fo:table-body start-indent="0pt">
																												<fo:table-row>
																													<fo:table-cell font-family="Arial"
																														font-size="9pt" font-weight="bold"
																														padding-bottom="1pt" padding="0pt"
																														display-align="center">
																														<fo:block>
																															<fo:inline>
																																<xsl:text>Type of Report: </xsl:text>
																															</fo:inline>
																														</fo:block>
																													</fo:table-cell>
																													<fo:table-cell font-family="Arial"
																														font-weight="normal" padding-bottom="1pt"
																														padding="0pt" display-align="center">
																														<fo:block>
																															<fo:inline-container>
																																<fo:block>
																																	<xsl:text>&#x2029;</xsl:text>
																																</fo:block>
																															</fo:inline-container>
																															<fo:block white-space="pre"
																																white-space-collapse="false"
																																wrap-option="wrap"
																																white-space-treatment="ignore-if-surrounding-linefeed"
																																margin="0pt">
																																<fo:block>
																																	<xsl:for-each select="ReportCodeDesc">
																																		<xsl:variable name="value-of-template">
																																			<xsl:apply-templates />
																																		</xsl:variable>
																																		<xsl:choose>
																																			<xsl:when
																																				test="contains(string($value-of-template),'&#x2029;')">
																																				<fo:block font-family="Arial"
																																					font-size="9pt" font-weight="normal">
																																					<xsl:copy-of select="$value-of-template" />
																																				</fo:block>
																																			</xsl:when>
																																			<xsl:otherwise>
																																				<fo:inline font-family="Arial"
																																					font-size="9pt" font-weight="normal">
																																					<xsl:copy-of select="$value-of-template" />
																																				</fo:inline>
																																			</xsl:otherwise>
																																		</xsl:choose>
																																	</xsl:for-each>
																																</fo:block>
																															</fo:block>
																														</fo:block>
																													</fo:table-cell>
																												</fo:table-row>
																												<fo:table-row>
																													<fo:table-cell font-family="Arial"
																														font-size="9pt" font-weight="bold"
																														padding-bottom="1pt" padding="0pt"
																														display-align="center">
																														<fo:block>
																															<fo:inline>
																																<xsl:text>Frequency:</xsl:text>
																															</fo:inline>
																														</fo:block>
																													</fo:table-cell>
																													<fo:table-cell font-family="Arial"
																														font-weight="normal" padding-bottom="1pt"
																														padding="0pt" display-align="center">
																														<fo:block>
																															<fo:inline-container>
																																<fo:block>
																																	<xsl:text>&#x2029;</xsl:text>
																																</fo:block>
																															</fo:inline-container>
																															<fo:block white-space="pre"
																																white-space-collapse="false"
																																wrap-option="wrap"
																																white-space-treatment="ignore-if-surrounding-linefeed"
																																margin="0pt">
																																<fo:block>
																																	<xsl:for-each select="FrequencyCodeDesc">
																																		<xsl:variable name="value-of-template">
																																			<xsl:apply-templates />
																																		</xsl:variable>
																																		<xsl:choose>
																																			<xsl:when
																																				test="contains(string($value-of-template),'&#x2029;')">
																																				<fo:block font-family="Arial"
																																					font-size="9pt" font-weight="normal">
																																					<xsl:copy-of select="$value-of-template" />
																																				</fo:block>
																																			</xsl:when>
																																			<xsl:otherwise>
																																				<fo:inline font-family="Arial"
																																					font-size="9pt" font-weight="normal">
																																					<xsl:copy-of select="$value-of-template" />
																																				</fo:inline>
																																			</xsl:otherwise>
																																		</xsl:choose>
																																	</xsl:for-each>
																																</fo:block>
																															</fo:block>
																														</fo:block>
																													</fo:table-cell>
																												</fo:table-row>
																												<fo:table-row>
																													<fo:table-cell font-family="Arial"
																														font-size="9pt" font-weight="bold"
																														padding-bottom="1pt" padding="0pt"
																														display-align="center">
																														<fo:block>
																															<fo:inline>
																																<xsl:text>Frequency Basis: </xsl:text>
																															</fo:inline>
																														</fo:block>
																													</fo:table-cell>
																													<fo:table-cell font-family="Arial"
																														font-weight="normal" padding-bottom="1pt"
																														padding="0pt" display-align="center">
																														<fo:block>
																															<fo:inline-container>
																																<fo:block>
																																	<xsl:text>&#x2029;</xsl:text>
																																</fo:block>
																															</fo:inline-container>
																															<fo:block white-space="pre"
																																white-space-collapse="false"
																																wrap-option="wrap"
																																white-space-treatment="ignore-if-surrounding-linefeed"
																																margin="0pt">
																																<fo:block>
																																	<xsl:for-each select="FrequencyBaseDesc">
																																		<xsl:variable name="value-of-template">
																																			<xsl:apply-templates />
																																		</xsl:variable>
																																		<xsl:choose>
																																			<xsl:when
																																				test="contains(string($value-of-template),'&#x2029;')">
																																				<fo:block font-family="Arial"
																																					font-size="9pt" font-weight="normal">
																																					<xsl:copy-of select="$value-of-template" />
																																				</fo:block>
																																			</xsl:when>
																																			<xsl:otherwise>
																																				<fo:inline font-family="Arial"
																																					font-size="9pt" font-weight="normal">
																																					<xsl:copy-of select="$value-of-template" />
																																				</fo:inline>
																																			</xsl:otherwise>
																																		</xsl:choose>
																																	</xsl:for-each>
																																</fo:block>
																															</fo:block>
																														</fo:block>
																													</fo:table-cell>
																												</fo:table-row>
																												<fo:table-row>
																													<fo:table-cell font-family="Arial"
																														font-size="9pt" font-weight="bold"
																														padding-bottom="1pt" padding="0pt"
																														display-align="center">
																														<fo:block>
																															<xsl:if
																																test="DueDate != &apos;1900-01-01+00:00&apos;">
																																<fo:inline>
																																	<xsl:text> Due Date:</xsl:text>
																																</fo:inline>
																															</xsl:if>
																														</fo:block>
																													</fo:table-cell>
																													<fo:table-cell font-family="Arial"
																														font-size="9pt" font-weight="normal"
																														padding-bottom="1pt" padding="0pt"
																														display-align="center">
																														<fo:block>
																															<xsl:if
																																test="DueDate != &apos;1900-01-01+00:00&apos;">
																																<xsl:for-each select="DueDate">
																																	<fo:inline font-family="Arial"
																																		font-size="9pt" font-weight="normal">
																																		<xsl:value-of
																																			select="format-number(number(substring(string(string(.)), 6, 2)), '00')" />
																																		<xsl:text>/</xsl:text>
																																		<xsl:value-of
																																			select="format-number(number(substring(string(string(.)), 9, 2)), '00')" />
																																		<xsl:text>/</xsl:text>
																																		<xsl:value-of
																																			select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')" />
																																	</fo:inline>
																																</xsl:for-each>
																															</xsl:if>
																														</fo:block>
																													</fo:table-cell>
																												</fo:table-row>
																												<fo:table-row>
																													<fo:table-cell font-family="Arial"
																														font-size="9pt" font-weight="bold"
																														padding-bottom="1pt" padding="0pt"
																														display-align="center">
																														<fo:block>
																															<fo:inline>
																																<xsl:text>OSP Distribution:</xsl:text>
																															</fo:inline>
																														</fo:block>
																													</fo:table-cell>
																													<fo:table-cell font-family="Arial"
																														font-weight="normal" padding-bottom="1pt"
																														padding="0pt" display-align="center">
																														<fo:block>
																															<xsl:for-each select="OSPDistributionDesc">
																																<xsl:variable name="value-of-template">
																																	<xsl:apply-templates />
																																</xsl:variable>
																																<xsl:choose>
																																	<xsl:when
																																		test="contains(string($value-of-template),'&#x2029;')">
																																		<fo:block font-family="Arial"
																																			font-size="9pt" font-weight="normal">
																																			<xsl:copy-of select="$value-of-template" />
																																		</fo:block>
																																	</xsl:when>
																																	<xsl:otherwise>
																																		<fo:inline font-family="Arial"
																																			font-size="9pt" font-weight="normal">
																																			<xsl:copy-of select="$value-of-template" />
																																		</fo:inline>
																																	</xsl:otherwise>
																																</xsl:choose>
																															</xsl:for-each>
																														</fo:block>
																													</fo:table-cell>
																												</fo:table-row>
																												<fo:table-row>
																													<fo:table-cell padding="0"
																														padding-bottom="0" padding-top="0"
																														number-columns-spanned="2" display-align="center">
																														<fo:block>
																															<xsl:if
																																test="MailCopies/NumberOfCopies != &quot;0&quot;">
																																<fo:inline-container>
																																	<fo:block>
																																		<xsl:text>&#x2029;</xsl:text>
																																	</fo:block>
																																</fo:inline-container>
																																<xsl:if test="MailCopies">
																																	<fo:table table-layout="fixed"
																																		width="100%" border-spacing="2pt">
																																		<fo:table-column
																																			column-width="proportional-column-width(1)" />
																																		<fo:table-column
																																			column-width="proportional-column-width(1)" />
																																		<fo:table-body
																																			start-indent="0pt">
																																			<xsl:for-each select="MailCopies">
																																				<fo:table-row
																																					padding-top="10pt">
																																					<fo:table-cell
																																						font-family="Arial" font-size="9pt"
																																						font-weight="normal" padding="0"
																																						padding-bottom="0"
																																						number-columns-spanned="2"
																																						display-align="center">
																																						<fo:block>
																																							<fo:inline-container>
																																								<fo:block>
																																									<xsl:text>&#x2029;</xsl:text>
																																								</fo:block>
																																							</fo:inline-container>
																																							<fo:block white-space="pre"
																																								white-space-collapse="false"
																																								wrap-option="wrap"
																																								white-space-treatment="ignore-if-surrounding-linefeed"
																																								margin="0pt">
																																								<fo:block>
																																									<fo:inline>
																																										<xsl:text>Mail </xsl:text>
																																									</fo:inline>
																																									<xsl:for-each
																																										select="NumberOfCopies">
																																										<xsl:variable
																																											name="value-of-template">
																																											<xsl:apply-templates />
																																										</xsl:variable>
																																										<xsl:choose>
																																											<xsl:when
																																												test="contains(string($value-of-template),'&#x2029;')">
																																												<fo:block>
																																													<xsl:copy-of
																																														select="$value-of-template" />
																																												</fo:block>
																																											</xsl:when>
																																											<xsl:otherwise>
																																												<fo:inline>
																																													<xsl:copy-of
																																														select="$value-of-template" />
																																												</fo:inline>
																																											</xsl:otherwise>
																																										</xsl:choose>
																																									</xsl:for-each>
																																									<fo:inline>
																																										<xsl:text>&#160;</xsl:text>
																																									</fo:inline>
																																									<xsl:choose>
																																										<xsl:when
																																											test="NumberOfCopies  &gt; 1">
																																											<fo:inline>
																																												<xsl:text>copies</xsl:text>
																																											</fo:inline>
																																										</xsl:when>
																																										<xsl:when
																																											test="NumberOfCopies &lt; 2">
																																											<fo:inline>
																																												<xsl:text>copy</xsl:text>
																																											</fo:inline>
																																										</xsl:when>
																																									</xsl:choose>
																																									<fo:inline>
																																										<xsl:text> to </xsl:text>
																																									</fo:inline>
																																									<xsl:for-each
																																										select="RolodexName">
																																										<xsl:variable
																																											name="value-of-template">
																																											<xsl:apply-templates />
																																										</xsl:variable>
																																										<xsl:choose>
																																											<xsl:when
																																												test="contains(string($value-of-template),'&#x2029;')">
																																												<fo:block>
																																													<xsl:copy-of
																																														select="$value-of-template" />
																																												</fo:block>
																																											</xsl:when>
																																											<xsl:otherwise>
																																												<fo:inline>
																																													<xsl:copy-of
																																														select="$value-of-template" />
																																												</fo:inline>
																																											</xsl:otherwise>
																																										</xsl:choose>
																																									</xsl:for-each>
																																									<xsl:for-each
																																										select="RolodexOrganization">
																																										<xsl:variable
																																											name="value-of-template">
																																											<xsl:apply-templates />
																																										</xsl:variable>
																																										<xsl:choose>
																																											<xsl:when
																																												test="contains(string($value-of-template),'&#x2029;')">
																																												<fo:block>
																																													<xsl:copy-of
																																														select="$value-of-template" />
																																												</fo:block>
																																											</xsl:when>
																																											<xsl:otherwise>
																																												<fo:inline>
																																													<xsl:copy-of
																																														select="$value-of-template" />
																																												</fo:inline>
																																											</xsl:otherwise>
																																										</xsl:choose>
																																									</xsl:for-each>
																																									<fo:inline>
																																										<xsl:text> (For complete address, see following address page Rolodex ID </xsl:text>
																																									</fo:inline>
																																									<xsl:for-each
																																										select="RolodexId">
																																										<xsl:variable
																																											name="value-of-template">
																																											<xsl:apply-templates />
																																										</xsl:variable>
																																										<xsl:choose>
																																											<xsl:when
																																												test="contains(string($value-of-template),'&#x2029;')">
																																												<fo:block>
																																													<xsl:copy-of
																																														select="$value-of-template" />
																																												</fo:block>
																																											</xsl:when>
																																											<xsl:otherwise>
																																												<fo:inline>
																																													<xsl:copy-of
																																														select="$value-of-template" />
																																												</fo:inline>
																																											</xsl:otherwise>
																																										</xsl:choose>
																																									</xsl:for-each>
																																									<fo:inline>
																																										<xsl:text>)</xsl:text>
																																									</fo:inline>
																																								</fo:block>
																																							</fo:block>
																																						</fo:block>
																																					</fo:table-cell>
																																				</fo:table-row>
																																			</xsl:for-each>
																																		</fo:table-body>
																																	</fo:table>
																																</xsl:if>
																															</xsl:if>
																														</fo:block>
																													</fo:table-cell>
																												</fo:table-row>
																											</fo:table-body>
																										</fo:table>
																									</xsl:if>
																								</xsl:for-each>
																							</fo:block>
																						</fo:table-cell>
																					</fo:table-row>
																				</xsl:for-each>
																			</fo:table-body>
																		</fo:table>
																	</xsl:if>
																</xsl:for-each>
															</xsl:if>
															</xsl:if>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
										<xsl:if test="../PrintRequirement/PaymentRequired = &quot;1&quot;">
											<fo:inline font-family="Arial" font-size="12pt"
												font-weight="bold">
												<xsl:text>Payment:</xsl:text>
											</fo:inline>											
											<xsl:for-each select="AwardDetails">											     
												<xsl:for-each select="OtherHeaderDetails">
													<fo:inline-container>
														<fo:block>
															<xsl:text>&#x2029;</xsl:text>
														</fo:block>
													</fo:inline-container>
													<fo:table table-layout="fixed" width="100%"
														border-spacing="2pt">
														<fo:table-column column-width="160" />
														<fo:table-column column-width="proportional-column-width(1)" />
														<fo:table-body start-indent="0pt">
															<fo:table-row>
																<fo:table-cell font-family="Arial"
																	font-size="9pt" font-weight="bold" padding="2pt"
																	display-align="before">
																	<fo:block>
																		<fo:inline font-size="9pt" font-weight="bold">
																			<xsl:text>Basis of Payment:</xsl:text>
																		</fo:inline>
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell font-family="Arial"
																	font-size="9pt" font-weight="normal" padding="2pt"
																	display-align="center">
																	<fo:block>
																		<xsl:for-each select="BasisPaymentDesc">
																			<xsl:variable name="value-of-template">
																				<xsl:apply-templates />
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when
																					test="contains(string($value-of-template),'&#x2029;')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template" />
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template" />
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</fo:block>
																</fo:table-cell>
															</fo:table-row>
															<fo:table-row>
																<fo:table-cell font-family="Arial"
																	font-size="9pt" font-weight="bold" padding="2pt"
																	display-align="before">
																	<fo:block>
																		<fo:inline font-size="9pt" font-weight="bold">
																			<xsl:text>Method of Payment:</xsl:text>
																		</fo:inline>
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell font-family="Arial"
																	font-size="9pt" font-weight="normal" padding="2pt"
																	display-align="center">
																	<fo:block>
																		<xsl:for-each select="PaymentMethodDesc">
																			<xsl:variable name="value-of-template">
																				<xsl:apply-templates />
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when
																					test="contains(string($value-of-template),'&#x2029;')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template" />
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template" />
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</fo:block>
																</fo:table-cell>
															</fo:table-row>
														</fo:table-body>
													</fo:table>
													<xsl:if test="string-length(  PaymentFreqDesc  )  &gt; 0">
														<fo:inline-container>
															<fo:block>
																<xsl:text>&#x2029;</xsl:text>
															</fo:block>
														</fo:inline-container>
														<fo:table table-layout="fixed" width="100%"
															border-spacing="2pt">
															<fo:table-column column-width="160" />
															<fo:table-column column-width="proportional-column-width(1)" />
															<fo:table-body start-indent="0pt">
																<fo:table-row>
																	<fo:table-cell font-family="Arial"
																		font-size="9pt" font-weight="bold" padding="2pt"
																		display-align="before">
																		<fo:block>
																			<fo:inline font-size="9pt" font-weight="bold">
																				<xsl:text>Payment/Invoice Frequency:</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell font-family="Arial"
																		font-size="9pt" font-weight="normal" padding="2pt"
																		display-align="center">
																		<fo:block>
																			<fo:inline-container>
																				<fo:block>
																					<xsl:text>&#x2029;</xsl:text>
																				</fo:block>
																			</fo:inline-container>
																			<fo:block white-space="pre"
																				white-space-collapse="false" wrap-option="wrap"
																				white-space-treatment="ignore-if-surrounding-linefeed"
																				margin="0pt">
																				<fo:block>
																					<xsl:for-each select="PaymentFreqDesc">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates />
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when
																								test="contains(string($value-of-template),'&#x2029;')">
																								<fo:block>
																									<xsl:copy-of select="$value-of-template" />
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline>
																									<xsl:copy-of select="$value-of-template" />
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:for-each>
																				</fo:block>
																			</fo:block>
																		</fo:block>
																	</fo:table-cell>
																</fo:table-row>
															</fo:table-body>
														</fo:table>
													</xsl:if>
													<fo:block />
													<xsl:if test="InvoiceCopies &gt; 0">
														<fo:inline-container>
															<fo:block>
																<xsl:text>&#x2029;</xsl:text>
															</fo:block>
														</fo:inline-container>
														<fo:table table-layout="fixed" width="100%"
															border-spacing="2pt">
															<fo:table-column column-width="160" />
															<fo:table-column column-width="proportional-column-width(1)" />
															<fo:table-body start-indent="0pt">
																<fo:table-row>
																	<fo:table-cell font-family="Arial"
																		font-size="9pt" font-weight="bold" padding="2pt"
																		height="21" display-align="before">
																		<fo:block>
																			<fo:inline font-size="9pt" font-weight="bold">
																				<xsl:text>Number of Copies:</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell font-family="Arial"
																		font-size="9pt" font-weight="normal" padding="2pt"
																		height="21" display-align="center">
																		<fo:block>
																			<xsl:for-each select="InvoiceCopies">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates />
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when
																						test="contains(string($value-of-template),'&#x2029;')">
																						<fo:block>
																							<xsl:copy-of select="$value-of-template" />
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline>
																							<xsl:copy-of select="$value-of-template" />
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																		</fo:block>
																	</fo:table-cell>
																</fo:table-row>
															</fo:table-body>
														</fo:table>
													</xsl:if>
													<fo:block />
													<xsl:if test="FinalInvoiceDue &gt;0">
														<fo:inline-container>
															<fo:block>
																<xsl:text>&#x2029;</xsl:text>
															</fo:block>
														</fo:inline-container>
														<fo:table table-layout="fixed" width="100%"
															border-spacing="2pt">
															<fo:table-column column-width="proportional-column-width(1)" />
															<fo:table-body start-indent="0pt">
																<fo:table-row>
																	<fo:table-cell font-family="Arial"
																		font-size="9pt" font-weight="bold" padding="2pt"
																		display-align="center">
																		<fo:block>
																			<fo:inline font-size="9pt" font-weight="bold">
																				<xsl:text>Final due within </xsl:text>
																			</fo:inline>
																			<xsl:for-each select="FinalInvoiceDue">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates />
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when
																						test="contains(string($value-of-template),'&#x2029;')">
																						<fo:block font-size="10pt" font-weight="bold">
																							<xsl:copy-of select="$value-of-template" />
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline font-size="10pt" font-weight="bold">
																							<xsl:copy-of select="$value-of-template" />
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																			<fo:inline font-size="10pt" font-weight="bold">
																				<xsl:text> days of expiration</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:table-cell>
																</fo:table-row>
															</fo:table-body>
														</fo:table>
													</xsl:if>
													<fo:block />
													<xsl:if test="string-length( InvoiceInstructions )  &gt; 0">
														<fo:inline-container>
															<fo:block>
																<xsl:text>&#x2029;</xsl:text>
															</fo:block>
														</fo:inline-container>
														<fo:table table-layout="fixed" width="100%"
															border-spacing="2pt">
															<fo:table-column column-width="160" />
															<fo:table-column column-width="proportional-column-width(1)" />
															<fo:table-body start-indent="0pt">
																<fo:table-row>
																	<fo:table-cell font-family="Arial"
																		font-size="9pt" font-weight="bold" padding="2pt"
																		display-align="before">
																		<fo:block>
																			<fo:inline font-size="9pt" font-weight="bold">
																				<xsl:text>Special Invoice Instructions:</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell font-family="Arial"
																		font-size="9pt" font-weight="normal" padding="2pt"
																		text-align="left" display-align="before">
																		<fo:block>
																			<xsl:for-each select="InvoiceInstructions">
																				<fo:inline-container>
																					<fo:block>
																						<xsl:text>&#x2029;</xsl:text>
																					</fo:block>
																				</fo:inline-container>
																				<fo:block white-space="pre"
																					white-space-collapse="false" wrap-option="wrap"
																					white-space-treatment="ignore-if-surrounding-linefeed"
																					margin="0pt">
																					<fo:block>
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates />
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when
																								test="contains(string($value-of-template),'&#x2029;')">
																								<fo:block>
																									<xsl:copy-of select="$value-of-template" />
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline>
																									<xsl:copy-of select="$value-of-template" />
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</fo:block>
																				</fo:block>
																			</xsl:for-each>
																		</fo:block>
																	</fo:table-cell>
																</fo:table-row>
															</fo:table-body>
														</fo:table>
													</xsl:if>
												</xsl:for-each>
											</xsl:for-each>																				
										<xsl:for-each select="AwardReportingDetails">
													<xsl:for-each select="ReportDetails">
														<xsl:for-each select="ReportTermDetails">
															<xsl:if test="ReportClassCode = 6">
																<fo:inline-container>
																	<fo:block>
																		<xsl:text>&#x2029;</xsl:text>
																	</fo:block>
																</fo:inline-container>
																<fo:table font-family="Arial" padding-top="10pt"
																	table-layout="fixed" width="100%" border-spacing="2pt">
																	<fo:table-column column-width="160" />
																	<fo:table-column column-width="proportional-column-width(1)" />
																	<fo:table-body start-indent="0pt">
																		<fo:table-row>
																			<fo:table-cell font-family="Arial"
																				font-size="9pt" font-weight="bold" padding-bottom="1pt"
																				padding="0pt" display-align="center">
																				<fo:block>
																					<fo:block />
																					<fo:inline font-family="Arial">
																						<xsl:text>Type of Report: </xsl:text>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell font-family="Arial"
																				font-size="9pt" font-weight="normal" padding-bottom="1pt"
																				padding="0pt" text-align="left" display-align="center">
																				<fo:block>
																					<fo:inline-container>
																						<fo:block>
																							<xsl:text>&#x2029;</xsl:text>
																						</fo:block>
																					</fo:inline-container>
																					<fo:block white-space="pre"
																						white-space-collapse="false" wrap-option="wrap"
																						white-space-treatment="ignore-if-surrounding-linefeed"
																						margin="0pt">
																						<fo:block>
																							<xsl:for-each select="ReportCodeDesc">
																								<xsl:variable name="value-of-template">
																									<xsl:apply-templates />
																								</xsl:variable>
																								<xsl:choose>
																									<xsl:when
																										test="contains(string($value-of-template),'&#x2029;')">
																										<fo:block>
																											<xsl:copy-of select="$value-of-template" />
																										</fo:block>
																									</xsl:when>
																									<xsl:otherwise>
																										<fo:inline>
																											<xsl:copy-of select="$value-of-template" />
																										</fo:inline>
																									</xsl:otherwise>
																								</xsl:choose>
																							</xsl:for-each>
																						</fo:block>
																					</fo:block>
																				</fo:block>
																			</fo:table-cell>
																		</fo:table-row>
																		<fo:table-row>
																			<fo:table-cell font-family="Arial"
																				font-size="9pt" font-weight="bold" padding-bottom="1pt"
																				padding="0pt" display-align="center">
																				<fo:block>
																					<fo:block />
																					<fo:inline>
																						<xsl:text>Frequency:</xsl:text>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell font-family="Arial"
																				font-size="9pt" font-weight="normal" padding-bottom="1pt"
																				padding="0pt" text-align="left" display-align="center">
																				<fo:block>
																					<fo:inline-container>
																						<fo:block>
																							<xsl:text>&#x2029;</xsl:text>
																						</fo:block>
																					</fo:inline-container>
																					<fo:block white-space="pre"
																						white-space-collapse="false" wrap-option="wrap"
																						white-space-treatment="ignore-if-surrounding-linefeed"
																						margin="0pt">
																						<fo:block>
																							<xsl:for-each select="FrequencyCodeDesc">
																								<xsl:variable name="value-of-template">
																									<xsl:apply-templates />
																								</xsl:variable>
																								<xsl:choose>
																									<xsl:when
																										test="contains(string($value-of-template),'&#x2029;')">
																										<fo:block>
																											<xsl:copy-of select="$value-of-template" />
																										</fo:block>
																									</xsl:when>
																									<xsl:otherwise>
																										<fo:inline>
																											<xsl:copy-of select="$value-of-template" />
																										</fo:inline>
																									</xsl:otherwise>
																								</xsl:choose>
																							</xsl:for-each>
																						</fo:block>
																					</fo:block>
																				</fo:block>
																			</fo:table-cell>
																		</fo:table-row>
																		<fo:table-row>
																			<fo:table-cell font-family="Arial"
																				font-size="9pt" font-weight="bold" padding-bottom="1pt"
																				padding="0pt" display-align="center">
																				<fo:block>
																					<fo:block />
																					<fo:inline>
																						<xsl:text>Frequency Basis</xsl:text>
																					</fo:inline>
																					<fo:inline padding-top="10pt">
																						<xsl:text>: </xsl:text>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell font-family="Arial"
																				font-size="9pt" font-weight="normal" padding-bottom="1pt"
																				padding="0pt" text-align="left" display-align="center">
																				<fo:block>
																					<fo:inline-container>
																						<fo:block>
																							<xsl:text>&#x2029;</xsl:text>
																						</fo:block>
																					</fo:inline-container>
																					<fo:block white-space="pre"
																						white-space-collapse="false" wrap-option="wrap"
																						white-space-treatment="ignore-if-surrounding-linefeed"
																						margin="0pt">
																						<fo:block>
																							<xsl:for-each select="FrequencyBaseDesc">
																								<xsl:variable name="value-of-template">
																									<xsl:apply-templates />
																								</xsl:variable>
																								<xsl:choose>
																									<xsl:when
																										test="contains(string($value-of-template),'&#x2029;')">
																										<fo:block>
																											<xsl:copy-of select="$value-of-template" />
																										</fo:block>
																									</xsl:when>
																									<xsl:otherwise>
																										<fo:inline>
																											<xsl:copy-of select="$value-of-template" />
																										</fo:inline>
																									</xsl:otherwise>
																								</xsl:choose>
																							</xsl:for-each>
																						</fo:block>
																					</fo:block>
																				</fo:block>
																			</fo:table-cell>
																		</fo:table-row>
																		<fo:table-row>
																			<fo:table-cell font-family="Arial"
																				font-size="9pt" font-weight="bold" padding-bottom="1pt"
																				padding="0pt" display-align="center">
																				<fo:block>
																					<fo:block />
																					<xsl:if test="DueDate != &apos;1900-01-01+00:00&apos;">
																						<fo:inline>
																							<xsl:text> Due Date:</xsl:text>
																						</fo:inline>
																					</xsl:if>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell font-family="Arial"
																				font-size="9pt" font-weight="normal" padding-bottom="1pt"
																				padding="0pt" text-align="left" display-align="center">
																				<fo:block>
																					<xsl:if test="DueDate != &apos;1900-01-01+00:00&apos;">
																						<xsl:for-each select="DueDate">
																							<fo:inline>
																								<xsl:value-of
																									select="format-number(number(substring(string(string(.)), 6, 2)), '00')" />
																								<xsl:text>/</xsl:text>
																								<xsl:value-of
																									select="format-number(number(substring(string(string(.)), 9, 2)), '00')" />
																								<xsl:text>/</xsl:text>
																								<xsl:value-of
																									select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')" />
																							</fo:inline>
																						</xsl:for-each>
																					</xsl:if>
																				</fo:block>
																			</fo:table-cell>
																		</fo:table-row>
																		<fo:table-row>
																			<fo:table-cell font-family="Arial"
																				font-size="9pt" font-weight="bold" padding-bottom="1pt"
																				padding="0pt" display-align="center">
																				<fo:block>
																					<fo:block />
																					<fo:inline padding-top="10pt">
																						<xsl:text>OSP Distribution:</xsl:text>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell font-family="Arial"
																				font-size="9pt" font-weight="normal" padding-bottom="1pt"
																				padding="0pt" text-align="left" display-align="center">
																				<fo:block>
																					<fo:inline-container>
																						<fo:block>
																							<xsl:text>&#x2029;</xsl:text>
																						</fo:block>
																					</fo:inline-container>
																					<fo:block white-space="pre"
																						white-space-collapse="false" wrap-option="wrap"
																						white-space-treatment="ignore-if-surrounding-linefeed"
																						margin="0pt">
																						<fo:block>
																							<xsl:for-each select="OSPDistributionDesc">
																								<xsl:variable name="value-of-template">
																									<xsl:apply-templates />
																								</xsl:variable>
																								<xsl:choose>
																									<xsl:when
																										test="contains(string($value-of-template),'&#x2029;')">
																										<fo:block>
																											<xsl:copy-of select="$value-of-template" />
																										</fo:block>
																									</xsl:when>
																									<xsl:otherwise>
																										<fo:inline>
																											<xsl:copy-of select="$value-of-template" />
																										</fo:inline>
																									</xsl:otherwise>
																								</xsl:choose>
																							</xsl:for-each>
																						</fo:block>
																					</fo:block>
																				</fo:block>
																			</fo:table-cell>
																		</fo:table-row>
																		<fo:table-row>
																			<fo:table-cell padding="0"
																				padding-bottom="0" padding-top="0"
																				number-columns-spanned="2" display-align="center">
																				<fo:block>
																					<xsl:if test="MailCopies/NumberOfCopies &gt;0">
																						<fo:inline-container>
																							<fo:block>
																								<xsl:text>&#x2029;</xsl:text>
																							</fo:block>
																						</fo:inline-container>
																						<xsl:if test="MailCopies">
																							<fo:table font-family="Arial"
																								table-layout="fixed" width="100%"
																								border-spacing="2pt">
																								<fo:table-column column-width="proportional-column-width(1)" />
																								<fo:table-column column-width="proportional-column-width(1)" />
																								<fo:table-body start-indent="0pt">
																									<xsl:for-each select="MailCopies">
																										<fo:table-row>
																											<fo:table-cell font-family="Arial"
																												font-size="9pt" font-weight="normal"
																												padding-bottom="0" number-columns-spanned="2"
																												padding="0" display-align="center">
																												<fo:block>
																													<fo:inline-container>
																														<fo:block>
																															<xsl:text>&#x2029;</xsl:text>
																														</fo:block>
																													</fo:inline-container>
																													<fo:block white-space="pre"
																														white-space-collapse="false" wrap-option="wrap"
																														white-space-treatment="ignore-if-surrounding-linefeed"
																														margin="0pt">
																														<fo:block>
																															<fo:inline>
																																<xsl:text>Mail </xsl:text>
																															</fo:inline>
																															<xsl:for-each select="NumberOfCopies">
																																<xsl:variable name="value-of-template">
																																	<xsl:apply-templates />
																																</xsl:variable>
																																<xsl:choose>
																																	<xsl:when
																																		test="contains(string($value-of-template),'&#x2029;')">
																																		<fo:block>
																																			<xsl:copy-of select="$value-of-template" />
																																		</fo:block>
																																	</xsl:when>
																																	<xsl:otherwise>
																																		<fo:inline>
																																			<xsl:copy-of select="$value-of-template" />
																																		</fo:inline>
																																	</xsl:otherwise>
																																</xsl:choose>
																															</xsl:for-each>
																															<fo:inline>
																																<xsl:text>&#160;</xsl:text>
																															</fo:inline>
																															<xsl:choose>
																																<xsl:when test="NumberOfCopies &gt; 1">
																																	<fo:inline>
																																		<xsl:text>copies</xsl:text>
																																	</fo:inline>
																																</xsl:when>
																																<xsl:when test="NumberOfCopies &lt;2">
																																	<fo:inline>
																																		<xsl:text>copy</xsl:text>
																																	</fo:inline>
																																</xsl:when>
																															</xsl:choose>
																															<fo:inline>
																																<xsl:text> to </xsl:text>
																															</fo:inline>
																															<xsl:for-each select="RolodexName">
																																<xsl:variable name="value-of-template">
																																	<xsl:apply-templates />
																																</xsl:variable>
																																<xsl:choose>
																																	<xsl:when
																																		test="contains(string($value-of-template),'&#x2029;')">
																																		<fo:block>
																																			<xsl:copy-of select="$value-of-template" />
																																		</fo:block>
																																	</xsl:when>
																																	<xsl:otherwise>
																																		<fo:inline>
																																			<xsl:copy-of select="$value-of-template" />
																																		</fo:inline>
																																	</xsl:otherwise>
																																</xsl:choose>
																															</xsl:for-each>
																															<fo:inline>
																																<xsl:text>&#160; </xsl:text>
																															</fo:inline>
																															<xsl:for-each select="RolodexOrganization">
																																<xsl:variable name="value-of-template">
																																	<xsl:apply-templates />
																																</xsl:variable>
																																<xsl:choose>
																																	<xsl:when
																																		test="contains(string($value-of-template),'&#x2029;')">
																																		<fo:block>
																																			<xsl:copy-of select="$value-of-template" />
																																		</fo:block>
																																	</xsl:when>
																																	<xsl:otherwise>
																																		<fo:inline>
																																			<xsl:copy-of select="$value-of-template" />
																																		</fo:inline>
																																	</xsl:otherwise>
																																</xsl:choose>
																															</xsl:for-each>
																															<fo:inline>
																																<xsl:text>&#160; (For complete address, see following address page Rolodex ID&#160; </xsl:text>
																															</fo:inline>
																															<xsl:for-each select="RolodexId">
																																<xsl:variable name="value-of-template">
																																	<xsl:apply-templates />
																																</xsl:variable>
																																<xsl:choose>
																																	<xsl:when
																																		test="contains(string($value-of-template),'&#x2029;')">
																																		<fo:block>
																																			<xsl:copy-of select="$value-of-template" />
																																		</fo:block>
																																	</xsl:when>
																																	<xsl:otherwise>
																																		<fo:inline>
																																			<xsl:copy-of select="$value-of-template" />
																																		</fo:inline>
																																	</xsl:otherwise>
																																</xsl:choose>
																															</xsl:for-each>
																															<fo:inline>
																																<xsl:text> )</xsl:text>
																															</fo:inline>
																														</fo:block>
																													</fo:block>
																												</fo:block>
																											</fo:table-cell>
																										</fo:table-row>
																									</xsl:for-each>
																								</fo:table-body>
																							</fo:table>
																						</xsl:if>
																					</xsl:if>
																				</fo:block>
																			</fo:table-cell>
																		</fo:table-row>
																	</fo:table-body>
																</fo:table>
															</xsl:if>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
										<xsl:if
											test="not (starts-with(  AwardDetails/PaymentScheduleIndicator  , &quot;N&quot;)) and count(  AwardPaymentSchedules/PaymentSchedule  )  &gt; 0">
											<fo:inline font-family="Arial" font-size="9pt"
												font-weight="bold">
												<xsl:text>Payment Schedule:</xsl:text>
											</fo:inline>
											<fo:block />
											<xsl:for-each select="AwardPaymentSchedules">
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<xsl:if test="PaymentSchedule">
													<fo:table table-layout="fixed" width="100%"
														border-spacing="2pt">
														<fo:table-column column-width="20" />
														<fo:table-column column-width="140" />
														<fo:table-column column-width="proportional-column-width(1)" />
														<fo:table-header start-indent="0pt">
															<fo:table-row font-family="Arial" font-size="9pt"
																font-weight="bold">
																<fo:table-cell padding="2pt"
																	display-align="center">
																	<fo:block />
																</fo:table-cell>
																<fo:table-cell padding="2pt"
																	display-align="center">
																	<fo:block>
																		<fo:inline font-weight="bold">
																			<xsl:text>Due Date</xsl:text>
																		</fo:inline>
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell padding="2pt"
																	display-align="center">
																	<fo:block>
																		<fo:inline font-weight="bold">
																			<xsl:text>Amount</xsl:text>
																		</fo:inline>
																	</fo:block>
																</fo:table-cell>																
															</fo:table-row>
														</fo:table-header>
														<fo:table-body start-indent="0pt">
															<xsl:for-each select="PaymentSchedule">
																<fo:table-row font-family="Arial"
																	font-size="9pt" font-weight="normal">
																	<fo:table-cell padding="2pt"
																		display-align="center">
																		<fo:block />
																	</fo:table-cell>
																	<fo:table-cell font-size="9pt" padding="2pt"
																		display-align="center">
																		<fo:block>
																			<xsl:for-each select="DueDate">
																				<fo:inline>
																					<xsl:value-of
																						select="format-number(number(substring(string(string(.)), 6, 2)), '00')" />
																					<xsl:text>/</xsl:text>
																					<xsl:value-of
																						select="format-number(number(substring(string(string(.)), 9, 2)), '00')" />
																					<xsl:text>/</xsl:text>
																					<xsl:value-of
																						select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')" />
																				</fo:inline>
																			</xsl:for-each>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell padding="2pt"
																		display-align="center">
																		<fo:block>
																			<xsl:for-each select="Amount">
																				<fo:inline>
																					<xsl:text>$</xsl:text>
																				</fo:inline>
																				<fo:inline>
																					<xsl:value-of
																						select="format-number(number(string(.)), '#,###,###,##0.00')" />
																				</fo:inline>
																			</xsl:for-each>
																		</fo:block>
																	</fo:table-cell>
																</fo:table-row>															   
															</xsl:for-each>
															    <fo:table-row>
															        <fo:table-cell>
																		<fo:block>
																			<fo:inline>
																				<xsl:text>&#160;</xsl:text>																				
																			</fo:inline>
																		</fo:block>
																	</fo:table-cell>
														        </fo:table-row>
														        <fo:table-row font-family="Arial" font-size="9pt" font-weight="normal">
																	<fo:table-cell padding="2pt" display-align="center">
																		<fo:block/>
																	</fo:table-cell>
																	<fo:table-cell font-size="9pt" padding="2pt" display-align="center">
																		<fo:block/>
																	</fo:table-cell>
																	<fo:table-cell font-size="9pt" padding="2pt" height="5" display-align="center">
																		<fo:block>
																			<fo:block text-align="left">
																				<fo:leader leader-pattern="rule" rule-thickness="1" leader-length="20%" color="black"/>
																			</fo:block>
																		</fo:block>
																	</fo:table-cell>
																</fo:table-row>														  
														        <fo:table-row font-family="Arial" font-size="9pt"
																       font-weight="bold">
																      <fo:table-cell padding="2pt"
																	      display-align="center">
																	      <fo:block />
																      </fo:table-cell>
																      <fo:table-cell padding="2pt"
																	      display-align="center">
																	     <fo:block>
																		    <fo:inline font-weight="bold">
																			    <xsl:text>Total:</xsl:text>
																		    </fo:inline>
																	     </fo:block>
																    </fo:table-cell>
																    <fo:table-cell padding="2pt"
																	display-align="center">
																	     <fo:block>
																		    <fo:inline font-weight="normal">
																				<xsl:text>$</xsl:text>
																		    </fo:inline>
																		    <fo:inline font-weight="normal">
																				<xsl:value-of
																						select="format-number(number(sum(//PaymentSchedule/Amount)), '#,###,###,##0.00')" />																					
																		    </fo:inline>
																	    </fo:block>
																   </fo:table-cell>																
															    </fo:table-row>
															    <fo:table-row font-family="Arial" font-size="9pt" font-weight="normal">
																	<fo:table-cell padding="2pt" display-align="center">
																		<fo:block/>
																	</fo:table-cell>
																	<fo:table-cell font-size="9pt" padding="2pt" display-align="center">
																		<fo:block/>
																	</fo:table-cell>
																	<fo:table-cell font-size="9pt" padding="2pt" height="5" display-align="center">
																		<fo:block>
																			<fo:block text-align="left">
																				<fo:leader leader-pattern="rule" rule-thickness="1" leader-length="20%" color="black"/>
																			</fo:block>
																		</fo:block>
																	</fo:table-cell>
																</fo:table-row>
													</fo:table-body>
												</fo:table>
											</xsl:if>
										</xsl:for-each>
									</xsl:if>
									</xsl:if>
										<xsl:if test="../PrintRequirement/PaymentRequired  = 1">
											<fo:inline-container>
												<fo:block>
													<xsl:text>&#x2029;</xsl:text>
												</fo:block>
											</fo:inline-container>
											<fo:table font-family="Arial" table-layout="fixed"
												width="100%" border-spacing="2pt">
												<fo:table-column column-width="160" />
												<fo:table-column column-width="proportional-column-width(1)" />
												<fo:table-body start-indent="0pt">
													<fo:table-row font-family="Arial" font-size="9pt">
														<fo:table-cell font-family="Arial"
															font-size="9pt" font-weight="bold" padding="2pt"
															display-align="center">
															<fo:block>
																<fo:inline font-size="9pt" font-weight="bold">
																	<xsl:text>Proposal Number:</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell font-family="Arial"
															font-size="9pt" font-weight="normal" padding="2pt"
															display-align="center">
															<fo:block>
																<xsl:for-each select="AwardFundingProposals">
																	<xsl:for-each select="FundingProposal">
																		<xsl:for-each select="ProposalNumber">
																			<xsl:variable name="value-of-template">
																				<xsl:apply-templates />
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when
																					test="contains(string($value-of-template),'&#x2029;')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template" />
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template" />
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																		<xsl:if test="position()  !=  last()">
																			<fo:inline font-size="9pt">
																				<xsl:text>,&#160;&#160;&#160; </xsl:text>
																			</fo:inline>
																		</xsl:if>
																	</xsl:for-each>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell font-family="Arial"
															font-size="9pt" font-weight="bold" padding="2pt"
															display-align="center">
															<fo:block>
																<fo:inline font-size="9pt" font-weight="bold">
																	<xsl:text>Document Funding ID:</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell font-family="Arial"
															font-size="9pt" font-weight="normal" padding="2pt"
															display-align="center">
															<fo:block>
																<xsl:for-each select="AwardDetails">
																	<xsl:for-each select="OtherHeaderDetails">
																		<xsl:for-each select="DFAFSNumber">
																			<xsl:variable name="value-of-template">
																				<xsl:apply-templates />
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when
																					test="contains(string($value-of-template),'&#x2029;')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template" />
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template" />
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell font-family="Arial"
															font-size="9pt" font-weight="bold" padding="2pt"
															display-align="center">
															<fo:block>
																<fo:inline font-size="9pt" font-weight="bold">
																	<xsl:text>CFDA Number:</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell font-family="Arial"
															font-size="9pt" font-weight="normal" padding="2pt"
															display-align="center">
															<fo:block>
																<xsl:for-each select="AwardDetails">
																	<xsl:for-each select="OtherHeaderDetails">
																		<xsl:for-each select="CFDANumber">
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<fo:block white-space="pre"
																		white-space-collapse="false" wrap-option="wrap"
																		white-space-treatment="ignore-if-surrounding-linefeed"
																		margin="0pt">
																		<fo:block>
																			<xsl:variable name="value-of-template">
																				<xsl:apply-templates />
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when
																					test="contains(string($value-of-template),'&#x2029;')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template" />
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template" />
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</fo:block>
																	</fo:block>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell font-family="Arial"
															font-size="9pt" font-weight="bold" padding="2pt"
															display-align="center">
															<fo:block>
																<fo:inline font-size="9pt" font-weight="bold">
																	<xsl:text>Procurement Priority Code:</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell font-family="Arial"
															font-size="9pt" font-weight="normal" padding="2pt"
															display-align="center">
															<fo:block>
																<xsl:for-each select="AwardDetails">
																	<xsl:for-each select="OtherHeaderDetails">
																		<xsl:for-each select="ProcurementPriorityCode">
																			<xsl:variable name="value-of-template">
																				<xsl:apply-templates />
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when
																					test="contains(string($value-of-template),'&#x2029;')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template" />
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template" />
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell font-family="Arial"
															font-size="9pt" font-weight="bold" padding="2pt"
															display-align="center">
															<fo:block>
																<fo:inline font-size="9pt" font-weight="bold">
																	<xsl:text>Small Business Subcontracting Plan:</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell font-family="Arial"
															font-size="9pt" font-weight="normal" padding="2pt"
															display-align="center">
															<fo:block>
																<xsl:for-each select="AwardDetails">
																	<xsl:for-each select="OtherHeaderDetails">
																		<xsl:for-each select="SubPlan">
																			<xsl:choose>
																				<xsl:when test=". = &apos;y&apos; or . = &apos;Y&apos;">
																					<fo:inline font-family="Arial" font-size="9pt">
																						<xsl:text>Yes</xsl:text>
																					</fo:inline>
																				</xsl:when>
																				<xsl:when test=". = &apos;n&apos; or . = &apos;N&apos;">
																					<fo:inline font-family="Arial" font-size="9pt">
																						<xsl:text>No</xsl:text>
																					</fo:inline>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline font-family="Arial" font-size="9pt">
																						<xsl:text>Unknown</xsl:text>
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell font-family="Arial"
															font-size="9pt" font-weight="bold" padding="2pt"
															display-align="center">
															<fo:block>
																<fo:inline font-size="9pt" font-weight="bold">
																	<xsl:text>Award Last Update User:</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell font-family="Arial"
															font-size="9pt" font-weight="normal" padding="2pt"
															display-align="center">
															<fo:block>
																<xsl:for-each select="AwardDetails">
																	<xsl:for-each select="OtherHeaderDetails">
																		<xsl:for-each select="UpdateUser">
																			<xsl:variable name="value-of-template">
																				<xsl:apply-templates />
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when
																					test="contains(string($value-of-template),'&#x2029;')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template" />
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template" />
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell font-family="Arial"
															font-size="9pt" font-weight="bold" padding="2pt"
															display-align="center">
															<fo:block>
																<fo:inline font-size="9pt" font-weight="bold">
																	<xsl:text>Award Last Update:</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell font-family="Arial"
															font-size="9pt" font-weight="normal" padding="2pt"
															display-align="center">
															<fo:block>
																<xsl:for-each select="AwardDetails">
																	<xsl:for-each select="OtherHeaderDetails">
																		<xsl:for-each select="LastUpdate">
																			<fo:inline>
																				<xsl:value-of
																					select="format-number(number(substring(string(string(.)), 6, 2)), '00')" />
																				<xsl:text>/</xsl:text>
																				<xsl:value-of
																					select="format-number(number(substring(string(string(.)), 9, 2)), '00')" />
																				<xsl:text>/</xsl:text>
																				<xsl:value-of
																					select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')" />
																				<xsl:text> </xsl:text>
																				<xsl:value-of
																					select="format-number(number(substring(string(string(.)), 12, 2)), '00')" />
																				<xsl:text>:</xsl:text>
																				<xsl:value-of
																					select="format-number(number(substring(string(string(.)), 15, 2)), '00')" />
																				<xsl:text>:</xsl:text>
																				<xsl:choose>
																					<xsl:when test="contains(string(string(.)), 'Z')">
																						<xsl:value-of
																							select="format-number(number(substring-after(substring-after(substring-before(string(string(.)), 'Z'), ':'), ':')), '00')" />
																					</xsl:when>
																					<xsl:when test="contains(string(string(.)), '+')">
																						<xsl:value-of
																							select="format-number(number(substring-after(substring-after(substring-before(string(string(.)), '+'), ':'), ':')), '00')" />
																					</xsl:when>
																					<xsl:when
																						test="contains(substring(string(string(.)), 18), '-')">
																						<xsl:value-of
																							select="format-number(number(substring-before(substring(string(string(.)), 18), '-')), '00')" />
																					</xsl:when>
																					<xsl:otherwise>
																						<xsl:value-of
																							select="format-number(number(substring(string(string(.)), 18)), '00')" />
																					</xsl:otherwise>
																				</xsl:choose>
																				<xsl:text> </xsl:text>
																				<xsl:text />
																			</fo:inline>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</fo:table-body>
											</fo:table>
										</xsl:if>
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:table table-layout="fixed" width="100%"
											border-spacing="2pt">
											<fo:table-column column-width="proportional-column-width(1)" />
											<fo:table-body start-indent="0pt">
												<fo:table-row>
													<fo:table-cell padding="2pt" display-align="center">
														<fo:block />
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
										<fo:block />
										<xsl:if
											test="../PrintRequirement/CloseoutRequired = &quot;1&quot;">
											<fo:inline-container>
												<fo:block>
													<xsl:text>&#x2029;</xsl:text>
												</fo:block>
											</fo:inline-container>
											<fo:inline font-family="Arial" font-size="12pt"
												font-weight="bold">
												<xsl:text>Close-Out:</xsl:text>
											</fo:inline>
											<fo:inline-container>
												<fo:block>
													<xsl:text>&#x2029;</xsl:text>
												</fo:block>
											</fo:inline-container>
											<fo:table table-layout="fixed" width="100%"
												border-spacing="2pt">
												<fo:table-column column-width="160" />
												<fo:table-column column-width="70" />
												<fo:table-column column-width="proportional-column-width(1)" />
												<fo:table-column column-width="proportional-column-width(1)" />
												<fo:table-body start-indent="0pt">
												<fo:table-row>
														<fo:table-cell font-family="Arial"
															font-size="9pt" font-weight="bold" padding="2pt"
															display-align="center">
															<fo:block>
															<xsl:for-each select="AwardCloseOutDeadlines">
															<xsl:for-each select="ArchiveLocation">
																<fo:inline>
																	<xsl:text>Archive Location:</xsl:text>
																</fo:inline>
																</xsl:for-each>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
															<fo:table-cell font-family="Arial" font-size="9pt"
																font-weight="normal" padding="2pt" display-align="center">
																<fo:block>
																<xsl:for-each select="AwardCloseOutDeadlines">
																	<xsl:for-each select="ArchiveLocation">
																		<fo:inline>
																			<xsl:variable name="value-of-template">
																				<xsl:apply-templates />
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template" />
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template" />
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</fo:inline>
																	</xsl:for-each>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell font-family="Arial"
															font-size="9pt" font-weight="bold" padding="2pt"
															display-align="center">
															<fo:block>
															<xsl:for-each select="AwardCloseOutDeadlines">
															<xsl:for-each select="ArchiveDate">
																<fo:inline>
																	<xsl:text>Archive Date:</xsl:text>
																</fo:inline>
															</xsl:for-each>
															</xsl:for-each>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell font-family="Arial" font-size="9pt"
																font-weight="normal" padding="2pt" display-align="center">
															<fo:block>
															<xsl:for-each select="AwardCloseOutDeadlines">
															<xsl:for-each select="ArchiveDate">
																<fo:inline>
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates />
																	</xsl:variable>
															 <xsl:choose>
															<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																<fo:block>
																	<fo:inline>
																		<xsl:value-of
																			select="format-number(number(substring(string(string(.)), 6, 2)), '00')" />
																		<xsl:text>/</xsl:text>
																		<xsl:value-of
																			select="format-number(number(substring(string(string(.)), 9, 2)), '00')" />
																		<xsl:text>/</xsl:text>
																		<xsl:value-of
																			select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')" />
																	</fo:inline>
																</fo:block>
															</xsl:when>
															<xsl:otherwise>
																<fo:inline>
																	<fo:inline>
																		<xsl:value-of
																			select="format-number(number(substring(string(string(.)), 6, 2)), '00')" />
																		<xsl:text>/</xsl:text>
																		<xsl:value-of
																			select="format-number(number(substring(string(string(.)), 9, 2)), '00')" />
																		<xsl:text>/</xsl:text>
																		<xsl:value-of
																			select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')" />
																	</fo:inline>
																</fo:inline>
															</xsl:otherwise>
														</xsl:choose>
														</fo:inline>
														</xsl:for-each>
														</xsl:for-each>
															</fo:block>
														</fo:table-cell>
												</fo:table-row>
													<fo:table-row>
														<fo:table-cell font-family="Arial"
															font-size="9pt" font-weight="bold" padding="2pt"
															display-align="center">
															<fo:block>
																<fo:inline>
																	<xsl:text>Final Report</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell font-family="Arial"
															font-size="9pt" font-weight="bold" padding="2pt"
															display-align="center">
															<fo:block>
																<fo:inline>
																	<xsl:text>Due Date</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell font-family="Arial"
															font-size="9pt" font-weight="bold" padding="2pt"
															display-align="center">
															<fo:block>
																<fo:inline>
																	<xsl:text>Submission Date</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<xsl:for-each select="AwardCloseOutDeadlines">
														<xsl:for-each select="CloseOutDeadlines">
														<fo:table-row>	
														<fo:table-cell font-family="Arial" font-size="9pt"
																font-weight="normal" padding="2pt" display-align="center">
															<fo:block>
															<xsl:for-each select="FinalReportType">
																<xsl:variable name="value-of-template">
																	<xsl:apply-templates />
																</xsl:variable>
																<xsl:choose>
																	<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																		<fo:block>
																			<xsl:copy-of select="$value-of-template" />
																		</fo:block>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:inline>
																			<xsl:copy-of select="$value-of-template" />
																		</fo:inline>
																	</xsl:otherwise>
																</xsl:choose>
															</xsl:for-each>
															</fo:block>
														</fo:table-cell>														
														<fo:table-cell font-family="Arial" font-size="9pt"
																font-weight="normal" padding="2pt" display-align="center">
															<fo:block>
														<xsl:for-each select="FinalDueDate">
																<xsl:variable name="value-of-template">
																	<xsl:apply-templates />
																</xsl:variable>
																<xsl:choose>
																	<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																		<fo:block>
																			<fo:inline>
																		<xsl:value-of
																			select="format-number(number(substring(string(string(.)), 6, 2)), '00')" />
																		<xsl:text>/</xsl:text>
																		<xsl:value-of
																			select="format-number(number(substring(string(string(.)), 9, 2)), '00')" />
																		<xsl:text>/</xsl:text>
																		<xsl:value-of
																			select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')" />
																	</fo:inline>
																		</fo:block>
																	</xsl:when>
																	<xsl:otherwise>																		
																			<fo:inline>
																		<xsl:value-of
																			select="format-number(number(substring(string(string(.)), 6, 2)), '00')" />
																		<xsl:text>/</xsl:text>
																		<xsl:value-of
																			select="format-number(number(substring(string(string(.)), 9, 2)), '00')" />
																		<xsl:text>/</xsl:text>
																		<xsl:value-of
																			select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')" />
																	</fo:inline>																		
																	</xsl:otherwise>
																</xsl:choose>
															</xsl:for-each>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell font-family="Arial" font-size="9pt"
																font-weight="normal" padding="2pt" display-align="center">
															<fo:block>
															<xsl:for-each select="FinalSubDate">
																<xsl:variable name="value-of-template">
																	<xsl:apply-templates />
																</xsl:variable>
																<xsl:choose>
																	<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																		<fo:block>
																		<fo:inline>
																		<xsl:value-of
																			select="format-number(number(substring(string(string(.)), 6, 2)), '00')" />
																		<xsl:text>/</xsl:text>
																		<xsl:value-of
																			select="format-number(number(substring(string(string(.)), 9, 2)), '00')" />
																		<xsl:text>/</xsl:text>
																		<xsl:value-of
																			select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')" />
																	</fo:inline>
																		</fo:block>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:inline>
																		<xsl:value-of
																			select="format-number(number(substring(string(string(.)), 6, 2)), '00')" />
																		<xsl:text>/</xsl:text>
																		<xsl:value-of
																			select="format-number(number(substring(string(string(.)), 9, 2)), '00')" />
																		<xsl:text>/</xsl:text>
																		<xsl:value-of
																			select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')" />
																	</fo:inline>
																	</xsl:otherwise>
																</xsl:choose>
															</xsl:for-each>
															</fo:block>
														</fo:table-cell>
														</fo:table-row>
														</xsl:for-each>
													</xsl:for-each>
													</fo:table-body>
											</fo:table>
										</xsl:if>
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:table table-layout="fixed" width="100%"
											border-spacing="2pt">
											<fo:table-column column-width="proportional-column-width(1)" />
											<fo:table-body start-indent="0pt">
												<fo:table-row>
													<fo:table-cell padding="2pt" display-align="center">
														<fo:block />
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
										<fo:block />

										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:table table-layout="fixed" width="100%"
											border-spacing="2pt">
											<fo:table-column column-width="proportional-column-width(1)" />
											<fo:table-body start-indent="0pt">
												<fo:table-row>
													<fo:table-cell padding="2pt" display-align="center">
														<fo:block />
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
										<fo:block />
										
										<xsl:if
											test="../PrintRequirement/AddressListRequired = 1 and    count(  AwardContacts/ContactDetails ) &gt; 0">
											<fo:inline-container>
												<fo:block>
													<xsl:text>&#x2029;</xsl:text>
												</fo:block>
											</fo:inline-container>
											<fo:table table-layout="fixed" width="100%"
												border-spacing="2pt">
												<fo:table-column column-width="proportional-column-width(1)" />
												<fo:table-body start-indent="0pt">
													<fo:table-row>
														<fo:table-cell padding="2pt" display-align="center">
															<fo:block />
														</fo:table-cell>
													</fo:table-row>
												</fo:table-body>
											</fo:table>
											<fo:block break-after="page">
												<fo:leader leader-pattern="space" />
											</fo:block>
											<fo:inline font-family="Arial" font-size="12pt"
												font-weight="bold">
												<xsl:text>Sponsor Contacts for Account</xsl:text>
											</fo:inline>
											<fo:inline font-size="12pt">
												<xsl:text>&#160;</xsl:text>
											</fo:inline>
											<xsl:for-each select="AwardDetails">
												<xsl:for-each select="AwardHeader">
													<xsl:for-each select="AccountNumber">
														<xsl:variable name="value-of-template">
															<xsl:apply-templates />
														</xsl:variable>
														<xsl:choose>
															<xsl:when
																test="contains(string($value-of-template),'&#x2029;')">
																<fo:block font-family="Arial" font-size="12pt">
																	<xsl:copy-of select="$value-of-template" />
																</fo:block>
															</xsl:when>
															<xsl:otherwise>
																<fo:inline font-family="Arial" font-size="12pt">
																	<xsl:copy-of select="$value-of-template" />
																</fo:inline>
															</xsl:otherwise>
														</xsl:choose>
													</xsl:for-each>
												</xsl:for-each>
											</xsl:for-each>
											<fo:block />
											<xsl:for-each select="AwardContacts">
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<xsl:if test="ContactDetails">
													<fo:table font-family="Arial" table-layout="fixed"
														width="100%" border-spacing="2pt">
														<fo:table-column column-width="132" />
														<fo:table-column column-width="80" />
														<fo:table-column column-width="proportional-column-width(1)" />
														<fo:table-column column-width="proportional-column-width(1)" />
														<fo:table-body start-indent="0pt">
															<xsl:for-each select="ContactDetails">
																<fo:table-row>
																	<fo:table-cell font-family="Arial"
																		font-size="9pt" font-weight="bold" padding="2pt"
																		text-align="right" display-align="before">
																		<fo:block>
																			<fo:inline font-weight="bold"
																				text-decoration="underline">
																				<xsl:text>Rolodex Id:</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell font-family="Arial"
																		font-size="9pt" font-weight="normal" padding="2pt"
																		display-align="before">
																		<fo:block>
																			<xsl:for-each select="RolodexDetails">
																				<xsl:for-each select="RolodexId">
																					<xsl:variable name="value-of-template">
																						<xsl:apply-templates />
																					</xsl:variable>
																					<xsl:choose>
																						<xsl:when
																							test="contains(string($value-of-template),'&#x2029;')">
																							<fo:block>
																								<xsl:copy-of select="$value-of-template" />
																							</fo:block>
																						</xsl:when>
																						<xsl:otherwise>
																							<fo:inline>
																								<xsl:copy-of select="$value-of-template" />
																							</fo:inline>
																						</xsl:otherwise>
																					</xsl:choose>
																				</xsl:for-each>
																			</xsl:for-each>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell number-columns-spanned="2"
																		padding="2pt" display-align="before">
																		<fo:block>
																			<fo:inline-container>
																				<fo:block>
																					<xsl:text>&#x2029;</xsl:text>
																				</fo:block>
																			</fo:inline-container>
																			<fo:block white-space="pre"
																				white-space-collapse="false" wrap-option="wrap"
																				white-space-treatment="ignore-if-surrounding-linefeed"
																				margin="0pt">
																				<fo:block>
																					<fo:inline font-family="Arial" font-size="9pt"
																						font-weight="bold" text-decoration="underline">
																						<xsl:text>Project Role:</xsl:text>
																					</fo:inline>
																					<xsl:for-each select="ContactTypeDesc">
																						<fo:inline>
																							<xsl:text>&#160;&#160; </xsl:text>
																						</fo:inline>
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates />
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when
																								test="contains(string($value-of-template),'&#x2029;')">
																								<fo:block font-family="Arial"
																									font-size="9pt" font-weight="normal">
																									<xsl:copy-of select="$value-of-template" />
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline font-family="Arial"
																									font-size="9pt" font-weight="normal">
																									<xsl:copy-of select="$value-of-template" />
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:for-each>
																				</fo:block>
																			</fo:block>
																		</fo:block>
																	</fo:table-cell>
																</fo:table-row>
																<fo:table-row>
																	<fo:table-cell padding="0" padding-top="1pt"
																		number-columns-spanned="4" display-align="center">
																		<fo:block>
																			<xsl:for-each select="RolodexDetails">
																				<fo:inline-container>
																					<fo:block>
																						<xsl:text>&#x2029;</xsl:text>
																					</fo:block>
																				</fo:inline-container>
																				<fo:table table-layout="fixed" width="100%"
																					border-spacing="2pt">
																					<fo:table-column column-width="130" />
																					<fo:table-column column-width="proportional-column-width(1)" />
																					<fo:table-column column-width="76" />
																					<fo:table-column column-width="proportional-column-width(1)" />
																					<fo:table-body start-indent="0pt">
																						<fo:table-row>
																							<fo:table-cell font-family="Arial"
																								font-size="9pt" font-weight="bold" padding-top="5pt"
																								padding="2pt" text-align="right" display-align="center">
																								<fo:block>
																									<fo:inline font-weight="bold">
																										<xsl:text>Name:</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell font-family="Arial"
																								font-size="9pt" font-weight="normal"
																								padding-top="5pt" number-columns-spanned="3"
																								padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:block white-space="pre"
																										white-space-collapse="false" wrap-option="wrap"
																										white-space-treatment="ignore-if-surrounding-linefeed"
																										margin="0pt">
																										<fo:block>
																											<xsl:for-each select="LastName">
																												<xsl:variable name="value-of-template">
																													<xsl:apply-templates />
																												</xsl:variable>
																												<xsl:choose>
																													<xsl:when
																														test="contains(string($value-of-template),'&#x2029;')">
																														<fo:block>
																															<xsl:copy-of select="$value-of-template" />
																														</fo:block>
																													</xsl:when>
																													<xsl:otherwise>
																														<fo:inline>
																															<xsl:copy-of select="$value-of-template" />
																														</fo:inline>
																													</xsl:otherwise>
																												</xsl:choose>
																											</xsl:for-each>
																										</fo:block>
																									</fo:block>
																									<fo:inline>
																										<xsl:text>&#160;&#160;&#160; </xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																						</fo:table-row>
																						<fo:table-row>
																							<fo:table-cell font-family="Arial"
																								font-size="9pt" font-weight="bold" padding="2pt"
																								text-align="right" display-align="center">
																								<fo:block>
																									<fo:inline font-weight="bold">
																										<xsl:text>Organization:</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell font-family="Arial"
																								font-size="9pt" font-weight="normal"
																								number-columns-spanned="3" padding="2pt"
																								display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:block white-space="pre"
																										white-space-collapse="false" wrap-option="wrap"
																										white-space-treatment="ignore-if-surrounding-linefeed"
																										margin="0pt">
																										<fo:block>
																											<xsl:for-each select="Organization">
																												<xsl:variable name="value-of-template">
																													<xsl:apply-templates />
																												</xsl:variable>
																												<xsl:choose>
																													<xsl:when
																														test="contains(string($value-of-template),'&#x2029;')">
																														<fo:block>
																															<xsl:copy-of select="$value-of-template" />
																														</fo:block>
																													</xsl:when>
																													<xsl:otherwise>
																														<fo:inline>
																															<xsl:copy-of select="$value-of-template" />
																														</fo:inline>
																													</xsl:otherwise>
																												</xsl:choose>
																											</xsl:for-each>
																										</fo:block>
																									</fo:block>
																								</fo:block>
																							</fo:table-cell>
																						</fo:table-row>
																						<fo:table-row>
																							<fo:table-cell font-family="Arial"
																								font-size="9pt" font-weight="bold" padding="2pt"
																								text-align="right" display-align="center">
																								<fo:block>
																									<fo:inline font-weight="bold">
																										<xsl:text>Address:</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell font-family="Arial"
																								font-size="9pt" font-weight="normal"
																								number-columns-spanned="3" padding="2pt"
																								display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:block white-space="pre"
																										white-space-collapse="false" wrap-option="wrap"
																										white-space-treatment="ignore-if-surrounding-linefeed"
																										margin="0pt">
																										<fo:block>
																											<xsl:for-each select="Address1">
																												<xsl:variable name="value-of-template">
																													<xsl:apply-templates />
																												</xsl:variable>
																												<xsl:choose>
																													<xsl:when
																														test="contains(string($value-of-template),'&#x2029;')">
																														<fo:block>
																															<xsl:copy-of select="$value-of-template" />
																														</fo:block>
																													</xsl:when>
																													<xsl:otherwise>
																														<fo:inline>
																															<xsl:copy-of select="$value-of-template" />
																														</fo:inline>
																													</xsl:otherwise>
																												</xsl:choose>
																											</xsl:for-each>
																										</fo:block>
																									</fo:block>
																								</fo:block>
																							</fo:table-cell>
																						</fo:table-row>
																						<fo:table-row>
																							<fo:table-cell font-family="Arial"
																								font-size="9pt" font-weight="bold" padding="2pt"
																								display-align="center">
																								<fo:block />
																							</fo:table-cell>
																							<fo:table-cell font-family="Arial"
																								font-size="9pt" font-weight="normal"
																								number-columns-spanned="3" padding="2pt"
																								display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:block white-space="pre"
																										white-space-collapse="false" wrap-option="wrap"
																										white-space-treatment="ignore-if-surrounding-linefeed"
																										margin="0pt">
																										<fo:block>
																											<xsl:for-each select="Address2">
																												<xsl:variable name="value-of-template">
																													<xsl:apply-templates />
																												</xsl:variable>
																												<xsl:choose>
																													<xsl:when
																														test="contains(string($value-of-template),'&#x2029;')">
																														<fo:block>
																															<xsl:copy-of select="$value-of-template" />
																														</fo:block>
																													</xsl:when>
																													<xsl:otherwise>
																														<fo:inline>
																															<xsl:copy-of select="$value-of-template" />
																														</fo:inline>
																													</xsl:otherwise>
																												</xsl:choose>
																											</xsl:for-each>
																										</fo:block>
																									</fo:block>
																								</fo:block>
																							</fo:table-cell>
																						</fo:table-row>
																						<fo:table-row>
																							<fo:table-cell font-family="Arial"
																								font-size="9pt" font-weight="bold" padding="2pt"
																								display-align="center">
																								<fo:block />
																							</fo:table-cell>
																							<fo:table-cell font-family="Arial"
																								font-size="9pt" font-weight="normal"
																								number-columns-spanned="3" padding="2pt"
																								display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:block white-space="pre"
																										white-space-collapse="false" wrap-option="wrap"
																										white-space-treatment="ignore-if-surrounding-linefeed"
																										margin="0pt">
																										<fo:block>
																											<xsl:for-each select="Address3">
																												<xsl:variable name="value-of-template">
																													<xsl:apply-templates />
																												</xsl:variable>
																												<xsl:choose>
																													<xsl:when
																														test="contains(string($value-of-template),'&#x2029;')">
																														<fo:block>
																															<xsl:copy-of select="$value-of-template" />
																														</fo:block>
																													</xsl:when>
																													<xsl:otherwise>
																														<fo:inline>
																															<xsl:copy-of select="$value-of-template" />
																														</fo:inline>
																													</xsl:otherwise>
																												</xsl:choose>
																											</xsl:for-each>
																										</fo:block>
																									</fo:block>
																								</fo:block>
																							</fo:table-cell>
																						</fo:table-row>
																						<fo:table-row>
																							<fo:table-cell font-family="Arial"
																								font-size="9pt" font-weight="bold" padding="2pt"
																								text-align="right" display-align="center">
																								<fo:block>
																									<fo:inline font-weight="bold">
																										<xsl:text>Title:</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell font-family="Arial"
																								font-size="9pt" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:block white-space="pre"
																										white-space-collapse="false" wrap-option="wrap"
																										white-space-treatment="ignore-if-surrounding-linefeed"
																										margin="0pt">
																										<fo:block>
																											<xsl:for-each select="Title">
																												<xsl:variable name="value-of-template">
																													<xsl:apply-templates />
																												</xsl:variable>
																												<xsl:choose>
																													<xsl:when
																														test="contains(string($value-of-template),'&#x2029;')">
																														<fo:block>
																															<xsl:copy-of select="$value-of-template" />
																														</fo:block>
																													</xsl:when>
																													<xsl:otherwise>
																														<fo:inline>
																															<xsl:copy-of select="$value-of-template" />
																														</fo:inline>
																													</xsl:otherwise>
																												</xsl:choose>
																											</xsl:for-each>
																										</fo:block>
																									</fo:block>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell font-family="Arial"
																								font-size="9pt" font-weight="bold" padding="2pt"
																								text-align="right" display-align="center">
																								<fo:block>
																									<fo:inline font-weight="bold">
																										<xsl:text>Phone:</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell font-family="Arial"
																								font-size="9pt" padding="2pt" display-align="center">
																								<fo:block>
																									<xsl:for-each select="PhoneNumber">
																										<xsl:variable name="value-of-template">
																											<xsl:apply-templates />
																										</xsl:variable>
																										<xsl:choose>
																											<xsl:when
																												test="contains(string($value-of-template),'&#x2029;')">
																												<fo:block>
																													<xsl:copy-of select="$value-of-template" />
																												</fo:block>
																											</xsl:when>
																											<xsl:otherwise>
																												<fo:inline>
																													<xsl:copy-of select="$value-of-template" />
																												</fo:inline>
																											</xsl:otherwise>
																										</xsl:choose>
																									</xsl:for-each>
																								</fo:block>
																							</fo:table-cell>
																						</fo:table-row>
																						<fo:table-row>
																							<fo:table-cell font-family="Arial"
																								font-size="9pt" font-weight="bold" padding="2pt"
																								text-align="right" display-align="center">
																								<fo:block>
																									<fo:inline font-weight="bold">
																										<xsl:text>City:</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell font-family="Arial"
																								font-size="9pt" padding="2pt" display-align="center">
																								<fo:block>
																									<xsl:for-each select="City">
																										<xsl:variable name="value-of-template">
																											<xsl:apply-templates />
																										</xsl:variable>
																										<xsl:choose>
																											<xsl:when
																												test="contains(string($value-of-template),'&#x2029;')">
																												<fo:block>
																													<xsl:copy-of select="$value-of-template" />
																												</fo:block>
																											</xsl:when>
																											<xsl:otherwise>
																												<fo:inline>
																													<xsl:copy-of select="$value-of-template" />
																												</fo:inline>
																											</xsl:otherwise>
																										</xsl:choose>
																									</xsl:for-each>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell font-family="Arial"
																								font-size="9pt" font-weight="bold" padding="2pt"
																								text-align="right" display-align="center">
																								<fo:block>
																									<fo:inline font-weight="bold">
																										<xsl:text>State:</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell font-family="Arial"
																								font-size="9pt" padding="2pt" display-align="center">
																								<fo:block>
																									<xsl:for-each select="StateDescription">
																										<xsl:variable name="value-of-template">
																											<xsl:apply-templates />
																										</xsl:variable>
																										<xsl:choose>
																											<xsl:when
																												test="contains(string($value-of-template),'&#x2029;')">
																												<fo:block>
																													<xsl:copy-of select="$value-of-template" />
																												</fo:block>
																											</xsl:when>
																											<xsl:otherwise>
																												<fo:inline>
																													<xsl:copy-of select="$value-of-template" />
																												</fo:inline>
																											</xsl:otherwise>
																										</xsl:choose>
																									</xsl:for-each>
																								</fo:block>
																							</fo:table-cell>
																						</fo:table-row>
																						<fo:table-row>
																							<fo:table-cell font-family="Arial"
																								font-size="9pt" font-weight="bold" padding="2pt"
																								text-align="right" display-align="center">
																								<fo:block>
																									<fo:inline font-weight="bold">
																										<xsl:text>Postal Code:</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell font-family="Arial"
																								font-size="9pt" padding="2pt" display-align="center">
																								<fo:block>
																									<xsl:for-each select="Pincode">
																										<xsl:variable name="value-of-template">
																											<xsl:apply-templates />
																										</xsl:variable>
																										<xsl:choose>
																											<xsl:when
																												test="contains(string($value-of-template),'&#x2029;')">
																												<fo:block>
																													<xsl:copy-of select="$value-of-template" />
																												</fo:block>
																											</xsl:when>
																											<xsl:otherwise>
																												<fo:inline>
																													<xsl:copy-of select="$value-of-template" />
																												</fo:inline>
																											</xsl:otherwise>
																										</xsl:choose>
																									</xsl:for-each>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell font-family="Arial"
																								font-size="9pt" font-weight="bold" padding="2pt"
																								text-align="right" display-align="center">
																								<fo:block>
																									<fo:inline font-weight="bold">
																										<xsl:text>Country:</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell font-family="Arial"
																								font-size="9pt" padding="2pt" display-align="center">
																								<fo:block>
																									<xsl:for-each select="CountryDescription">
																										<xsl:variable name="value-of-template">
																											<xsl:apply-templates />
																										</xsl:variable>
																										<xsl:choose>
																											<xsl:when
																												test="contains(string($value-of-template),'&#x2029;')">
																												<fo:block>
																													<xsl:copy-of select="$value-of-template" />
																												</fo:block>
																											</xsl:when>
																											<xsl:otherwise>
																												<fo:inline>
																													<xsl:copy-of select="$value-of-template" />
																												</fo:inline>
																											</xsl:otherwise>
																										</xsl:choose>
																									</xsl:for-each>
																								</fo:block>
																							</fo:table-cell>
																						</fo:table-row>
																						<fo:table-row>
																							<fo:table-cell font-family="Arial"
																								font-size="9pt" font-weight="bold" padding="2pt"
																								text-align="right" display-align="center">
																								<fo:block>
																									<fo:inline font-weight="bold">
																										<xsl:text>Fax:</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell font-family="Arial"
																								font-size="9pt" padding="2pt" display-align="center">
																								<fo:block>
																									<xsl:for-each select="Fax">
																										<xsl:variable name="value-of-template">
																											<xsl:apply-templates />
																										</xsl:variable>
																										<xsl:choose>
																											<xsl:when
																												test="contains(string($value-of-template),'&#x2029;')">
																												<fo:block>
																													<xsl:copy-of select="$value-of-template" />
																												</fo:block>
																											</xsl:when>
																											<xsl:otherwise>
																												<fo:inline>
																													<xsl:copy-of select="$value-of-template" />
																												</fo:inline>
																											</xsl:otherwise>
																										</xsl:choose>
																									</xsl:for-each>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell font-family="Arial"
																								font-size="9pt" font-weight="bold" padding="2pt"
																								text-align="right" display-align="center">
																								<fo:block>
																									<fo:inline font-weight="bold">
																										<xsl:text>E Mail:</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell font-family="Arial"
																								font-size="9pt" padding="2pt" display-align="center">
																								<fo:block>
																									<xsl:for-each select="Email">
																										<xsl:variable name="value-of-template">
																											<xsl:apply-templates />
																										</xsl:variable>
																										<xsl:choose>
																											<xsl:when
																												test="contains(string($value-of-template),'&#x2029;')">
																												<fo:block>
																													<xsl:copy-of select="$value-of-template" />
																												</fo:block>
																											</xsl:when>
																											<xsl:otherwise>
																												<fo:inline>
																													<xsl:copy-of select="$value-of-template" />
																												</fo:inline>
																											</xsl:otherwise>
																										</xsl:choose>
																									</xsl:for-each>
																								</fo:block>
																							</fo:table-cell>
																						</fo:table-row>
																					</fo:table-body>
																				</fo:table>
																			</xsl:for-each>
																		</fo:block>
																	</fo:table-cell>
																</fo:table-row>
																<fo:table-row>
																	<fo:table-cell number-columns-spanned="4"
																		padding="2pt" display-align="center">
																		<fo:block>
																			<xsl:if test="position() !=  last()">
																				<fo:block text-align="center">
																					<fo:leader leader-pattern="rule"
																						rule-thickness="1" leader-length="100%" color="black" />
																				</fo:block>
																			</xsl:if>
																		</fo:block>
																	</fo:table-cell>
																</fo:table-row>
															</xsl:for-each>
														</fo:table-body>
													</fo:table>
												</xsl:if>
											</xsl:for-each>
										</xsl:if>
										<xsl:if
											test="../PrintRequirement/OtherDataRequired  = &quot;1&quot;">
											<fo:inline font-family="Arial" font-size="12pt"
												font-weight="bold">
												<xsl:text>Other Data:</xsl:text>
											</fo:inline>
											<fo:block />
											<xsl:for-each select="AwardOtherDatas">
												<xsl:for-each select="OtherData">
													<xsl:for-each select="OtherDetails">
														<fo:inline-container>
															<fo:block>
																<xsl:text>&#x2029;</xsl:text>
															</fo:block>
														</fo:inline-container>
														<fo:table table-layout="fixed" width="100%"
															border-spacing="2pt">
															<fo:table-column column-width="160" />
															<fo:table-column column-width="proportional-column-width(1)" />
															<fo:table-body start-indent="0pt">
																<fo:table-row>
																	<fo:table-cell font-family="Arial"
																		font-size="12pt" font-weight="bold" padding="2pt"
																		display-align="center">
																		<fo:block>
																			<xsl:for-each select="Description">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates />
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when
																						test="contains(string($value-of-template),'&#x2029;')">
																						<fo:block font-family="Arial" font-size="9pt"
																							font-weight="bold">
																							<xsl:copy-of select="$value-of-template" />
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline font-family="Arial"
																							font-size="9pt" font-weight="bold">
																							<xsl:copy-of select="$value-of-template" />
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell padding="2pt"
																		display-align="center">
																		<fo:block />
																	</fo:table-cell>
																</fo:table-row>
															</fo:table-body>
														</fo:table>
														<xsl:for-each select="OtherGroupDetails">
															<fo:inline-container>
																<fo:block>
																	<xsl:text>&#x2029;</xsl:text>
																</fo:block>
															</fo:inline-container>
															<fo:table table-layout="fixed" width="100%"
																border-spacing="0pt">
																<fo:table-column column-width="2%" />
																<fo:table-column column-width="160" />
																<fo:table-column column-width="98%" />
																<fo:table-body start-indent="0pt">
																	<fo:table-row font-family="Arial"
																		font-size="9pt" font-weight="normal">
																		<fo:table-cell font-family="Arial"
																			font-size="9pt" padding="0pt" display-align="center">
																			<fo:block />
																		</fo:table-cell>
																		<fo:table-cell font-family="Arial"
																			font-size="9pt" padding="0pt" display-align="center">
																			<fo:block>
																				<xsl:for-each select="ColumnName">
																					<xsl:variable name="value-of-template">
																						<xsl:apply-templates />
																					</xsl:variable>
																					<xsl:choose>
																						<xsl:when
																							test="contains(string($value-of-template),'&#x2029;')">
																							<fo:block>
																								<xsl:copy-of select="$value-of-template" />
																							</fo:block>
																						</xsl:when>
																						<xsl:otherwise>
																							<fo:inline>
																								<xsl:copy-of select="$value-of-template" />
																							</fo:inline>
																						</xsl:otherwise>
																					</xsl:choose>
																				</xsl:for-each>
																				<fo:inline>
																					<xsl:text>:</xsl:text>
																				</fo:inline>
																			</fo:block>
																		</fo:table-cell>
																		<fo:table-cell font-family="Arial"
																			font-size="9pt" padding="0pt" display-align="center">
																			<fo:block>
																				<xsl:for-each select="ColumnValue">
																					<xsl:variable name="value-of-template">
																						<xsl:apply-templates />
																					</xsl:variable>
																					<xsl:choose>
																						<xsl:when
																							test="contains(string($value-of-template),'&#x2029;')">
																							<fo:block>
																								<xsl:copy-of select="$value-of-template" />
																							</fo:block>
																						</xsl:when>
																						<xsl:otherwise>
																							<fo:inline>
																								<xsl:copy-of select="$value-of-template" />
																							</fo:inline>
																						</xsl:otherwise>
																					</xsl:choose>
																				</xsl:for-each>
																			</fo:block>
																		</fo:table-cell>
																	</fo:table-row>
																</fo:table-body>
															</fo:table>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</xsl:for-each>
										</xsl:if>
										<xsl:if	test="../PrintRequirement/ScienceCodeRequired  = &quot;1&quot;">
												<fo:inline font-family="Arial" font-size="12pt"
													font-weight="bold">
													<xsl:text>Science Code:</xsl:text>
												</fo:inline>
												<fo:block />
												<xsl:if	test="starts-with(AwardDetails/ScienceCodeIndicator , &quot;P&quot; )">
												<xsl:for-each select="AwardScienceCodes">
													<fo:inline-container>
														<fo:block>
															<xsl:text>&#x2029;</xsl:text>
														</fo:block>
													</fo:inline-container>
													<xsl:if test="ScienceCodeDetail">
														<fo:table font-family="Arial" font-weight="bold"
															table-layout="fixed" width="100%" border-spacing="2pt">
															<fo:table-column column-width="362" />
															<fo:table-column column-width="proportional-column-width(1)" />
															<fo:table-header start-indent="0pt">
																<fo:table-row font-family="Arial"
																	font-size="9pt" font-weight="bold">
																	<fo:table-cell padding="2pt"
																		display-align="center">
																		<fo:block>
																			<fo:inline font-weight="bold">
																				<xsl:text>Code</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell padding="2pt" text-align="left"
																		display-align="center">
																		<fo:block>
																			<fo:inline font-weight="bold">
																				<xsl:text>Description</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:table-cell>
																</fo:table-row>
															</fo:table-header>
															<fo:table-body start-indent="0pt">
																<xsl:for-each select="ScienceCodeDetail">
																	<fo:table-row font-family="Arial"
																		font-size="9pt" font-weight="normal">
																		<fo:table-cell padding="2pt"
																			display-align="center">
																			<fo:block>
																				<xsl:for-each select="Code">
																					<xsl:variable name="value-of-template">
																						<xsl:apply-templates />
																					</xsl:variable>
																					<xsl:choose>
																						<xsl:when
																							test="contains(string($value-of-template),'&#x2029;')">
																							<fo:block>
																								<xsl:copy-of select="$value-of-template" />
																							</fo:block>
																						</xsl:when>
																						<xsl:otherwise>
																							<fo:inline>
																								<xsl:copy-of select="$value-of-template" />
																							</fo:inline>
																						</xsl:otherwise>
																					</xsl:choose>
																				</xsl:for-each>
																			</fo:block>
																		</fo:table-cell>
																		<fo:table-cell padding="2pt" text-align="left"
																			display-align="center">
																			<fo:block>
																				<fo:inline-container>
																					<fo:block>
																						<xsl:text>&#x2029;</xsl:text>
																					</fo:block>
																				</fo:inline-container>
																				<fo:block white-space="pre"
																					white-space-collapse="false" wrap-option="wrap"
																					white-space-treatment="ignore-if-surrounding-linefeed"
																					margin="0pt">
																					<fo:block>
																						<xsl:for-each select="Description">
																							<xsl:variable name="value-of-template">
																								<xsl:apply-templates />
																							</xsl:variable>
																							<xsl:choose>
																								<xsl:when
																									test="contains(string($value-of-template),'&#x2029;')">
																									<fo:block>
																										<xsl:copy-of select="$value-of-template" />
																									</fo:block>
																								</xsl:when>
																								<xsl:otherwise>
																									<fo:inline>
																										<xsl:copy-of select="$value-of-template" />
																									</fo:inline>
																								</xsl:otherwise>
																							</xsl:choose>
																						</xsl:for-each>
																					</fo:block>
																				</fo:block>
																			</fo:block>
																		</fo:table-cell>
																	</fo:table-row>
																</xsl:for-each>
															</fo:table-body>
														</fo:table>
													</xsl:if>
												</xsl:for-each>
											</xsl:if>
										</xsl:if>
									</xsl:if>
										<fo:block />
								
								</xsl:for-each>
							</xsl:for-each>
						</xsl:for-each>
					</fo:block>
					<fo:block id="SV_RefID_PageTotal" />
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	<xsl:template match="AwardHeader">
		<xsl:variable name="value-of-template">
			<xsl:apply-templates />
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="contains(string($value-of-template),'&#x2029;')">
				<fo:block font-family="Arial">
					<xsl:copy-of select="$value-of-template" />
				</fo:block>
			</xsl:when>
			<xsl:otherwise>
				<fo:inline font-family="Arial">
					<xsl:copy-of select="$value-of-template" />
				</fo:inline>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="AwardNotice">
		<xsl:variable name="value-of-template">
			<xsl:apply-templates />
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="contains(string($value-of-template),'&#x2029;')">
				<fo:block>
					<xsl:copy-of select="$value-of-template" />
				</fo:block>
			</xsl:when>
			<xsl:otherwise>
				<fo:inline>
					<xsl:copy-of select="$value-of-template" />
				</fo:inline>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="headerall">
		<fo:static-content flow-name="xsl-region-before">
			<fo:block>
				<xsl:for-each select="$XML">
					<fo:inline-container>
						<fo:block>
							<xsl:text>&#x2029;</xsl:text>
						</fo:block>
					</fo:inline-container>
					<fo:table font-family="Arial" font-size="9pt"
						table-layout="fixed" width="100%" border-spacing="2pt">
						<fo:table-column column-width="20%" />
						<fo:table-column column-width="30%" />
						<fo:table-column column-width="35%" />
						<fo:table-column column-width="15%" />
						<fo:table-body start-indent="0pt">
							<fo:table-row>
								<fo:table-cell padding="0" padding-bottom="0"
									number-columns-spanned="4" height="18" display-align="center">
									<fo:block />
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell font-family="Verdana" font-size="9pt"
									padding-bottom="0" padding="2pt" text-align="left"
									display-align="before">
									<fo:block>										
										<fo:inline font-family="Arial" font-size="9pt"
											font-weight="bold">
											<xsl:text> Award ID:Account: </xsl:text>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell padding-bottom="0" padding-left="0"
									padding-top="1pt" padding="2pt" text-align="left"
									display-align="after">
									<fo:block>
										<xsl:for-each select="AwardNotice">
											<xsl:for-each select="Award">
												<xsl:for-each select="AwardDetails">
													<xsl:for-each select="AwardHeader">
														<xsl:for-each select="AwardNumber">
															<xsl:variable name="value-of-template">
																<xsl:apply-templates />
															</xsl:variable>
															<xsl:choose>
																<xsl:when
																	test="contains(string($value-of-template),'&#x2029;')">
																	<fo:block font-family="Arial" font-size="9pt">
																		<xsl:copy-of select="$value-of-template" />
																	</fo:block>
																</xsl:when>
																<xsl:otherwise>
																	<fo:inline font-family="Arial" font-size="9pt">
																		<xsl:copy-of select="$value-of-template" />
																	</fo:inline>
																</xsl:otherwise>
															</xsl:choose>
														</xsl:for-each>
														<fo:inline font-family="Arial" font-size="9pt"
															font-weight="bold">
															<xsl:text>:</xsl:text>
														</fo:inline>
															<xsl:for-each select="AccountNumber">
																<xsl:if test=". != 0">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates />
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when
																			test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block font-family="Arial" font-size="9pt">
																				<xsl:copy-of select="$value-of-template" />
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline font-family="Arial" font-size="9pt">
																				<xsl:copy-of select="$value-of-template" />
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:if>
															</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</xsl:for-each>
										</xsl:for-each>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell font-size="9pt" padding-bottom="0"
									padding-right="5pt" padding="2pt" text-align="right"
									display-align="before">
									<fo:block>
										<fo:inline font-family="Arial" font-size="9pt"
											font-weight="bold">
											<xsl:text>Page: </xsl:text>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell font-size="9pt" padding-bottom="0"
									padding="2pt" text-align="left" display-align="before">
									<fo:block>
										<fo:page-number font-family="Arial" font-size="9pt" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell padding-top="0" padding="2pt"
									text-align="left" display-align="before">
									<fo:block>
										<fo:inline font-family="Arial" font-size="9pt"
											font-weight="bold">
											<xsl:text>PI:</xsl:text>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell padding-left="0" padding-top="0"
									padding="2pt" text-align="left" display-align="before">
									<fo:block>
										<xsl:for-each select="AwardNotice">
											<xsl:for-each select="Award">
												<xsl:for-each select="AwardDetails">
													<xsl:for-each select="AwardHeader">
														<xsl:for-each select="PIName">
															<xsl:variable name="value-of-template">
																<xsl:apply-templates />
															</xsl:variable>
															<xsl:choose>
																<xsl:when
																	test="contains(string($value-of-template),'&#x2029;')">
																	<fo:block font-family="Arial" font-size="9pt">
																		<xsl:copy-of select="$value-of-template" />
																	</fo:block>
																</xsl:when>
																<xsl:otherwise>
																	<fo:inline font-family="Arial" font-size="9pt">
																		<xsl:copy-of select="$value-of-template" />
																	</fo:inline>
																</xsl:otherwise>
															</xsl:choose>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</xsl:for-each>
										</xsl:for-each>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell padding-right="6pt" padding-top="0"
									padding="2pt" text-align="right" display-align="before">
									<fo:block>
										<fo:inline font-family="Arial" font-size="9pt"
											font-weight="bold">
											<xsl:text>Date:</xsl:text>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell font-size="9pt" padding-top="0"
									padding="2pt" display-align="after">
									<fo:block>
										<xsl:for-each select="AwardNotice">
											<xsl:for-each select="PrintRequirement">
												<xsl:for-each select="CurrentDate">
													<fo:inline font-family="Arial" font-size="9pt">
														<xsl:value-of
															select="format-number(number(substring(string(string(.)), 6, 2)), '00')" />
														<xsl:text>/</xsl:text>
														<xsl:value-of
															select="format-number(number(substring(string(string(.)), 9, 2)), '00')" />
														<xsl:text>/</xsl:text>
														<xsl:value-of
															select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')" />
													</fo:inline>
												</xsl:for-each>
											</xsl:for-each>
										</xsl:for-each>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell font-family="Verdana" font-size="9pt"
									padding="0" padding-top="0" number-columns-spanned="4"
									text-align="left" display-align="before">
									<fo:block>
										<fo:block text-align="center">
											<fo:leader leader-pattern="rule" rule-thickness="1"
												leader-length="100%" color="black" />
										</fo:block>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</xsl:for-each>
			</fo:block>
		</fo:static-content>
	</xsl:template>
	<xsl:template name="double-backslash">
		<xsl:param name="text" />
		<xsl:param name="text-length" />
		<xsl:variable name="text-after-bs" select="substring-after($text, '\')" />
		<xsl:variable name="text-after-bs-length" select="string-length($text-after-bs)" />
		<xsl:choose>
			<xsl:when test="$text-after-bs-length = 0">
				<xsl:choose>
					<xsl:when test="substring($text, $text-length) = '\'">
						<xsl:value-of select="concat(substring($text,1,$text-length - 1), '\\')" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$text" />
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of
					select="concat(substring($text,1,$text-length - $text-after-bs-length - 1), '\\')" />
				<xsl:call-template name="double-backslash">
					<xsl:with-param name="text" select="$text-after-bs" />
					<xsl:with-param name="text-length" select="$text-after-bs-length" />
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
