/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.budget.document.authorization;

import java.util.HashSet;
import java.util.Set;
import org.kuali.coeus.common.budget.framework.core.BudgetParentDocument;
import org.kuali.coeus.common.framework.auth.KcTransactionalDocumentAuthorizerBase;
import org.kuali.coeus.common.framework.auth.perm.KcAuthorizationService;
import org.kuali.coeus.common.framework.auth.task.Task;
import org.kuali.kra.award.budget.document.AwardBudgetDocument;
import org.kuali.kra.award.budget.document.authorization.AwardBudgetTask;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.document.Document;

public class AwardBudgetDocumentAuthorizer
extends KcTransactionalDocumentAuthorizerBase {
    private KcAuthorizationService kcAuthorizationService;

    public Set<String> getEditModes(Document document, Person user, Set<String> currentEditModes) {
        HashSet<String> editModes = new HashSet<String>();
        AwardBudgetDocument awardBudgetDocument = (AwardBudgetDocument)document;
        BudgetParentDocument<Award> parentDocument = awardBudgetDocument.getBudget().getBudgetParent().getDocument();
        if (this.canExecuteAwardBudgetTask(user, awardBudgetDocument, "modifyBudget")) {
            editModes.add("fullEntry");
            editModes.add("modifyBudgets");
            editModes.add("viewBudgets");
            this.setPermissions(user, parentDocument, editModes);
        } else if (this.canExecuteAwardBudgetTask(user, awardBudgetDocument, "viewBudget")) {
            editModes.add("viewOnly");
            editModes.add("viewBudgets");
            this.setPermissions(user, parentDocument, editModes);
        } else {
            editModes.add("unviewable");
        }
        if (this.canExecuteAwardBudgetTask(user, awardBudgetDocument, "viewSalaries")) {
            editModes.add("viewSalaries");
        }
        return editModes;
    }

    public boolean canOpen(Document document, Person user) {
        return this.canExecuteAwardBudgetTask(user, (AwardBudgetDocument)document, "viewBudget");
    }

    private boolean canExecuteAwardBudgetTask(Person user, AwardBudgetDocument doc, String taskName) {
        AwardBudgetTask task = new AwardBudgetTask(taskName, doc);
        return this.getTaskAuthorizationService().isAuthorized(user.getPrincipalId(), task);
    }

    public boolean canInitiate(String documentTypeName, Person user) {
        return true;
    }

    @Override
    public boolean canEdit(Document document, Person user) {
        return this.canExecuteAwardBudgetTask(user, (AwardBudgetDocument)document, "modifyBudget");
    }

    @Override
    public boolean canSave(Document document, Person user) {
        return this.canEdit(document, user);
    }

    @Override
    public boolean canReload(Document document, Person user) {
        WorkflowDocument workflow = document.getDocumentHeader().getWorkflowDocument();
        return this.canEdit(document, user) || workflow.isCanceled();
    }

    @Override
    public boolean canApprove(Document document, Person user) {
        return super.canApprove(document, user) && this.canExecuteAwardBudgetTask(user, (AwardBudgetDocument)document, "approveAwardBudget");
    }

    @Override
    public boolean canDisapprove(Document document, Person user) {
        return super.canDisapprove(document, user) && this.canExecuteAwardBudgetTask(user, (AwardBudgetDocument)document, "disapproveAwardBudget");
    }

    @Override
    public boolean canRoute(Document document, Person user) {
        return this.canExecuteAwardBudgetTask(user, (AwardBudgetDocument)document, "submitToWorkflow");
    }

    @Override
    public boolean canCancel(Document document, Person user) {
        WorkflowDocument workflow = document.getDocumentHeader().getWorkflowDocument();
        boolean cancelAuthZn = this.canExecuteAwardBudgetTask(user, (AwardBudgetDocument)document, "cancelBudget");
        return cancelAuthZn && super.canCancel(document) && this.canEdit(document) && !workflow.isEnroute();
    }

    protected void setPermissions(Person user, BudgetParentDocument doc, Set<String> editModes) {
        String userId = user.getPrincipalId();
        if (this.canExecuteParentDocumentTask(userId, doc, "addBudget")) {
            editModes.add("addBudget");
        }
        if (this.canExecuteParentDocumentTask(userId, doc, "openBudgets")) {
            editModes.add("openBudgets");
        }
        if (this.canExecuteParentDocumentTask(userId, doc, "modifyBudget")) {
            editModes.add("modifyProposalBudget");
        }
    }

    private boolean canExecuteParentDocumentTask(String userId, BudgetParentDocument doc, String taskName) {
        Task task = ((AwardDocument)doc).getParentAuthZTask(taskName);
        return this.getTaskAuthorizationService().isAuthorized(userId, task);
    }

    public boolean canSendNoteFyi(Document document, Person user) {
        return false;
    }

    @Override
    public boolean canFyi(Document document, Person user) {
        return false;
    }
}

