/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.notification;

import java.util.HashMap;
import java.util.List;
import org.kuali.coeus.common.framework.mail.EmailAttachment;
import org.kuali.coeus.common.notification.impl.NotificationContextBase;
import org.kuali.coeus.common.notification.impl.NotificationRenderer;
import org.kuali.coeus.common.notification.impl.bo.NotificationTypeRecipient;
import org.kuali.coeus.common.notification.impl.exception.UnknownRoleException;
import org.kuali.coeus.common.notification.impl.service.KcNotificationModuleRoleService;
import org.kuali.coeus.common.notification.impl.service.KcNotificationService;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.notification.ProposalDevelopmentNotificationRenderer;
import org.kuali.coeus.propdev.impl.notification.ProposalDevelopmentNotificationRoleQualifierService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;

public class ProposalDevelopmentNotificationContext
extends NotificationContextBase {
    private static final long serialVersionUID = 7899968257291957401L;
    private DevelopmentProposal proposal;
    private String documentNumber;
    private String actionTypeCode;
    private String contextName;
    private List<EmailAttachment> emailAttachments;
    private transient KcNotificationService kcNotificationService;
    private transient KcNotificationModuleRoleService kcNotificationModuleRoleService;
    private transient ProposalDevelopmentNotificationRoleQualifierService proposalDevelopmentNotificationRoleQualifierService;

    protected KcNotificationService getKcNotificationService() {
        if (this.kcNotificationService == null) {
            this.kcNotificationService = KcServiceLocator.getService(KcNotificationService.class);
        }
        return this.kcNotificationService;
    }

    protected ProposalDevelopmentNotificationRoleQualifierService getProposalDevelopmentNotificationRoleQualifierService() {
        if (this.proposalDevelopmentNotificationRoleQualifierService == null) {
            this.proposalDevelopmentNotificationRoleQualifierService = KcServiceLocator.getService(ProposalDevelopmentNotificationRoleQualifierService.class);
        }
        return this.proposalDevelopmentNotificationRoleQualifierService;
    }

    protected KcNotificationModuleRoleService getKcNotificationModuleRoleService() {
        if (this.kcNotificationModuleRoleService == null) {
            this.kcNotificationModuleRoleService = KcServiceLocator.getService(KcNotificationModuleRoleService.class);
        }
        return this.kcNotificationModuleRoleService;
    }

    public ProposalDevelopmentNotificationContext(DevelopmentProposal developmentProposal, String actionTypeCode, String contextName, NotificationRenderer renderer) {
        super(renderer);
        this.proposal = developmentProposal;
        this.documentNumber = developmentProposal.getProposalDocument().getDocumentNumber();
        this.actionTypeCode = actionTypeCode;
        this.contextName = contextName;
        this.setNotificationService(this.getKcNotificationService());
        this.setNotificationModuleRoleService(this.getKcNotificationModuleRoleService());
        ProposalDevelopmentNotificationRoleQualifierService roleQualifier = this.getProposalDevelopmentNotificationRoleQualifierService();
        roleQualifier.setDevelopmentProposal(developmentProposal);
        this.setNotificationRoleQualifierService(roleQualifier);
    }

    public ProposalDevelopmentNotificationContext(DevelopmentProposal developmentProposal, String actionTypeCode, String contextName) {
        this(developmentProposal, actionTypeCode, contextName, KcServiceLocator.getService(ProposalDevelopmentNotificationRenderer.class));
        this.getRenderer().setDevelopmentProposal(developmentProposal);
    }

    @Override
    public String getModuleCode() {
        return "3";
    }

    @Override
    public String getDocumentNumber() {
        return this.documentNumber;
    }

    @Override
    public String getActionTypeCode() {
        return this.actionTypeCode;
    }

    @Override
    public String getContextName() {
        return this.contextName;
    }

    @Override
    public List<EmailAttachment> getEmailAttachments() {
        return this.emailAttachments;
    }

    @Override
    public void populateRoleQualifiers(NotificationTypeRecipient notificationRecipient) throws UnknownRoleException {
        if (notificationRecipient.getRoleQualifiers() == null) {
            notificationRecipient.setRoleQualifiers(new HashMap<String, String>());
        }
        notificationRecipient.getRoleQualifiers().put("documentNumber", this.getDocumentNumber());
        notificationRecipient.getRoleQualifiers().put("proposal", this.getProposal().getProposalNumber());
        super.populateRoleQualifiers(notificationRecipient);
    }

    public void setEmailAttachments(List<EmailAttachment> emailAttachments) {
        this.emailAttachments = emailAttachments;
    }

    public DevelopmentProposal getProposal() {
        return this.proposal;
    }

    public void setProposal(DevelopmentProposal proposal) {
        this.proposal = proposal;
    }

    @Override
    public ProposalDevelopmentNotificationRenderer getRenderer() {
        return (ProposalDevelopmentNotificationRenderer)super.getRenderer();
    }
}

