/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.web.struts.action;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionRedirect;
import org.apache.struts.config.ForwardConfig;
import org.kuali.coeus.coi.framework.Project;
import org.kuali.coeus.coi.framework.ProjectPublisher;
import org.kuali.coeus.coi.framework.ProjectRetrievalService;
import org.kuali.coeus.common.api.sponsor.hierarchy.SponsorHierarchyService;
import org.kuali.coeus.common.budget.framework.core.BudgetParentActionBase;
import org.kuali.coeus.common.framework.custom.CustomDataUtils;
import org.kuali.coeus.common.framework.krms.KrmsRulesExecutionService;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.coeus.common.framework.version.history.VersionHistory;
import org.kuali.coeus.common.framework.version.history.VersionHistoryService;
import org.kuali.coeus.common.notification.impl.service.KcNotificationService;
import org.kuali.coeus.sys.framework.controller.StrutsConfirmation;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.validation.AuditHelper;
import org.kuali.kra.award.AwardForm;
import org.kuali.kra.award.AwardLockService;
import org.kuali.kra.award.AwardNumberService;
import org.kuali.kra.award.AwardTemplateSyncScope;
import org.kuali.kra.award.AwardTemplateSyncService;
import org.kuali.kra.award.awardhierarchy.AwardHierarchy;
import org.kuali.kra.award.awardhierarchy.AwardHierarchyBean;
import org.kuali.kra.award.awardhierarchy.AwardHierarchyService;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncPendingChangeBean;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncType;
import org.kuali.kra.award.awardhierarchy.sync.service.AwardSyncCreationService;
import org.kuali.kra.award.awardhierarchy.sync.service.AwardSyncService;
import org.kuali.kra.award.budget.AwardBudgetService;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardService;
import org.kuali.kra.award.home.AwardTemplate;
import org.kuali.kra.award.notesandattachments.attachments.AwardAttachmentFormBean;
import org.kuali.kra.award.paymentreports.ReportClass;
import org.kuali.kra.award.paymentreports.awardreports.reporting.service.ReportTrackingService;
import org.kuali.kra.award.paymentreports.closeout.AwardCloseoutService;
import org.kuali.kra.award.paymentreports.closeout.CloseoutReportTypeValuesFinder;
import org.kuali.kra.award.service.AwardDirectFandADistributionService;
import org.kuali.kra.award.service.AwardReportsService;
import org.kuali.kra.award.service.AwardSponsorTermService;
import org.kuali.kra.award.version.service.AwardVersionService;
import org.kuali.kra.external.award.AwardAccountService;
import org.kuali.kra.subaward.service.SubAwardService;
import org.kuali.kra.timeandmoney.AwardHierarchyNode;
import org.kuali.kra.timeandmoney.document.TimeAndMoneyDocument;
import org.kuali.kra.timeandmoney.rules.TimeAndMoneyAwardDateSaveRuleImpl;
import org.kuali.kra.timeandmoney.service.TimeAndMoneyExistenceService;
import org.kuali.kra.timeandmoney.service.TimeAndMoneyService;
import org.kuali.kra.timeandmoney.service.TimeAndMoneyVersionService;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.KualiRuleService;
import org.kuali.rice.krad.service.PessimisticLockService;
import org.kuali.rice.krad.util.GlobalVariables;

public class AwardAction
extends BudgetParentActionBase {
    protected static final String AWARD_ID_PARAMETER_NAME = "awardId";
    private static final String REPORTS_PROPERTY_NAME = "Reports";
    private static final String PAYMENT_INVOICES_PROPERTY_NAME = "Payments and Invoices";
    private static final String COMFIRMATION_PARAM_STRING = "After Award {0} information is synchronized, make sure that the Award Sponsor Contacts information is also synchronized with the same sponsor template. Failing to do so will result in data inconsistency. Are you sure you want to replace current {0} information with selected {1} template information?";
    private static final String SUPER_USER_ACTION_REQUESTS = "superUserActionRequests";
    private static final String DATA_VALIDATION = "datavalidation";
    private static final String DOC_HANDLER = "docHandler";
    private static final String ERROR_AWARD_AWARDHIERARCHY_SYNC_LOCKED = "error.award.awardhierarchy.sync.locked";
    private static final String AWARD_DOCUMENT = "AwardDocument";
    private static final String SAVE = "save";
    public static final String AWARD_NUMBER = "awardNumber";
    public static final String ACTIVE = "active";
    private static final String ROOT_AWARD_NUMBER = "rootAwardNumber";
    public static final String VIEW_ONLY = "viewOnly";
    public static final String FULL_ENTRY = "fullEntry";
    private static final String BACK_LOCATION = "&backLocation=";
    public static final String ENABLE_AWD_ANT_OBL_DIRECT_INDIRECT_COST = "ENABLE_AWD_ANT_OBL_DIRECT_INDIRECT_COST";
    private static final String AWARD_DOCUMENT_NUMBER = "awardDocumentNumber";
    private static final String BASIC = "basic";
    private static final String SELECTED_AWARD_NUMBER = "selectedAwardNumber";
    private static final String DOCUMENT_AWARD_AWARD_TEMPLATE = "document.award.awardTemplate";
    private static final String AWARD_TEMPLATE = "awardTemplate";
    private static final String PROCESS_SYNC_AWARD = "processSyncAward";
    private static final String METHOD_TO_CALL_SYNC_ACTION_CALLER = "methodToCall.syncActionCaller";
    private static final String CONFIRM_SYNC_ACTION_KEY = "confirmSyncActionKey";
    private static final String CONFIRM_SYNC_ACTION = "confirmSyncAction";
    private static final String REFUSE_SYNC_ACTION = "refuseSyncAction";
    private static final String DISABLE_ATTACHMENT_REMOVAL = "disableAttachmentRemoval";
    private static final String CURRENT_VERSION_BUDGETS = "currentVersionBudgets";
    private static final String QUESTION_VERIFY_SYNC = "VerifySync";
    private static final String QUESTION_VERIFY_EMPTY_SYNC = "VerifyEmptySync";
    private static final Logger LOG = LogManager.getLogger(AwardAction.class);
    private transient SponsorHierarchyService sponsorHierarchyService;
    private TimeAndMoneyService timeAndMoneyService;
    private TimeAndMoneyExistenceService timeAndMoneyExistenceService;
    private AwardAccountService awardAccountService;
    private AwardCloseoutService awardCloseoutService;
    private static final AwardTemplateSyncScope[] DEFAULT_SCOPES_REQUIRE_VERIFY_FOR_EMPTY = new AwardTemplateSyncScope[]{AwardTemplateSyncScope.PAYMENTS_AND_INVOICES_TAB, AwardTemplateSyncScope.SPONSOR_CONTACTS_TAB, AwardTemplateSyncScope.REPORTS_TAB};
    private static final AwardTemplateSyncScope[] DEFAULT_AWARD_TEMPLATE_SYNC_SCOPES = new AwardTemplateSyncScope[]{AwardTemplateSyncScope.AWARD_PAGE, AwardTemplateSyncScope.COST_SHARE, AwardTemplateSyncScope.PAYMENTS_AND_INVOICES_TAB, AwardTemplateSyncScope.SPONSOR_CONTACTS_TAB, AwardTemplateSyncScope.TERMS_TAB, AwardTemplateSyncScope.REPORTS_TAB, AwardTemplateSyncScope.COMMENTS_TAB};
    private static final String DOCUMENT_ROUTE_QUESTION = "DocRoute";
    private static final String ADD_SYNC_CHANGE_QUESTION = "document.question.awardhierarchy.sync";
    private static final String DEL_SYNC_CHANGE_QUESTION = "document.question.awardhierarchy.sync";
    private transient ParameterService parameterService;
    private transient AwardBudgetService awardBudgetService;
    private transient AwardService awardService;
    private transient ReportTrackingService reportTrackingService;
    private transient KcNotificationService notificationService;
    private transient SubAwardService subAwardService;
    private transient TimeAndMoneyVersionService timeAndMoneyVersionService;
    private transient ProjectPublisher projectPublisher;
    private transient ProjectRetrievalService projectRetrievalService;

    @Override
    public ActionForward docHandler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Optional<Award> newActiveAward;
        AwardForm awardForm = (AwardForm)form;
        this.cleanUpUserSession();
        ActionForward docHandlerForward = this.handleLoadingDocument(mapping, awardForm, request, response);
        AwardDocument awardDocument = (AwardDocument)awardForm.getDocument();
        Award award = awardDocument.getAward();
        if (awardForm.getMethodToCall().equals(DOC_HANDLER)) {
            AwardDocument parentSyncAward = this.getAwardSyncService().getAwardLockingHierarchyForSync(awardDocument, GlobalVariables.getUserSession().getPrincipalId());
            if (parentSyncAward != null) {
                KNSGlobalVariables.getMessageList().add(ERROR_AWARD_AWARDHIERARCHY_SYNC_LOCKED, new String[]{parentSyncAward.getDocumentNumber()});
                awardForm.setViewOnly(true);
            }
            this.setBooleanAwardInMultipleNodeHierarchyOnForm(award);
            awardForm.initializeFormOrDocumentBasedOnCommand();
            this.setBooleanAwardHasTandMOrIsVersioned(award);
            this.setSubAwardDetails(award);
            this.handlePlaceHolderDocument(awardForm, awardDocument);
        }
        if ((newActiveAward = this.getAwardService().verifyAwardSequencing(award)).isPresent()) {
            awardForm.setDocId(newActiveAward.get().getAwardDocument().getDocumentNumber());
            awardForm.setPlaceHolderAwardId(newActiveAward.get().getAwardId());
            LOG.info("An award sequencing issue was detected on the docHandler. Document Number = " + awardForm.getDocId());
            return this.docHandler(mapping, form, request, response);
        }
        ActionForward commandForward = this.handleDocHandlerForwards(mapping, awardForm, request, response);
        if (commandForward != null) {
            return commandForward;
        }
        return docHandlerForward;
    }

    private void handlePlaceHolderDocument(AwardForm form, AwardDocument awardDocument) {
        if (awardDocument.isPlaceHolderDocument()) {
            Long awardId = form.getPlaceHolderAwardId();
            int currentAwardIndex = -1;
            Award currentAward = null;
            for (Award award : awardDocument.getAwardList()) {
                ++currentAwardIndex;
                if (!Objects.equals(award.getAwardId(), awardId)) continue;
                currentAward = award;
                break;
            }
            if (currentAward != null) {
                awardDocument.getAwardList().remove(currentAwardIndex);
                awardDocument.getAwardList().add(0, currentAward);
                form.setViewOnly(true);
            }
        }
    }

    protected void cleanUpUserSession() {
        GlobalVariables.getUserSession().removeObject(GlobalVariables.getUserSession().getKualiSessionId() + "TIME_AND_MONEY");
    }

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        ActionForward actionForward = super.execute(mapping, form, request, response);
        if (awardForm.isAuditActivated()) {
            awardForm.setUnitRulesMessages(this.getUnitRulesMessages(awardForm.getAwardDocument()));
        }
        if (GlobalVariables.getAuditErrorMap().isEmpty()) {
            this.getAuditHelper().auditConditionally((AwardForm)form);
        }
        return actionForward;
    }

    protected List<String> getUnitRulesMessages(AwardDocument awardDoc) {
        KrmsRulesExecutionService rulesService = KcServiceLocator.getService(KrmsRulesExecutionService.class);
        return rulesService.processUnitValidations(awardDoc.getLeadUnitNumber(), awardDoc);
    }

    protected void populateAwardHierarchy(ActionForm form) throws WorkflowException {
        AwardForm awardForm = (AwardForm)form;
        AwardDocument awardDocument = awardForm.getAwardDocument();
        AwardHierarchyBean helperBean = awardForm.getAwardHierarchyBean();
        AwardHierarchy rootNode = helperBean.getRootNode();
        Award currentAward = awardDocument.getAward();
        awardForm.setRootAwardNumber(rootNode.getRootAwardNumber());
        this.buildAwardHierarchySourceAndTargetList(awardForm, currentAward);
    }

    public ActionForward approve(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward;
        AwardForm awardForm = (AwardForm)form;
        if (this.getTimeAndMoneyExistenceService().validateTimeAndMoneyRule(awardForm.getAwardDocument().getAward(), awardForm.getAwardHierarchyBean().getRootNode().getAwardNumber())) {
            forward = super.approve(mapping, form, request, response);
        } else {
            this.getTimeAndMoneyExistenceService().addAwardVersionErrorMessage();
            forward = mapping.findForward(BASIC);
        }
        String routeHeaderId = awardForm.getDocument().getDocumentNumber();
        String returnLocation = this.buildActionUrl(routeHeaderId, "awardActions", AWARD_DOCUMENT);
        ActionForward basicForward = mapping.findForward("portal");
        ActionRedirect holdingPageForward = new ActionRedirect((ForwardConfig)mapping.findForward("kraHoldingPage"));
        holdingPageForward.addParameter("holdingPageDocumentId", (Object)routeHeaderId);
        return this.routeToHoldingPage(basicForward, forward, holdingPageForward, returnLocation, routeHeaderId);
    }

    protected ActionForward submitAward(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        ActionForward forward = mapping.findForward(BASIC);
        if (this.getTimeAndMoneyExistenceService().validateTimeAndMoneyRule(awardForm.getAwardDocument().getAward(), awardForm.getAwardHierarchyBean().getRootNode().getAwardNumber())) {
            forward = super.route(mapping, form, request, response);
            this.populateAwardHierarchy((ActionForm)awardForm);
        } else {
            this.getTimeAndMoneyExistenceService().addAwardVersionErrorMessage();
        }
        String routeHeaderId = awardForm.getDocument().getDocumentNumber();
        String returnLocation = this.buildActionUrl(routeHeaderId, "awardActions", AWARD_DOCUMENT);
        ActionForward basicForward = mapping.findForward("portal");
        ActionRedirect holdingPageForward = new ActionRedirect((ForwardConfig)mapping.findForward("kraHoldingPage"));
        holdingPageForward.addParameter("holdingPageDocumentId", (Object)routeHeaderId);
        return this.routeToHoldingPage(basicForward, forward, holdingPageForward, returnLocation, routeHeaderId);
    }

    @Override
    public ActionForward route(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        awardForm.setAuditActivated(true);
        AuditHelper.ValidationState status = this.getAuditHelper().isValidSubmission(awardForm, true);
        awardForm.setUnitRulesMessages(this.getUnitRulesMessages(awardForm.getAwardDocument()));
        if (status != AuditHelper.ValidationState.ERROR && awardForm.getUnitRulesMessages().size() > 0) {
            status = AuditHelper.ValidationState.WARNING;
        }
        if (awardForm.getUnitRulesErrors().size() > 0) {
            status = AuditHelper.ValidationState.ERROR;
        }
        if (status == AuditHelper.ValidationState.WARNING) {
            return this.handleWarning(mapping, form, request, response);
        }
        if (status == AuditHelper.ValidationState.OK) {
            return this.submitAward(mapping, form, request, response);
        }
        GlobalVariables.getMessageMap().clearErrorMessages();
        GlobalVariables.getMessageMap().putError(DATA_VALIDATION, "error.workflow.submission", new String[0]);
        return mapping.findForward(BASIC);
    }

    protected boolean isAutoPostAward() {
        return this.getParameterService().getParameterValueAsBoolean("KC-AWARD", "All", "AWARD_AUTO_POST_ENABLED");
    }

    protected AuditHelper getAuditHelper() {
        return KcServiceLocator.getService(AuditHelper.class);
    }

    protected ActionForward handleWarning(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String buttonClicked = request.getParameter("buttonClicked");
        String question = request.getParameter("questionIndex");
        String methodToCall = ((KualiForm)form).getMethodToCall();
        if (question == null) {
            return this.performQuestionWithoutInput(mapping, form, request, response, DOCUMENT_ROUTE_QUESTION, "Validation Warning Exists. Are you sure want to submit to workflow routing.", "confirmationQuestion", methodToCall, "");
        }
        if (DOCUMENT_ROUTE_QUESTION.equals(question) && "0".equals(buttonClicked)) {
            return this.submitAward(mapping, form, request, response);
        }
        return mapping.findForward(BASIC);
    }

    public ActionForward blanketApprove(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward;
        AwardForm awardForm = (AwardForm)form;
        if (this.getTimeAndMoneyExistenceService().validateTimeAndMoneyRule(awardForm.getAwardDocument().getAward(), awardForm.getAwardHierarchyBean().getRootNode().getAwardNumber())) {
            awardForm.setAuditActivated(true);
            AuditHelper.ValidationState status = this.getAuditHelper().isValidSubmission(awardForm, true);
            if (status == AuditHelper.ValidationState.ERROR) {
                GlobalVariables.getMessageMap().clearErrorMessages();
                GlobalVariables.getMessageMap().putError(DATA_VALIDATION, "error.workflow.submission", new String[0]);
                forward = mapping.findForward(BASIC);
            } else {
                forward = super.blanketApprove(mapping, form, request, response);
            }
        } else {
            this.getTimeAndMoneyExistenceService().addAwardVersionErrorMessage();
            forward = mapping.findForward(BASIC);
        }
        String routeHeaderId = awardForm.getDocument().getDocumentNumber();
        String returnLocation = this.buildActionUrl(routeHeaderId, "awardActions", AWARD_DOCUMENT);
        ActionForward basicForward = mapping.findForward("portal");
        ActionRedirect holdingPageForward = new ActionRedirect((ForwardConfig)mapping.findForward("kraHoldingPage"));
        holdingPageForward.addParameter("holdingPageDocumentId", (Object)routeHeaderId);
        return this.routeToHoldingPage(basicForward, forward, holdingPageForward, returnLocation, routeHeaderId);
    }

    @Override
    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardHierarchyBean bean;
        AwardForm awardForm = (AwardForm)form;
        Award award = awardForm.getAwardDocument().getAward();
        this.getAwardService().checkAwardNumber(award);
        this.updateIndicators(award);
        ActionForward forward = super.save(mapping, form, request, response);
        if (awardForm.getMethodToCall().equals(SAVE) && awardForm.isAuditActivated()) {
            forward = mapping.findForward("awardActions");
        }
        if ((bean = awardForm.getAwardHierarchyBean()).saveHierarchyChanges()) {
            ArrayList order = new ArrayList();
            awardForm.setAwardHierarchyNodes(bean.getAwardHierarchy(bean.getRootNode().getAwardNumber(), (List<String>)order));
        }
        for (AwardSyncPendingChangeBean pendingChange : awardForm.getAwardSyncBean().getConfirmedPendingChanges()) {
            pendingChange.getObject().refresh();
            this.getAwardSyncCreationService().addAwardSyncChange(award, pendingChange);
        }
        this.getBusinessObjectService().save(award.getSyncChanges());
        awardForm.getAwardSyncBean().getConfirmedPendingChanges().clear();
        this.getReportTrackingService().generateReportTrackingAndSave(award, false);
        this.getAwardCloseoutService().updateCloseoutDueDatesBeforeSave(award);
        Project project = this.getProjectRetrievalService().retrieveProject(awardForm.getAwardDocument().getAward().getAwardNumber());
        if (project != null) {
            this.getProjectPublisher().publishProject(project);
        }
        return forward;
    }

    protected void updateIndicators(Award award) {
        if (award.getAwardApprovedSubawards() == null || award.getAwardApprovedSubawards().isEmpty()) {
            award.setSubContractIndicator("N");
        } else {
            award.setSubContractIndicator("Y");
        }
        if (award.getAwardTransferringSponsors() == null || award.getAwardTransferringSponsors().isEmpty()) {
            award.setTransferSponsorIndicator("N");
        } else {
            award.setTransferSponsorIndicator("Y");
        }
        if (award.getKeywords() == null || award.getKeywords().isEmpty()) {
            award.setScienceCodeIndicator("N");
        } else {
            award.setScienceCodeIndicator("Y");
        }
        if (award.getSpecialReviews() == null || award.getSpecialReviews().isEmpty()) {
            award.setSpecialReviewIndicator("N");
        } else {
            award.setSpecialReviewIndicator("Y");
        }
        if (award.getAwardFandaRate() == null || award.getAwardFandaRate().isEmpty()) {
            award.setIndirectCostIndicator("N");
        } else {
            award.setIndirectCostIndicator("Y");
        }
        if (award.getAwardCostShares() == null || award.getAwardCostShares().isEmpty()) {
            award.setCostSharingIndicator("N");
        } else {
            award.setCostSharingIndicator("Y");
        }
        if (award.getApprovedEquipmentItems() == null || award.getApprovedEquipmentItems().isEmpty()) {
            award.setApprovedEquipmentIndicator("N");
        } else {
            award.setApprovedEquipmentIndicator("Y");
        }
        if (award.getApprovedForeignTravelTrips() == null || award.getApprovedForeignTravelTrips().isEmpty()) {
            award.setApprovedForeignTripIndicator("N");
        } else {
            award.setApprovedForeignTripIndicator("Y");
        }
        if (award.getPaymentScheduleItems() == null || award.getPaymentScheduleItems().isEmpty()) {
            award.setPaymentScheduleIndicator("N");
        } else {
            award.setPaymentScheduleIndicator("Y");
        }
    }

    @Override
    public ActionForward reload(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        awardForm.refreshDisclosureProjectStatuses();
        ActionForward actionForward = super.reload(mapping, form, request, response);
        this.getReportTrackingService().refreshReportTracking(awardForm.getAwardDocument().getAward());
        return actionForward;
    }

    @Override
    public ActionForward close(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        CustomDataUtils.processCustomDataBeforeSave(awardForm.getAwardDocument().getDocumentCustomData());
        if (awardForm.getViewFundingSource()) {
            return mapping.findForward("closePage");
        }
        return super.close(mapping, form, request, response);
    }

    protected Award getAward(ActionForm form) {
        return this.getAwardDocument(form).getAward();
    }

    protected AwardDocument getAwardDocument(ActionForm form) {
        return ((AwardForm)form).getAwardDocument();
    }

    protected AwardNumberService getAwardNumberService() {
        return KcServiceLocator.getService(AwardNumberService.class);
    }

    @Override
    protected void initialDocumentSave(KualiDocumentFormBase form) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        AwardDocument awardDocument = (AwardDocument)awardForm.getDocument();
        this.getAwardService().createInitialAwardUsers(awardForm.getAwardDocument().getAward());
        this.populateStaticCloseoutReports(awardForm);
        String userId = GlobalVariables.getUserSession().getPrincipalName();
        Award award = awardDocument.getAward();
        this.getAwardService().updateAwardSequenceStatus(award, VersionStatus.PENDING);
        this.getVersionHistoryService().updateVersionHistory(award, VersionStatus.PENDING, userId);
        if (!awardForm.getAwardDocument().isDocumentSaveAfterVersioning()) {
            awardForm.getAwardHierarchyBean().createDefaultAwardHierarchy(awardForm.determineParentAwardNumber(), awardForm.determineRootAwardNumber(), awardForm.getAwardDocument().getAward());
            awardForm.getAwardHierarchyBean().saveHierarchyChanges();
        }
    }

    protected void populateStaticCloseoutReports(AwardForm form) {
        CloseoutReportTypeValuesFinder closeoutReportTypeValuesFinder = new CloseoutReportTypeValuesFinder();
        form.getAwardCloseoutBean().addAwardCloseoutStaticItems(closeoutReportTypeValuesFinder.getKeyValues());
    }

    protected AwardHierarchyService getAwardHierarchyService() {
        return KcServiceLocator.getService(AwardHierarchyService.class);
    }

    protected final boolean applyRules(DocumentEvent event) {
        return this.getKualiRuleService().applyRules(event);
    }

    public String buildForwardStringForActionListCommand(String forwardPath, String docIdRequestParameter) {
        StringBuilder sb = new StringBuilder();
        sb.append(forwardPath);
        sb.append("?");
        sb.append("docId");
        sb.append("=");
        sb.append(docIdRequestParameter);
        return sb.toString();
    }

    public ActionForward home(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        AwardForm awardForm = (AwardForm)form;
        AwardDocument awardDocument = (AwardDocument)awardForm.getDocument();
        this.setBooleanAwardInMultipleNodeHierarchyOnForm(awardDocument.getAward());
        this.setBooleanAwardHasTandMOrIsVersioned(awardDocument.getAward());
        this.setSubAwardDetails(awardDocument.getAward());
        return mapping.findForward("home");
    }

    public void setBooleanAwardInMultipleNodeHierarchyOnForm(Award award) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        String awardNumber = award.getAwardNumber();
        fieldValues.put(AWARD_NUMBER, awardNumber);
        fieldValues.put(ACTIVE, Boolean.TRUE);
        List awardHierarchies = this.getBusinessObjectService().findMatching(AwardHierarchy.class, fieldValues);
        if (awardHierarchies.size() == 0) {
            award.setAwardInMultipleNodeHierarchy(false);
        } else {
            HashMap<String, Object> newFieldValues = new HashMap<String, Object>();
            String rootAwardNumber = ((AwardHierarchy)awardHierarchies.get(0)).getRootAwardNumber();
            newFieldValues.put(ROOT_AWARD_NUMBER, rootAwardNumber);
            newFieldValues.put(ACTIVE, Boolean.TRUE);
            int matchingValues = this.getBusinessObjectService().countMatching(AwardHierarchy.class, newFieldValues);
            if (matchingValues > 1) {
                award.setAwardInMultipleNodeHierarchy(true);
            } else {
                award.setAwardInMultipleNodeHierarchy(false);
            }
        }
    }

    public void setBooleanAwardHasTandMOrIsVersioned(Award award) {
        boolean previousVersionHasBeenEditedInTandMDocument = false;
        List<VersionHistory> awardHistory = this.getVersionHistoryService().findVersionHistory(Award.class, award.getAwardNumber());
        if (awardHistory.size() > 1) {
            if (award.getSequenceNumber() == 1 && award.getAwardAmountInfos().size() > 2) {
                previousVersionHasBeenEditedInTandMDocument = true;
            } else if (award.getSequenceNumber() > 1 && award.getAwardAmountInfos().size() > 1) {
                previousVersionHasBeenEditedInTandMDocument = true;
            }
        }
        award.setAwardHasAssociatedTandMOrIsVersioned(previousVersionHasBeenEditedInTandMDocument);
    }

    public ActionForward contacts(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        AwardForm awardForm = (AwardForm)form;
        awardForm.refreshDisclosureProjectStatuses();
        Award award = this.getAward(form);
        award.getAwardCentralAdminContacts();
        award.removeDuplicateAwardCentralAdminContacts();
        return mapping.findForward("contacts");
    }

    public ActionForward commitments(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("commitments");
    }

    public ActionForward timeAndMoney(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward;
        AwardForm awardForm = (AwardForm)form;
        AwardDocument awardDocument = awardForm.getAwardDocument();
        if (!(awardForm.getEditingMode().containsKey(VIEW_ONLY) && !awardForm.getEditingMode().containsKey(FULL_ENTRY) || awardDocument.getDocumentHeader().getWorkflowDocument().isFinal())) {
            this.save(mapping, form, request, response);
        }
        TimeAndMoneyAwardDateSaveRuleImpl timeAndMoneyAwardDateSaveRuleImpl = new TimeAndMoneyAwardDateSaveRuleImpl();
        timeAndMoneyAwardDateSaveRuleImpl.enforceAwardStartDatePopulated(awardDocument.getAward());
        if (GlobalVariables.getMessageMap().hasNoErrors()) {
            this.populateAwardHierarchy(form);
            Award currentAward = awardDocument.getAward();
            String rootAwardNumber = awardForm.getAwardHierarchyNodes().get(currentAward.getAwardNumber()).getRootAwardNumber();
            String documentNumber = this.getTimeAndMoneyVersionService().getCurrentTimeAndMoneyDocumentNumber(rootAwardNumber);
            if (documentNumber == null) {
                if (!this.getTimeAndMoneyVersionService().validateCreateNewTimeAndMoneyDocument(rootAwardNumber)) {
                    return mapping.findForward(BASIC);
                }
                TimeAndMoneyDocument timeAndMoneyDocument = this.getTimeAndMoneyService().setupTimeAndMoneyDocument(rootAwardNumber, currentAward);
                documentNumber = timeAndMoneyDocument.getDocumentHeader().getDocumentNumber();
            }
            String routeHeaderId = documentNumber;
            String backUrl = URLEncoder.encode(this.buildActionUrl(awardDocument.getDocumentNumber(), "home", AWARD_DOCUMENT), StandardCharsets.UTF_8);
            String forward = this.buildForwardUrl(routeHeaderId) + BACK_LOCATION + backUrl;
            actionForward = new ActionForward(forward, true);
            GlobalVariables.getUserSession().addObject("returnToAwardDocument-" + documentNumber, (Object)awardDocument.getDocumentNumber());
            GlobalVariables.getUserSession().addObject("awardEnteredFrom", (Object)awardForm.getAwardDocument().getAward().getAwardNumber());
        } else {
            actionForward = mapping.findForward(BASIC);
        }
        return actionForward;
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    protected AwardAccountService getAwardAccountService() {
        if (this.awardAccountService == null) {
            this.awardAccountService = KcServiceLocator.getService(AwardAccountService.class);
        }
        return this.awardAccountService;
    }

    public AwardVersionService getAwardVersionService() {
        return KcServiceLocator.getService(AwardVersionService.class);
    }

    public ActionForward openWindow(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String documentNumber = request.getParameter(AWARD_DOCUMENT_NUMBER);
        String awardNumber = request.getParameter(AWARD_NUMBER);
        AwardForm awardForm = (AwardForm)form;
        DocumentService documentService = KcServiceLocator.getService(DocumentService.class);
        AwardDocument awardDocument = (AwardDocument)documentService.getByDocumentHeaderId(documentNumber);
        Award award = this.getAwardService().getAwardAssociatedWithDocument(awardDocument.getDocumentNumber());
        awardForm.setCurrentAwardNumber(awardNumber);
        awardForm.setCurrentSeqNumber(award.getSequenceNumber().toString());
        awardDocument.setAward(award);
        awardForm.setDocument(awardDocument);
        this.populateAwardHierarchy((ActionForm)awardForm);
        return mapping.findForward(BASIC);
    }

    protected AwardDirectFandADistributionService getAwardDirectFandADistributionService() {
        return KcServiceLocator.getService(AwardDirectFandADistributionService.class);
    }

    public ActionForward paymentReportsAndTerms(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        AwardForm awardForm = (AwardForm)form;
        this.setReportsAndTermsOnAwardForm(awardForm);
        return mapping.findForward("paymentReportsAndTerms");
    }

    protected void setReportsAndTermsOnAwardForm(AwardForm awardForm) {
        AwardSponsorTermService awardSponsorTermService = this.getAwardSponsorTermService();
        List<KeyValue> sponsorTermTypes = awardSponsorTermService.retrieveSponsorTermTypesToAwardFormForPanelHeaderDisplay();
        awardForm.getSponsorTermFormHelper().setSponsorTermTypes(sponsorTermTypes);
        awardForm.getSponsorTermFormHelper().setNewSponsorTerms(awardSponsorTermService.getEmptyNewSponsorTerms(sponsorTermTypes));
        AwardReportsService awardReportsService = KcServiceLocator.getService(AwardReportsService.class);
        Map<String, Object> initializedObjects = awardReportsService.initializeObjectsForReportsAndPayments(awardForm.getAwardDocument().getAward());
        awardForm.setReportClasses((List)initializedObjects.get("reportClasses"));
        awardForm.getAwardReportsBean().setNewAwardReportTerms((List)initializedObjects.get("newAwardReportTermList"));
        awardForm.getAwardReportsBean().setNewAwardReportTermRecipients((List)initializedObjects.get("newAwardReportTermRecipientsList"));
        awardForm.setReportClassForPaymentsAndInvoices((ReportClass)initializedObjects.get("reportClassForPaymentsAndInvoicesPanel"));
        awardForm.buildReportTrackingBeans();
    }

    protected AwardSponsorTermService getAwardSponsorTermService() {
        return KcServiceLocator.getService(AwardSponsorTermService.class);
    }

    public ActionForward specialReview(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ((AwardForm)form).getSpecialReviewHelper().prepareView();
        return mapping.findForward("specialReview");
    }

    public ActionForward customData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        AwardForm awardForm = (AwardForm)form;
        awardForm.getCustomDataHelper().prepareCustomData();
        return mapping.findForward("customData");
    }

    public ActionForward questions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("questions");
    }

    public ActionForward notesAndAttachments(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        AwardForm awardForm = (AwardForm)form;
        awardForm.getAwardCommentBean().setAwardCommentScreenDisplayTypesOnForm();
        awardForm.getAwardCommentBean().setAwardCommentHistoryFlags();
        this.setDisableAttachmentRemovalIndicator(((AwardForm)form).getAwardAttachmentFormBean());
        return mapping.findForward("notesAndAttachments");
    }

    protected void setDisableAttachmentRemovalIndicator(AwardAttachmentFormBean awardAttachmentForm) {
        if (awardAttachmentForm != null) {
            awardAttachmentForm.setDisableAttachmentRemovalIndicator(this.getParameterService().getParameterValueAsBoolean("KC-GEN", "Document", DISABLE_ATTACHMENT_REMOVAL));
        }
    }

    public ActionForward medusa(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        if (awardForm.getDocument().getDocumentNumber() == null) {
            this.loadDocumentInForm(request, awardForm);
        }
        awardForm.getMedusaBean().setMedusaViewRadio("0");
        awardForm.getMedusaBean().setModuleName("award");
        awardForm.getMedusaBean().setModuleIdentifier(awardForm.getAwardDocument().getAward().getAwardId());
        awardForm.getMedusaBean().generateParentNodes();
        return mapping.findForward("medusa");
    }

    public ActionForward awardActions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        String command = request.getParameter("command");
        if (StringUtils.isNotEmpty((CharSequence)command) && "displayDocSearchView".equals(command)) {
            this.loadDocumentInForm(request, awardForm);
            AwardDocument awardDocument = awardForm.getAwardDocument();
            if (!this.getDocumentHelperService().getDocumentAuthorizer((Document)awardDocument).canOpen((Document)awardDocument, GlobalVariables.getUserSession().getPerson())) {
                throw this.buildAuthorizationException("open", awardDocument);
            }
            WorkflowDocument workflowDoc = awardDocument.getDocumentHeader().getWorkflowDocument();
            if (workflowDoc != null) {
                awardForm.setDocTypeName(workflowDoc.getDocumentTypeName());
            }
            request.setAttribute(SELECTED_AWARD_NUMBER, (Object)awardDocument.getAward().getAwardNumber());
        }
        this.populateAwardHierarchy(form);
        return mapping.findForward("awardActions");
    }

    public ActionForward budgets(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        AwardForm awardForm = (AwardForm)form;
        String awardNumber = awardForm.getAwardDocument().getAward().getAwardNumber();
        this.getAwardService().findAwardsForAwardNumber(awardNumber).stream().forEach(award -> award.refreshReferenceObject(CURRENT_VERSION_BUDGETS));
        this.getAwardBudgetService().populateBudgetLimitSummary(awardForm.getBudgetLimitSummary(), awardForm.getAwardDocument().getAward());
        return mapping.findForward("budgets");
    }

    ActionForward handleLoadingDocument(ActionMapping mapping, AwardForm awardForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = null;
        String command = awardForm.getCommand();
        if ("awardActions".equals(command)) {
            this.loadDocument((KualiDocumentFormBase)awardForm);
        } else if ("budgets".equals(command)) {
            this.loadDocument((KualiDocumentFormBase)awardForm);
        } else if ("home".equals(command)) {
            this.loadDocument((KualiDocumentFormBase)awardForm);
        } else {
            forward = super.docHandler(mapping, (ActionForm)awardForm, request, response);
        }
        return forward;
    }

    ActionForward handleDocHandlerForwards(ActionMapping mapping, AwardForm awardForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = null;
        String command = awardForm.getCommand();
        if ("awardActions".equals(command)) {
            forward = this.awardActions(mapping, (ActionForm)awardForm, request, response);
        } else if ("budgets".equals(command)) {
            forward = this.budgets(mapping, (ActionForm)awardForm, request, response);
        } else if ("home".equals(command)) {
            forward = this.home(mapping, (ActionForm)awardForm, request, response);
        }
        return forward;
    }

    protected void loadDocumentInForm(HttpServletRequest request, AwardForm awardForm) throws WorkflowException {
        String docIdRequestParameter = request.getParameter("docId");
        AwardDocument retrievedDocument = (AwardDocument)KRADServiceLocatorWeb.getDocumentService().getByDocumentHeaderId(docIdRequestParameter);
        awardForm.setDocument(retrievedDocument);
        request.setAttribute("docId", (Object)docIdRequestParameter);
        this.handlePlaceHolderDocument(awardForm, retrievedDocument);
    }

    protected DocumentService getDocumentService() {
        return KRADServiceLocatorWeb.getDocumentService();
    }

    protected KualiRuleService getKualiRuleService() {
        return KcServiceLocator.getService(KualiRuleService.class);
    }

    public ActionForward syncAwardTemplate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        AwardDocument awardDocument = awardForm.getAwardDocument();
        String syncScopes = this.getSyncScopesString(request);
        if (awardDocument.getAward().getTemplateCode() == null || awardDocument.getAward().getAwardTemplate() == null) {
            GlobalVariables.getMessageMap().clearErrorMessages();
            GlobalVariables.getMessageMap().putError(StringUtils.isBlank((CharSequence)syncScopes) ? DOCUMENT_AWARD_AWARD_TEMPLATE : String.format("document.award.awardTemplate.%s", StringUtils.substring((String)syncScopes, (int)1)), "error.award.sponsor.template.notFound", new String[0]);
            awardForm.setOldTemplateCode(null);
            awardForm.setTemplateLookup(false);
            return mapping.findForward(BASIC);
        }
        String question = request.getParameter("questionIndex");
        if (question != null) {
            return this.processSyncAward(mapping, (ActionForm)awardForm, request, response);
        }
        awardForm.setCurrentSyncScopes(null);
        awardForm.setSyncRequiresConfirmationMap(null);
        if (StringUtils.isNotBlank((CharSequence)syncScopes) && syncScopes.length() > 1 && syncScopes.contains(":")) {
            String[] scopeStrings = StringUtils.split((String)StringUtils.substringAfter((String)syncScopes, (String)":"));
            AwardTemplateSyncScope[] scopes = new AwardTemplateSyncScope[scopeStrings.length];
            for (int i = 0; i < scopeStrings.length; ++i) {
                scopes[i] = Enum.valueOf(AwardTemplateSyncScope.class, scopeStrings[i]);
            }
            awardForm.setSyncRequiresConfirmationMap(this.generateScopeRequiresConfirmationMap(scopes, awardDocument, false, false));
            awardForm.setCurrentSyncScopes(scopes);
        } else {
            awardForm.setSyncRequiresConfirmationMap(this.generateScopeRequiresConfirmationMap(DEFAULT_AWARD_TEMPLATE_SYNC_SCOPES, awardDocument, false, false));
            awardForm.setCurrentSyncScopes(DEFAULT_AWARD_TEMPLATE_SYNC_SCOPES);
        }
        return this.processSyncAward(mapping, form, request, response);
    }

    private Map<AwardTemplateSyncScope, Boolean> generateScopeRequiresConfirmationMap(AwardTemplateSyncScope[] scopes, AwardDocument awardDocument, boolean skipCheck, boolean defaultValue) {
        AwardTemplateSyncService awardTemplateSyncService = KcServiceLocator.getService(AwardTemplateSyncService.class);
        HashMap<AwardTemplateSyncScope, Boolean> requiresQuestionMap = new HashMap<AwardTemplateSyncScope, Boolean>();
        for (AwardTemplateSyncScope scope : scopes) {
            if (skipCheck) {
                requiresQuestionMap.put(scope, defaultValue);
                continue;
            }
            if (awardTemplateSyncService.syncWillAlterData(awardDocument, scope)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("%s:%s", new Object[]{scope, true}));
                }
                requiresQuestionMap.put(scope, true);
                continue;
            }
            if (LOG.isDebugEnabled()) {
                LOG.warn(String.format("%s:%s", new Object[]{scope, false}));
            }
            requiresQuestionMap.put(scope, false);
        }
        return requiresQuestionMap;
    }

    public ActionForward fullSyncToAwardTemplate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        AwardDocument awardDocument = awardForm.getAwardDocument();
        if (awardDocument.getAward().getTemplateCode() == null || !this.isValidTemplateCode(awardDocument.getAward().getTemplateCode())) {
            GlobalVariables.getMessageMap().clearErrorMessages();
            GlobalVariables.getMessageMap().putError(DOCUMENT_AWARD_AWARD_TEMPLATE, "error.award.templateCode.notFound", new String[0]);
            awardForm.setOldTemplateCode(null);
            awardForm.setTemplateLookup(false);
            return mapping.findForward(BASIC);
        }
        awardDocument.getAward().refreshReferenceObject(AWARD_TEMPLATE);
        String question = request.getParameter("questionIndex");
        String buttonClicked = request.getParameter("buttonClicked");
        boolean proceedToProcessSyncAward = true;
        if (question == null) {
            AwardTemplateSyncScope[] scopes = new AwardTemplateSyncScope[]{AwardTemplateSyncScope.FULL};
            HashMap<AwardTemplateSyncScope, Boolean> confirmMap = new HashMap<AwardTemplateSyncScope, Boolean>();
            confirmMap.put(AwardTemplateSyncScope.FULL, true);
            awardForm.setCurrentSyncScopes(scopes);
            awardForm.setSyncRequiresConfirmationMap(confirmMap);
        } else if (("VerifySync:" + String.valueOf((Object)AwardTemplateSyncScope.FULL)).equals(question)) {
            if ("0".equals(buttonClicked)) {
                if (awardDocument.getAward().getSequenceNumber() > 1) {
                    awardForm.setCurrentSyncScopes(new AwardTemplateSyncScope[0]);
                    proceedToProcessSyncAward = false;
                    awardForm.setTemplateLookup(false);
                    awardForm.setOldTemplateCode(null);
                } else {
                    awardForm.setCurrentSyncScopes(DEFAULT_AWARD_TEMPLATE_SYNC_SCOPES);
                    awardForm.setSyncRequiresConfirmationMap(this.generateScopeRequiresConfirmationMap(DEFAULT_AWARD_TEMPLATE_SYNC_SCOPES, awardDocument, false, false));
                }
            } else {
                proceedToProcessSyncAward = false;
                awardDocument.getAward().setTemplateCode(awardForm.getOldTemplateCode());
                awardDocument.getAward().refreshReferenceObject(AWARD_TEMPLATE);
                awardForm.setOldTemplateCode(null);
                awardForm.setTemplateLookup(false);
            }
        }
        return proceedToProcessSyncAward ? this.processSyncAward(mapping, form, request, response) : mapping.findForward(BASIC);
    }

    protected boolean isValidTemplateCode(Integer templateCode) {
        return this.getBusinessObjectService().countMatching(AwardTemplate.class, Collections.singletonMap("templateCode", templateCode)) > 0;
    }

    protected StrutsConfirmation buildAwardSyncParameterizedConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String questionId, String ... params) throws Exception {
        StrutsConfirmation retval = new StrutsConfirmation();
        retval.setMapping(mapping);
        retval.setForm(form);
        retval.setRequest(request);
        retval.setResponse(response);
        retval.setQuestionId(questionId);
        retval.setQuestionType("confirmationQuestion");
        String questionText = COMFIRMATION_PARAM_STRING;
        for (int i = 0; i < params.length; ++i) {
            questionText = StringUtils.replace((String)questionText, (String)("{" + i + "}"), (String)params[i]);
        }
        retval.setQuestionText(questionText);
        return retval;
    }

    public ActionForward processSyncAward(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardTemplateSyncScope[] scopes;
        AwardTemplateSyncService awardTemplateSyncService = KcServiceLocator.getService(AwardTemplateSyncService.class);
        AwardForm awardForm = (AwardForm)form;
        AwardDocument awardDocument = awardForm.getAwardDocument();
        String question = request.getParameter("questionIndex");
        String buttonClicked = request.getParameter("buttonClicked");
        AwardTemplateSyncScope[] scopesList = scopes = awardForm.getCurrentSyncScopes();
        ConfigurationService kualiConfiguration = CoreApiServiceLocator.getKualiConfigurationService();
        for (AwardTemplateSyncScope currentScope : scopes) {
            if (!(question != null && StringUtils.equals((CharSequence)("VerifySync:" + String.valueOf((Object)currentScope)), (CharSequence)question) || !awardForm.getSyncRequiresConfirmationMap().get((Object)currentScope).booleanValue() || StringUtils.equals((CharSequence)("VerifyEmptySync:" + String.valueOf((Object)currentScope)), (CharSequence)question))) {
                String scopeSyncLabel = "";
                if (StringUtils.isNotEmpty((CharSequence)currentScope.getDisplayPropertyName())) {
                    scopeSyncLabel = kualiConfiguration.getPropertyValueAsString(currentScope.getDisplayPropertyName());
                }
                StrutsConfirmation confirmationQuestion = StringUtils.equals((CharSequence)scopeSyncLabel, (CharSequence)REPORTS_PROPERTY_NAME) || StringUtils.equals((CharSequence)scopeSyncLabel, (CharSequence)PAYMENT_INVOICES_PROPERTY_NAME) ? this.buildAwardSyncParameterizedConfirmationQuestion(mapping, form, request, response, "VerifySync:" + String.valueOf((Object)currentScope), scopeSyncLabel, awardDocument.getAward().getAwardTemplate().getDescription(), this.getScopeMessageToAddQuestion(currentScope)) : this.buildParameterizedConfirmationQuestion(mapping, form, request, response, "VerifySync:" + String.valueOf((Object)currentScope), currentScope.equals((Object)AwardTemplateSyncScope.FULL) ? "document.question.syncAll.text" : "document.question.syncPanel.text", scopeSyncLabel, awardDocument.getAward().getAwardTemplate().getDescription(), this.getScopeMessageToAddQuestion(currentScope));
                confirmationQuestion.setCaller(PROCESS_SYNC_AWARD);
                awardForm.setCurrentSyncQuestionId("VerifySync:" + String.valueOf((Object)currentScope));
                return this.performQuestionWithoutInput(confirmationQuestion, "");
            }
            if (StringUtils.equals((CharSequence)awardForm.getCurrentSyncQuestionId(), (CharSequence)question) && "0".equals(buttonClicked) || !awardForm.getSyncRequiresConfirmationMap().get((Object)currentScope).booleanValue()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("USER ACCEPTED SYNC OR NO CONFIRM REQUIRED FOR:" + String.valueOf((Object)currentScope) + " CALLING SYNC SERVICE.");
                }
                boolean templateHasScopedData = awardTemplateSyncService.templateContainsScopedData(awardDocument, currentScope);
                boolean scopeRequiresEmptyConfirm = ArrayUtils.contains((Object[])DEFAULT_SCOPES_REQUIRE_VERIFY_FOR_EMPTY, (Object)((Object)currentScope));
                if (awardDocument.getAward().getSequenceNumber() > 1 && !templateHasScopedData && StringUtils.equals((CharSequence)awardForm.getCurrentSyncQuestionId(), (CharSequence)("VerifySync:" + String.valueOf((Object)currentScope))) && scopeRequiresEmptyConfirm) {
                    String scopeSyncLabel = "";
                    if (StringUtils.isNotEmpty((CharSequence)currentScope.getDisplayPropertyName())) {
                        scopeSyncLabel = kualiConfiguration.getPropertyValueAsString(currentScope.getDisplayPropertyName());
                    }
                    StrutsConfirmation confirmationQuestion = this.buildParameterizedConfirmationQuestion(mapping, form, request, response, "VerifyEmptySync:" + String.valueOf((Object)currentScope), "document.question.syncPanelToEmpty.text", scopeSyncLabel, awardDocument.getAward().getAwardTemplate().getDescription());
                    awardForm.setCurrentSyncQuestionId("VerifyEmptySync:" + String.valueOf((Object)currentScope));
                    confirmationQuestion.setCaller(PROCESS_SYNC_AWARD);
                    return this.performQuestionWithoutInput(confirmationQuestion, "");
                }
                AwardTemplateSyncScope[] s = new AwardTemplateSyncScope[]{currentScope};
                awardTemplateSyncService.syncAwardToTemplate(awardDocument, s);
                scopesList = (AwardTemplateSyncScope[])ArrayUtils.remove((Object[])scopesList, (int)0);
                awardForm.setCurrentSyncScopes(scopesList);
                continue;
            }
            if (StringUtils.equals((CharSequence)awardForm.getCurrentSyncQuestionId(), (CharSequence)question) && "1".equals(buttonClicked)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("USER DECLINED " + String.valueOf((Object)currentScope) + ", SKIPPING.");
                }
                scopesList = (AwardTemplateSyncScope[])ArrayUtils.remove((Object[])scopesList, (int)0);
                awardForm.setCurrentSyncScopes(scopesList);
                continue;
            }
            throw new RuntimeException("Do not know what to do in this case!");
        }
        awardForm.setOldTemplateCode(null);
        awardForm.setTemplateLookup(false);
        awardForm.setCurrentSyncScopes(null);
        awardForm.setCurrentSyncQuestionId(null);
        awardForm.buildReportTrackingBeans();
        return mapping.findForward(BASIC);
    }

    private String getScopeMessageToAddQuestion(AwardTemplateSyncScope scope) {
        ConfigurationService configurationService = CoreApiServiceLocator.getKualiConfigurationService();
        String result = configurationService.getPropertyValueAsString("document.question.syncPanel.add.text." + String.valueOf((Object)scope));
        return result == null ? "" : result;
    }

    protected String getSyncScopesString(HttpServletRequest request) {
        String syncScopesList = null;
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((CharSequence)parameterName) && parameterName.contains(".scopes")) {
            syncScopesList = StringUtils.substringBetween((String)parameterName, (String)".scopes", (String)".anchor");
        }
        return syncScopesList;
    }

    protected SponsorHierarchyService getSponsorHierarchyService() {
        if (this.sponsorHierarchyService == null) {
            this.sponsorHierarchyService = KcServiceLocator.getService(SponsorHierarchyService.class);
        }
        return this.sponsorHierarchyService;
    }

    public void setSponsorHierarchyService(SponsorHierarchyService sponsorHierarchyService) {
        this.sponsorHierarchyService = sponsorHierarchyService;
    }

    protected PessimisticLockService getPessimisticLockService() {
        return KcServiceLocator.getService(AwardLockService.class);
    }

    protected VersionHistoryService getVersionHistoryService() {
        return KcServiceLocator.getService(VersionHistoryService.class);
    }

    public ActionForward performLookup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((CharSequence)parameterName) && parameterName.contains(".performLookup") && parameterName.contains("templateCode:document.award.templateCode")) {
            AwardForm awardForm = (AwardForm)form;
            awardForm.setTemplateLookup(true);
            ((AwardForm)form).setOldTemplateCode(((AwardForm)form).getAwardDocument().getAward().getTemplateCode());
        }
        return super.performLookup(mapping, form, request, response);
    }

    protected ActionForward confirmSyncAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, AwardSyncType syncType, PersistableBusinessObject object, String awardAttrName, String attrName, ActionForward returnForward) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        if (awardForm.isSyncMode()) {
            awardForm.getAwardSyncBean().setCurrentForward(returnForward);
            awardForm.getAwardSyncBean().addPendingChange(syncType, object, awardAttrName, attrName);
            return this.syncActionCaller(mapping, form, request, response);
        }
        return returnForward;
    }

    protected ActionForward confirmSyncAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, List<AwardSyncPendingChangeBean> pendingChanges, ActionForward returnForward) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        if (awardForm.isSyncMode()) {
            awardForm.getAwardSyncBean().setCurrentForward(returnForward);
            awardForm.getAwardSyncBean().getPendingChanges().addAll(pendingChanges);
            return this.syncActionCaller(mapping, form, request, response);
        }
        return returnForward;
    }

    public ActionForward syncActionCaller(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        String message = "document.question.awardhierarchy.sync";
        if (awardForm.getAwardSyncBean().getPendingChanges().get(0).getSyncType().equals((Object)AwardSyncType.DELETE_SYNC)) {
            message = "document.question.awardhierarchy.sync";
        }
        request.setAttribute("methodToCallAttribute", (Object)METHOD_TO_CALL_SYNC_ACTION_CALLER);
        ActionForward confirmAction = this.confirm(this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_SYNC_ACTION_KEY, message, new String[0]), CONFIRM_SYNC_ACTION, REFUSE_SYNC_ACTION);
        if (confirmAction != null) {
            return confirmAction;
        }
        return awardForm.getAwardSyncBean().getCurrentForward();
    }

    public ActionForward confirmSyncAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        AwardForm awardForm = (AwardForm)form;
        awardForm.getAwardSyncBean().confirmPendingChanges();
        return null;
    }

    public ActionForward refuseSyncAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        AwardForm awardForm = (AwardForm)form;
        awardForm.getAwardSyncBean().getPendingChanges().clear();
        return null;
    }

    protected AwardSyncCreationService getAwardSyncCreationService() {
        return KcServiceLocator.getService(AwardSyncCreationService.class);
    }

    protected AwardSyncService getAwardSyncService() {
        return KcServiceLocator.getService(AwardSyncService.class);
    }

    protected AwardBudgetService getAwardBudgetService() {
        if (this.awardBudgetService == null) {
            this.awardBudgetService = KcServiceLocator.getService(AwardBudgetService.class);
        }
        return this.awardBudgetService;
    }

    @Override
    protected void populateAuthorizationFields(KualiDocumentFormBase formBase) {
        AwardForm awardForm = (AwardForm)formBase;
        super.populateAuthorizationFields(formBase);
        AwardDocument awardDocument = awardForm.getAwardDocument();
        Award award = awardDocument.getAward();
        Map documentActions = formBase.getDocumentActions();
        if (award.getAwardAmountInfos().size() > 1 && (award.getAwardAmountInfos().size() != 2 || award.getAwardAmountInfos().get(0).getOriginatingAwardVersion() != null) && documentActions.containsKey("canCancel")) {
            documentActions.remove("canCancel");
        }
    }

    public AwardService getAwardService() {
        if (this.awardService == null) {
            this.awardService = KcServiceLocator.getService(AwardService.class);
        }
        return this.awardService;
    }

    public void setAwardService(AwardService awardService) {
        this.awardService = awardService;
    }

    public ReportTrackingService getReportTrackingService() {
        if (this.reportTrackingService == null) {
            this.reportTrackingService = KcServiceLocator.getService(ReportTrackingService.class);
        }
        return this.reportTrackingService;
    }

    protected void setSubAwardDetails(Award award) {
        award.setSubAwardList(this.getSubAwardService().getLinkedSubAwards(award));
    }

    protected KcNotificationService getNotificationService() {
        if (this.notificationService == null) {
            this.notificationService = KcServiceLocator.getService(KcNotificationService.class);
        }
        return this.notificationService;
    }

    public void setNotificationService(KcNotificationService notificationService) {
        this.notificationService = notificationService;
    }

    protected SubAwardService getSubAwardService() {
        if (this.subAwardService == null) {
            this.subAwardService = KcServiceLocator.getService(SubAwardService.class);
        }
        return this.subAwardService;
    }

    public void setSubAwardService(SubAwardService subAwardService) {
        this.subAwardService = subAwardService;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ActionForward superUserActionHelper(SuperUserAction actionName, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ActionForward forward = mapping.findForward(BASIC);
        AwardForm awardForm = (AwardForm)form;
        String question = request.getParameter("questionIndex");
        String buttonClicked = request.getParameter("buttonClicked");
        String methodToCall = ((KualiForm)form).getMethodToCall();
        awardForm.setAuditActivated(true);
        AuditHelper.ValidationState status = AuditHelper.ValidationState.OK;
        if (!awardForm.getDocument().getDocumentHeader().getWorkflowDocument().isEnroute()) {
            status = this.getAuditHelper().isValidSubmission(awardForm, true);
        }
        if (status == AuditHelper.ValidationState.WARNING) {
            if (question == null) {
                List selectedActionRequests = awardForm.getSelectedActionRequests();
                GlobalVariables.getUserSession().addObject(SUPER_USER_ACTION_REQUESTS, (Object)selectedActionRequests);
                try {
                    return this.performQuestionWithoutInput(mapping, form, request, response, DOCUMENT_ROUTE_QUESTION, "Validation Warning Exists. Are you sure want to submit to workflow routing.", "confirmationQuestion", methodToCall, "");
                }
                catch (Exception e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                    return forward;
                }
            } else {
                if (!DOCUMENT_ROUTE_QUESTION.equals(question) || !"0".equals(buttonClicked)) return forward;
                awardForm.setSelectedActionRequests((List)GlobalVariables.getUserSession().retrieveObject(SUPER_USER_ACTION_REQUESTS));
                GlobalVariables.getUserSession().removeObject(SUPER_USER_ACTION_REQUESTS);
                switch (actionName.ordinal()) {
                    case 0: {
                        return super.superUserApprove(mapping, (ActionForm)awardForm, request, response);
                    }
                    case 1: {
                        return super.takeSuperUserActions(mapping, (ActionForm)awardForm, request, response);
                    }
                }
            }
            return forward;
        } else if (status == AuditHelper.ValidationState.OK) {
            switch (actionName.ordinal()) {
                case 0: {
                    return super.superUserApprove(mapping, (ActionForm)awardForm, request, response);
                }
                case 1: {
                    return super.takeSuperUserActions(mapping, (ActionForm)awardForm, request, response);
                }
            }
            return forward;
        } else {
            GlobalVariables.getMessageMap().clearErrorMessages();
            GlobalVariables.getMessageMap().putError(DATA_VALIDATION, "error.workflow.submission", new String[0]);
            return forward;
        }
    }

    public ActionForward optimisticActionForward(ActionMapping mapping, ActionForm form, Callable<ActionForward> callable) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        Award award = awardForm.getAwardDocument().getAward();
        Award dbAward = (Award)this.getBusinessObjectService().findBySinglePrimaryKey(Award.class, (Object)award.getAwardId());
        if (Duration.between(dbAward.getUpdateTimestamp().toLocalDateTime(), award.getUpdateTimestamp().toLocalDateTime()).toSeconds() < -1L) {
            KNSGlobalVariables.getMessageList().add("error.document.optimisticLockException", new String[0]);
            GlobalVariables.getMessageMap().putError("noField", "error.document.optimisticLockException", new String[0]);
            return mapping.findForward(BASIC);
        }
        return callable.call();
    }

    public ActionForward superUserApprove(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.superUserActionHelper(SuperUserAction.SUPER_USER_APPROVE, mapping, form, request, response);
    }

    public ActionForward takeSuperUserActions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.superUserActionHelper(SuperUserAction.TAKE_SUPER_USER_ACTIONS, mapping, form, request, response);
    }

    public TimeAndMoneyVersionService getTimeAndMoneyVersionService() {
        if (this.timeAndMoneyVersionService == null) {
            this.timeAndMoneyVersionService = KcServiceLocator.getService(TimeAndMoneyVersionService.class);
        }
        return this.timeAndMoneyVersionService;
    }

    public void setTimeAndMoneyVersionService(TimeAndMoneyVersionService timeAndMoneyVersionService) {
        this.timeAndMoneyVersionService = timeAndMoneyVersionService;
    }

    protected TimeAndMoneyExistenceService getTimeAndMoneyExistenceService() {
        if (this.timeAndMoneyExistenceService == null) {
            this.timeAndMoneyExistenceService = KcServiceLocator.getService(TimeAndMoneyExistenceService.class);
        }
        return this.timeAndMoneyExistenceService;
    }

    protected TimeAndMoneyService getTimeAndMoneyService() {
        if (this.timeAndMoneyService == null) {
            this.timeAndMoneyService = KcServiceLocator.getService(TimeAndMoneyService.class);
        }
        return this.timeAndMoneyService;
    }

    protected void buildAwardHierarchySourceAndTargetList(AwardForm awardForm, Award currentAward) {
        ArrayList<String> order = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)awardForm.getAwardHierarchyTargetAwardNumber())) {
            awardForm.setAwardHierarchyTargetAwardNumber(currentAward.getAwardNumber());
        }
        HashMap<String, AwardHierarchyNode> awardHierarchyNodes = new HashMap<String, AwardHierarchyNode>();
        Map<String, AwardHierarchy> awardHierarchyItems = awardForm.getAwardHierarchyBean().getAwardHierarchy(awardForm.getAwardHierarchyTargetAwardNumber(), order);
        this.getAwardHierarchyService().populateAwardHierarchyNodes(awardHierarchyItems, awardHierarchyNodes, currentAward.getAwardNumber(), currentAward.getSequenceNumber().toString());
        StringBuilder sourceAwardStrList = new StringBuilder();
        StringBuilder targetAwardStrList = new StringBuilder();
        for (String str : order) {
            sourceAwardStrList.append("'").append(str).append("',");
            if (!((AwardHierarchyNode)awardHierarchyNodes.get(str)).isAwardDocumentFinalStatus().booleanValue()) continue;
            targetAwardStrList.append("'").append(str).append("',");
        }
        if (sourceAwardStrList.length() > 1) {
            awardForm.setAwardHierarchySourceAwardStrList(this.removeTrailingCommaIfExists(sourceAwardStrList.toString()));
        }
        if (targetAwardStrList.length() > 1) {
            awardForm.setAwardHierarchyTargetAwardStrList(this.removeTrailingCommaIfExists(targetAwardStrList.toString()));
        }
    }

    protected String removeTrailingCommaIfExists(String listStr) {
        String result = listStr;
        if (result.endsWith(",")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public ProjectPublisher getProjectPublisher() {
        if (this.projectPublisher == null) {
            this.projectPublisher = KcServiceLocator.getService(ProjectPublisher.class);
        }
        return this.projectPublisher;
    }

    public void setProjectPublisher(ProjectPublisher projectPublisher) {
        this.projectPublisher = projectPublisher;
    }

    public ProjectRetrievalService getProjectRetrievalService() {
        if (this.projectRetrievalService == null) {
            this.projectRetrievalService = (ProjectRetrievalService)KcServiceLocator.getService("awardProjectRetrievalService");
        }
        return this.projectRetrievalService;
    }

    public void setProjectRetrievalService(ProjectRetrievalService projectRetrievalService) {
        this.projectRetrievalService = projectRetrievalService;
    }

    public AwardCloseoutService getAwardCloseoutService() {
        if (this.awardCloseoutService == null) {
            this.awardCloseoutService = KcServiceLocator.getService(AwardCloseoutService.class);
        }
        return this.awardCloseoutService;
    }

    public void setAwardCloseoutService(AwardCloseoutService awardCloseoutService) {
        this.awardCloseoutService = awardCloseoutService;
    }

    private static enum SuperUserAction {
        SUPER_USER_APPROVE,
        TAKE_SUPER_USER_ACTIONS;

    }
}

