/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.excon.project.web.struts.action;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.coeus.common.framework.version.history.VersionHistory;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.excon.project.ExconProject;
import org.kuali.kra.excon.project.ExconProjectAssociatedDocument;
import org.kuali.kra.excon.project.ExconProjectAssociatedDocumentsBean;
import org.kuali.kra.excon.project.document.ExconProjectDocument;
import org.kuali.kra.excon.project.notification.ExconProjectAssociatedDocumentNotificationContext;
import org.kuali.kra.excon.project.notification.ExconProjectNotificationBean;
import org.kuali.kra.excon.project.notification.ExconProjectNotificationContext;
import org.kuali.kra.excon.project.service.ExconProjectAssociatedInfoBean;
import org.kuali.kra.excon.project.service.ExconProjectService;
import org.kuali.kra.excon.project.web.struts.action.ExconProjectAction;
import org.kuali.kra.excon.project.web.struts.form.ExconProjectForm;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.GlobalVariables;

public class ExconProjectHomeAction
extends ExconProjectAction {
    private static final String DOC_HANDLER_URL_PATTERN = "%s/DocHandler.do?command=displayDocSearchView&docId=%s";
    private static final String EXCON_PROJECT_VERSION_EDITPENDING_PROMPT_KEY = "message.excon.version.editpending.prompt";
    private static final String EXCON_STATUS_CHANGED_NOTIFICATION = "-3";
    private static final String EXCON_ASSOCIATION_LINK_CREATED_NOTIFICATION = "-4";
    private static final String EXCON_PROJECT_CREATED_NOTIFICATION = "-5";
    private transient ExconProjectService exconProjectService;

    @Override
    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ExconProjectForm exconForm = (ExconProjectForm)form;
        ExconProject exconProject = ((ExconProjectForm)form).getExconProject();
        boolean newProject = Objects.isNull(exconProject.getProjectId());
        if (StringUtils.isEmpty((CharSequence)exconProject.getTitle())) {
            exconProject.setTitle(exconProject.getProjectTypeCode());
        }
        boolean statusChanging = this.isStatusChanging(exconForm);
        List<ExconProjectAssociatedDocument> deletedAssociations = exconProject.getProjectId() != null ? this.getDeletedAssociations(((ExconProject)this.getBusinessObjectservice().findBySinglePrimaryKey(ExconProject.class, (Object)exconProject.getProjectId())).getExconProjectAssociatedDocuments(), exconProject.getExconProjectAssociatedDocuments()) : Collections.emptyList();
        ActionForward actionForward = super.save(mapping, form, request, response);
        if (exconProject.getProjectId() != null && GlobalVariables.getMessageMap().hasNoErrors()) {
            if (newProject) {
                exconForm.getQueuedNotifications().addLast(new ExconProjectNotificationBean(f -> new ExconProjectNotificationContext(f.getExconProject(), EXCON_PROJECT_CREATED_NOTIFICATION, "Export Control Created", "home")));
            }
            if (statusChanging) {
                exconForm.getQueuedNotifications().addLast(new ExconProjectNotificationBean(f -> new ExconProjectNotificationContext(f.getExconProject(), EXCON_STATUS_CHANGED_NOTIFICATION, "Export Control Status Changed", "home")));
            }
            this.createLinkCreatedNotifications(this.getExconProjectService().syncAssociatedDocuments(exconProject)).forEach(n -> exconForm.getQueuedNotifications().addLast((ExconProjectNotificationBean)n));
            this.getExconProjectService().deleteAssociatedDocumentLinks(exconProject.getProjectNumber(), deletedAssociations);
        }
        return actionForward;
    }

    private List<ExconProjectNotificationBean> createLinkCreatedNotifications(List<ExconProjectAssociatedInfoBean> infos) {
        return infos.stream().filter(i -> i.getSyncAction() == ExconProjectAssociatedInfoBean.SyncAction.CREATE).map(i -> new ExconProjectNotificationBean(f -> new ExconProjectAssociatedDocumentNotificationContext(f.getExconProject().getExconProjectAssociatedDocuments().stream().filter(ad -> ad.getProjectAssocDocId().equals(i.getProjectAssocDocId())).findFirst().orElseThrow(), EXCON_ASSOCIATION_LINK_CREATED_NOTIFICATION, "Export Control Document Association Link Created", "home"))).collect(Collectors.toList());
    }

    private List<ExconProjectAssociatedDocument> getDeletedAssociations(List<ExconProjectAssociatedDocument> previousAssociations, List<ExconProjectAssociatedDocument> currentAssociations) {
        return previousAssociations.stream().filter(pa -> !currentAssociations.contains(pa)).collect(Collectors.toList());
    }

    private boolean isStatusChanging(ExconProjectForm form) {
        return form.getExconProject().getProjectId() != null && Optional.ofNullable((ExconProject)this.getBusinessObjectService().findBySinglePrimaryKey(ExconProject.class, (Object)form.getExconProject().getProjectId())).filter(exconProject -> !StringUtils.equals((CharSequence)exconProject.getProjectStatusCode(), (CharSequence)form.getExconProject().getProjectStatusCode())).isPresent();
    }

    public ActionForward editOrVersion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String question;
        ExconProjectForm exconProjectForm = (ExconProjectForm)form;
        ExconProjectDocument exconProjectDocument = exconProjectForm.getExconProjectDocument();
        ExconProject exconproject = exconProjectDocument.getExconProject();
        VersionHistory foundPending = this.findPendingVersion(exconproject);
        ActionForward forward = foundPending != null ? ((question = request.getParameter("buttonClicked")) == null ? this.showPromptForEditingPendingVersion(mapping, form, request, response) : this.processPromptForEditingPendingVersionResponse(mapping, request, response, exconProjectForm, foundPending)) : this.createAndSaveNewExconProjectVersion(exconProjectForm);
        return forward;
    }

    private VersionHistory findPendingVersion(ExconProject exconproject) {
        List<VersionHistory> histories = this.getVersionHistoryService().loadVersionHistory(ExconProject.class, exconproject.getProjectNumber());
        VersionHistory foundPending = null;
        for (VersionHistory history : histories) {
            if (history.getStatus() != VersionStatus.PENDING || exconproject.getSequenceNumber() >= history.getSequenceOwnerSequenceNumber()) continue;
            foundPending = history;
            break;
        }
        return foundPending;
    }

    private ActionForward showPromptForEditingPendingVersion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.performQuestionWithoutInput(mapping, form, request, response, "EDIT_OR_VERSION_QUESTION_ID", this.getResources(request).getMessage(EXCON_PROJECT_VERSION_EDITPENDING_PROMPT_KEY), "confirmationQuestion", "cancel", "");
    }

    private ActionForward processPromptForEditingPendingVersionResponse(ActionMapping mapping, HttpServletRequest request, HttpServletResponse response, ExconProjectForm exconProjectForm, VersionHistory foundPending) throws WorkflowException, IOException {
        ActionForward forward;
        String buttonClicked = request.getParameter("buttonClicked");
        if ("1".equals(buttonClicked)) {
            forward = mapping.findForward("basic");
        } else {
            this.initializeFormWithExconProject(exconProjectForm, (ExconProject)foundPending.getSequenceOwner());
            response.sendRedirect(this.makeDocumentOpenUrl(exconProjectForm.getExconProjectDocument()));
            forward = null;
        }
        return forward;
    }

    private void initializeFormWithExconProject(ExconProjectForm exconProjectForm, ExconProject exconProject) throws WorkflowException {
        this.reinitializeExconProjectForm(exconProjectForm, this.findDocumentForExconProject(exconProject));
    }

    private ExconProjectDocument findDocumentForExconProject(ExconProject exconProject) throws WorkflowException {
        ExconProjectDocument document = (ExconProjectDocument)this.getDocumentService().getByDocumentHeaderId(exconProject.getExconProjectDocument().getDocumentNumber());
        document.setExconProject(exconProject);
        return document;
    }

    private void reinitializeExconProjectForm(ExconProjectForm exconProjectForm, ExconProjectDocument document) {
        exconProjectForm.populateHeaderFields(document.getDocumentHeader().getWorkflowDocument());
        exconProjectForm.setDocument(document);
        document.setDocumentSaveAfterExconProjectLookupEditOrVersion(true);
        exconProjectForm.initialize();
    }

    private String makeDocumentOpenUrl(ExconProjectDocument newExconProjectDocument) {
        String workflowUrl = this.getKualiConfigurationService().getPropertyValueAsString("workflow.url");
        return String.format(DOC_HANDLER_URL_PATTERN, workflowUrl, newExconProjectDocument.getDocumentNumber());
    }

    private ActionForward createAndSaveNewExconProjectVersion(ExconProjectForm exconProjectForm) throws WorkflowException {
        ExconProjectDocument newExconProjectDocument = this.getExconProjectService().createNewExconProjectVersion(exconProjectForm.getExconProjectDocument());
        this.getDocumentService().saveDocument((Document)newExconProjectDocument);
        this.getExconProjectService().updateExconProjectSequenceStatus(newExconProjectDocument.getExconProject(), VersionStatus.PENDING);
        this.getVersionHistoryService().updateVersionHistory(newExconProjectDocument.getExconProject(), VersionStatus.PENDING, GlobalVariables.getUserSession().getPrincipalName());
        this.reinitializeExconProjectForm(exconProjectForm, newExconProjectDocument);
        return new ActionForward(this.makeDocumentOpenUrl(newExconProjectDocument), true);
    }

    public ActionForward addAssociatedDocumentStub(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.getExconProjectAssociatedDocumentsBean(form).reInitDocument();
        return mapping.findForward("basic");
    }

    public ActionForward deleteAssociatedDocumentStub(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.getExconProjectAssociatedDocumentsBean(form).getNewAssociatedDocument().setAssocDocTypeCode(null);
        return mapping.findForward("basic");
    }

    public ActionForward addAssociatedDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.getExconProjectAssociatedDocumentsBean(form).addExconProjectAssociatedDocument();
        return mapping.findForward("basic");
    }

    public ActionForward deleteAssociatedDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.getExconProjectAssociatedDocumentsBean(form).deleteExconProjectAssociatedDocument(this.getLineToDelete(request));
        return mapping.findForward("basic");
    }

    private ExconProjectAssociatedDocumentsBean getExconProjectAssociatedDocumentsBean(ActionForm form) {
        return ((ExconProjectForm)form).getExconProjectAssociatedDocumentsBean();
    }

    @Override
    public ExconProjectService getExconProjectService() {
        if (this.exconProjectService == null) {
            this.exconProjectService = KcServiceLocator.getService(ExconProjectService.class);
        }
        return this.exconProjectService;
    }

    @Override
    public void setExconProjectService(ExconProjectService exconProjectService) {
        this.exconProjectService = exconProjectService;
    }
}

