/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.negotiations.printing.xmlstream;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.kuali.coeus.common.framework.print.stream.xml.XmlStream;
import org.kuali.coeus.common.framework.type.ProposalType;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.kra.negotiations.bo.Negotiable;
import org.kuali.kra.negotiations.bo.Negotiation;
import org.kuali.kra.negotiations.bo.NegotiationActivity;
import org.kuali.kra.negotiations.bo.NegotiationAssociationType;
import org.kuali.kra.negotiations.bo.NegotiationUnassociatedDetail;
import org.kuali.kra.negotiations.printing.NegotiationActivityPrintType;
import org.kuali.kra.printing.schema.ActivitiesType;
import org.kuali.kra.printing.schema.ActivityTypes;
import org.kuali.kra.printing.schema.LeadUnitType;
import org.kuali.kra.printing.schema.NegotiationDataType;
import org.kuali.kra.printing.schema.NegotiationsDocument;
import org.kuali.kra.printing.schema.ProposalTypes;
import org.kuali.kra.printing.schema.SponsorTypes;
import org.kuali.kra.printing.schema.StatusType;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.krad.service.BusinessObjectService;

public class NegotiationActivityXmlStream
implements XmlStream<NegotiationsDocument> {
    private static final String PROP_LOG = "PL";
    private static final String PROP_TYPE_CODE = "PROPOSAL_TYPE_CODE";
    private Negotiation negotiation;
    private DateTimeService dateTimeService;
    private BusinessObjectService businessObjectService;

    @Override
    public Class<NegotiationsDocument> type() {
        return NegotiationsDocument.class;
    }

    @Override
    public Map<String, NegotiationsDocument> generateXmlStream(KcPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) {
        LinkedHashMap<String, NegotiationsDocument> xmlObjectList = new LinkedHashMap<String, NegotiationsDocument>();
        NegotiationsDocument negotiationsDocument = (NegotiationsDocument)NegotiationsDocument.Factory.newInstance();
        this.initialize((Negotiation)printableBusinessObject);
        negotiationsDocument.setNegotiations(this.getNegotiations());
        xmlObjectList.put(NegotiationActivityPrintType.NEGOTIATION_ACTIVITY_REPORT.getNegotiationActivityPrintType(), negotiationsDocument);
        return xmlObjectList;
    }

    private void initialize(Negotiation negotiation) {
        this.negotiation = negotiation;
    }

    protected NegotiationsDocument.Negotiations getNegotiations() {
        NegotiationsDocument.Negotiations negotiations = (NegotiationsDocument.Negotiations)NegotiationsDocument.Negotiations.Factory.newInstance();
        ArrayList<NegotiationDataType> negotiationDataList = new ArrayList<NegotiationDataType>();
        negotiationDataList.add(this.getNegotiationDataType());
        negotiations.setNegotiationDataArray(negotiationDataList.toArray(new NegotiationDataType[0]));
        return negotiations;
    }

    protected NegotiationDataType getNegotiationDataType() {
        NegotiationDataType negotiationDataType = (NegotiationDataType)NegotiationDataType.Factory.newInstance();
        NegotiationAssociationType negotiationAssociationType = this.negotiation.getNegotiationAssociationType();
        if (this.negotiation.getNegotiator() != null) {
            negotiationDataType.setNegotiator(this.negotiation.getNegotiator().getFullName());
        }
        if (this.negotiation.getNegotiationStartDate() != null) {
            negotiationDataType.setStartDate(this.getDateTimeService().getCalendar((Date)this.negotiation.getNegotiationStartDate()));
        }
        Calendar cal = this.getDateTimeService().getCurrentCalendar();
        negotiationDataType.setCurrentDate(cal);
        if (this.negotiation.getNegotiationStatus() != null) {
            StatusType statusType = (StatusType)StatusType.Factory.newInstance();
            statusType.setStatusDesc(this.negotiation.getNegotiationStatus().getDescription());
            negotiationDataType.setStatus(statusType);
        }
        if (this.negotiation.getUnAssociatedDetail() != null) {
            this.setUnAssociatedDetails(negotiationDataType);
        } else if (this.negotiation.getAssociatedDocument() != null) {
            this.setAssociatedDetails(negotiationDataType);
        }
        if (negotiationAssociationType != null && negotiationAssociationType.getCode().equals(PROP_LOG)) {
            negotiationDataType.setProposalNumber(this.negotiation.getAssociatedNegotiable().getAssociatedDocumentId());
            ProposalTypes proposalTypes = (ProposalTypes)ProposalTypes.Factory.newInstance();
            proposalTypes.setProposalTypeDesc(this.getProposalTypeDescription(Integer.parseInt(this.negotiation.getAssociatedNegotiable().getNegotiableProposalTypeCode())));
            negotiationDataType.setProposalTypes(proposalTypes);
        }
        negotiationDataType.setDocFileAddress(this.negotiation.getDocumentFolder());
        negotiationDataType.setNegotiationId(this.negotiation.getNegotiationId().toString());
        this.setActivitiesType(negotiationDataType);
        return negotiationDataType;
    }

    private void setUnAssociatedDetails(NegotiationDataType negotiationDataType) {
        NegotiationUnassociatedDetail negotiationUnassociatedDetail = this.negotiation.getUnAssociatedDetail();
        negotiationDataType.setTitle(negotiationUnassociatedDetail.getTitle());
        negotiationDataType.setInvestigator(negotiationUnassociatedDetail.getPiName());
        if (negotiationUnassociatedDetail.getLeadUnit() != null) {
            LeadUnitType leadUnitType = (LeadUnitType)LeadUnitType.Factory.newInstance();
            leadUnitType.setUnitNumber(negotiationUnassociatedDetail.getLeadUnit().getUnitNumber());
            leadUnitType.setUnitName(negotiationUnassociatedDetail.getLeadUnit().getUnitName());
            negotiationDataType.setLeadUnit(leadUnitType);
        }
        if (negotiationUnassociatedDetail.getSponsor() != null) {
            SponsorTypes sponsorTypes = (SponsorTypes)SponsorTypes.Factory.newInstance();
            sponsorTypes.setSponsorName(negotiationUnassociatedDetail.getSponsor().getSponsorName());
            sponsorTypes.setSponsorCode(negotiationUnassociatedDetail.getSponsorCode());
            negotiationDataType.setSponsor(sponsorTypes);
        }
        if (negotiationUnassociatedDetail.getContactAdmin() != null) {
            negotiationDataType.setContractAdmin(negotiationUnassociatedDetail.getContactAdmin().getFullName());
        }
    }

    private void setAssociatedDetails(NegotiationDataType negotiationDataType) {
        Negotiable negotiable = this.negotiation.getAssociatedDocument();
        LeadUnitType leadUnitType = (LeadUnitType)LeadUnitType.Factory.newInstance();
        leadUnitType.setUnitNumber(negotiable.getLeadUnitNumber());
        leadUnitType.setUnitName(negotiable.getLeadUnitName());
        negotiationDataType.setLeadUnit(leadUnitType);
        SponsorTypes sponsorTypes = (SponsorTypes)SponsorTypes.Factory.newInstance();
        sponsorTypes.setSponsorName(negotiable.getSponsorName());
        sponsorTypes.setSponsorCode(negotiable.getSponsorCode());
        negotiationDataType.setSponsor(sponsorTypes);
        negotiationDataType.setTitle(negotiable.getTitle());
        negotiationDataType.setInvestigator(negotiable.getPiName());
        negotiationDataType.setContractAdmin(negotiable.getAdminPersonName());
    }

    private void setActivitiesType(NegotiationDataType negotiationDataType) {
        ArrayList<ActivitiesType> activitiesTypeList = new ArrayList<ActivitiesType>();
        List<NegotiationActivity> negotiationActivities = this.negotiation.getActivities();
        if (this.negotiation.getPrintindex() == 0) {
            for (NegotiationActivity negotiationActivity : negotiationActivities) {
                if (!this.negotiation.isPrintAll() && negotiationActivity.getEndDate() != null) continue;
                activitiesTypeList.add(this.getActivitiesType(negotiationActivity));
            }
        } else {
            activitiesTypeList.add(this.getActivitiesType(negotiationActivities.get(this.negotiation.getPrintindex() - 1)));
        }
        negotiationDataType.setActivitiesArray(activitiesTypeList.toArray(new ActivitiesType[0]));
    }

    private ActivitiesType getActivitiesType(NegotiationActivity negotiationActivity) {
        ActivitiesType activitiesType = (ActivitiesType)ActivitiesType.Factory.newInstance();
        activitiesType.setDescription(negotiationActivity.getDescription());
        if (negotiationActivity.getCreateDate() != null) {
            activitiesType.setCreateDate(this.getDateTimeService().getCalendar((Date)negotiationActivity.getCreateDate()));
        }
        if (negotiationActivity.getFollowupDate() != null) {
            activitiesType.setFollowupDate(this.getDateTimeService().getCalendar((Date)negotiationActivity.getFollowupDate()));
        }
        activitiesType.setLastDate(this.getDateTimeService().getCalendar((Date)negotiationActivity.getLastModifiedDate()));
        activitiesType.setUpdatedBy(negotiationActivity.getLastModifiedUser().getFullName());
        if (negotiationActivity.getStartDate() != null) {
            activitiesType.setActivityDate(this.getDateTimeService().getCalendar((Date)negotiationActivity.getStartDate()));
        }
        ActivityTypes activityTypes = (ActivityTypes)ActivityTypes.Factory.newInstance();
        activityTypes.setActivityDesc(negotiationActivity.getActivityType().getDescription());
        activitiesType.setActivity(activityTypes);
        return activitiesType;
    }

    private String getProposalTypeDescription(int proposalTypeCode) {
        String proposalTypeDescription = null;
        HashMap<String, String> proposalTypeDescMap = new HashMap<String, String>();
        proposalTypeDescMap.put(PROP_TYPE_CODE, String.valueOf(proposalTypeCode));
        List proposalTypeList = this.getBusinessObjectService().findMatching(ProposalType.class, proposalTypeDescMap);
        if (proposalTypeList != null && !proposalTypeList.isEmpty()) {
            ProposalType proposalType = (ProposalType)proposalTypeList.get(0);
            proposalTypeDescription = proposalType.getDescription();
        }
        return proposalTypeDescription;
    }

    public Negotiation getNegotiation() {
        return this.negotiation;
    }

    public void setNegotiation(Negotiation negotiation) {
        this.negotiation = negotiation;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }
}

