/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.workflow;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kew.api.action.ActionTaken;
import org.kuali.rice.kew.api.action.ActionType;
import org.kuali.rice.kew.api.document.WorkflowDocumentService;
import org.kuali.rice.kim.api.role.RoleMembership;
import org.kuali.rice.kns.kim.role.DerivedRoleTypeServiceBase;

public class PastApproversDerivedRoleTypeServiceImpl
extends DerivedRoleTypeServiceBase {
    private WorkflowDocumentService workflowDocumentService;

    public List<RoleMembership> getRoleMembersFromDerivedRole(String namespaceCode, String roleName, Map<String, String> qualification) {
        List actions;
        this.validateRequiredAttributesAgainstReceived(qualification);
        ArrayList<RoleMembership> members = new ArrayList<RoleMembership>();
        String documentNumber = qualification.get("documentNumber");
        if (documentNumber != null && (actions = this.getWorkflowDocumentService().getAllActionsTaken(documentNumber)) != null && !actions.isEmpty()) {
            for (ActionTaken action : actions) {
                if (action.getActionTaken() != ActionType.APPROVE) continue;
                members.add(RoleMembership.Builder.create(null, null, (String)action.getPrincipalId(), (MemberType)MemberType.PRINCIPAL, null).build());
            }
        }
        return members;
    }

    public boolean hasDerivedRole(String principalId, List<String> groupIds, String namespaceCode, String roleName, Map<String, String> qualification) {
        List<RoleMembership> members = this.getRoleMembersFromDerivedRole(namespaceCode, roleName, qualification);
        for (RoleMembership member : members) {
            if (!StringUtils.equals((CharSequence)member.getMemberId(), (CharSequence)principalId)) continue;
            return true;
        }
        return false;
    }

    public WorkflowDocumentService getWorkflowDocumentService() {
        return this.workflowDocumentService;
    }

    public void setWorkflowDocumentService(WorkflowDocumentService workflowDocumentService) {
        this.workflowDocumentService = workflowDocumentService;
    }

    public boolean dynamicRoleMembership(String namespaceCode, String roleName) {
        return true;
    }
}

