/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.home;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.auth.perm.KcAuthorizationService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.AwardLimitedEditAuthorizationService;
import org.kuali.kra.award.infrastructure.AwardPermissionConstants;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;

public class AwardLimitedEditAuthorizationServiceImpl
implements AwardLimitedEditAuthorizationService {
    private ParameterService parameterService;
    private KcAuthorizationService kcAuthorizationService;

    @Override
    public List<String> getLimitedEditabilityAwardSponsorContactTypes() {
        return this.getLimitedEditabilityParameterValues("LIMITED_EDITABILITY_AWARD_SPONSOR_CONTACT_TYPES");
    }

    @Override
    public List<String> getLimitedEditabilityAwardAttachmentTypes() {
        return this.getLimitedEditabilityParameterValues("LIMITED_EDITABILITY_AWARD_ATTACHMENT_TYPES");
    }

    @Override
    public List<String> getLimitedEditabilityAwardReportClasses() {
        return this.getLimitedEditabilityParameterValues("LIMITED_EDITABILITY_REPORT_CLASSES");
    }

    private List<String> getLimitedEditabilityParameterValues(String parameterName) {
        String value = this.getParameterService().getParameterValueAsString("KC-AWARD", "Document", parameterName);
        if (StringUtils.isBlank((CharSequence)value)) {
            return Collections.emptyList();
        }
        return Arrays.stream(value.split(",")).filter(StringUtils::isNotBlank).map(String::trim).distinct().collect(Collectors.toList());
    }

    @Override
    public boolean canLimitedModifyAwardSponsorContacts(AwardDocument awardDocument, String principalId) {
        return this.canLimitedModifyAward(awardDocument, principalId, AwardPermissionConstants.LIMITED_MODIFY_AWARD_SPONSOR_CONTACTS.getAwardPermission());
    }

    @Override
    public boolean canLimitedModifyAwardAttachments(AwardDocument awardDocument, String principalId) {
        return this.canLimitedModifyAward(awardDocument, principalId, AwardPermissionConstants.LIMITED_MODIFY_AWARD_ATTACHMENTS.getAwardPermission());
    }

    @Override
    public boolean canLimitedModifyAwardReportClasses(AwardDocument awardDocument, String principalId) {
        return this.canLimitedModifyAward(awardDocument, principalId, AwardPermissionConstants.LIMITED_MODIFY_AWARD_REPORT_CLASSES.getAwardPermission());
    }

    @Override
    public boolean canLimitedModifyAwardNotes(AwardDocument awardDocument, String principalId) {
        return this.canLimitedModifyAward(awardDocument, principalId, AwardPermissionConstants.LIMITED_MODIFY_AWARD_NOTES.getAwardPermission());
    }

    private boolean canLimitedModifyAward(AwardDocument awardDocument, String principalId, String permissionName) {
        return awardDocument != null && this.getKcAuthorizationService().hasPermission(principalId, awardDocument, permissionName) && awardDocument.getDocumentHeader().getWorkflowDocument().isFinal();
    }

    public ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public KcAuthorizationService getKcAuthorizationService() {
        if (this.kcAuthorizationService == null) {
            this.kcAuthorizationService = KcServiceLocator.getService(KcAuthorizationService.class);
        }
        return this.kcAuthorizationService;
    }

    public void setKcAuthorizationService(KcAuthorizationService kcAuthorizationService) {
        this.kcAuthorizationService = kcAuthorizationService;
    }
}

