/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.framework.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.kuali.coeus.common.budget.framework.core.Account;
import org.kuali.coeus.sys.framework.rule.KcMaintenanceDocumentRuleBase;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.util.ErrorMessage;

public class AccountDocumentMaintenanceRule
extends KcMaintenanceDocumentRuleBase {
    private static final String SOURCE_ACCOUNT_NUMBER = "accountNumber";
    private static final String ACCOUNT_NUMBER_TITLE = "Account number";
    private static final String NAME_KEY = "document.newMaintainableObject.accountNumber";
    public static final String ALPHA_NUMERIC_VALIDATION_PATTERN_KEY = "error.format.org.kuali.rice.kns.datadictionary.validation.charlevel.AlphaNumericValidationPattern";
    public static final String DESCRIPTION_KEY = "document.newMaintainableObject.description";
    public static final String DESCRIPTION = "description";
    private static final String DESCRIPTION_TITLE = "Account description";

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        Account account = (Account)document.getDocumentBusinessObject();
        Map errorMessages = this.getGlobalVariableService().getMessageMap().getErrorMessages();
        ArrayList<ErrorMessage> messages = new ArrayList<ErrorMessage>();
        if (Objects.nonNull(errorMessages.get(NAME_KEY))) {
            ((List)errorMessages.get(NAME_KEY)).remove(new ErrorMessage(ALPHA_NUMERIC_VALIDATION_PATTERN_KEY, new String[0]));
            messages.add(new ErrorMessage("error.format.org.kuali.rice.kns.datadictionary.validation.charlevel.AlphaNumericValidationPattern.allowUnderscore.allowDash.allowWhitespace", new String[]{ACCOUNT_NUMBER_TITLE}));
            errorMessages.put(NAME_KEY, messages);
        }
        if (Objects.nonNull(errorMessages.get(DESCRIPTION_KEY))) {
            messages = new ArrayList();
            ((List)errorMessages.get(DESCRIPTION_KEY)).remove(new ErrorMessage(ALPHA_NUMERIC_VALIDATION_PATTERN_KEY, new String[0]));
            messages.add(new ErrorMessage("error.format.org.kuali.rice.kns.datadictionary.validation.charlevel.AlphaNumericValidationPattern.allowUnderscore.allowDash.allowWhitespace.allowPeriod", new String[]{DESCRIPTION_TITLE}));
            errorMessages.put(DESCRIPTION_KEY, messages);
        }
        if (!document.getNewMaintainableObject().getMaintenanceAction().equals("Delete") && !document.getNewMaintainableObject().getMaintenanceAction().equals("Edit")) {
            return this.validate(account);
        }
        return Boolean.TRUE;
    }

    protected boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        if (!document.getNewMaintainableObject().getMaintenanceAction().equals("Delete") && !document.getNewMaintainableObject().getMaintenanceAction().equals("Edit")) {
            Account costShareSourceAccount = (Account)document.getDocumentBusinessObject();
            return this.validate(costShareSourceAccount);
        }
        return Boolean.TRUE;
    }

    protected boolean validate(Account account) {
        boolean valid;
        HashMap<String, String> pk = new HashMap<String, String>();
        pk.put(SOURCE_ACCOUNT_NUMBER, account.getAccountNumber());
        boolean bl = valid = this.getBoService().countMatching(Account.class, pk) == 0;
        if (!valid) {
            this.getGlobalVariableService().getMessageMap().putErrorWithoutFullErrorPath(NAME_KEY, "error.duplicate.element", new String[]{ACCOUNT_NUMBER_TITLE, account.getAccountNumber()});
        }
        return valid;
    }
}

