/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.hierarchy;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.common.budget.framework.personnel.HierarchyPersonnelSummary;
import org.kuali.coeus.common.framework.auth.perm.KcAuthorizationService;
import org.kuali.coeus.common.framework.keyword.ScienceKeyword;
import org.kuali.coeus.elasticsearch.ElasticsearchIndexService;
import org.kuali.coeus.propdev.impl.attachment.LegacyNarrativeService;
import org.kuali.coeus.propdev.impl.attachment.Narrative;
import org.kuali.coeus.propdev.impl.attachment.NarrativeType;
import org.kuali.coeus.propdev.impl.budget.ProposalBudgetService;
import org.kuali.coeus.propdev.impl.budget.ProposalDevelopmentBudgetExt;
import org.kuali.coeus.propdev.impl.budget.hierarchy.ProposalBudgetHierarchyService;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.hierarchy.HierarchyBudgetTypeConstants;
import org.kuali.coeus.propdev.impl.hierarchy.HierarchyProposalSummary;
import org.kuali.coeus.propdev.impl.hierarchy.HierarchyStatusConstants;
import org.kuali.coeus.propdev.impl.hierarchy.ProposalHierarchyDao;
import org.kuali.coeus.propdev.impl.hierarchy.ProposalHierarchyErrorWarningDto;
import org.kuali.coeus.propdev.impl.hierarchy.ProposalHierarchyException;
import org.kuali.coeus.propdev.impl.hierarchy.ProposalHierarchyService;
import org.kuali.coeus.propdev.impl.keyword.PropScienceKeyword;
import org.kuali.coeus.propdev.impl.location.CongressionalDistrict;
import org.kuali.coeus.propdev.impl.location.ProposalSite;
import org.kuali.coeus.propdev.impl.person.KeyPersonnelService;
import org.kuali.coeus.propdev.impl.person.ProposalPerson;
import org.kuali.coeus.propdev.impl.person.ProposalPersonDegree;
import org.kuali.coeus.propdev.impl.person.ProposalPersonUnit;
import org.kuali.coeus.propdev.impl.person.attachment.ProposalPersonBiography;
import org.kuali.coeus.propdev.impl.person.attachment.ProposalPersonBiographyAttachment;
import org.kuali.coeus.propdev.impl.person.attachment.ProposalPersonBiographyService;
import org.kuali.coeus.propdev.impl.person.creditsplit.ProposalPersonCreditSplit;
import org.kuali.coeus.propdev.impl.person.creditsplit.ProposalUnitCreditSplit;
import org.kuali.coeus.propdev.impl.s2s.S2sOppForms;
import org.kuali.coeus.propdev.impl.s2s.S2sOpportunity;
import org.kuali.coeus.propdev.impl.specialreview.ProposalSpecialReview;
import org.kuali.coeus.propdev.impl.sponsor.ProposalCfda;
import org.kuali.coeus.propdev.impl.state.ProposalState;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.model.KcDataObject;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.workflow.KcDocumentRejectionService;
import org.kuali.coeus.sys.framework.workflow.KewDocHeaderDao;
import org.kuali.kra.bo.DocumentNextvalue;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.criteria.OrderByField;
import org.kuali.rice.core.api.criteria.OrderDirection;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.actionrequest.ActionRequestFactory;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actionrequest.KimPrincipalRecipient;
import org.kuali.rice.kew.actionrequest.Recipient;
import org.kuali.rice.kew.actionrequest.service.ActionRequestService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.engine.node.service.RouteNodeService;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.routeheader.service.RouteHeaderService;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.data.CopyOption;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.DocumentBase;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.PessimisticLockService;
import org.kuali.rice.krad.util.ObjectUtils;
import org.kuali.rice.krad.workflow.service.WorkflowDocumentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Component(value="proposalHierarchyService")
@Transactional
public class ProposalHierarchyServiceImpl
implements ProposalHierarchyService {
    private static final Logger LOG = LogManager.getLogger(ProposalHierarchyServiceImpl.class);
    private static final String HIERARCHY_REJECTED_APPSTATUS = "message.proposalDevelopment.workflow.applicationStatus.rejected";
    private static final String HIERARCHY_ENROUTE_APPSTATUS = "message.proposalDevelopment.workflow.applicationStatus.enroute";
    private static final String HIERARCHY_CANCEL_APPSTATUS = "message.proposalDevelopment.workflow.applicationStatus.cancel";
    private static final String HIERARCHY_DISAPPROVE_APPSTATUS = "message.proposalDevelopment.workflow.applicationStatus.disapprove";
    private static final String HIERARCHY_PROCESSED_APPSTATUS = "message.proposalDevelopment.workflow.applicationStatus.processed";
    private static final String HIERARCHY_FINAL_APPSTATUS = "message.proposalDevelopment.workflow.applicationStatus.final";
    private static final String INITIATOR_COMPLETE_RESPONSIBILITY_DESCRIPTION = "Initiator needs to complete document.";
    private static final String PROPOSAL_ROUTING_RETURNED_ANNOTATION = "message.proposalDevelopment.workflow.annotation.rejected";
    private static final String PROPOSAL_DEVELOPMENT_DOCUMENT_TYPE = "ProposalDevelopmentDocument";
    private static final String DOCUMENT_NEXTVALUES = "documentNextvalues";
    private static final String HIERARCHY_STATUS = "hierarchyStatus";
    private static final String PROPOSAL_NUMBER = "proposalNumber";
    private static final String CODE = "code";
    private static final String COMPLETE = "C";
    private static final String NARRATIVE_TYPE = "narrativeType";
    private static final String HIERARCHY_PROPOSAL_NUMBER = "hierarchyProposalNumber";
    private static final String NARRATIVE_TYPE_CODE = "narrativeTypeCode";
    private static final String HIERARCHY_UNIT_SYNC = "HIERARCHY_UNIT_SYNC";
    @Autowired
    @Qualifier(value="actionRequestService")
    private ActionRequestService actionRequestService;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="documentService")
    private DocumentService documentService;
    @Autowired
    @Qualifier(value="kcAuthorizationService")
    private KcAuthorizationService kcAuthorizationService;
    @Autowired
    @Qualifier(value="proposalHierarchyDao")
    private ProposalHierarchyDao proposalHierarchyDao;
    @Autowired
    @Qualifier(value="legacyNarrativeService")
    private LegacyNarrativeService legacyNarrativeService;
    @Autowired
    @Qualifier(value="proposalPersonBiographyService")
    private ProposalPersonBiographyService proposalPersonBiographyService;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;
    @Autowired
    @Qualifier(value="kualiConfigurationService")
    private ConfigurationService kualiConfigurationService;
    @Autowired
    @Qualifier(value="kcDocumentRejectionService")
    private KcDocumentRejectionService kcDocumentRejectionService;
    @Autowired
    @Qualifier(value="kradWorkflowDocumentService")
    private WorkflowDocumentService kradWorkflowDocumentService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;
    @Autowired
    @Qualifier(value="pessimisticLockService")
    private PessimisticLockService pessimisticLockService;
    @Autowired
    @Qualifier(value="proposalBudgetHierarchyService")
    private ProposalBudgetHierarchyService proposalBudgetHierarchyService;
    @Autowired
    @Qualifier(value="keyPersonnelService")
    private KeyPersonnelService keyPersonnelService;
    @Autowired
    @Qualifier(value="routeHeaderService")
    private RouteHeaderService routeHeaderService;
    @Autowired
    @Qualifier(value="routeNodeService")
    protected RouteNodeService routeNodeService;
    @Autowired
    @Qualifier(value="proposalBudgetService")
    private ProposalBudgetService budgetService;
    @Autowired(required=false)
    @Qualifier(value="kewDocHeaderDao")
    private KewDocHeaderDao kewDocHeaderDao;
    @Autowired(required=false)
    @Qualifier(value="elasticsearchIndexService")
    private ElasticsearchIndexService elasticsearchIndexService;

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setKcAuthorizationService(KcAuthorizationService kcAuthorizationService) {
        this.kcAuthorizationService = kcAuthorizationService;
    }

    public void setProposalHierarchyDao(ProposalHierarchyDao proposalHierarchyDao) {
        this.proposalHierarchyDao = proposalHierarchyDao;
    }

    public void setLegacyNarrativeService(LegacyNarrativeService narrativeService) {
        this.legacyNarrativeService = narrativeService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setKualiConfigurationService(ConfigurationService kualiConfigurationService) {
        this.kualiConfigurationService = kualiConfigurationService;
    }

    @Override
    public DevelopmentProposal createHierarchy(DevelopmentProposal initialChild, String userId) {
        LOG.info(String.format("***Create Hierarchy using Proposal #%s", initialChild.getProposalNumber()));
        ProposalDevelopmentDocument newDoc = this.assembleDoc();
        DevelopmentProposal hierarchy = newDoc.getDevelopmentProposal();
        this.copyInitialData(hierarchy, initialChild);
        this.setHierarchyStatus(initialChild.getProposalDocument(), newDoc);
        this.addCreateDetails(newDoc);
        ProposalDevelopmentDocument hierarchyDoc = this.saveDocument(newDoc);
        this.copyProposalCfda(initialChild, hierarchyDoc.getDevelopmentProposal());
        if (initialChild.getS2sOpportunity() != null && !initialChild.getS2sOpportunity().isMultiProject()) {
            this.copyOpportunity(initialChild, hierarchyDoc.getDevelopmentProposal());
        }
        this.kcAuthorizationService.addDocumentLevelRole(userId, "Aggregator", hierarchyDoc);
        this.proposalBudgetHierarchyService.initializeBudget(hierarchyDoc.getDevelopmentProposal(), initialChild);
        this.linkChild(hierarchyDoc.getDevelopmentProposal(), initialChild, HierarchyBudgetTypeConstants.SubBudget.code(), false);
        this.setInitialPi(hierarchyDoc.getDevelopmentProposal(), initialChild);
        this.copyInitialAttachments(initialChild, hierarchyDoc.getDevelopmentProposal());
        LOG.info(String.format("***Initial Child (#%s) linked to Parent (#%s)", initialChild.getProposalNumber(), hierarchyDoc.getDevelopmentProposal().getProposalNumber()));
        this.finalizeHierarchySync(hierarchyDoc.getDevelopmentProposal());
        LOG.info(String.format("***Hierarchy creation (#%s) complete", hierarchyDoc.getDevelopmentProposal().getProposalNumber()));
        return hierarchyDoc.getDevelopmentProposal();
    }

    private void addCreateDetails(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        proposalDevelopmentDocument.getDevelopmentProposal().setCreateTimestamp(new Timestamp(System.currentTimeMillis()));
        proposalDevelopmentDocument.getDevelopmentProposal().setCreateUser(this.getGlobalVariableService().getUserSession().getLoggedInUserPrincipalName());
    }

    protected ProposalDevelopmentDocument saveDocument(ProposalDevelopmentDocument newDoc) {
        ProposalDevelopmentDocument hierarchyDoc;
        try {
            hierarchyDoc = (ProposalDevelopmentDocument)this.documentService.saveDocument((Document)newDoc);
        }
        catch (WorkflowException x) {
            throw new ProposalHierarchyException("Error saving new document: " + String.valueOf((Object)x));
        }
        return hierarchyDoc;
    }

    protected void setHierarchyStatus(ProposalDevelopmentDocument childDocument, ProposalDevelopmentDocument newDoc) {
        DevelopmentProposal hierarchy = newDoc.getDevelopmentProposal();
        hierarchy.setHierarchyStatus(HierarchyStatusConstants.Parent.code());
        String docDescription = childDocument.getDocumentHeader().getDocumentDescription();
        newDoc.getDocumentHeader().setDocumentDescription(docDescription);
        newDoc.setDevelopmentProposal(hierarchy);
        hierarchy.setProposalDocument(newDoc);
    }

    protected ProposalDevelopmentDocument assembleDoc() {
        ProposalDevelopmentDocument newDoc;
        try {
            WorkflowDocument workflowDocument = this.kradWorkflowDocumentService.createWorkflowDocument(PROPOSAL_DEVELOPMENT_DOCUMENT_TYPE, this.globalVariableService.getUserSession().getPerson());
            DocumentHeader documentHeader = new DocumentHeader();
            documentHeader.setWorkflowDocument(workflowDocument);
            documentHeader.setDocumentNumber(workflowDocument.getDocumentId());
            newDoc = new ProposalDevelopmentDocument();
            newDoc.setDocumentHeader(documentHeader);
            newDoc.setDocumentNumber(documentHeader.getDocumentNumber());
        }
        catch (WorkflowException x) {
            throw new ProposalHierarchyException("Error creating new document: " + String.valueOf((Object)x));
        }
        return newDoc;
    }

    @Override
    public void linkToHierarchy(DevelopmentProposal hierarchyProposal, DevelopmentProposal newChildProposal, String hierarchyBudgetTypeCode) throws ProposalHierarchyException {
        this.prepareHierarchySync(hierarchyProposal);
        this.linkChild(hierarchyProposal, newChildProposal, hierarchyBudgetTypeCode, true);
        this.finalizeHierarchySync(hierarchyProposal);
    }

    @Override
    public List<ProposalHierarchyErrorWarningDto> validateLinkToHierarchy(DevelopmentProposal hierarchyProposal, DevelopmentProposal childProposal) {
        ArrayList<ProposalHierarchyErrorWarningDto> errors = new ArrayList<ProposalHierarchyErrorWarningDto>();
        if (hierarchyProposal == null) {
            errors.add(new ProposalHierarchyErrorWarningDto("error.hierarchy.proposal.not.found", Boolean.TRUE, new String[0]));
            return errors;
        }
        if (!hierarchyProposal.isParent()) {
            errors.add(new ProposalHierarchyErrorWarningDto("error.hierarchy.proposal.not.hierarchy.parent", Boolean.TRUE, hierarchyProposal.getProposalNumber()));
        }
        if (childProposal.isInHierarchy()) {
            errors.add(new ProposalHierarchyErrorWarningDto("error.hierarchy.proposal.not.hierarchy.child", Boolean.TRUE, childProposal.getProposalNumber()));
        }
        errors.addAll(this.validateChildBudgetPeriods(hierarchyProposal, childProposal, true));
        errors.addAll(this.validateSponsor(childProposal, hierarchyProposal));
        errors.addAll(this.validateParent(hierarchyProposal, childProposal));
        errors.addAll(this.validateIsParentLocked(hierarchyProposal));
        errors.addAll(this.validateIsAggregatorOnParent(hierarchyProposal));
        List<ProposalHierarchyErrorWarningDto> sponsorErrors = this.validateSponsor(childProposal, hierarchyProposal);
        errors.addAll(sponsorErrors);
        return errors;
    }

    @Override
    public DevelopmentProposal removeFromHierarchy(DevelopmentProposal childProposal) throws ProposalHierarchyException {
        String hierarchyProposalNumber = childProposal.getHierarchyParentProposalNumber();
        DevelopmentProposal hierarchyProposal = this.getHierarchy(hierarchyProposalNumber);
        List<String> childProposalNumbers = this.proposalHierarchyDao.getHierarchyChildProposalNumbers(hierarchyProposalNumber);
        boolean isLast = childProposalNumbers.size() == 1 && StringUtils.equals((CharSequence)childProposalNumbers.get(0), (CharSequence)childProposal.getProposalNumber());
        childProposal.setHierarchyStatus(HierarchyStatusConstants.None.code());
        childProposal.setHierarchyParentProposalNumber(null);
        if (StringUtils.equalsIgnoreCase((CharSequence)hierarchyProposal.getHierarchyOriginatingChildProposalNumber(), (CharSequence)childProposal.getProposalNumber()) && hierarchyProposal.getPrincipalInvestigator() != null) {
            hierarchyProposal.getPrincipalInvestigator().setHierarchyProposalNumber(null);
        }
        this.removeChildElements(hierarchyProposal, childProposal.getProposalNumber());
        this.removeAllChildPersonnelFromParent(hierarchyProposal, childProposal);
        if (isLast) {
            try {
                childProposal = (DevelopmentProposal)this.dataObjectService.save((Object)childProposal, new PersistenceOption[0]);
                Document doc = this.documentService.getByDocumentHeaderId(hierarchyProposal.getProposalDocument().getDocumentNumber());
                this.documentService.cancelDocument(doc, "Removed last child from Proposal Hierarchy");
                return childProposal;
            }
            catch (WorkflowException e) {
                throw new ProposalHierarchyException("Error cancelling empty parent proposal", e);
            }
        }
        String lowestProposalNumber = "";
        for (String proposalNumber : childProposalNumbers) {
            if (StringUtils.equals((CharSequence)proposalNumber, (CharSequence)childProposal.getProposalNumber())) continue;
            lowestProposalNumber = proposalNumber;
            break;
        }
        hierarchyProposal.setHierarchyOriginatingChildProposalNumber(lowestProposalNumber);
        this.dataObjectService.save((Object)childProposal, new PersistenceOption[0]);
        this.dataObjectService.save((Object)hierarchyProposal, new PersistenceOption[0]);
        return childProposal;
    }

    protected void removeDeletedPersonnelFromParent(DevelopmentProposal hierarchyProposal, DevelopmentProposal childProposal) {
        Iterator<ProposalPerson> iterator = hierarchyProposal.getProposalPersons().iterator();
        while (iterator.hasNext()) {
            ProposalPerson person = iterator.next();
            if (!StringUtils.equals((CharSequence)person.getHierarchyProposalNumber(), (CharSequence)childProposal.getProposalNumber()) || childProposal.getProposalPersons().indexOf(person) != -1 || (!StringUtils.isNotBlank((CharSequence)person.getPersonId()) || this.employeePersonInMultipleProposals(person.getPersonId(), hierarchyProposal)) && (person.getRolodexId() == null || this.nonEmployeePersonInMultipleProposals(person.getRolodexId(), hierarchyProposal))) continue;
            if (person.getCertificationDetails() != null) {
                this.dataObjectService.delete((Object)person.getCertificationDetails());
            }
            iterator.remove();
            this.getProposalPersonBiographyService().removePersonnelAttachmentForDeletedPerson(hierarchyProposal.getProposalDocument(), person);
        }
    }

    protected void removeAllChildPersonnelFromParent(DevelopmentProposal hierarchyProposal, DevelopmentProposal childProposal) {
        for (ProposalPerson childPerson : childProposal.getProposalPersons()) {
            if ((!StringUtils.isNotBlank((CharSequence)childPerson.getPersonId()) || this.employeePersonInMultipleProposals(childPerson.getPersonId(), hierarchyProposal)) && (childPerson.getRolodexId() == null || this.nonEmployeePersonInMultipleProposals(childPerson.getRolodexId(), hierarchyProposal))) continue;
            Iterator<ProposalPerson> parentIterator = hierarchyProposal.getProposalPersons().iterator();
            while (parentIterator.hasNext()) {
                ProposalPerson parentPerson = parentIterator.next();
                if (!StringUtils.equals((CharSequence)childPerson.getPersonId(), (CharSequence)parentPerson.getPersonId())) continue;
                parentIterator.remove();
                this.getProposalPersonBiographyService().removePersonnelAttachmentForDeletedPerson(hierarchyProposal.getProposalDocument(), parentPerson);
            }
        }
    }

    @Override
    public void synchronizeAllChildren(DevelopmentProposal hierarchyProposal) throws ProposalHierarchyException {
        this.prepareHierarchySync(hierarchyProposal);
        this.synchronizeAll(hierarchyProposal);
        this.finalizeHierarchySync(hierarchyProposal);
        this.reinstateCollections(hierarchyProposal);
    }

    protected void reinstateCollections(DevelopmentProposal proposal) {
        this.reinstateDegreeInfo(proposal);
    }

    @Override
    public DevelopmentProposal getDevelopmentProposal(String proposalNumber) {
        return this.getProposalHierarchyDao().getDevelopmentProposal(proposalNumber);
    }

    @Override
    public ProposalState getProposalState(String proposalNumber) {
        return this.getProposalHierarchyDao().getProposalState(proposalNumber);
    }

    @Override
    public void synchronizeAll(DevelopmentProposal hierarchyProposal) throws ProposalHierarchyException {
        this.synchronizeAllChildProposals(hierarchyProposal);
    }

    @Override
    public void synchronizeChild(DevelopmentProposal childProposal) throws ProposalHierarchyException {
        DevelopmentProposal hierarchy = this.getHierarchy(childProposal.getHierarchyParentProposalNumber());
        this.prepareHierarchySync(hierarchy);
        this.synchronizeChildProposal(hierarchy, childProposal, true, this.getHierarchyChildren(hierarchy.getProposalNumber()));
        this.finalizeHierarchySync(hierarchy);
    }

    @Override
    public DevelopmentProposal lookupParent(DevelopmentProposal childProposal) throws ProposalHierarchyException {
        return this.getHierarchy(childProposal.getHierarchyParentProposalNumber());
    }

    @Override
    public void linkChild(DevelopmentProposal hierarchyProposal, DevelopmentProposal childProposal, String hierarchyBudgetTypeCode, boolean syncPersonnelAttachments) throws ProposalHierarchyException {
        childProposal.setHierarchyStatus(HierarchyStatusConstants.Child.code());
        childProposal.setHierarchyParentProposalNumber(hierarchyProposal.getProposalNumber());
        childProposal.setHierarchyBudgetType(hierarchyBudgetTypeCode);
        this.synchronizeChildProposal(hierarchyProposal, childProposal, syncPersonnelAttachments, this.getHierarchyChildren(hierarchyProposal.getProposalNumber()));
    }

    protected void copyInitialData(DevelopmentProposal hierarchyProposal, DevelopmentProposal srcProposal) throws ProposalHierarchyException {
        hierarchyProposal.setHierarchyOriginatingChildProposalNumber(srcProposal.getProposalNumber());
        hierarchyProposal.setSponsor(srcProposal.getSponsor());
        hierarchyProposal.setSponsorCode(srcProposal.getSponsorCode());
        hierarchyProposal.setProposalTypeCode(srcProposal.getProposalTypeCode());
        hierarchyProposal.setRequestedStartDateInitial(srcProposal.getRequestedStartDateInitial());
        hierarchyProposal.setRequestedEndDateInitial(srcProposal.getRequestedEndDateInitial());
        hierarchyProposal.setOwnedByUnit(srcProposal.getOwnedByUnit());
        hierarchyProposal.setOwnedByUnitNumber(srcProposal.getOwnedByUnitNumber());
        hierarchyProposal.setActivityType(srcProposal.getActivityType());
        hierarchyProposal.setActivityTypeCode(srcProposal.getActivityTypeCode());
        hierarchyProposal.setTitle(srcProposal.getTitle());
        hierarchyProposal.setDeadlineDate(srcProposal.getDeadlineDate());
        hierarchyProposal.setDeadlineTime(srcProposal.getDeadlineTime());
        hierarchyProposal.setDeadlineType(srcProposal.getDeadlineType());
        hierarchyProposal.setAnticipatedAwardTypeCode(srcProposal.getAnticipatedAwardTypeCode());
        hierarchyProposal.setNoticeOfOpportunityCode(srcProposal.getNoticeOfOpportunityCode());
        hierarchyProposal.setPrimeSponsorCode(srcProposal.getPrimeSponsorCode());
        hierarchyProposal.setNsfSequenceNumber(srcProposal.getNsfSequenceNumber());
        hierarchyProposal.setSponsorProposalNumber(srcProposal.getSponsorProposalNumber());
        hierarchyProposal.setAgencyDivisionCode(srcProposal.getAgencyDivisionCode());
        hierarchyProposal.setAgencyProgramCode(srcProposal.getAgencyProgramCode());
        hierarchyProposal.setSubcontracts(srcProposal.getSubcontracts());
        hierarchyProposal.setProgramAnnouncementNumber(srcProposal.getProgramAnnouncementNumber());
        hierarchyProposal.setProgramAnnouncementTitle(srcProposal.getProgramAnnouncementTitle());
        hierarchyProposal.getProposalSites().clear();
        for (ProposalSite site : srcProposal.getProposalSites()) {
            ProposalSite newSite = this.deepCopy(site);
            newSite.setDevelopmentProposal(null);
            for (CongressionalDistrict cd : newSite.getCongressionalDistricts()) {
                cd.setProposalSite(newSite);
            }
            hierarchyProposal.addProposalSite(newSite);
        }
        this.setDocumentNextValueForProposalSites(hierarchyProposal);
        hierarchyProposal.setMailBy(srcProposal.getMailBy());
        hierarchyProposal.setMailType(srcProposal.getMailType());
        hierarchyProposal.setMailAccountNumber(srcProposal.getMailAccountNumber());
        hierarchyProposal.setNumberOfCopies(srcProposal.getNumberOfCopies());
        hierarchyProposal.setMailingAddressId(srcProposal.getMailingAddressId());
        hierarchyProposal.setMailDescription(srcProposal.getMailDescription());
    }

    private void setDocumentNextValueForProposalSites(DevelopmentProposal hierarchyProposal) {
        List<DocumentNextvalue> documentNextValues = hierarchyProposal.getProposalDocument().getDocumentNextvalues();
        DocumentNextvalue documentNextvalue = new DocumentNextvalue();
        documentNextvalue.setPropertyName("proposalDevelopment.proposalLocation.locationSequenceNumber");
        documentNextvalue.setNextValue(hierarchyProposal.getProposalSites().size() + 1);
        documentNextvalue.setDocumentKey(hierarchyProposal.getProposalDocument().getDocumentNumber());
        documentNextValues.add(documentNextvalue);
        hierarchyProposal.getProposalDocument().setDocumentNextvalues(documentNextValues);
    }

    protected void copyOpportunity(DevelopmentProposal srcProposal, DevelopmentProposal hierarchyProposal) {
        if (srcProposal.hasS2sOpportunity()) {
            S2sOpportunity opportunity = this.deepCopy(srcProposal.getS2sOpportunity());
            opportunity.setDevelopmentProposal(hierarchyProposal);
            hierarchyProposal.setS2sOpportunity(opportunity);
            for (S2sOppForms form : opportunity.getS2sOppForms()) {
                form.getS2sOppFormsId().setProposalNumber(hierarchyProposal.getProposalNumber());
            }
        }
    }

    protected void copyProposalCfda(DevelopmentProposal srcProposal, DevelopmentProposal hierarchyProposal) {
        hierarchyProposal.setProposalCfdas(srcProposal.getProposalCfdas().stream().map(src -> {
            ProposalCfda cfda = new ProposalCfda();
            cfda.setCfdaNumber(src.getCfdaNumber());
            cfda.setCfdaDescription(src.getCfdaDescription());
            cfda.setProposalNumber(hierarchyProposal.getProposalNumber());
            return cfda;
        }).collect(Collectors.toList()));
    }

    protected <T extends KcDataObject> T deepCopy(T oldObject) {
        return (T)((KcDataObject)this.getDataObjectService().copyInstance(oldObject, new CopyOption[]{CopyOption.RESET_OBJECT_ID, CopyOption.RESET_PK_FIELDS, CopyOption.RESET_VERSION_NUMBER}));
    }

    @Override
    public boolean synchronizeAllChildProposals(DevelopmentProposal hierarchyProposal) throws ProposalHierarchyException {
        boolean changed = false;
        this.deleteAllMultipleInternal(hierarchyProposal);
        ProposalDevelopmentBudgetExt budget = this.proposalBudgetHierarchyService.getHierarchyBudget(hierarchyProposal);
        this.proposalBudgetHierarchyService.removeMergeableChildBudgetElements(budget);
        this.finalizeHierarchySync(hierarchyProposal.getProposalDocument());
        List<DevelopmentProposal> hierarchyChildren = this.getHierarchyChildren(hierarchyProposal.getProposalNumber());
        for (DevelopmentProposal childProposal : hierarchyChildren) {
            List<BudgetPeriod> oldBudgetPeriods = this.getOldBudgetPeriods(budget);
            ProposalPerson principalInvestigator = hierarchyProposal.getPrincipalInvestigator();
            childProposal.setHierarchyLastSyncHashCode(this.computeHierarchyHashCode(childProposal));
            this.removeChildElements(hierarchyProposal, childProposal.getProposalNumber());
            this.synchronizeKeywords(hierarchyProposal, childProposal);
            this.synchronizeSpecialReviews(hierarchyProposal, childProposal);
            this.synchronizePersons(hierarchyProposal, childProposal, principalInvestigator);
            this.synchronizeNarratives(hierarchyProposal, childProposal);
            this.addInternalAttachments(hierarchyProposal, childProposal);
            this.syncDegreeInfo(hierarchyProposal, childProposal);
            this.syncAllPersonnelAttachments(hierarchyProposal, childProposal);
            this.proposalBudgetHierarchyService.synchronizeChildBudget(hierarchyProposal, childProposal, oldBudgetPeriods);
            this.dataObjectService.save((Object)childProposal, new PersistenceOption[0]);
            changed = true;
        }
        this.synchronizePersonUnits(hierarchyChildren, hierarchyProposal);
        return changed;
    }

    protected boolean isUnitSyncEnabled() {
        return this.getParameterService().getParameterValueAsBoolean("KC-PD", "All", HIERARCHY_UNIT_SYNC);
    }

    protected void synchronizePersonUnits(List<DevelopmentProposal> hierarchyChildren, DevelopmentProposal parentProposal) {
        if (this.isUnitSyncEnabled() && hierarchyChildren != null) {
            Map personUnits = hierarchyChildren.stream().flatMap(childProposal -> childProposal.getProposalPersons().stream()).flatMap(proposalPerson -> proposalPerson.getUnits().stream()).collect(Collectors.groupingBy(proposalPersonUnit -> proposalPersonUnit.getProposalPerson().getPersonId(), Collectors.mapping(ProposalPersonUnit::getUnitNumber, Collectors.toSet())));
            if (parentProposal.getProposalPersons() != null) {
                parentProposal.getProposalPersons().stream().filter(parentPerson -> personUnits.containsKey(parentPerson.getPersonId())).forEach(parentPerson -> {
                    parentPerson.setUnits(new ArrayList<ProposalPersonUnit>());
                    ((Set)personUnits.get(parentPerson.getPersonId())).forEach(unitNumber -> this.keyPersonnelService.addUnitToPerson((ProposalPerson)parentPerson, this.keyPersonnelService.createProposalPersonUnit((String)unitNumber, (ProposalPerson)parentPerson)));
                });
            }
        }
    }

    protected void deleteAllMultipleInternal(DevelopmentProposal proposal) {
        List<Narrative> narrativesToRemove = proposal.getInstituteAttachments().stream().filter(narrative -> narrative.getNarrativeType().isAllowMultiple()).collect(Collectors.toList());
        narrativesToRemove.forEach(narrative -> {
            this.getDataObjectService().delete((Object)narrative.getNarrativeAttachment());
            proposal.getInstituteAttachments().remove(narrative);
        });
    }

    protected void synchronizeChildProposal(DevelopmentProposal hierarchyProposal, DevelopmentProposal childProposal, boolean syncPersonnelAttachments, List<DevelopmentProposal> hierarchyChildren) throws ProposalHierarchyException {
        List<BudgetPeriod> oldBudgetPeriods = this.getOldBudgetPeriods(this.proposalBudgetHierarchyService.getHierarchyBudget(hierarchyProposal));
        ProposalPerson principalInvestigator = hierarchyProposal.getPrincipalInvestigator();
        childProposal.setHierarchyLastSyncHashCode(this.computeHierarchyHashCode(childProposal));
        this.removeChildElements(hierarchyProposal, childProposal.getProposalNumber());
        this.synchronizeKeywords(hierarchyProposal, childProposal);
        this.synchronizeSpecialReviews(hierarchyProposal, childProposal);
        this.synchronizePersonsAndAggregate(hierarchyProposal, childProposal, principalInvestigator);
        this.syncDegreeInfo(hierarchyProposal, childProposal);
        this.proposalBudgetHierarchyService.synchronizeChildBudget(hierarchyProposal, childProposal, oldBudgetPeriods);
        if (syncPersonnelAttachments) {
            this.synchronizeNarratives(hierarchyProposal, childProposal);
            this.synchronizeInternalAttachments(hierarchyProposal, childProposal);
            this.syncAllPersonnelAttachments(hierarchyProposal, childProposal);
        }
        this.synchronizePersonUnits(hierarchyChildren, hierarchyProposal);
        this.dataObjectService.save((Object)childProposal, new PersistenceOption[0]);
    }

    @Override
    public void reinstateDegreeInfo(DevelopmentProposal proposal) {
        for (ProposalPerson person : proposal.getProposalPersons()) {
            List<ProposalPersonDegree> degrees = this.getProposalHierarchyDao().getDegreeInformation(proposal.getProposalNumber(), person);
            person.setProposalPersonDegrees(degrees);
        }
    }

    protected List<BudgetPeriod> getOldBudgetPeriods(Budget oldBudget) {
        return new ArrayList<BudgetPeriod>(oldBudget.getBudgetPeriods());
    }

    protected void synchronizeKeywords(DevelopmentProposal hierarchyProposal, DevelopmentProposal childProposal) {
        for (PropScienceKeyword keyword : childProposal.getPropScienceKeywords()) {
            PropScienceKeyword newKeyword = new PropScienceKeyword(hierarchyProposal, this.getScienceKeyword(keyword.getScienceKeyword().getCode()));
            if (this.doesOldKeyWordExist(hierarchyProposal.getPropScienceKeywords(), newKeyword)) continue;
            newKeyword.setHierarchyProposalNumber(childProposal.getProposalNumber());
            hierarchyProposal.addPropScienceKeyword(newKeyword);
        }
    }

    protected boolean doesOldKeyWordExist(List<PropScienceKeyword> oldKeywords, PropScienceKeyword newKeyword) {
        for (PropScienceKeyword oldKeyWord : oldKeywords) {
            if (!oldKeyWord.getScienceKeyword().getCode().equals(newKeyword.getScienceKeyword().getCode()) || !oldKeyWord.getProposalNumber().equals(newKeyword.getProposalNumber())) continue;
            return true;
        }
        return false;
    }

    protected ScienceKeyword getScienceKeyword(String code) {
        return (ScienceKeyword)this.getDataObjectService().findUnique(ScienceKeyword.class, QueryByCriteria.Builder.forAttribute((String)CODE, (Object)code).build());
    }

    protected void synchronizeSpecialReviews(DevelopmentProposal hierarchyProposal, DevelopmentProposal childProposal) {
        for (ProposalSpecialReview review : childProposal.getPropSpecialReviews()) {
            ProposalSpecialReview newReview = this.deepCopy(review);
            newReview.setDevelopmentProposal(hierarchyProposal);
            newReview.setHierarchyProposalNumber(childProposal.getProposalNumber());
            if (review.getSpecialReviewAttachment() != null) {
                newReview.setSpecialReviewAttachment(this.deepCopy(review.getSpecialReviewAttachment()));
                newReview.getSpecialReviewAttachment().setFileDataId(null);
                newReview.getSpecialReviewAttachment().setData(review.getSpecialReviewAttachment().getData());
            }
            hierarchyProposal.getPropSpecialReviews().add(newReview);
        }
    }

    protected void synchronizeNarratives(DevelopmentProposal hierarchyProposal, DevelopmentProposal childProposal) {
        this.deleteMultipleTypeAttachments(childProposal, childProposal.getNarratives());
        this.syncAttachmentsFromChild(hierarchyProposal, childProposal, childProposal.getNarratives(), hierarchyProposal.getNarratives());
    }

    protected void synchronizeInternalAttachments(DevelopmentProposal hierarchyProposal, DevelopmentProposal childProposal) {
        this.deleteMultipleTypeAttachments(childProposal, childProposal.getInstituteAttachments());
        this.syncAttachmentsFromChild(hierarchyProposal, childProposal, childProposal.getInstituteAttachments(), hierarchyProposal.getInstituteAttachments());
    }

    protected void addInternalAttachments(DevelopmentProposal hierarchyProposal, DevelopmentProposal childProposal) {
        this.syncAttachmentsFromChild(hierarchyProposal, childProposal, childProposal.getInstituteAttachments(), hierarchyProposal.getInstituteAttachments());
    }

    protected void syncAttachmentsFromChild(DevelopmentProposal hierarchyProposal, DevelopmentProposal childProposal, List<Narrative> childAttachments, List<Narrative> hierarchyAttachments) {
        for (Narrative narrative : childAttachments) {
            narrative.refreshReferenceObject(NARRATIVE_TYPE);
            if (!narrative.getNarrativeType().isAllowMultiple() && !this.doesParentHaveNarrativeType(hierarchyProposal, narrative.getNarrativeType())) {
                this.addNarrativeToParent(hierarchyProposal, childProposal, narrative, hierarchyAttachments);
            }
            if (!narrative.getNarrativeType().isAllowMultiple()) continue;
            this.addNarrativeToParent(hierarchyProposal, childProposal, narrative, hierarchyAttachments);
        }
    }

    protected void addNarrativeToParent(DevelopmentProposal hierarchyProposal, DevelopmentProposal childProposal, Narrative narrative, List<Narrative> hierarchyAttachments) {
        Narrative newNarrative = this.deepCopy(narrative);
        newNarrative.setNarrativeTypeCode(narrative.getNarrativeTypeCode());
        newNarrative.setNarrativeType(narrative.getNarrativeType());
        newNarrative.refreshReferenceObject(NARRATIVE_TYPE);
        newNarrative.setHierarchyProposalNumber(childProposal.getProposalNumber());
        newNarrative.setModuleStatusCode("I");
        newNarrative.setModuleNumber(this.legacyNarrativeService.getNextModuleNumber(hierarchyProposal.getProposalDocument()));
        newNarrative.setDevelopmentProposal(hierarchyProposal);
        newNarrative.setNarrativeUserRights(null);
        newNarrative.setNarrativeAttachment(this.deepCopy(narrative.getNarrativeAttachment()));
        newNarrative.getNarrativeAttachment().setFileDataId(null);
        newNarrative.getNarrativeAttachment().setData(narrative.getNarrativeAttachment().getData());
        hierarchyAttachments.add(newNarrative);
    }

    protected void deleteMultipleTypeAttachments(DevelopmentProposal childProposal, List<Narrative> attachments) {
        for (Narrative narrative : attachments) {
            narrative.refreshReferenceObject(NARRATIVE_TYPE);
            if (!narrative.getNarrativeType().isAllowMultiple()) continue;
            this.deleteNarrativesFromParent(childProposal, narrative.getNarrativeType());
        }
    }

    protected void deleteNarrativesFromParent(DevelopmentProposal childProposal, NarrativeType type) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put(HIERARCHY_PROPOSAL_NUMBER, childProposal.getProposalNumber());
        param.put(NARRATIVE_TYPE_CODE, type.getCode());
        this.getDataObjectService().deleteMatching(Narrative.class, QueryByCriteria.Builder.andAttributes(param).build());
    }

    protected boolean doesParentHaveNarrativeType(DevelopmentProposal hierarchyProposal, NarrativeType narrativeType) {
        return this.getLegacyNarrativeService().doesProposalHaveNarrativeType(hierarchyProposal, narrativeType);
    }

    protected void syncAllPersonnelAttachments(DevelopmentProposal hierarchyProposal, DevelopmentProposal childProposal) {
        ArrayList<ProposalPersonBiography> newList = new ArrayList<ProposalPersonBiography>();
        if (hierarchyProposal.isMultiProjectParent()) {
            return;
        }
        for (ProposalPersonBiography srcPropPersonBio : childProposal.getPropPersonBios()) {
            ProposalPersonBiography destPropPersonBio;
            if (!(!StringUtils.isNotBlank((CharSequence)srcPropPersonBio.getPersonId()) || this.isEmployeeBioInNewChildDuplicate(hierarchyProposal, srcPropPersonBio) || this.employeePersonInMultipleProposals(srcPropPersonBio.getPersonId(), hierarchyProposal) && this.hasBeenAdded(ListUtils.union(hierarchyProposal.getPropPersonBios(), newList), srcPropPersonBio))) {
                destPropPersonBio = this.getNewPropPersonBio(srcPropPersonBio, hierarchyProposal);
                destPropPersonBio.setDevelopmentProposal(hierarchyProposal);
                destPropPersonBio.setProposalNumber(hierarchyProposal.getProposalNumber());
                destPropPersonBio.setProposalPersonNumber(this.getEmployeeProposalPersonNumber(destPropPersonBio.getPersonId(), hierarchyProposal));
                destPropPersonBio.setVersionNumber(0L);
                newList.add(destPropPersonBio);
                continue;
            }
            if (srcPropPersonBio.getRolodexId() == null || this.isNonEmployeeBioInNewChildDuplicate(hierarchyProposal, srcPropPersonBio) || this.nonEmployeePersonInMultipleProposals(srcPropPersonBio.getRolodexId(), hierarchyProposal) && this.hasBeenAdded(ListUtils.union(hierarchyProposal.getPropPersonBios(), newList), srcPropPersonBio)) continue;
            destPropPersonBio = this.getNewPropPersonBio(srcPropPersonBio, hierarchyProposal);
            destPropPersonBio.setDevelopmentProposal(hierarchyProposal);
            destPropPersonBio.setProposalNumber(hierarchyProposal.getProposalNumber());
            destPropPersonBio.setProposalPersonNumber(this.getNonEmployeeProposalPersonNumber(destPropPersonBio.getRolodexId(), hierarchyProposal));
            destPropPersonBio.setVersionNumber(0L);
            newList.add(destPropPersonBio);
        }
        hierarchyProposal.getPropPersonBios().addAll(newList);
    }

    protected boolean hasBeenAdded(List<ProposalPersonBiography> bios, ProposalPersonBiography srcPropPersonBio) {
        return bios.stream().filter(bio -> StringUtils.isNotBlank((CharSequence)srcPropPersonBio.getPersonId()) && srcPropPersonBio.getPersonId().equals(bio.getPersonId()) || srcPropPersonBio.getRolodexId() != null && srcPropPersonBio.getRolodexId().equals(bio.getRolodexId())).anyMatch(bio -> bio.getDocumentTypeCode().equals(srcPropPersonBio.getDocumentTypeCode()));
    }

    protected ProposalPersonBiography getNewPropPersonBio(ProposalPersonBiography srcPropPersonBio, DevelopmentProposal hierarchyProposal) {
        ProposalPersonBiography proposalPersonBiography = new ProposalPersonBiography();
        proposalPersonBiography.setDescription(srcPropPersonBio.getDescription());
        proposalPersonBiography.setContentType(srcPropPersonBio.getContentType());
        proposalPersonBiography.setDocumentTypeCode(srcPropPersonBio.getDocumentTypeCode());
        proposalPersonBiography.setName(srcPropPersonBio.getName());
        proposalPersonBiography.setPersonId(srcPropPersonBio.getPersonId());
        proposalPersonBiography.setRolodexId(srcPropPersonBio.getRolodexId());
        proposalPersonBiography.setPositionNumber(srcPropPersonBio.getPositionNumber());
        proposalPersonBiography.setPropPerDocType(srcPropPersonBio.getPropPerDocType());
        proposalPersonBiography.setDevelopmentProposal(hierarchyProposal);
        proposalPersonBiography.setBiographyNumber(hierarchyProposal.getProposalDocument().getDocumentNextValue("proposalDevelopment.proposalPersonBiography.biographyNumber"));
        ProposalPersonBiographyAttachment attachment = new ProposalPersonBiographyAttachment();
        attachment.setType(srcPropPersonBio.getPersonnelAttachment().getType());
        attachment.setName(srcPropPersonBio.getPersonnelAttachment().getName());
        attachment.setFileDataId(srcPropPersonBio.getPersonnelAttachment().getFileDataId());
        attachment.setUploadUser(srcPropPersonBio.getPersonnelAttachment().getUploadUser());
        attachment.setUploadTimestamp(srcPropPersonBio.getPersonnelAttachment().getUploadTimestamp());
        proposalPersonBiography.setPersonnelAttachment(attachment);
        return proposalPersonBiography;
    }

    protected boolean isEmployeeBioInNewChildDuplicate(DevelopmentProposal hierarchyProposal, ProposalPersonBiography srcPropPersonBio) {
        return StringUtils.isNotBlank((CharSequence)srcPropPersonBio.getPersonId()) && this.isEmployeePersonOnParent(hierarchyProposal, srcPropPersonBio.getPersonId(), srcPropPersonBio);
    }

    protected boolean isNonEmployeeBioInNewChildDuplicate(DevelopmentProposal hierarchyProposal, ProposalPersonBiography srcPropPersonBio) {
        return srcPropPersonBio.getRolodexId() != null && this.isNonEmployeePersonOnParent(hierarchyProposal, srcPropPersonBio.getRolodexId(), srcPropPersonBio);
    }

    protected Integer getEmployeeProposalPersonNumber(String personId, DevelopmentProposal hierarchyProposal) {
        for (ProposalPerson person : hierarchyProposal.getProposalPersons()) {
            if (!StringUtils.isNotBlank((CharSequence)personId) || !StringUtils.equalsIgnoreCase((CharSequence)person.getPersonId(), (CharSequence)personId)) continue;
            return person.getProposalPersonNumber();
        }
        return null;
    }

    protected Integer getNonEmployeeProposalPersonNumber(Integer rolodexId, DevelopmentProposal hierarchyProposal) {
        for (ProposalPerson person : hierarchyProposal.getProposalPersons()) {
            if (rolodexId == null || !rolodexId.equals(person.getRolodexId())) continue;
            return person.getProposalPersonNumber();
        }
        return null;
    }

    @Override
    public boolean employeePersonInMultipleProposals(String personId, DevelopmentProposal proposal) {
        if (proposal.isChild()) {
            return this.getProposalHierarchyDao().employeePersonInMultipleChildProposals(personId, proposal.getHierarchyParentProposalNumber());
        }
        return this.getProposalHierarchyDao().employeePersonInMultipleChildProposals(personId, proposal.getProposalNumber());
    }

    @Override
    public boolean nonEmployeePersonInMultipleProposals(Integer rolodexId, DevelopmentProposal proposal) {
        if (rolodexId != null) {
            if (proposal.isChild()) {
                return this.getProposalHierarchyDao().nonEmployeePersonInMultipleChildProposals(rolodexId, proposal.getHierarchyParentProposalNumber());
            }
            return this.getProposalHierarchyDao().nonEmployeePersonInMultipleChildProposals(rolodexId, proposal.getProposalNumber());
        }
        return false;
    }

    protected boolean isEmployeePersonOnParent(DevelopmentProposal proposal, String id, ProposalPersonBiography srcPropPersonBio) {
        List<ProposalPerson> persons = this.getProposalHierarchyDao().isEmployeePersonOnProposal(proposal.getProposalNumber(), id);
        return persons.size() > 0 && !StringUtils.equals((CharSequence)persons.get(0).getHierarchyProposalNumber(), (CharSequence)srcPropPersonBio.getDevelopmentProposal().getProposalNumber());
    }

    protected boolean isNonEmployeePersonOnParent(DevelopmentProposal proposal, Integer id, ProposalPersonBiography srcPropPersonBio) {
        List<ProposalPerson> persons = this.getProposalHierarchyDao().isNonEmployeePersonOnProposal(proposal.getProposalNumber(), id);
        return persons.size() > 0 && !StringUtils.equals((CharSequence)persons.get(0).getHierarchyProposalNumber(), (CharSequence)srcPropPersonBio.getDevelopmentProposal().getProposalNumber());
    }

    protected void synchronizePersonsAndAggregate(DevelopmentProposal hierarchyProposal, DevelopmentProposal primaryChildProposal, ProposalPerson principalInvestigator) {
        this.synchronizePersons(hierarchyProposal, primaryChildProposal, principalInvestigator);
        this.getHierarchyChildren(hierarchyProposal.getProposalNumber()).forEach(childProposal -> this.synchronizePersons(hierarchyProposal, (DevelopmentProposal)childProposal, principalInvestigator));
    }

    protected void synchronizePersons(DevelopmentProposal hierarchyProposal, DevelopmentProposal childProposal, ProposalPerson principalInvestigator) {
        for (ProposalPerson person : childProposal.getProposalPersons()) {
            ProposalPerson firstInstance;
            int firstIndex = hierarchyProposal.getProposalPersons().indexOf(person);
            int lastIndex = hierarchyProposal.getProposalPersons().lastIndexOf(person);
            ProposalPerson proposalPerson = firstInstance = firstIndex == -1 ? null : hierarchyProposal.getProposalPersons().get(firstIndex);
            if (firstIndex != -1 && (firstIndex != lastIndex || this.rolesAreSimilar(person, firstInstance))) continue;
            ProposalPerson newPerson = this.deepCopy(person);
            if (newPerson.getCertificationDetails() != null) {
                newPerson.getCertificationDetails().setCertifiedBy(null);
                newPerson.getCertificationDetails().setCertifiedTime(null);
                newPerson.getCertificationDetails().setCertifiedTimeStamp(null);
                newPerson.getCertificationDetails().setCertifiedPersonName(null);
            }
            newPerson.setDevelopmentProposal(hierarchyProposal);
            newPerson.getProposalPersonYnqs().clear();
            for (ProposalPersonUnit unit : newPerson.getUnits()) {
                for (ProposalUnitCreditSplit creditSplit : unit.getCreditSplits()) {
                    creditSplit.setCredit(ScaleTwoDecimal.ZERO);
                }
                if (childProposal.getHierarchyParentProposalNumber().equals(childProposal.getProposalNumber())) continue;
                unit.setLeadUnit(false);
            }
            for (ProposalPersonCreditSplit creditSplit : newPerson.getCreditSplits()) {
                creditSplit.setCredit(ScaleTwoDecimal.ZERO);
            }
            newPerson.setProposalPersonNumber(null);
            newPerson.setVersionNumber(null);
            newPerson.setHierarchyProposalNumber(childProposal.getProposalNumber());
            if (StringUtils.equalsIgnoreCase((CharSequence)person.getProposalPersonRoleId(), (CharSequence)"PI")) {
                if (principalInvestigator == null && hierarchyProposal.getHierarchyOriginatingChildProposalNumber().equalsIgnoreCase(childProposal.getProposalNumber())) {
                    newPerson.setProposalPersonRoleId("PI");
                } else {
                    newPerson.setProposalPersonRoleId("COI");
                }
            }
            if (newPerson.equals(principalInvestigator) && (firstIndex == -1 || !firstInstance.isInvestigator())) {
                newPerson.setProposalPersonRoleId("PI");
            }
            hierarchyProposal.addProposalPerson(newPerson);
        }
        this.removeDeletedPersonnelFromParent(hierarchyProposal, childProposal);
    }

    protected void syncDegreeInfo(DevelopmentProposal hierarchyProposal, DevelopmentProposal childProposal) {
        for (ProposalPerson person : childProposal.getProposalPersons()) {
            int firstIndex = hierarchyProposal.getProposalPersons().indexOf(person);
            this.syncDegreeInfo(hierarchyProposal, firstIndex, person);
        }
    }

    protected void syncDegreeInfo(DevelopmentProposal hierarchyProposal, int indexOfPersonInParent, ProposalPerson childPerson) {
        ProposalPerson personInParent = hierarchyProposal.getProposalPersons().get(indexOfPersonInParent);
        if (personInParent != null && personInParent.getVersionNumber() != null && (StringUtils.isNotBlank((CharSequence)personInParent.getPersonId()) && !this.employeePersonInMultipleProposals(personInParent.getPersonId(), hierarchyProposal) || personInParent.getRolodexId() != null && !this.nonEmployeePersonInMultipleProposals(personInParent.getRolodexId(), hierarchyProposal))) {
            this.getProposalHierarchyDao().deleteDegreeInfo(hierarchyProposal.getProposalNumber(), personInParent.getProposalPersonNumber(), personInParent);
            for (ProposalPersonDegree degree : childPerson.getProposalPersonDegrees()) {
                ProposalPersonDegree newDegree = new ProposalPersonDegree();
                newDegree.setDegree(degree.getDegree());
                newDegree.setDegreeCode(degree.getDegreeCode());
                newDegree.setProposalPerson(personInParent);
                newDegree.setDegreeType(degree.getDegreeType());
                newDegree.setFieldOfStudy(degree.getFieldOfStudy());
                newDegree.setGraduationYear(degree.getGraduationYear());
                newDegree.setSchool(degree.getSchool());
                newDegree.setSpecialization(degree.getSpecialization());
                newDegree.setDegreeSequenceNumber(this.getDocument(hierarchyProposal).getDocumentNextValue("proposalDevelopment.proposalPerson.degree.degreeSequenceNumber"));
                this.dataObjectService.save((Object)newDegree, new PersistenceOption[0]);
            }
        }
    }

    protected ProposalDevelopmentDocument getDocument(DevelopmentProposal proposal) {
        ProposalDevelopmentDocument doc;
        try {
            doc = (ProposalDevelopmentDocument)this.documentService.getByDocumentHeaderId(proposal.getProposalDocument().getDocumentNumber());
        }
        catch (WorkflowException e) {
            throw new RuntimeException("Cannot find the proposal", e);
        }
        return doc;
    }

    @Override
    public DevelopmentProposal getHierarchy(String hierarchyProposalNumber) throws ProposalHierarchyException {
        DevelopmentProposal hierarchy = this.getDevelopmentProposal(hierarchyProposalNumber);
        if (hierarchy == null || !hierarchy.isParent()) {
            throw new ProposalHierarchyException("Proposal " + hierarchyProposalNumber + " is not a hierarchy");
        }
        return hierarchy;
    }

    @Override
    public boolean isSynchronized(DevelopmentProposal childProposal) {
        Integer hc1 = this.computeHierarchyHashCode(childProposal);
        Integer hc2 = childProposal.getHierarchyLastSyncHashCode();
        return Objects.equals(hc1, hc2);
    }

    protected boolean isBudgetSynchronized(DevelopmentProposal childProposal, ProposalDevelopmentBudgetExt childBudget) throws ProposalHierarchyException {
        if (Objects.equals(childProposal.getLastSyncedBudget(), childBudget)) {
            ObjectUtils.materializeAllSubObjects((PersistableBusinessObject)childBudget);
            Integer hc1 = this.proposalBudgetHierarchyService.computeHierarchyHashCode(childBudget);
            Integer hc2 = childBudget.getHierarchyLastSyncHashCode();
            return Objects.equals(hc1, hc2);
        }
        return false;
    }

    protected void setInitialPi(DevelopmentProposal hierarchy, DevelopmentProposal child) {
        ProposalPerson childPi = child.getPrincipalInvestigator();
        if (childPi != null) {
            Optional<ProposalPersonUnit> childPiLeadUnit = childPi.getUnits().stream().filter(ProposalPersonUnit::isLeadUnit).findFirst();
            int index = hierarchy.getProposalPersons().indexOf(childPi);
            if (index > -1) {
                ProposalPerson hierarchyPi = hierarchy.getProposalPerson(index);
                hierarchyPi.setProposalPersonRoleId("PI");
                if (childPiLeadUnit.isPresent()) {
                    Optional<ProposalPersonUnit> hierarchyPiLeadUnit = hierarchyPi.getUnits().stream().filter(unit -> unit.getUnitNumber().equals(((ProposalPersonUnit)childPiLeadUnit.get()).getUnitNumber())).findFirst();
                    hierarchyPiLeadUnit.ifPresent(proposalPersonUnit -> proposalPersonUnit.setLeadUnit(true));
                }
            }
        }
    }

    @Override
    public List<ProposalHierarchyErrorWarningDto> validateChildBudgetPeriods(DevelopmentProposal hierarchyProposal, DevelopmentProposal childProposal, boolean allowEndDateChange) throws ProposalHierarchyException {
        return this.proposalBudgetHierarchyService.validateChildBudgetPeriods(hierarchyProposal, childProposal, allowEndDateChange);
    }

    @Override
    public void synchronizeChildBudget(DevelopmentProposal hierarchyProposal, ProposalDevelopmentBudgetExt budget) {
        this.prepareHierarchySync(hierarchyProposal);
        this.proposalBudgetHierarchyService.synchronizeChildBudget(hierarchyProposal, budget);
        this.finalizeHierarchySync(hierarchyProposal);
    }

    @Override
    public ProposalDevelopmentBudgetExt getSyncableBudget(DevelopmentProposal proposal) {
        return this.proposalBudgetHierarchyService.getSyncableBudget(proposal);
    }

    @Override
    public boolean needToExtendProjectDate(DevelopmentProposal hierarchyProposal, DevelopmentProposal childProposal) {
        if (hierarchyProposal != null && !hierarchyProposal.getBudgets().isEmpty()) {
            ProposalDevelopmentBudgetExt parentBudget = this.proposalBudgetHierarchyService.getHierarchyBudget(hierarchyProposal);
            ProposalDevelopmentBudgetExt childBudget = this.getSyncableBudget(childProposal);
            if (childBudget != null && parentBudget != null) {
                BudgetPeriod lastParentPeriod = parentBudget.getBudgetPeriods().get(parentBudget.getBudgetPeriods().size() - 1);
                BudgetPeriod lastChildPeriod = childBudget.getBudgetPeriods().get(childBudget.getBudgetPeriods().size() - 1);
                return lastChildPeriod.getStartDate().after(lastParentPeriod.getEndDate());
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean needToExtendProjectDate(DevelopmentProposal hierarchyProposal) {
        List<DevelopmentProposal> proposals = this.getHierarchyProposals(hierarchyProposal);
        for (DevelopmentProposal proposal : proposals) {
            if (!this.needToExtendProjectDate(hierarchyProposal, proposal)) continue;
            return true;
        }
        return false;
    }

    protected void removeChildElements(DevelopmentProposal parentProposal, String childProposalNumber) {
        List<ProposalSpecialReview> reviews = parentProposal.getPropSpecialReviews();
        for (int i = reviews.size() - 1; i >= 0; --i) {
            if (!StringUtils.equals((CharSequence)childProposalNumber, (CharSequence)reviews.get(i).getHierarchyProposalNumber())) continue;
            reviews.remove(i);
        }
        List<Narrative> narratives = parentProposal.getNarratives();
        for (int i = narratives.size() - 1; i >= 0; --i) {
            if (!StringUtils.equals((CharSequence)childProposalNumber, (CharSequence)narratives.get(i).getHierarchyProposalNumber())) continue;
            this.dataObjectService.delete((Object)narratives.remove(i));
        }
        List<ProposalPersonBiography> bios = parentProposal.getPropPersonBios();
        for (int i = bios.size() - 1; i >= 0; --i) {
            ProposalPersonBiography bio = bios.get(i);
            Optional<ProposalPerson> person = parentProposal.getProposalPersons().stream().filter(p -> p.getProposalPersonNumber().equals(bio.getProposalPersonNumber())).findAny();
            if (!person.isPresent() || !StringUtils.equals((CharSequence)childProposalNumber, (CharSequence)person.get().getHierarchyProposalNumber()) || this.personInMultipleProposals(person.get().getPersonId(), person.get().getRolodexId(), parentProposal)) continue;
            this.dataObjectService.delete((Object)bios.remove(i));
        }
        ProposalDevelopmentBudgetExt parentBudget = this.proposalBudgetHierarchyService.getHierarchyBudget(parentProposal);
        if (parentBudget != null) {
            this.proposalBudgetHierarchyService.removeChildBudgetElements(parentProposal, parentBudget, childProposalNumber);
            this.getBudgetService().recalculateBudget(parentBudget);
        }
    }

    protected boolean personInMultipleProposals(String personId, Integer rolodexId, DevelopmentProposal parentProposal) {
        if (StringUtils.isNotBlank((CharSequence)personId)) {
            return this.employeePersonInMultipleProposals(personId, parentProposal);
        }
        if (rolodexId != null) {
            return this.nonEmployeePersonInMultipleProposals(rolodexId, parentProposal);
        }
        return false;
    }

    protected void prepareHierarchySync(DevelopmentProposal hierarchyProposal) {
        this.prepareHierarchySync(hierarchyProposal.getProposalDocument());
    }

    protected void prepareHierarchySync(ProposalDevelopmentDocument pdDoc) {
        pdDoc.refreshReferenceObject(DOCUMENT_NEXTVALUES);
    }

    protected void finalizeHierarchySync(ProposalDevelopmentDocument pdDoc) throws ProposalHierarchyException {
        try {
            this.documentService.saveDocument((Document)pdDoc);
        }
        catch (WorkflowException e) {
            throw new ProposalHierarchyException(e);
        }
    }

    protected DevelopmentProposal finalizeHierarchySync(DevelopmentProposal hierarchyProposal) throws ProposalHierarchyException {
        DevelopmentProposal savedParentProposal = (DevelopmentProposal)this.dataObjectService.save((Object)hierarchyProposal, new PersistenceOption[0]);
        this.dataObjectService.save((Object)this.proposalBudgetHierarchyService.getHierarchyBudget(hierarchyProposal), new PersistenceOption[0]);
        return savedParentProposal;
    }

    protected void copyInitialAttachments(DevelopmentProposal srcProposal, DevelopmentProposal destProposal) {
        ProposalPerson srcPerson = null;
        ProposalPerson destPerson = null;
        for (ProposalPersonBiography srcPropPersonBio : srcProposal.getPropPersonBios()) {
            for (ProposalPerson person : srcProposal.getProposalPersons()) {
                if (!person.getProposalPersonNumber().equals(srcPropPersonBio.getProposalPersonNumber())) continue;
                srcPerson = person;
                break;
            }
            for (ProposalPerson person : destProposal.getProposalPersons()) {
                if (!person.equals(srcPerson)) continue;
                destPerson = person;
                break;
            }
            if (destPerson == null) continue;
            ProposalPersonBiography destPropPersonBio = this.getNewPropPersonBio(srcPropPersonBio, destProposal);
            destPropPersonBio.setDevelopmentProposal(destProposal);
            destPropPersonBio.setProposalNumber(destProposal.getProposalNumber());
            destPropPersonBio.setProposalPersonNumber(destPerson.getProposalPersonNumber());
            destPropPersonBio.setPersonId(destPerson.getPersonId());
            destPropPersonBio.setRolodexId(destPerson.getRolodexId());
            destProposal.getPropPersonBios().add(destPropPersonBio);
        }
        for (Narrative srcNarrative : srcProposal.getNarratives()) {
            this.addNarrativeToParent(destProposal, srcProposal, srcNarrative, destProposal.getNarratives());
        }
        for (Narrative narrative : destProposal.getNarratives()) {
            narrative.setNarrativeUserRights(null);
        }
        for (Narrative attInternal : srcProposal.getInstituteAttachments()) {
            this.addNarrativeToParent(destProposal, srcProposal, attInternal, destProposal.getInstituteAttachments());
        }
    }

    protected int computeHierarchyHashCode(DevelopmentProposal proposal) {
        int prime = 31;
        int result = 1;
        for (ProposalPerson person : proposal.getProposalPersons()) {
            result = prime * result + person.hashCode();
        }
        for (Narrative narrative : proposal.getNarratives()) {
            result = prime * result + narrative.hierarchyHashCode();
        }
        for (PropScienceKeyword keyword : proposal.getPropScienceKeywords()) {
            result = prime * result + keyword.getScienceKeyword().getCode().hashCode();
        }
        for (ProposalSpecialReview review : proposal.getPropSpecialReviews()) {
            result = prime * result + review.hierarchyHashCode();
        }
        return result;
    }

    @Override
    public List<DevelopmentProposal> getHierarchyChildren(String parentProposalNumber) {
        return this.proposalHierarchyDao.getHierarchyChildProposalNumbers(parentProposalNumber).stream().map(this::getDevelopmentProposal).collect(Collectors.toList());
    }

    @Override
    public WorkflowDocument getParentWorkflowDocument(ProposalDevelopmentDocument child) throws ProposalHierarchyException {
        return this.getParentDocument(child).getDocumentHeader().getWorkflowDocument();
    }

    @Override
    public ProposalDevelopmentDocument getParentDocument(ProposalDevelopmentDocument child) throws ProposalHierarchyException {
        try {
            DevelopmentProposal parentProposal = this.getHierarchy(child.getDevelopmentProposal().getHierarchyParentProposalNumber());
            String parentDocumentNumber = parentProposal.getProposalDocument().getDocumentNumber();
            return (ProposalDevelopmentDocument)this.documentService.getByDocumentHeaderId(parentDocumentNumber);
        }
        catch (WorkflowException e) {
            throw new ProposalHierarchyException(String.format("Could not lookup hierarchy workflow status for child:%s", child.getDocumentHeader().getDocumentNumber()), e);
        }
    }

    protected void rejectProposal(ProposalDevelopmentDocument proposalDoc, String reason, String principalId, String appDocStatus) {
        this.getKcDocumentRejectionService().reject(proposalDoc.getDocumentHeader().getWorkflowDocument(), reason, principalId, appDocStatus);
    }

    protected void rejectProposalHierarchy(ProposalDevelopmentDocument hierarchyParent, String reason, String principalId) throws ProposalHierarchyException {
        this.rejectProposal(hierarchyParent, this.renderMessage(PROPOSAL_ROUTING_RETURNED_ANNOTATION, reason), principalId, this.renderMessage(HIERARCHY_REJECTED_APPSTATUS, new String[0]));
    }

    @Override
    public void rejectProposalDevelopmentDocument(String proposalNumber, String reason, String principalName, MultipartFile rejectFile) throws WorkflowException, ProposalHierarchyException {
        DevelopmentProposal pbo = this.getDevelopmentProposal(proposalNumber);
        ProposalDevelopmentDocument pDoc = (ProposalDevelopmentDocument)this.documentService.getByDocumentHeaderId(pbo.getProposalDocument().getDocumentNumber());
        if (!pbo.isInHierarchy()) {
            this.rejectProposal(pDoc, this.renderMessage(PROPOSAL_ROUTING_RETURNED_ANNOTATION, reason), principalName, this.renderMessage(HIERARCHY_REJECTED_APPSTATUS, new String[0]));
        } else if (pbo.isParent()) {
            this.rejectProposalHierarchy(pDoc, reason, principalName);
        } else {
            throw new UnsupportedOperationException(String.format("Cannot return proposal %s it is a hierarchy child or ", proposalNumber));
        }
        this.createAndSaveActionNarrative(reason, "Proposal return attachment.", rejectFile, this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "returnNarrativeTypeCode"), pDoc);
    }

    @Override
    public void createAndSaveActionNarrative(String reason, String title, MultipartFile file, String narrativeTypeCode, ProposalDevelopmentDocument pDoc) {
        if (file != null && !file.isEmpty()) {
            Narrative narrative = new Narrative();
            narrative.setName(file.getOriginalFilename());
            narrative.setComments(reason);
            try {
                narrative.init(file);
            }
            catch (Exception e) {
                throw new RuntimeException("Error Initializing narrative attachment file", e);
            }
            narrative.setNarrativeTypeCode(narrativeTypeCode);
            narrative.setModuleStatusCode(COMPLETE);
            narrative.setModuleTitle(title);
            narrative.setContactName(this.globalVariableService.getUserSession().getPrincipalName());
            narrative.setPhoneNumber(this.globalVariableService.getUserSession().getPerson().getPhoneNumber());
            narrative.setEmailAddress(this.globalVariableService.getUserSession().getPerson().getEmailAddress());
            this.getLegacyNarrativeService().prepareNarrative(pDoc, narrative);
            String narrativeTypeGroup = narrative.getNarrativeType().getNarrativeTypeGroup();
            if ("O".equals(narrativeTypeGroup)) {
                pDoc.getDevelopmentProposal().getInstituteAttachments().add(narrative);
            } else if ("P".equals(narrativeTypeGroup)) {
                pDoc.getDevelopmentProposal().getNarratives().add(narrative);
            }
            this.dataObjectService.save((Object)pDoc, new PersistenceOption[0]);
        }
    }

    @Override
    public void calculateAndSetProposalAppDocStatus(ProposalDevelopmentDocument doc, DocumentRouteStatusChange dto) throws ProposalHierarchyException {
        String principalId = this.globalVariableService.getUserSession().getPrincipalId();
        if (StringUtils.equals((CharSequence)dto.getNewRouteStatus(), (CharSequence)"R")) {
            this.updateAppDocStatus(doc, principalId, HIERARCHY_ENROUTE_APPSTATUS);
        } else if (StringUtils.equals((CharSequence)dto.getNewRouteStatus(), (CharSequence)"X")) {
            this.updateAppDocStatus(doc, principalId, HIERARCHY_CANCEL_APPSTATUS);
        } else if (StringUtils.equals((CharSequence)dto.getNewRouteStatus(), (CharSequence)"D")) {
            this.updateAppDocStatus(doc, principalId, HIERARCHY_DISAPPROVE_APPSTATUS);
        } else if (StringUtils.equals((CharSequence)dto.getNewRouteStatus(), (CharSequence)"F")) {
            this.updateAppDocStatus(doc, principalId, HIERARCHY_FINAL_APPSTATUS);
        } else if (StringUtils.equals((CharSequence)dto.getNewRouteStatus(), (CharSequence)"P")) {
            this.updateAppDocStatus(doc, principalId, HIERARCHY_PROCESSED_APPSTATUS);
        }
    }

    @Override
    public void updateChildProposalsDocumentStatus(ProposalDevelopmentDocument doc, DocumentRouteStatusChange dto) {
        (doc.getDevelopmentProposal().isChild() ? Stream.of(doc.getDevelopmentProposal()) : this.getHierarchyProposals(doc.getDevelopmentProposal()).stream()).filter(DevelopmentProposal::isChild).map(DevelopmentProposal::getProposalDocument).map(DocumentBase::getDocumentNumber).forEach(documentNumber -> {
            DocumentRouteHeaderValue routeHeaderValue = this.getRouteHeaderService().getRouteHeader(documentNumber);
            routeHeaderValue.setDocRouteStatus(dto.getNewRouteStatus());
            this.getRouteHeaderService().saveRouteHeader(routeHeaderValue);
            if (this.wasRouteStatusRolledBackToSaved(dto)) {
                this.generateCompleteRequest(routeHeaderValue).ifPresent(arg_0 -> ((ActionRequestService)this.getActionRequestService()).activateRequest(arg_0));
            }
            try {
                if (this.kualiConfigurationService.getPropertyValueAsBoolean("elasticsearch.enabled")) {
                    this.getElasticsearchIndexService().indexPostCommit((String)documentNumber, this.getKewDocHeaderDao().getAllNonActiveDocumentIds((String)documentNumber));
                }
            }
            catch (Exception e) {
                LOG.warn("Failed to trigger ES reindex for child proposal document {}: {}", documentNumber, (Object)e.getMessage());
                LOG.debug("Indexing error details", (Throwable)e);
            }
        });
    }

    protected ElasticsearchIndexService getElasticsearchIndexService() {
        if (this.elasticsearchIndexService == null) {
            this.elasticsearchIndexService = KcServiceLocator.getService(ElasticsearchIndexService.class);
        }
        return this.elasticsearchIndexService;
    }

    protected KewDocHeaderDao getKewDocHeaderDao() {
        if (this.kewDocHeaderDao == null) {
            this.kewDocHeaderDao = KcServiceLocator.getService(KewDocHeaderDao.class);
        }
        return this.kewDocHeaderDao;
    }

    protected boolean wasRouteStatusRolledBackToSaved(DocumentRouteStatusChange dto) {
        return !"I".equals(dto.getOldRouteStatus()) && "S".equals(dto.getNewRouteStatus());
    }

    protected Optional<ActionRequestValue> generateCompleteRequest(DocumentRouteHeaderValue routeHeader) {
        return this.getRouteNodeService().getInitialNodeInstances(routeHeader.getDocumentId()).stream().findFirst().map(node -> new ActionRequestFactory(routeHeader, node).createActionRequest(COMPLETE, Integer.valueOf(0), (Recipient)new KimPrincipalRecipient((PrincipalContract)routeHeader.getInitiatorPrincipal()), INITIATOR_COMPLETE_RESPONSIBILITY_DESCRIPTION, "-3", Boolean.TRUE, null));
    }

    protected void updateAppDocStatus(ProposalDevelopmentDocument doc, String principalId, String newStatus) throws ProposalHierarchyException {
        try {
            WorkflowDocument wdoc = WorkflowDocumentFactory.loadDocument((String)principalId, (String)doc.getDocumentHeader().getWorkflowDocument().getDocumentId());
            wdoc.setApplicationDocumentStatus(this.renderMessage(newStatus, new String[0]));
        }
        catch (Exception e) {
            throw new ProposalHierarchyException(String.format("Exception encountered while attempting to update App Doc Status of proposal %s ( document #%s )", doc.getDevelopmentProposal().getProposalNumber(), doc.getDocumentNumber()), e);
        }
    }

    protected boolean rolesAreSimilar(ProposalPerson person1, ProposalPerson person2) {
        boolean isInvestigator1 = StringUtils.equals((CharSequence)person1.getProposalPersonRoleId(), (CharSequence)"PI") || StringUtils.equals((CharSequence)person1.getProposalPersonRoleId(), (CharSequence)"COI");
        boolean isInvestigator2 = StringUtils.equals((CharSequence)person2.getProposalPersonRoleId(), (CharSequence)"PI") || StringUtils.equals((CharSequence)person2.getProposalPersonRoleId(), (CharSequence)"COI");
        return isInvestigator1 == isInvestigator2;
    }

    @Override
    public List<HierarchyPersonnelSummary> getHierarchyPersonnelSummaries(String parentProposalNumber) throws ProposalHierarchyException {
        ArrayList<HierarchyPersonnelSummary> summaries = new ArrayList<HierarchyPersonnelSummary>();
        ArrayList<String> proposalNumbers = new ArrayList<String>(this.proposalHierarchyDao.getHierarchyChildProposalNumbers(parentProposalNumber));
        Collections.sort(proposalNumbers);
        for (String proposalNumber : proposalNumbers) {
            HierarchyPersonnelSummary summary = new HierarchyPersonnelSummary();
            DevelopmentProposal childProposal = this.getDevelopmentProposal(proposalNumber);
            List<Budget> hierarchyBudgets = this.getProposalBudgetHierarchyService().getHierarchyBudgets(childProposal).stream().sorted().collect(Collectors.toList());
            summary.setProposalNumber(proposalNumber);
            summary.setHierarchyBudgets(hierarchyBudgets);
            summaries.add(summary);
        }
        return summaries;
    }

    @Override
    public List<HierarchyProposalSummary> getHierarchyProposalSummaries(String proposalNumber) throws ProposalHierarchyException {
        DevelopmentProposal proposal = this.getDevelopmentProposal(proposalNumber);
        ArrayList<HierarchyProposalSummary> summaries = new ArrayList<HierarchyProposalSummary>();
        ArrayList<String> proposalNumbers = new ArrayList<String>();
        if (proposal.isParent()) {
            proposalNumbers.add(proposalNumber);
        } else if (proposal.isChild()) {
            proposalNumbers.add(proposal.getHierarchyParentProposalNumber());
        } else {
            throw new ProposalHierarchyException("Proposal " + proposalNumber + " is not a member of a hierarchy.");
        }
        proposalNumbers.addAll(this.proposalHierarchyDao.getHierarchyChildProposalNumbers((String)proposalNumbers.get(0)));
        for (String number : proposalNumbers) {
            HierarchyProposalSummary summary = new HierarchyProposalSummary();
            summary.setProposalNumber(number);
            if (!StringUtils.equals((CharSequence)number, (CharSequence)((CharSequence)proposalNumbers.get(0)))) {
                summary = this.getProposalSummary(number);
            }
            summaries.add(summary);
        }
        return summaries;
    }

    @Override
    public HierarchyProposalSummary getProposalSummary(String proposalNumber) throws ProposalHierarchyException {
        HierarchyProposalSummary summary = new HierarchyProposalSummary();
        summary.setProposalNumber(proposalNumber);
        DevelopmentProposal childProposal = this.getDevelopmentProposal(proposalNumber);
        summary.setSynced(this.isSynchronized(childProposal));
        ProposalDevelopmentBudgetExt budget = this.getSyncableBudget(childProposal);
        summary.setBudgetSynced(this.isBudgetSynchronized(childProposal, budget));
        return summary;
    }

    @Override
    public List<DevelopmentProposal> getHierarchyProposals(DevelopmentProposal proposal) {
        ArrayList<DevelopmentProposal> hierarchyProposals = new ArrayList<DevelopmentProposal>();
        ArrayList<String> proposalNumbers = new ArrayList<String>();
        if (proposal.isParent()) {
            proposalNumbers.add(proposal.getProposalNumber());
        } else if (proposal.isChild()) {
            proposalNumbers.add(proposal.getHierarchyParentProposalNumber());
        } else {
            return hierarchyProposals;
        }
        proposalNumbers.addAll(this.proposalHierarchyDao.getHierarchyChildProposalNumbers((String)proposalNumbers.get(0)));
        hierarchyProposals.addAll(this.getDataObjectService().findMatching(DevelopmentProposal.class, QueryByCriteria.Builder.andAttributes(Collections.singletonMap(PROPOSAL_NUMBER, proposalNumbers)).setOrderByFields(new OrderByField[]{OrderByField.Builder.create((String)HIERARCHY_STATUS, (OrderDirection)OrderDirection.DESCENDING).build()}).build()).getResults());
        return hierarchyProposals;
    }

    @Override
    public boolean validateRemovePermissions(DevelopmentProposal childProposal, String principalId) {
        boolean valid = this.kcAuthorizationService.hasPermission(principalId, childProposal.getProposalDocument(), "Maintain ProposalHierarchy");
        try {
            valid &= this.kcAuthorizationService.hasPermission(principalId, this.getHierarchy(childProposal.getHierarchyParentProposalNumber()).getProposalDocument(), "Maintain ProposalHierarchy");
        }
        catch (ProposalHierarchyException e) {
            valid = false;
        }
        return valid;
    }

    @Override
    public List<ProposalHierarchyErrorWarningDto> validateChildForRemoval(DevelopmentProposal child) {
        ArrayList<ProposalHierarchyErrorWarningDto> errors = new ArrayList<ProposalHierarchyErrorWarningDto>();
        try {
            DevelopmentProposal hierarchy = this.lookupParent(child);
            if (this.hasCompleteBudget(hierarchy)) {
                errors.add(new ProposalHierarchyErrorWarningDto("error.hierarchy.remove.parentBudgetComplete", Boolean.TRUE, new String[0]));
            }
        }
        catch (ProposalHierarchyException e) {
            errors.add(new ProposalHierarchyErrorWarningDto("error.hierarchy.unexpected", Boolean.TRUE, e.getMessage()));
        }
        return errors;
    }

    protected String renderMessage(String key, String ... params) {
        String msg = this.kualiConfigurationService.getPropertyValueAsString(key);
        for (int i = 0; i < params.length; ++i) {
            msg = StringUtils.replace((String)msg, (String)("{" + i + "}"), (String)params[i]);
        }
        return msg;
    }

    protected KcDocumentRejectionService getKcDocumentRejectionService() {
        return this.kcDocumentRejectionService;
    }

    protected DocumentService getDocumentService() {
        return this.documentService;
    }

    protected KcAuthorizationService getKcAuthorizationService() {
        return this.kcAuthorizationService;
    }

    protected ProposalHierarchyDao getProposalHierarchyDao() {
        return this.proposalHierarchyDao;
    }

    protected LegacyNarrativeService getLegacyNarrativeService() {
        return this.legacyNarrativeService;
    }

    protected ProposalPersonBiographyService getProposalPersonBiographyService() {
        return this.proposalPersonBiographyService;
    }

    public void setProposalPersonBiographyService(ProposalPersonBiographyService proposalPersonBiographyService) {
        this.proposalPersonBiographyService = proposalPersonBiographyService;
    }

    protected ParameterService getParameterService() {
        return this.parameterService;
    }

    protected ConfigurationService getKualiConfigurationService() {
        return this.kualiConfigurationService;
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    @Override
    public List<ProposalHierarchyErrorWarningDto> validateChildForSync(DevelopmentProposal child, DevelopmentProposal hierarchy, boolean allowEndDateChange) {
        ArrayList<ProposalHierarchyErrorWarningDto> errors = new ArrayList<ProposalHierarchyErrorWarningDto>();
        if (child.getPrincipalInvestigator() == null) {
            errors.add(new ProposalHierarchyErrorWarningDto("error.hierarchy.sync.noPrincipleInvestigator", Boolean.TRUE, child.getProposalNumber()));
        }
        errors.addAll(this.validateSponsor(child, hierarchy));
        errors.addAll(this.validateIsParentLocked(hierarchy));
        errors.addAll(this.validateParent(hierarchy, child));
        return errors;
    }

    @Override
    public List<ProposalHierarchyErrorWarningDto> validateChildCandidate(DevelopmentProposal proposal) {
        ArrayList<ProposalHierarchyErrorWarningDto> errors = new ArrayList<ProposalHierarchyErrorWarningDto>();
        if (proposal.isInHierarchy()) {
            errors.add(new ProposalHierarchyErrorWarningDto("error.hierarchy.link.alreadyHierarchyMember", Boolean.TRUE, new String[0]));
        }
        if (proposal.getBudgets().isEmpty()) {
            errors.add(new ProposalHierarchyErrorWarningDto("error.hierarchy.link.noBudgetVersion", Boolean.TRUE, new String[0]));
        } else if (!this.hasFinalBudget(proposal)) {
            errors.add(new ProposalHierarchyErrorWarningDto("warning.hierarchy.link.noFinalBudget", Boolean.FALSE, proposal.getProposalNumber()));
        }
        if (proposal.getPrincipalInvestigator() == null) {
            errors.add(new ProposalHierarchyErrorWarningDto("error.hierarchy.link.noPrincipleInvestigator", Boolean.TRUE, new String[0]));
        }
        return errors;
    }

    @Override
    public List<ProposalHierarchyErrorWarningDto> validateChildCandidateForHierarchy(DevelopmentProposal hierarchy, DevelopmentProposal child, boolean allowEndDateChange) {
        ArrayList<ProposalHierarchyErrorWarningDto> errors = new ArrayList<ProposalHierarchyErrorWarningDto>();
        if (!StringUtils.equalsIgnoreCase((CharSequence)hierarchy.getSponsorCode(), (CharSequence)child.getSponsorCode())) {
            errors.add(new ProposalHierarchyErrorWarningDto("warning.hierarchy.link.differentSponsor", Boolean.FALSE, new String[0]));
        }
        return errors;
    }

    @Override
    public List<ProposalHierarchyErrorWarningDto> validateParent(DevelopmentProposal proposal) {
        return this.validateParent(proposal, null);
    }

    @Override
    public List<ProposalHierarchyErrorWarningDto> validateParent(DevelopmentProposal proposal, DevelopmentProposal child) {
        Set<String> siblingsWithPeriodsNotInSync;
        Set<String> childrenWithDatesNotInSync;
        ArrayList<ProposalHierarchyErrorWarningDto> errors = new ArrayList<ProposalHierarchyErrorWarningDto>();
        if (!proposal.isParent()) {
            errors.add(new ProposalHierarchyErrorWarningDto("error.hierarchy.link.notParent", Boolean.TRUE, new String[0]));
        }
        if (this.hasCompleteBudget(proposal)) {
            errors.add(new ProposalHierarchyErrorWarningDto("error.hierarchy.link.parentBudgetComplete", Boolean.TRUE, new String[0]));
        }
        if ((childrenWithDatesNotInSync = this.getChildrenWithDatesNotInSync(proposal)).size() > 0) {
            errors.add(new ProposalHierarchyErrorWarningDto("error.hierarchy.project.dates.not.in.sync", Boolean.TRUE, String.join((CharSequence)", ", childrenWithDatesNotInSync)));
        }
        if ((siblingsWithPeriodsNotInSync = this.getSiblingsWithPeriodsNotInSync(proposal, child)).size() > 0) {
            errors.add(new ProposalHierarchyErrorWarningDto("error.hierarchy.child.periods.not.in.sync", Boolean.TRUE, String.join((CharSequence)", ", siblingsWithPeriodsNotInSync)));
        }
        return errors;
    }

    public Set<String> getChildrenWithDatesNotInSync(DevelopmentProposal proposal) {
        List<DevelopmentProposal> hierarchyProposals = this.getHierarchyProposals(proposal);
        Optional<DevelopmentProposal> parent = hierarchyProposals.stream().filter(developmentProposal -> developmentProposal.isParent()).findFirst();
        if (parent.isPresent()) {
            DevelopmentProposal parentProposal = parent.get();
            return hierarchyProposals.stream().filter(developmentProposal -> !developmentProposal.getRequestedStartDateInitial().equals(parentProposal.getRequestedStartDateInitial()) || !developmentProposal.getRequestedEndDateInitial().equals(parentProposal.getRequestedEndDateInitial())).map(developmentProposal -> developmentProposal.getProposalNumber()).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    protected ProposalDevelopmentBudgetExt getBudgetForProposal(DevelopmentProposal proposal) {
        return proposal.getFinalBudget() != null ? proposal.getFinalBudget() : proposal.getLatestBudget();
    }

    protected boolean arePeriodsInSync(ProposalDevelopmentBudgetExt budget1, ProposalDevelopmentBudgetExt budget2) {
        for (int i = 0; i < budget1.getBudgetPeriods().size(); ++i) {
            BudgetPeriod currentPeriod = budget1.getBudgetPeriod(i);
            if (i < budget2.getBudgetPeriods().size()) {
                BudgetPeriod periodToCompare = budget2.getBudgetPeriod(i);
                if (currentPeriod.getStartDate().equals(periodToCompare.getStartDate()) && currentPeriod.getEndDate().equals(periodToCompare.getEndDate())) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public Set<String> getSiblingsWithPeriodsNotInSync(DevelopmentProposal parentProposal, DevelopmentProposal childProposal) {
        HashSet<String> siblingsWithPeriodsNotInSync = new HashSet<String>();
        List siblingProposals = this.getHierarchyProposals(parentProposal).stream().filter(DevelopmentProposal::isChild).collect(Collectors.toList());
        Optional.ofNullable(childProposal).map(DevelopmentProposal::getProposalNumber).map(proposalNumber -> siblingProposals.stream().filter(proposal -> proposal.getProposalNumber().equals(proposalNumber)).findFirst()).orElse(siblingProposals.stream().findFirst()).ifPresent(proposalToCompare -> {
            ProposalDevelopmentBudgetExt budgetToCompare = this.getBudgetForProposal((DevelopmentProposal)proposalToCompare);
            siblingProposals.stream().map(this::getBudgetForProposal).forEach(budget -> {
                if (!budgetToCompare.equals(budget) && !this.arePeriodsInSync((ProposalDevelopmentBudgetExt)budget, budgetToCompare)) {
                    siblingsWithPeriodsNotInSync.add(budget.getDevelopmentProposal().getProposalNumber());
                }
            });
        });
        return siblingsWithPeriodsNotInSync;
    }

    @Override
    public List<ProposalHierarchyErrorWarningDto> validateSponsor(DevelopmentProposal childProposal, DevelopmentProposal parentProposal) {
        ArrayList<ProposalHierarchyErrorWarningDto> errors = new ArrayList<ProposalHierarchyErrorWarningDto>();
        if (!StringUtils.equals((CharSequence)childProposal.getSponsorCode(), (CharSequence)parentProposal.getSponsorCode())) {
            errors.add(new ProposalHierarchyErrorWarningDto("error.child.and.parent.have.different.sponsors", Boolean.FALSE, new String[0]));
        }
        return errors;
    }

    protected List<ProposalHierarchyErrorWarningDto> validateIsAggregatorOnParent(DevelopmentProposal parentProposal) {
        ArrayList<ProposalHierarchyErrorWarningDto> errors = new ArrayList<ProposalHierarchyErrorWarningDto>();
        if (!this.getKcAuthorizationService().hasPermission(this.getGlobalVariableService().getUserSession().getPrincipalId(), parentProposal.getDocument(), "Maintain ProposalHierarchy")) {
            errors.add(new ProposalHierarchyErrorWarningDto("error.hierarchy.not.parent.aggregator", Boolean.TRUE, parentProposal.getProposalNumber()));
        }
        return errors;
    }

    @Override
    public List<ProposalHierarchyErrorWarningDto> validateIsAggregatorOnChild(DevelopmentProposal childProposal) {
        ArrayList<ProposalHierarchyErrorWarningDto> errors = new ArrayList<ProposalHierarchyErrorWarningDto>();
        if (!this.getKcAuthorizationService().hasPermission(this.getGlobalVariableService().getUserSession().getPrincipalId(), childProposal.getDocument(), "Maintain ProposalHierarchy")) {
            errors.add(new ProposalHierarchyErrorWarningDto("error.hierarchy.not.child.aggregator", Boolean.TRUE, childProposal.getProposalNumber()));
        }
        return errors;
    }

    protected List<ProposalHierarchyErrorWarningDto> validateIsParentLocked(DevelopmentProposal parentProposal) {
        ArrayList<ProposalHierarchyErrorWarningDto> errors = new ArrayList<ProposalHierarchyErrorWarningDto>();
        if (!this.getPessimisticLockService().getPessimisticLocksForDocument(parentProposal.getDocument().getDocumentNumber()).isEmpty()) {
            errors.add(new ProposalHierarchyErrorWarningDto("error.hierarchy.parent.locked", Boolean.TRUE, parentProposal.getProposalNumber()));
        }
        return errors;
    }

    private boolean hasFinalBudget(DevelopmentProposal proposal) {
        return proposal.getFinalBudget() != null;
    }

    private boolean hasCompleteBudget(DevelopmentProposal developmentProposal) {
        boolean retval = false;
        String completeCode = this.getParameterService().getParameterValueAsString(Budget.class, "budgetStatusCompleteCode");
        for (ProposalDevelopmentBudgetExt version : developmentProposal.getBudgets()) {
            if (version.getBudgetStatus() == null || !version.getBudgetStatus().equalsIgnoreCase(completeCode)) continue;
            retval = true;
            break;
        }
        return retval;
    }

    public ActionRequestService getActionRequestService() {
        return this.actionRequestService;
    }

    public void setActionRequestService(ActionRequestService actionRequestService) {
        this.actionRequestService = actionRequestService;
    }

    protected DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public void setKradWorkflowDocumentService(WorkflowDocumentService kradWorkflowDocumentService) {
        this.kradWorkflowDocumentService = kradWorkflowDocumentService;
    }

    public void setKcDocumentRejectionService(KcDocumentRejectionService kcDocumentRejectionService) {
        this.kcDocumentRejectionService = kcDocumentRejectionService;
    }

    public PessimisticLockService getPessimisticLockService() {
        return this.pessimisticLockService;
    }

    public void setPessimisticLockService(PessimisticLockService pessimisticLockService) {
        this.pessimisticLockService = pessimisticLockService;
    }

    protected ProposalBudgetHierarchyService getProposalBudgetHierarchyService() {
        return this.proposalBudgetHierarchyService;
    }

    public void setProposalBudgetHierarchyService(ProposalBudgetHierarchyService proposalBudgetHierarchyService) {
        this.proposalBudgetHierarchyService = proposalBudgetHierarchyService;
    }

    public RouteHeaderService getRouteHeaderService() {
        return this.routeHeaderService;
    }

    public void setRouteHeaderService(RouteHeaderService routeHeaderService) {
        this.routeHeaderService = routeHeaderService;
    }

    public RouteNodeService getRouteNodeService() {
        return this.routeNodeService;
    }

    public void setRouteNodeService(RouteNodeService routeNodeService) {
        this.routeNodeService = routeNodeService;
    }

    public ProposalBudgetService getBudgetService() {
        return this.budgetService;
    }

    public void setBudgetService(ProposalBudgetService budgetService) {
        this.budgetService = budgetService;
    }
}

