/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.budget;

import java.io.Serializable;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.kra.award.AwardForm;
import org.kuali.kra.award.budget.AwardBudgetLimit;

public class AwardBudgetLimitsBean
implements Serializable {
    private AwardForm awardForm;

    public AwardBudgetLimitsBean(AwardForm awardForm) {
        this.awardForm = awardForm;
    }

    public ScaleTwoDecimal getTotalCostBudgetLimit() {
        return this.getSpecificBudgetLimit(AwardBudgetLimit.LIMIT_TYPE.TOTAL_COST).getLimit();
    }

    public void setTotalCostBudgetLimit(ScaleTwoDecimal newLimit) {
        this.setSpecificBudgetLimit(newLimit, AwardBudgetLimit.LIMIT_TYPE.TOTAL_COST);
    }

    public ScaleTwoDecimal getDirectCostBudgetLimit() {
        return this.getSpecificBudgetLimit(AwardBudgetLimit.LIMIT_TYPE.DIRECT_COST).getLimit();
    }

    public void setDirectCostBudgetLimit(ScaleTwoDecimal newLimit) {
        this.setSpecificBudgetLimit(newLimit, AwardBudgetLimit.LIMIT_TYPE.DIRECT_COST);
    }

    public ScaleTwoDecimal getIndirectCostBudgetLimit() {
        return this.getSpecificBudgetLimit(AwardBudgetLimit.LIMIT_TYPE.INDIRECT_COST).getLimit();
    }

    public void setIndirectCostBudgetLimit(ScaleTwoDecimal newLimit) {
        this.setSpecificBudgetLimit(newLimit, AwardBudgetLimit.LIMIT_TYPE.INDIRECT_COST);
    }

    protected AwardBudgetLimit getSpecificBudgetLimit(AwardBudgetLimit.LIMIT_TYPE type) {
        for (AwardBudgetLimit limit : this.awardForm.getAwardDocument().getAward().getAwardBudgetLimits()) {
            if (limit.getLimitType() != type) continue;
            return limit;
        }
        return new AwardBudgetLimit(type);
    }

    protected void setSpecificBudgetLimit(ScaleTwoDecimal newLimit, AwardBudgetLimit.LIMIT_TYPE type) {
        for (AwardBudgetLimit limit : this.awardForm.getAwardDocument().getAward().getAwardBudgetLimits()) {
            if (limit.getLimitType() != type) continue;
            limit.setLimit(newLimit);
            return;
        }
        AwardBudgetLimit limit = new AwardBudgetLimit(type);
        limit.setLimit(newLimit);
        this.awardForm.getAwardDocument().getAward().getAwardBudgetLimits().add(limit);
    }
}

