/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.framework.custom.attr;

import java.sql.PreparedStatement;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.kuali.coeus.common.api.custom.attr.CustomAttributeContract;
import org.kuali.coeus.common.framework.custom.CustomDataUtils;
import org.kuali.coeus.common.framework.custom.DocumentCustomData;
import org.kuali.coeus.common.framework.custom.attr.CustomAttributeDataType;
import org.kuali.coeus.common.framework.custom.attr.CustomAttributeDocValue;
import org.kuali.coeus.common.framework.person.attr.PersonCustomData;
import org.kuali.coeus.common.util.Wrapper;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.util.ProfileUtils;
import org.kuali.kra.award.customdata.AwardCustomData;
import org.kuali.kra.excon.project.customdata.ExconProjectCustomData;
import org.kuali.kra.institutionalproposal.customdata.InstitutionalProposalCustomData;
import org.kuali.kra.negotiations.customdata.NegotiationCustomData;
import org.kuali.kra.subaward.customdata.SubAwardCustomData;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;
import org.kuali.rice.krad.service.LegacyDataAdapter;
import org.springframework.jdbc.core.JdbcOperations;

@Entity
@Table(name="CUSTOM_ATTRIBUTE")
public class CustomAttribute
extends KcPersistableBusinessObjectBase
implements CustomAttributeContract {
    @PortableSequenceGenerator(name="SEQ_CUSTOM_ATTRIBUTE")
    @GeneratedValue(generator="SEQ_CUSTOM_ATTRIBUTE")
    @Id
    @Column(name="ID")
    private Long id;
    @Column(name="DATA_LENGTH")
    private Integer dataLength;
    @Column(name="DATA_TYPE_CODE")
    private String dataTypeCode;
    @Column(name="ALLOWS_MULTIPLE_VALUES")
    @Convert(converter=BooleanYNConverter.class)
    private boolean allowsMultipleValues;
    @Column(name="DEFAULT_VALUE")
    private String defaultValue;
    @Column(name="GROUP_NAME")
    private String groupName = "General";
    @Column(name="LABEL")
    private String label;
    @Column(name="LOOKUP_CLASS")
    private String lookupClass;
    @Column(name="LOOKUP_RETURN")
    private String lookupReturn;
    @Column(name="NAME")
    private String name;
    @ManyToOne(cascade={CascadeType.REFRESH})
    @JoinColumn(name="DATA_TYPE_CODE", referencedColumnName="DATA_TYPE_CODE", insertable=false, updatable=false)
    private CustomAttributeDataType customAttributeDataType;
    @Transient
    private transient JdbcOperations jdbcOperations;
    @Transient
    private transient LegacyDataAdapter legacyDataAdapter;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getDataLength() {
        return this.dataLength;
    }

    public void setDataLength(Integer dataLength) {
        this.dataLength = dataLength;
    }

    public String getDataTypeCode() {
        return this.dataTypeCode;
    }

    public void setDataTypeCode(String dataTypeCode) {
        this.dataTypeCode = dataTypeCode;
    }

    public boolean getAllowsMultipleValues() {
        return this.allowsMultipleValues;
    }

    public void setAllowsMultipleValues(boolean allowsMultipleValues) {
        this.allowsMultipleValues = allowsMultipleValues;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLookupClass() {
        return this.lookupClass;
    }

    public void setLookupClass(String lookupClass) {
        this.lookupClass = lookupClass;
    }

    public String getLookupReturn() {
        return this.lookupReturn;
    }

    public void setLookupReturn(String lookupReturn) {
        this.lookupReturn = lookupReturn;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCustomAttributeDataType(CustomAttributeDataType customAttributeDataType) {
        this.customAttributeDataType = customAttributeDataType;
    }

    public CustomAttributeDataType getCustomAttributeDataType() {
        return this.customAttributeDataType;
    }

    private JdbcOperations getJdbcOperations() {
        if (this.jdbcOperations == null) {
            this.jdbcOperations = KcServiceLocator.getService(JdbcOperations.class);
        }
        return this.jdbcOperations;
    }

    private LegacyDataAdapter _getLegacyDataAdapter() {
        if (this.legacyDataAdapter == null) {
            this.legacyDataAdapter = KcServiceLocator.getService(LegacyDataAdapter.class);
        }
        return this.legacyDataAdapter;
    }

    @Override
    protected void preUpdate() {
        super.preUpdate();
        String selectAllowsMultipleValuesSqlQuery = "SELECT ALLOWS_MULTIPLE_VALUES FROM CUSTOM_ATTRIBUTE WHERE ID = ?";
        boolean oldAllowsMultipleValues = Boolean.TRUE.equals(this.getJdbcOperations().query(c -> {
            PreparedStatement statement = c.prepareStatement("SELECT ALLOWS_MULTIPLE_VALUES FROM CUSTOM_ATTRIBUTE WHERE ID = ?");
            statement.setLong(1, this.id);
            return statement;
        }, rs -> rs.next() && rs.getBoolean(1)));
        if (this.allowsMultipleValues != oldAllowsMultipleValues) {
            this.updateCustomDataOnAllowsMultipleValuesChange(CustomAttributeDocValue.class, "id", this.id);
            this.updateCustomDataOnAllowsMultipleValuesChange(AwardCustomData.class, "awardCustomDataId", this.id);
            this.updateCustomDataOnAllowsMultipleValuesChange(SubAwardCustomData.class, "subAwardCustomDataId", this.id);
            if (ProfileUtils.isProfileActive("excon")) {
                this.updateCustomDataOnAllowsMultipleValuesChange(ExconProjectCustomData.class, "projectCustomDataId", this.id);
            }
            this.updateCustomDataOnAllowsMultipleValuesChange(NegotiationCustomData.class, "negotiationCustomDataId", this.id);
            this.updateCustomDataOnAllowsMultipleValuesChange(PersonCustomData.class, "personCustomDataId", this.id);
            this.updateCustomDataOnAllowsMultipleValuesChange(InstitutionalProposalCustomData.class, "proposalCustomDataId", this.id);
        }
    }

    private <T extends DocumentCustomData> void updateCustomDataOnAllowsMultipleValuesChange(Class<T> aClass, String idColumnName, Long id) {
        List docValues = this._getLegacyDataAdapter().findMatching(aClass, Map.of(idColumnName, id));
        docValues.stream().filter(docValue -> docValue.getValue() != null).forEach(docValue -> {
            docValue.setValue(this.allowsMultipleValues ? this.convertSingleValueToMultiValue(docValue.getValue()) : this.convertMultiValueToSingleValue(docValue.getValue()));
            this._getLegacyDataAdapter().save(docValue);
        });
        this._getLegacyDataAdapter().flush(aClass);
    }

    private String convertSingleValueToMultiValue(String singleValue) {
        return CustomDataUtils.serializeListValue(List.of(new Wrapper<String>(singleValue)));
    }

    private String convertMultiValueToSingleValue(String multiValue) {
        List<Wrapper<String>> listValue = CustomDataUtils.deserializeListValue(multiValue);
        return listValue.stream().map(Wrapper::getValue).findFirst().orElse(null);
    }
}

