/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.instprop.impl.api.service.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.kuali.coeus.common.api.SpecialReviewDto;
import org.kuali.coeus.common.api.document.service.CommonApiService;
import org.kuali.coeus.common.api.rolodex.RolodexContract;
import org.kuali.coeus.common.api.rolodex.RolodexService;
import org.kuali.coeus.common.framework.compliance.core.AddSpecialReviewEvent;
import org.kuali.coeus.common.framework.compliance.core.AddSpecialReviewRule;
import org.kuali.coeus.common.framework.custom.attr.CustomAttributeDocument;
import org.kuali.coeus.common.framework.type.InvestigatorCreditType;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.coeus.instprop.impl.api.dto.InstitutionalProposalDto;
import org.kuali.coeus.instprop.impl.api.dto.IpCfdaDto;
import org.kuali.coeus.instprop.impl.api.dto.IpCommentsDto;
import org.kuali.coeus.instprop.impl.api.dto.IpCostShareDto;
import org.kuali.coeus.instprop.impl.api.dto.IpFandADto;
import org.kuali.coeus.instprop.impl.api.dto.IpPersonDto;
import org.kuali.coeus.instprop.impl.api.dto.IpUnrecoveredFandADto;
import org.kuali.coeus.instprop.impl.api.dto.ProposalLogDto;
import org.kuali.coeus.instprop.impl.api.service.InstitutionalProposalApiService;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.rest.UnprocessableEntityException;
import org.kuali.coeus.sys.framework.view.JstlFunctions;
import org.kuali.kra.award.home.fundingproposal.AwardFundingProposal;
import org.kuali.kra.institutionalproposal.ProposalIpReviewJoin;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPerson;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonCreditSplit;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonUnit;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonUnitCreditSplit;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalProjectPersonAddRuleImpl;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalProjectPersonRuleAddEvent;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalUnitContact;
import org.kuali.kra.institutionalproposal.customdata.InstitutionalProposalCustomData;
import org.kuali.kra.institutionalproposal.document.InstitutionalProposalDocument;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalCfda;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalComment;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalCostShare;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalFandA;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalScienceKeyword;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalUnrecoveredFandA;
import org.kuali.kra.institutionalproposal.proposallog.ProposalLog;
import org.kuali.kra.institutionalproposal.proposallog.service.ProposalLogService;
import org.kuali.kra.institutionalproposal.service.InstitutionalProposalService;
import org.kuali.kra.institutionalproposal.specialreview.InstitutionalProposalSpecialReview;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.entity.Entity;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="institutionalProposalApiService")
public class InstitutionalProposalApiServiceImpl
implements InstitutionalProposalApiService {
    private static final String DEFAULT_VALUE = "0";
    @Autowired
    @Qualifier(value="documentService")
    private DocumentService documentService;
    @Autowired
    @Qualifier(value="proposalLogService")
    private ProposalLogService proposalLogService;
    @Autowired
    @Qualifier(value="institutionalProposalService")
    private InstitutionalProposalService institutionalProposalService;
    @Autowired
    @Qualifier(value="identityService")
    private IdentityService identityService;
    @Autowired
    @Qualifier(value="rolodexService")
    private RolodexService rolodexService;
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;
    @Autowired
    @Qualifier(value="commonApiService")
    private CommonApiService commonApiService;

    @Override
    public void addCustomData(InstitutionalProposal institutionalProposal, InstitutionalProposalDto institutionalProposalDto) {
        Map<String, CustomAttributeDocument> customAttributeDocuments = institutionalProposal.getInstitutionalProposalDocument().getCustomAttributeDocuments();
        if (institutionalProposalDto.getInstitutionalProposalCustomDataList() != null) {
            institutionalProposalDto.getInstitutionalProposalCustomDataList().forEach(customDataDto -> {
                String customAttributeId = customDataDto.getCustomAttributeId().toString();
                String customDataValue = customDataDto.getValue();
                InstitutionalProposalCustomData customData = new InstitutionalProposalCustomData();
                customAttributeDocuments.keySet().forEach(id -> {
                    CustomAttributeDocument customAttributeDoc = (CustomAttributeDocument)customAttributeDocuments.get(id);
                    if (customAttributeId.equalsIgnoreCase(customAttributeDoc.getCustomAttribute().getId().toString())) {
                        customData.setCustomAttributeId(customAttributeDoc.getId());
                        customData.setCustomAttribute(customAttributeDoc.getCustomAttribute());
                        customData.setValue(customDataValue);
                        customData.setInstitutionalProposal(institutionalProposal);
                        institutionalProposal.getInstitutionalProposalCustomDataList().add(customData);
                    }
                });
            });
        }
    }

    @Override
    public InstitutionalProposalDocument saveInitialProposal(InstitutionalProposal proposal, String description) throws WorkflowException {
        InstitutionalProposalDocument ipDocument = (InstitutionalProposalDocument)this.getDocumentService().getNewDocument(InstitutionalProposalDocument.class);
        String proposalNumber = this.getInstitutionalProposalService().getNextInstitutionalProposalNumber();
        this.addRequiredFields(proposal, ipDocument, proposalNumber);
        this.initializeCollections(proposal);
        proposal.setProjectPersons(new ArrayList<InstitutionalProposalPerson>());
        proposal.setInstitutionalProposalCustomDataList(new ArrayList<InstitutionalProposalCustomData>());
        proposal.setInstitutionalProposalCostShares(new ArrayList<InstitutionalProposalCostShare>());
        proposal.setProposalComments(new ArrayList<InstitutionalProposalComment>());
        proposal.setInstitutionalProposalFandAs(new ArrayList<InstitutionalProposalFandA>());
        proposal.setInstitutionalProposalUnrecoveredFandAs(new ArrayList<InstitutionalProposalUnrecoveredFandA>());
        proposal.setProposalCfdas(new ArrayList<InstitutionalProposalCfda>());
        ipDocument.getDocumentHeader().setDocumentDescription(description);
        ipDocument.setInstitutionalProposal(proposal);
        this.commonApiService.saveDocument((Document)ipDocument);
        return ipDocument;
    }

    @Override
    public void initializeCollections(InstitutionalProposal proposal) {
        if (proposal.getProjectPersons() == null) {
            proposal.setProjectPersons(new ArrayList<InstitutionalProposalPerson>());
        }
        if (proposal.getInstitutionalProposalCustomDataList() == null) {
            proposal.setInstitutionalProposalCustomDataList(new ArrayList<InstitutionalProposalCustomData>());
        }
        if (proposal.getSpecialReviews() == null) {
            proposal.setSpecialReviews(new ArrayList<InstitutionalProposalSpecialReview>());
        }
        if (proposal.getInstitutionalProposalScienceKeywords() == null) {
            proposal.setInstitutionalProposalScienceKeywords(new ArrayList<InstitutionalProposalScienceKeyword>());
        }
        if (proposal.getInstitutionalProposalCostShares() == null) {
            proposal.setInstitutionalProposalCostShares(new ArrayList<InstitutionalProposalCostShare>());
        }
        if (proposal.getInstitutionalProposalUnrecoveredFandAs() == null) {
            proposal.setInstitutionalProposalUnrecoveredFandAs(new ArrayList<InstitutionalProposalUnrecoveredFandA>());
        }
        if (proposal.getProposalIpReviewJoins() == null) {
            proposal.setProposalIpReviewJoins(new ArrayList<ProposalIpReviewJoin>());
        }
        if (proposal.getAwardFundingProposals() == null) {
            proposal.setAwardFundingProposals(new ArrayList<AwardFundingProposal>());
        }
        if (proposal.getAllFundingProposals() == null) {
            proposal.setAllFundingProposals(new ArrayList<AwardFundingProposal>());
        }
        if (proposal.getInstitutionalProposalUnitContacts() == null) {
            proposal.setInstitutionalProposalUnitContacts(new ArrayList<InstitutionalProposalUnitContact>());
        }
        if (proposal.getProposalComments() == null) {
            proposal.setProposalComments(new ArrayList<InstitutionalProposalComment>());
        }
        if (proposal.getProposalCfdas() == null) {
            proposal.setProposalCfdas(new ArrayList<InstitutionalProposalCfda>());
        }
    }

    @Override
    public void updateProposalLog(String proposalLogNumber, InstitutionalProposalDocument ipDocument) {
        this.getProposalLogService().mergeProposalLog(proposalLogNumber);
        this.getProposalLogService().updateMergedInstProposal(ipDocument.getInstitutionalProposal().getProposalId(), proposalLogNumber);
    }

    @Override
    public String createProposalLog(InstitutionalProposalDto ipDto, IpPersonDto ipId) {
        ProposalLog proposalLog = this.addProposalLog(ipDto, ipId);
        String proposalLogNumber = proposalLog.getProposalNumber();
        this.getProposalLogService().promoteProposalLog(proposalLogNumber);
        return proposalLogNumber;
    }

    @Override
    public void addPersons(InstitutionalProposalDocument proposalDocument, List<IpPersonDto> personDtos) {
        if (personDtos != null) {
            personDtos.forEach(personDto -> this.addPerson(proposalDocument, (IpPersonDto)personDto));
        }
    }

    @Override
    public InstitutionalProposalPerson addPerson(InstitutionalProposalDocument proposalDocument, IpPersonDto personDto) {
        InstitutionalProposal proposal = proposalDocument.getInstitutionalProposal();
        InstitutionalProposalPerson projectPerson = this.commonApiService.convertObject(personDto, InstitutionalProposalPerson.class);
        projectPerson.setUnits(new ArrayList<InstitutionalProposalPersonUnit>());
        projectPerson.setCreditSplits(new ArrayList<InstitutionalProposalPersonCreditSplit>());
        this.validatePersonAndRole(projectPerson);
        if (projectPerson.isPrincipalInvestigator()) {
            proposal.refreshReferenceObject("leadUnit");
            proposal.initializeDefaultPrincipalInvestigator(projectPerson);
            this.validateAndAddPerson(proposalDocument, projectPerson, proposal);
            projectPerson.setRoleCode("PI");
        } else {
            this.initializeProposalPerson(proposalDocument, projectPerson);
        }
        List personUnits = projectPerson.getUnits().stream().map(InstitutionalProposalPersonUnit::getUnitNumber).collect(Collectors.toList());
        if (personDto.getUnits() != null) {
            personDto.getUnits().forEach(unitDto -> {
                InstitutionalProposalPersonUnit instPropPersonUnit;
                if (!personUnits.contains(unitDto.getUnitNumber())) {
                    InstitutionalProposalPersonUnit ippu = this.commonApiService.convertObject(unitDto, InstitutionalProposalPersonUnit.class);
                    projectPerson.getUnits().add(ippu);
                    personUnits.add(unitDto.getUnitNumber());
                }
                if ((instPropPersonUnit = projectPerson.getUnit(unitDto.getUnitNumber())) != null && unitDto.getCreditSplits() != null) {
                    instPropPersonUnit.setCreditSplits(unitDto.getCreditSplits().stream().map(unitCredit -> {
                        InvestigatorCreditType ict = this.commonApiService.convertObject(unitCredit.getInvestigatorCreditType(), InvestigatorCreditType.class);
                        unitCredit.setInvestigatorCreditType(null);
                        InstitutionalProposalPersonUnitCreditSplit ippucs = this.commonApiService.convertObject(unitCredit, InstitutionalProposalPersonUnitCreditSplit.class);
                        ippucs.setInvCreditTypeCode(ict.getCode());
                        ippucs.setInvestigatorCreditType(ict);
                        return ippucs;
                    }).collect(Collectors.toList()));
                } else if (instPropPersonUnit != null) {
                    instPropPersonUnit.setCreditSplits(new ArrayList<InstitutionalProposalPersonUnitCreditSplit>());
                    instPropPersonUnit.initializeDefaultCreditSplits();
                }
            });
        }
        if (personDto.getCreditSplits() != null) {
            projectPerson.setCreditSplits(personDto.getCreditSplits().stream().map(personCredit -> {
                InvestigatorCreditType ict = this.commonApiService.convertObject(personCredit.getInvestigatorCreditType(), InvestigatorCreditType.class);
                personCredit.setInvestigatorCreditType(null);
                InstitutionalProposalPersonCreditSplit ippcs = this.commonApiService.convertObject(personCredit, InstitutionalProposalPersonCreditSplit.class);
                ippcs.setInvCreditTypeCode(ict.getCode());
                ippcs.setInvestigatorCreditType(ict);
                return ippcs;
            }).collect(Collectors.toList()));
        }
        return projectPerson;
    }

    @Override
    public void addSpecialReviews(InstitutionalProposalDocument proposalDocument, List<SpecialReviewDto> specialReviewDtos) {
        if (specialReviewDtos != null) {
            proposalDocument.getInstitutionalProposal().setSpecialReviews(new ArrayList<InstitutionalProposalSpecialReview>());
            ArrayList specialReviews = new ArrayList();
            AddSpecialReviewRule addSpecialReviewRule = new AddSpecialReviewRule();
            IntStream.range(0, specialReviewDtos.size()).forEach(specialReviewIndex -> {
                SpecialReviewDto specialReviewDto = (SpecialReviewDto)specialReviewDtos.get(specialReviewIndex);
                InstitutionalProposalSpecialReview specialReview = this.commonApiService.convertObject(specialReviewDto, InstitutionalProposalSpecialReview.class);
                specialReview.setProposalId(proposalDocument.getInstitutionalProposal().getProposalId());
                specialReview.setSequenceOwner(proposalDocument.getInstitutionalProposal());
                AddSpecialReviewEvent<InstitutionalProposalSpecialReview> event = new AddSpecialReviewEvent<InstitutionalProposalSpecialReview>((Document)proposalDocument, specialReview, specialReviews, JstlFunctions.isProfileActive("excon"));
                boolean success = addSpecialReviewRule.processRules(event);
                if (!success) {
                    String errors = this.commonApiService.getValidationErrors();
                    throw new RuntimeException(errors);
                }
                specialReview.setSpecialReviewNumber(specialReviewIndex + 1);
                proposalDocument.getInstitutionalProposal().addSpecialReview(specialReview);
                specialReviews.add(specialReview);
            });
        }
    }

    @Override
    public void addCostShares(InstitutionalProposalDocument ipDocument, List<IpCostShareDto> institutionalProposalCostShareDtos) {
        InstitutionalProposal ip = ipDocument.getInstitutionalProposal();
        if (institutionalProposalCostShareDtos != null) {
            List ipCostShares = institutionalProposalCostShareDtos.stream().map(ipCostShareDto -> {
                InstitutionalProposalCostShare ipCostShare = this.commonApiService.convertObject(ipCostShareDto, InstitutionalProposalCostShare.class);
                ipCostShare.setInstitutionalProposal(ip);
                return ipCostShare;
            }).collect(Collectors.toList());
            ip.getInstitutionalProposalCostShares().addAll(ipCostShares);
        }
    }

    @Override
    public void addComments(InstitutionalProposalDocument ipDocument, List<IpCommentsDto> commentDtos) {
        InstitutionalProposal ip = ipDocument.getInstitutionalProposal();
        if (commentDtos != null) {
            List ipComments = commentDtos.stream().map(commentDto -> {
                InstitutionalProposalComment ipComment = this.commonApiService.convertObject(commentDto, InstitutionalProposalComment.class);
                ipComment.setInstitutionalProposal(ip);
                return ipComment;
            }).collect(Collectors.toList());
            ip.getProposalComments().addAll(ipComments);
        }
    }

    @Override
    public void addFandAs(InstitutionalProposalDocument ipDocument, List<IpFandADto> fandADtos) {
        InstitutionalProposal ip = ipDocument.getInstitutionalProposal();
        if (fandADtos != null) {
            List ipFandAs = fandADtos.stream().map(ipFandADto -> {
                InstitutionalProposalFandA ipFandA = this.commonApiService.convertObject(ipFandADto, InstitutionalProposalFandA.class);
                ipFandA.setInstitutionalProposal(ip);
                return ipFandA;
            }).collect(Collectors.toList());
            ip.getInstitutionalProposalFandAs().addAll(ipFandAs);
        }
    }

    @Override
    public void addUnrecoveredFandAs(InstitutionalProposalDocument ipDocument, List<IpUnrecoveredFandADto> unrecoveredFandADtos) {
        InstitutionalProposal ip = ipDocument.getInstitutionalProposal();
        if (unrecoveredFandADtos != null) {
            List ipUnrecoveredFandAS = unrecoveredFandADtos.stream().map(unrecoveredFandADto -> {
                InstitutionalProposalUnrecoveredFandA ipUnrecoveredFandA = this.commonApiService.convertObject(unrecoveredFandADto, InstitutionalProposalUnrecoveredFandA.class);
                ipUnrecoveredFandA.setInstitutionalProposal(ip);
                return ipUnrecoveredFandA;
            }).collect(Collectors.toList());
            ip.getInstitutionalProposalUnrecoveredFandAs().addAll(ipUnrecoveredFandAS);
        }
    }

    @Override
    public void addProposalCfdas(InstitutionalProposalDocument ipDocument, List<IpCfdaDto> proposalCfdaDtos) {
        InstitutionalProposal ip = ipDocument.getInstitutionalProposal();
        if (proposalCfdaDtos != null) {
            List cfdas = proposalCfdaDtos.stream().map(proposalCfdaDto -> {
                InstitutionalProposalCfda proposalCfda = this.commonApiService.convertObject(proposalCfdaDto, InstitutionalProposalCfda.class);
                proposalCfda.setInstitutionalProposal(ip);
                return proposalCfda;
            }).collect(Collectors.toList());
            ip.getProposalCfdas().addAll(cfdas);
        }
    }

    private InstitutionalProposalProjectPersonRuleAddEvent generateAddProjectPersonEvent(InstitutionalProposalPerson person, InstitutionalProposalDocument document) {
        return new InstitutionalProposalProjectPersonRuleAddEvent("AddInstitutionalProposalProjectPersonRuleEvent", "projectPersonnelBean.newInstitutionalProposalContact", (Document)document, person);
    }

    protected void initializeProposalPerson(InstitutionalProposalDocument proposalDocument, InstitutionalProposalPerson person) {
        InstitutionalProposal proposal = proposalDocument.getInstitutionalProposal();
        person.setProposalNumber(proposal.getProposalNumber());
        person.setSequenceNumber(proposal.getSequenceNumber());
        person.initializeDefaultCreditSplits();
        person.setFaculty(this.getFacultyFlag(person));
        person.setInstitutionalProposal(proposal);
        person.setContactRoleCode(person.getRoleCode());
        person.refreshContactRole();
        if (!person.isKeyPerson()) {
            InstitutionalProposalPersonUnit ipPersonUnit = new InstitutionalProposalPersonUnit();
            ipPersonUnit.setUnitNumber(this.getPersonUnit(person).getUnitNumber());
            ipPersonUnit.initializeDefaultCreditSplits();
            person.add(ipPersonUnit);
        }
        this.validateAndAddPerson(proposalDocument, person, proposal);
    }

    protected Unit getPersonUnit(InstitutionalProposalPerson person) {
        return person.getPerson() != null ? person.getPerson().getUnit() : person.getRolodex().getUnit();
    }

    private Boolean getFacultyFlag(InstitutionalProposalPerson person) {
        if (person.getPerson() != null) {
            return person.getPerson().getFacultyFlag();
        }
        return Boolean.FALSE;
    }

    private void validateAndAddPerson(InstitutionalProposalDocument proposalDocument, InstitutionalProposalPerson person, InstitutionalProposal proposal) {
        InstitutionalProposalProjectPersonRuleAddEvent event = this.generateAddProjectPersonEvent(person, proposalDocument);
        boolean success = new InstitutionalProposalProjectPersonAddRuleImpl().processAddInstitutionalProposalProjectPersonBusinessRules(event);
        if (!success) {
            String errors = this.commonApiService.getValidationErrors();
            throw new RuntimeException(errors);
        }
        proposal.add(person);
    }

    public void validatePersonAndRole(InstitutionalProposalPerson person) {
        this.validatePerson(person);
        if (!person.isInvestigator() && !person.isKeyPerson()) {
            throw new UnprocessableEntityException("Invalid role " + person.getRoleCode() + " for person " + this.getId(person));
        }
    }

    public void validatePerson(InstitutionalProposalPerson person) {
        Entity personEntity = null;
        RolodexContract rolodex = null;
        if (person.getPersonId() != null) {
            personEntity = this.identityService.getEntityByPrincipalId(person.getPersonId());
        } else {
            rolodex = this.rolodexService.getRolodex(person.getRolodexId());
            if (rolodex != null) {
                person.setRolodexId(rolodex.getRolodexId());
                person.setPersonId(null);
            }
        }
        if (rolodex == null && personEntity == null) {
            throw new UnprocessableEntityException("Invalid person or rolodex for person " + this.getId(person));
        }
    }

    protected String getId(InstitutionalProposalPerson person) {
        return person.getPersonId() != null ? person.getPersonId() : person.getRolodexId().toString();
    }

    public ProposalLog addProposalLog(InstitutionalProposalDto ipDto, IpPersonDto personDto) {
        ProposalLogDto proposalLogDto = this.commonApiService.convertObject(ipDto, ProposalLogDto.class);
        ProposalLog proposalLog = this.commonApiService.convertObject(proposalLogDto, ProposalLog.class);
        if (ipDto.getProposalTypeCode() == null) {
            throw new UnprocessableEntityException("Proposal type code cannot be null.");
        }
        proposalLog.setProposalTypeCode(ipDto.getProposalTypeCode().toString());
        if (ipDto.getCreateTimestamp() != null) {
            proposalLog.setCreateTimestamp(new Timestamp(ipDto.getCreateTimestamp().getTime()));
        }
        proposalLog.setLogStatus("1");
        proposalLog.setCreateUser("admin");
        if (personDto != null) {
            InstitutionalProposalPerson projectPerson = this.commonApiService.convertObject(personDto, InstitutionalProposalPerson.class);
            this.validatePerson(projectPerson);
            if (projectPerson.isPrincipalInvestigator()) {
                proposalLog.setRolodexId(projectPerson.getRolodexId());
                proposalLog.setPiId(projectPerson.getPersonId());
            }
        }
        proposalLog.setProposalNumber(this.institutionalProposalService.getNextInstitutionalProposalNumber());
        this.businessObjectService.save((PersistableBusinessObject)proposalLog);
        return proposalLog;
    }

    @Override
    public void addRequiredFields(InstitutionalProposal proposal, InstitutionalProposalDocument ipDocument, String proposalNumber) {
        proposal.setProposalNumber(proposalNumber);
        proposal.setProposalSequenceStatus(VersionStatus.ACTIVE.toString());
        proposal.setSequenceNumber(1);
        proposal.setSubcontractFlag(false);
        proposal.setInstProposalNumber(proposalNumber);
        if (proposal.getScienceCodeIndicator() == null) {
            proposal.setScienceCodeIndicator(DEFAULT_VALUE);
        }
        if (proposal.getAwardType() == null) {
            proposal.setAwardTypeCode(null);
        }
        proposal.setInstitutionalProposalDocument(ipDocument);
    }

    @Override
    public void initializeCostTotals(InstitutionalProposal proposal) {
        if (proposal.getTotalDirectCostTotal() == null) {
            proposal.setTotalDirectCostTotal(ScaleTwoDecimal.ZERO);
        }
        if (proposal.getTotalIndirectCostInitial() == null) {
            proposal.setTotalIndirectCostInitial(ScaleTwoDecimal.ZERO);
        }
        if (proposal.getTotalDirectCostInitial() == null) {
            proposal.setTotalDirectCostInitial(ScaleTwoDecimal.ZERO);
        }
        if (proposal.getTotalIndirectCostTotal() == null) {
            proposal.setTotalIndirectCostTotal(ScaleTwoDecimal.ZERO);
        }
    }

    @Override
    public void initializeData(InstitutionalProposal proposal) {
        if (proposal.getCostSharingIndicator() == null) {
            proposal.setCostSharingIndicator(DEFAULT_VALUE);
        }
        if (proposal.getIdcRateIndicator() == null) {
            proposal.setIdcRateIndicator(DEFAULT_VALUE);
        }
        if (proposal.getSpecialReviewIndicator() == null) {
            proposal.setSpecialReviewIndicator(DEFAULT_VALUE);
        }
        if (proposal.getScienceCodeIndicator() == null) {
            proposal.setScienceCodeIndicator(DEFAULT_VALUE);
        }
        this.initializeCollections(proposal);
        this.initializeCostTotals(proposal);
    }

    public InstitutionalProposalService getInstitutionalProposalService() {
        return this.institutionalProposalService;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public ProposalLogService getProposalLogService() {
        return this.proposalLogService;
    }
}

