/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.award.api;

import org.kuali.coeus.award.api.AwardApiService;
import org.kuali.coeus.award.dto.AwardDto;
import org.kuali.coeus.common.api.document.service.CommonApiService;
import org.kuali.kra.award.contacts.AwardSponsorContact;
import org.kuali.kra.award.home.Award;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="awardApiService")
public class AwardApiServiceImpl
implements AwardApiService {
    @Autowired
    @Qualifier(value="commonApiService")
    private CommonApiService commonApiService;

    @Override
    public AwardDto convertAwardToDto(Award award) {
        AwardDto awardDto = this.commonApiService.convertObject(award, AwardDto.class);
        awardDto.getAwardSponsorContacts().forEach(contact -> {
            AwardSponsorContact awardContactFound = award.getSponsorContacts().stream().filter(awardcontact -> contact.getAwardContactId().compareTo(awardcontact.getAwardContactId()) == 0).findFirst().orElse(null);
            contact.setOrgName(awardContactFound != null ? awardContactFound.getContactOrganizationName() : "");
        });
        return awardDto;
    }

    public CommonApiService getCommonApiService() {
        return this.commonApiService;
    }

    public void setCommonApiService(CommonApiService commonApiService) {
        this.commonApiService = commonApiService;
    }
}

