/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.framework.rate;

import java.io.Serializable;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.kuali.coeus.common.budget.api.core.IdentifiableBudget;
import org.kuali.coeus.common.budget.api.rate.RateClassType;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.rate.AbstractInstituteRate;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.persistence.ScaleTwoDecimalConverter;

@MappedSuperclass
@IdClass(value=AbstractBudgetRateId.class)
public abstract class AbstractBudgetRate
extends AbstractInstituteRate
implements IdentifiableBudget {
    private static final long serialVersionUID = -7152006670699620080L;
    @Id
    @Column(name="BUDGET_ID", insertable=false, updatable=false)
    private Long budgetId;
    @ManyToOne(cascade={CascadeType.REFRESH})
    @JoinColumn(name="BUDGET_ID", referencedColumnName="BUDGET_ID")
    private Budget budget;
    @Column(name="APPLICABLE_RATE")
    @Convert(converter=ScaleTwoDecimalConverter.class)
    private ScaleTwoDecimal applicableRate;
    @Transient
    private ScaleTwoDecimal oldApplicableRate;
    @Transient
    private boolean rateChanged;
    @Transient
    private String viewLocation;
    @Transient
    private boolean displayLocation = true;
    @Transient
    private String budgetPeriod;
    @Transient
    private String affectedBudgetPeriod;
    @Transient
    private String trackAffectedPeriod;

    public AbstractBudgetRate() {
    }

    public AbstractBudgetRate(String unitNumber, AbstractInstituteRate abstractInstituteRate) {
        this();
        this.copyValues(unitNumber, abstractInstituteRate);
    }

    private void copyValues(String unitNumber, AbstractInstituteRate abstractInstituteRate) {
        this.setApplicableRate(abstractInstituteRate.getExternalApplicableRate());
        this.setFiscalYear(abstractInstituteRate.getFiscalYear());
        this.setInstituteRate(abstractInstituteRate.getInstituteRate());
        this.setOnOffCampusFlag(abstractInstituteRate.getOnOffCampusFlag());
        this.setRateClass(abstractInstituteRate.getRateClass());
        this.setRateClassCode(abstractInstituteRate.getRateClassCode());
        this.setRateType(abstractInstituteRate.getRateType());
        this.setRateTypeCode(abstractInstituteRate.getRateTypeCode());
        this.setStartDate(abstractInstituteRate.getStartDate());
        this.setUnitNumber(unitNumber);
        this.setOldApplicableRate(abstractInstituteRate.getInstituteRate());
        this.setNonEditableRateFlag(abstractInstituteRate.getNonEditableRateFlag());
    }

    @Override
    public boolean getNonEditableRateFlag() {
        boolean nonEditableRate = false;
        if (this.getBudget() != null) {
            if (RateClassType.EMPLOYEE_BENEFITS.getRateClassType().equals(this.getRateClassType())) {
                nonEditableRate = this.getBudget().getEbRatesNonEditable();
            } else if (RateClassType.OVERHEAD.getRateClassType().equals(this.getRateClassType())) {
                nonEditableRate = this.getBudget().getOhRatesNonEditable();
            }
        }
        return nonEditableRate;
    }

    public ScaleTwoDecimal getApplicableRate() {
        return ScaleTwoDecimal.returnZeroIfNull((ScaleTwoDecimal)this.applicableRate);
    }

    public ScaleTwoDecimal getExactApplicableRate() {
        return this.applicableRate;
    }

    public boolean isApplicableRateNull() {
        return this.applicableRate == null;
    }

    public void setExactApplicableRate(ScaleTwoDecimal applicableRate) {
        this.setApplicableRate(applicableRate);
    }

    public void setApplicableRate(ScaleTwoDecimal applicableRate) {
        this.setOldApplicableRate(this.applicableRate);
        if (!Objects.equals(this.applicableRate, applicableRate)) {
            this.setRateChanged(true);
        }
        this.applicableRate = applicableRate;
    }

    public ScaleTwoDecimal getOldApplicableRate() {
        return ScaleTwoDecimal.returnZeroIfNull((ScaleTwoDecimal)this.oldApplicableRate);
    }

    public void setOldApplicableRate(ScaleTwoDecimal oldApplicableRate) {
        this.oldApplicableRate = oldApplicableRate;
    }

    public String getViewLocation() {
        return this.viewLocation;
    }

    public void setViewLocation(String viewLocation) {
        this.viewLocation = viewLocation;
    }

    public boolean isDisplayLocation() {
        return this.displayLocation;
    }

    public void setDisplayLocation(boolean displayLocation) {
        this.displayLocation = displayLocation;
    }

    public String getBudgetPeriod() {
        return this.budgetPeriod;
    }

    public void setBudgetPeriod(String budgetPeriod) {
        this.budgetPeriod = budgetPeriod;
    }

    public final String getAffectedBudgetPeriod() {
        return this.affectedBudgetPeriod;
    }

    public final void setAffectedBudgetPeriod(String affectedBudgetPeriod) {
        this.affectedBudgetPeriod = affectedBudgetPeriod;
    }

    public final String getTrackAffectedPeriod() {
        return this.trackAffectedPeriod;
    }

    public final void setTrackAffectedPeriod(String trackAffectedPeriod) {
        this.trackAffectedPeriod = trackAffectedPeriod;
    }

    public Budget getBudget() {
        return this.budget;
    }

    public void setBudget(Budget budget) {
        this.budget = budget;
    }

    public Long getBudgetId() {
        return this.budgetId;
    }

    public void setBudgetId(Long budgetId) {
        this.budgetId = budgetId;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.affectedBudgetPeriod == null ? 0 : this.affectedBudgetPeriod.hashCode());
        result = 31 * result + (this.applicableRate == null ? 0 : this.applicableRate.hashCode());
        result = 31 * result + (this.budgetId == null ? 0 : this.budgetId.hashCode());
        result = 31 * result + (this.budgetPeriod == null ? 0 : this.budgetPeriod.hashCode());
        result = 31 * result + (this.displayLocation ? 1231 : 1237);
        result = 31 * result + (this.oldApplicableRate == null ? 0 : this.oldApplicableRate.hashCode());
        result = 31 * result + (this.trackAffectedPeriod == null ? 0 : this.trackAffectedPeriod.hashCode());
        result = 31 * result + (this.viewLocation == null ? 0 : this.viewLocation.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractBudgetRate other = (AbstractBudgetRate)obj;
        if (this.affectedBudgetPeriod == null ? other.affectedBudgetPeriod != null : !this.affectedBudgetPeriod.equals(other.affectedBudgetPeriod)) {
            return false;
        }
        if (this.applicableRate == null ? other.applicableRate != null : !this.applicableRate.equals((Object)other.applicableRate)) {
            return false;
        }
        if (this.budget == null ? other.budget != null : !this.budget.equals(other.budget)) {
            return false;
        }
        if (this.budgetId == null ? other.budgetId != null : !this.budgetId.equals(other.budgetId)) {
            return false;
        }
        if (this.budgetPeriod == null ? other.budgetPeriod != null : !this.budgetPeriod.equals(other.budgetPeriod)) {
            return false;
        }
        if (this.displayLocation != other.displayLocation) {
            return false;
        }
        if (this.oldApplicableRate == null ? other.oldApplicableRate != null : !this.oldApplicableRate.equals((Object)other.oldApplicableRate)) {
            return false;
        }
        if (this.trackAffectedPeriod == null ? other.trackAffectedPeriod != null : !this.trackAffectedPeriod.equals(other.trackAffectedPeriod)) {
            return false;
        }
        return !(this.viewLocation == null ? other.viewLocation != null : !this.viewLocation.equals(other.viewLocation));
    }

    public boolean isRateChanged() {
        return this.rateChanged;
    }

    public void setRateChanged(boolean rateChanged) {
        this.rateChanged = rateChanged;
    }

    public static final class AbstractBudgetRateId
    extends AbstractInstituteRate.AbstractInstituteRateId
    implements Serializable,
    Comparable<AbstractBudgetRateId> {
        private Long budgetId;

        @Override
        public String toString() {
            return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("budgetId", (Object)this.budgetId).toString();
        }

        @Override
        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (other.getClass() != this.getClass()) {
                return false;
            }
            AbstractBudgetRateId rhs = (AbstractBudgetRateId)other;
            return new EqualsBuilder().appendSuper(super.equals(rhs)).append((Object)this.budgetId, (Object)rhs.budgetId).isEquals();
        }

        @Override
        public int hashCode() {
            return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.budgetId).toHashCode();
        }

        @Override
        public int compareTo(AbstractBudgetRateId other) {
            return new CompareToBuilder().appendSuper(super.compareTo(other)).append((Object)this.budgetId, (Object)other.budgetId).toComparison();
        }

        public Long getBudgetId() {
            return this.budgetId;
        }

        public void setBudgetId(Long budgetId) {
            this.budgetId = budgetId;
        }
    }
}

