/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.framework.rate;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.BudgetAuditEvent;
import org.kuali.coeus.common.budget.framework.core.BudgetAuditRuleBase;
import org.kuali.coeus.common.budget.framework.core.BudgetAuditRuleEvent;
import org.kuali.coeus.common.budget.framework.core.BudgetConstants;
import org.kuali.coeus.common.budget.framework.rate.AbstractInstituteRate;
import org.kuali.coeus.common.budget.framework.rate.BudgetRate;
import org.kuali.coeus.common.budget.framework.rate.BudgetRatesService;
import org.kuali.coeus.common.budget.framework.rate.InstituteRate;
import org.kuali.coeus.common.framework.ruleengine.KcBusinessRule;
import org.kuali.coeus.common.framework.ruleengine.KcEventMethod;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.AuditError;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@KcBusinessRule(value="budgetRateAuditRule")
public class BudgetRateAuditRule
extends BudgetAuditRuleBase {
    public static final String RATE_CLASS_TYPES_MESSAGE = "Rate class types - ";
    @Autowired
    @Qualifier(value="budgetRatesService")
    private BudgetRatesService budgetRatesService;

    @KcEventMethod
    @Deprecated
    public boolean processRunAuditBusinessRules(BudgetAuditEvent event) {
        boolean retval = true;
        HashSet<String> outOfSyncRates = this.getOutOfSyncRatesForAudit(event.getBudget());
        if (!outOfSyncRates.isEmpty()) {
            this.addAuditErrors(outOfSyncRates);
            retval = false;
        }
        return retval;
    }

    @KcEventMethod
    public boolean processRunAuditBusinessRules(BudgetAuditRuleEvent event) {
        HashSet<String> outOfSyncRates = this.getOutOfSyncRatesForAudit(event.getBudget());
        if (!outOfSyncRates.isEmpty()) {
            BudgetConstants.BudgetAuditRules budgetRatesRule = BudgetConstants.BudgetAuditRules.RATES;
            List<AuditError> auditErrors = this.getAuditErrors(budgetRatesRule, false);
            String additionalMessage = RATE_CLASS_TYPES_MESSAGE + outOfSyncRates.toString();
            auditErrors.add(new AuditError(budgetRatesRule.getPageId(), "warning.rate.outofsync", budgetRatesRule.getPageId(), new String[]{additionalMessage}));
        }
        return true;
    }

    protected BudgetRatesService getBudgetRatesService() {
        return this.budgetRatesService;
    }

    public void setBudgetRatesService(BudgetRatesService budgetRatesService) {
        this.budgetRatesService = budgetRatesService;
    }

    public HashSet<String> getOutOfSyncRatesForAudit(Budget budget) {
        this.getBudgetRatesService().populateInstituteRates(budget);
        HashSet<String> outOfSyncRateClassTypes = new HashSet<String>();
        outOfSyncRateClassTypes.addAll(this.getOutOfSyncRateClassTypes(budget.getInstituteRates(), budget.getBudgetRates()));
        outOfSyncRateClassTypes.addAll(this.getOutOfSyncRateClassTypes(budget.getInstituteLaRates(), budget.getBudgetLaRates()));
        return outOfSyncRateClassTypes;
    }

    protected HashSet<String> getOutOfSyncRateClassTypes(List instituteRates, List budgetRates) {
        HashSet<String> unmatchedRateClassTypes = new HashSet<String>();
        String rateClassType = this.getUnMatchedRateClassType(instituteRates, budgetRates);
        if (rateClassType != null) {
            unmatchedRateClassTypes.add(rateClassType);
        }
        if ((rateClassType = this.getUnMatchedRateClassType(budgetRates, instituteRates)) != null) {
            unmatchedRateClassTypes.add(rateClassType);
        }
        return unmatchedRateClassTypes;
    }

    protected String getUnMatchedRateClassType(List<AbstractInstituteRate> fromRates, List<AbstractInstituteRate> toRates) {
        boolean isRateMatched = false;
        Iterator<AbstractInstituteRate> iterator = fromRates.iterator();
        while (iterator.hasNext()) {
            AbstractInstituteRate rate;
            AbstractInstituteRate budgetRate = rate = iterator.next();
            for (AbstractInstituteRate rate1 : toRates) {
                AbstractInstituteRate instituteRate = rate1;
                if (!(instituteRate.getRateKeyAsString() + instituteRate.getInstituteRate()).equals(budgetRate.getRateKeyAsString() + budgetRate.getInstituteRate())) continue;
                if (instituteRate instanceof InstituteRate) {
                    if (!((InstituteRate)instituteRate).getActivityTypeCode().equals(((BudgetRate)budgetRate).getActivityTypeCode())) continue;
                    isRateMatched = true;
                    break;
                }
                isRateMatched = true;
                break;
            }
            if (isRateMatched) continue;
            return budgetRate.getRateClass().getRateClassType().getDescription();
        }
        return null;
    }

    protected void addAuditErrors(HashSet<String> rateClassTypes) {
        for (String rateClassType : rateClassTypes) {
            String errorPath = "document.budgetProposalRate[" + rateClassType + "]";
            this.getAuditErrors().add(new AuditError(errorPath, "warning.rate.outofsync", "budgetRate." + rateClassType));
        }
    }

    protected List<AuditError> getAuditErrors() {
        String BUDGET_RATE_AUDIT_WARNING_KEY = "budgetRateAuditWarnings";
        ArrayList<AuditError> auditErrors = new ArrayList();
        if (!this.getGlobalVariableService().getAuditErrorMap().containsKey(BUDGET_RATE_AUDIT_WARNING_KEY)) {
            this.getGlobalVariableService().getAuditErrorMap().put(BUDGET_RATE_AUDIT_WARNING_KEY, new AuditCluster("Budget Rate", auditErrors, "Warnings"));
        } else {
            auditErrors = this.getGlobalVariableService().getAuditErrorMap().get(BUDGET_RATE_AUDIT_WARNING_KEY).getAuditErrorList();
        }
        return auditErrors;
    }
}

