/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.core;

import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="validationHelper")
public class ValidationHelper {
    private static final String REQUIRED_ERROR_KEY = "error.required";
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;

    public boolean checkRequiredField(Object fieldValue, String errorProperty, String ... errorParms) {
        boolean isEmpty = this.isEmpty(fieldValue);
        if (isEmpty) {
            this.globalVariableService.getMessageMap().putError(errorProperty, REQUIRED_ERROR_KEY, errorParms);
        }
        return !isEmpty;
    }

    private boolean isEmpty(Object fieldValue) {
        boolean empty;
        boolean bl = empty = fieldValue == null;
        if (!empty && fieldValue instanceof String) {
            String value = (String)fieldValue;
            empty = StringUtils.trimWhitespace((String)value).length() == 0;
        }
        return empty;
    }

    public boolean checkValuePositive(ScaleTwoDecimal projectIncome, String errorProperty, String errorKey, String ... parms) {
        boolean success = projectIncome.isPositive();
        if (!success) {
            this.globalVariableService.getMessageMap().putError(errorProperty, errorKey, parms);
        }
        return success;
    }

    protected GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }
}

