/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.core;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocumentForm;
import org.kuali.coeus.sys.framework.view.KcTransactionalDocumentView;
import org.kuali.rice.core.api.util.RiceConstants;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.authorization.PessimisticLock;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.web.form.TransactionalDocumentFormBase;

public class ProposalDocumentView
extends KcTransactionalDocumentView {
    private static final String KC_ERROR_TRANSACTIONAL_LOCKED = "kc.error.transactional.locked";
    public static final String FULL = "full";

    @Override
    protected void generatePessimisticLockMessages(TransactionalDocumentFormBase form) {
        ProposalDevelopmentDocumentForm proposalDevelopmentDocumentForm = (ProposalDevelopmentDocumentForm)form;
        if (!proposalDevelopmentDocumentForm.isViewOnly() || this.canSaveCertification(proposalDevelopmentDocumentForm)) {
            Document document = form.getDocument();
            String pageId = proposalDevelopmentDocumentForm.getPageId();
            Person user = GlobalVariables.getUserSession().getPerson();
            for (PessimisticLock lock : document.getPessimisticLocks()) {
                String lockRegion;
                String string = lockRegion = lock.getLockDescriptor() != null ? StringUtils.split((String)lock.getLockDescriptor(), (String)"-")[1] : null;
                if (lock.isOwnedByUser(user) || StringUtils.equals((CharSequence)pageId, (CharSequence)"PropDev-BudgetPage") || StringUtils.equals((CharSequence)lockRegion, (CharSequence)"BUDGET") || StringUtils.contains((CharSequence)lockRegion, (CharSequence)"PROPOSAL DEVELOPMENT PERSONNEL")) continue;
                String lockDescriptor = (String)StringUtils.defaultIfBlank((CharSequence)lock.getLockDescriptor(), (CharSequence)FULL);
                String lockOwner = lock.getOwnedByUser().getName();
                String lockTime = RiceConstants.getDefaultTimeFormat().format(lock.getGeneratedTimestamp());
                String lockDate = RiceConstants.getDefaultDateFormat().format(lock.getGeneratedTimestamp());
                if (!this.getParameterService().getParameterValueAsBoolean("KC-GEN", "All", "ALLOW_CLEAR_PESSIMISTIC_LOCK").booleanValue()) {
                    GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.transactional.locked", new String[]{lockDescriptor, lockOwner, lockTime, lockDate});
                } else {
                    GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", KC_ERROR_TRANSACTIONAL_LOCKED, new String[]{lockDescriptor, lockOwner, lockTime, lockDate, lock.getId().toString()});
                }
                this.removeSaveCertification(proposalDevelopmentDocumentForm);
            }
        }
    }

    protected boolean canSaveCertification(ProposalDevelopmentDocumentForm proposalDevelopmentDocumentForm) {
        Map editModes = proposalDevelopmentDocumentForm.getEditModes();
        return (Boolean)editModes.get("canSaveCertification");
    }

    protected void removeSaveCertification(ProposalDevelopmentDocumentForm proposalDevelopmentDocumentForm) {
        Map editModes = proposalDevelopmentDocumentForm.getEditModes();
        editModes.remove("canSaveCertification");
    }
}

