/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.location;

import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.propdev.impl.location.AddProposalCongressionalDistrictEvent;
import org.kuali.coeus.propdev.impl.location.CongressionalDistrict;
import org.kuali.coeus.propdev.impl.location.DeleteProposalCongressionalDistrictEvent;
import org.kuali.coeus.propdev.impl.location.ProposalSiteRule;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;

public class ProposalDevelopmentCongressionalDistrictRule
extends ProposalSiteRule {
    Pattern districtValidationPattern = Pattern.compile("^[a-zA-Z][a-zA-Z]-[0-9]{1,3}|[a-zA-Z][a-zA-Z]-all|00-000|US-all$");
    private GlobalVariableService globalVariableService;

    public boolean processAddCongressionalDistrictRules(AddProposalCongressionalDistrictEvent addCongressionalDistrictEvent) {
        boolean isValid = true;
        List<CongressionalDistrict> congressionalDistricts = addCongressionalDistrictEvent.getCongressionalDistricts();
        CongressionalDistrict congressionalDistrict = addCongressionalDistrictEvent.getCongressionalDistrict();
        String stateCode = congressionalDistrict.getNewState();
        String districtNumber = congressionalDistrict.getNewDistrictNumber().toLowerCase();
        CongressionalDistrict newDistrict = new CongressionalDistrict();
        newDistrict.setCongressionalDistrict(stateCode, districtNumber);
        String districtString = newDistrict.getCongressionalDistrict();
        if (!this.districtValidationPattern.matcher(districtString).matches()) {
            this.getGlobalVariableService().getMessageMap().putErrorForSectionId(addCongressionalDistrictEvent.getCollectionId(), "error.congressionalDistrict.format", new String[]{addCongressionalDistrictEvent.getCollectionLabel(), congressionalDistrict.getCongressionalDistrict()});
            isValid = false;
        }
        if (isValid) {
            isValid = this.checkUniqueness(addCongressionalDistrictEvent, congressionalDistrict);
        }
        return isValid;
    }

    private boolean checkUniqueness(AddProposalCongressionalDistrictEvent addCongressionalDistrictEvent, CongressionalDistrict congressionalDistrict) {
        boolean isValid = true;
        CongressionalDistrict newDistrict = new CongressionalDistrict();
        newDistrict.setCongressionalDistrict(congressionalDistrict.getNewState(), congressionalDistrict.getNewDistrictNumber());
        for (CongressionalDistrict existingDistrict : addCongressionalDistrictEvent.getCongressionalDistricts()) {
            if (!StringUtils.equals((CharSequence)newDistrict.getCongressionalDistrict(), (CharSequence)existingDistrict.getCongressionalDistrict())) continue;
            this.getGlobalVariableService().getMessageMap().putErrorForSectionId(addCongressionalDistrictEvent.getCollectionId(), "error.duplicate.element", new String[]{addCongressionalDistrictEvent.getCollectionLabel(), congressionalDistrict.getCongressionalDistrict()});
            isValid = false;
        }
        return isValid;
    }

    public boolean processDeleteCongressionalDistrictRules(DeleteProposalCongressionalDistrictEvent deleteCongressionalDistrictEvent) {
        String siteIndexStr = deleteCongressionalDistrictEvent.getSiteIndex();
        String districtIndexStr = deleteCongressionalDistrictEvent.getDistrictIndex();
        return this.isIndexValid(siteIndexStr, "Site Index") && this.isIndexValid(districtIndexStr, "District Index");
    }

    public GlobalVariableService getGlobalVariableService() {
        if (this.globalVariableService == null) {
            this.globalVariableService = KcServiceLocator.getService(GlobalVariableService.class);
        }
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }
}

