/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.s2s;

import org.kuali.coeus.propdev.impl.s2s.S2sAppSubmission;
import org.kuali.coeus.propdev.impl.s2s.S2sRequestConfigDto;
import org.kuali.coeus.propdev.impl.s2s.S2sSubmissionDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.stereotype.Repository;

@Repository(value="s2sSubmissionDao")
public class S2sSubmissionDaoJdbcImpl
implements S2sSubmissionDao {
    private static final String SUBMISSION_REQUEST_INFO = "select duns_number, connector_service_name from eps_prop_sites sites inner join organization org on sites.organization_id = org.organization_id inner join s2s_opportunity opp on sites.proposal_number = opp.proposal_number inner join s2s_providers provider on opp.provider = provider.code where sites.location_type_code = 1 and sites.proposal_number = ?";
    @Autowired
    @Qualifier(value="jdbcOperations")
    private JdbcOperations jdbcOperations;

    @Override
    public S2sRequestConfigDto getSubmissionRequestInfo(S2sAppSubmission submission) {
        return (S2sRequestConfigDto)this.jdbcOperations.queryForObject(SUBMISSION_REQUEST_INFO, new Object[]{submission.getProposalNumber()}, (rs, rowNum) -> new S2sRequestConfigDto(rs.getString("duns_number"), rs.getString("connector_service_name")));
    }
}

