/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.s2s.connect;

import gov.grants.apply.services.applicantwebservices_v2.GetApplicationZipRequest;
import gov.grants.apply.services.applicantwebservices_v2.GetApplicationZipResponse;
import gov.grants.apply.services.applicantwebservices_v2.GetOpportunityListRequest;
import gov.grants.apply.services.applicantwebservices_v2.GetOpportunityListResponse;
import gov.grants.apply.services.applicantwebservices_v2.GetSubmissionListRequest;
import gov.grants.apply.services.applicantwebservices_v2.GetSubmissionListResponse;
import gov.grants.apply.services.applicantwebservices_v2.SubmitApplicationRequest;
import gov.grants.apply.services.applicantwebservices_v2.SubmitApplicationResponse;
import gov.grants.apply.services.applicantwebservices_v2_0.ApplicantWebServicesPortType;
import gov.grants.apply.services.applicantwebservices_v2_0.ErrorMessage;
import gov.grants.apply.system.applicantcommonelements_v1.OpportunityFilter;
import gov.grants.apply.system.applicantcommonelements_v1.SubmissionFilter;
import gov.grants.apply.system.applicantcommonelements_v1.SubmissionFilterType;
import gov.grants.apply.system.grantscommonelements_v1.Attachment;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.xml.bind.JAXBException;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.configuration.security.FiltersType;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.propdev.api.s2s.S2SConfigurationService;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.s2s.connect.S2SConfigurationReader;
import org.kuali.coeus.propdev.impl.s2s.connect.S2SConnectorService;
import org.kuali.coeus.propdev.impl.s2s.connect.S2sCommunicationException;
import org.kuali.coeus.sys.framework.util.JaxbUtils;
import org.kuali.rice.krad.data.DataObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class S2SConnectorServiceBase
implements S2SConnectorService {
    protected static final Logger LOG = LogManager.getLogger(S2SConnectorServiceBase.class);
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="s2SConfigurationService")
    private S2SConfigurationService s2SConfigurationService;
    protected S2SConfigurationReader s2SConfigurationReader;

    @Override
    public GetOpportunityListResponse getOpportunityList(String cfdaNumber, String opportunityId, String competitionId, String packageId) throws S2sCommunicationException {
        ApplicantWebServicesPortType port = this.configureApplicantIntegrationSoapPort(null, false);
        GetOpportunityListRequest request = new GetOpportunityListRequest();
        request.setPackageID(packageId);
        if (StringUtils.isBlank((CharSequence)packageId) && (StringUtils.isNotBlank((CharSequence)cfdaNumber) || StringUtils.isNotBlank((CharSequence)competitionId) || StringUtils.isNotBlank((CharSequence)opportunityId))) {
            OpportunityFilter filter = new OpportunityFilter();
            filter.setCFDANumber(cfdaNumber);
            filter.setCompetitionID(competitionId);
            filter.setFundingOpportunityNumber(opportunityId);
            request.setOpportunityFilter(filter);
        }
        try {
            this.debugLogJaxbObject(GetOpportunityListRequest.class, request);
            GetOpportunityListResponse response = port.getOpportunityList(request);
            this.debugLogJaxbObject(GetOpportunityListResponse.class, response);
            return response;
        }
        catch (SOAPFaultException soapFault) {
            LOG.error("Error while getting list of opportunities", (Throwable)soapFault);
            if (soapFault.getMessage().contains("Connection refused")) {
                throw new S2sCommunicationException("error.grantsgov.opportunity.server.unavailable", soapFault.getMessage());
            }
            throw new S2sCommunicationException("error.s2s.unknown", soapFault.getMessage());
        }
        catch (ErrorMessage | WebServiceException e) {
            LOG.error("Error while getting list of opportunities", e);
            throw new S2sCommunicationException("error.s2s.unknown", e.getMessage());
        }
    }

    @Override
    public GetApplicationZipResponse getApplicationZip(String ggTrackingId, String proposalNumber) throws S2sCommunicationException {
        ApplicantWebServicesPortType port = this.getApplicantIntegrationSoapPort(proposalNumber);
        GetApplicationZipRequest request = new GetApplicationZipRequest();
        request.setGrantsGovTrackingNumber(ggTrackingId);
        try {
            this.debugLogJaxbObject(GetApplicationZipRequest.class, request);
            GetApplicationZipResponse response = port.getApplicationZip(request);
            this.debugLogJaxbObject(GetApplicationZipResponse.class, response);
            return response;
        }
        catch (ErrorMessage | WebServiceException e) {
            LOG.error("Error while getting proposal submission status details", e);
            throw new S2sCommunicationException("error.grantsgov.server.status.refresh", e.getMessage());
        }
    }

    @Override
    public GetSubmissionListResponse getSubmissionList(String opportunityId, String ggTrackingId, String packageId, String submissionTitle, String status, String proposalNumber) throws S2sCommunicationException {
        SubmissionFilter submissionFilter;
        GetSubmissionListRequest request = new GetSubmissionListRequest();
        List<SubmissionFilter> filterList = request.getSubmissionFilter();
        if (StringUtils.isNotBlank((CharSequence)opportunityId)) {
            submissionFilter = new SubmissionFilter();
            submissionFilter.setType(SubmissionFilterType.FUNDING_OPPORTUNITY_NUMBER);
            submissionFilter.setValue(opportunityId);
            filterList.add(submissionFilter);
        }
        if (StringUtils.isNotBlank((CharSequence)ggTrackingId)) {
            submissionFilter = new SubmissionFilter();
            submissionFilter.setType(SubmissionFilterType.GRANTS_GOV_TRACKING_NUMBER);
            submissionFilter.setValue(ggTrackingId);
            filterList.add(submissionFilter);
        }
        if (StringUtils.isNotBlank((CharSequence)packageId)) {
            submissionFilter = new SubmissionFilter();
            submissionFilter.setType(SubmissionFilterType.PACKAGE_ID);
            submissionFilter.setValue(packageId);
            filterList.add(submissionFilter);
        }
        if (StringUtils.isNotBlank((CharSequence)submissionTitle)) {
            submissionFilter = new SubmissionFilter();
            submissionFilter.setType(SubmissionFilterType.SUBMISSION_TITLE);
            submissionFilter.setValue(submissionTitle);
            filterList.add(submissionFilter);
        }
        if (StringUtils.isNotBlank((CharSequence)status)) {
            submissionFilter = new SubmissionFilter();
            submissionFilter.setType(SubmissionFilterType.STATUS);
            submissionFilter.setValue(status);
            filterList.add(submissionFilter);
        }
        ApplicantWebServicesPortType port = this.getApplicantIntegrationSoapPort(proposalNumber);
        try {
            this.debugLogJaxbObject(GetSubmissionListRequest.class, request);
            GetSubmissionListResponse response = port.getSubmissionList(request);
            this.debugLogJaxbObject(GetSubmissionListResponse.class, response);
            return response;
        }
        catch (ErrorMessage | WebServiceException e) {
            LOG.error("Error occurred while fetching application list", e);
            throw new S2sCommunicationException("error.grantsgov.server.applicationList.refresh", e.getMessage());
        }
    }

    @Override
    public GetSubmissionListResponse getSubmissionList(String dunsNumber) throws S2sCommunicationException {
        GetSubmissionListRequest request = new GetSubmissionListRequest();
        ApplicantWebServicesPortType port = this.getApplicantIntegrationSoapPortForDunsNumber(dunsNumber);
        try {
            this.debugLogJaxbObject(GetSubmissionListRequest.class, request);
            GetSubmissionListResponse response = port.getSubmissionList(request);
            this.debugLogJaxbObject(GetSubmissionListResponse.class, response);
            return response;
        }
        catch (ErrorMessage | WebServiceException e) {
            LOG.error("Error occurred while fetching application list", e);
            throw new S2sCommunicationException("error.grantsgov.server.applicationList.refresh", e.getMessage());
        }
    }

    @Override
    public SubmitApplicationResponse submitApplication(String xmlText, Map<String, DataHandler> attachments, String proposalNumber) throws S2sCommunicationException {
        ApplicantWebServicesPortType port = this.getApplicantIntegrationSoapPort(proposalNumber);
        SubmitApplicationRequest request = new SubmitApplicationRequest();
        for (Map.Entry<String, DataHandler> entry : attachments.entrySet()) {
            DataHandler dataHandler = entry.getValue();
            Attachment attachment = new Attachment();
            attachment.setFileContentId(entry.getKey());
            attachment.setFileDataHandler(dataHandler);
            request.getAttachment().add(attachment);
        }
        request.setGrantApplicationXML(xmlText);
        try {
            this.debugLogJaxbObject(SubmitApplicationRequest.class, request);
            SubmitApplicationResponse response = port.submitApplication(request);
            this.debugLogJaxbObject(SubmitApplicationResponse.class, response);
            return response;
        }
        catch (ErrorMessage e) {
            LOG.error("Error occurred while submitting proposal to Grants Gov", (Throwable)e);
            throw new S2sCommunicationException("error.grantsgov.server.submit.application", e.getMessage());
        }
        catch (WebServiceException e) {
            LOG.error("Error occurred while submitting proposal to Grants Gov", (Throwable)e);
            throw new S2sCommunicationException("error.s2s.unknown", e.getMessage());
        }
    }

    private <T> void debugLogJaxbObject(Class<? extends T> clazz, T o) {
        if (LOG.isDebugEnabled()) {
            try {
                LOG.debug(JaxbUtils.toString(clazz, o));
            }
            catch (JAXBException e) {
                LOG.debug("Unable to marshall object", (Throwable)e);
            }
        }
    }

    protected ApplicantWebServicesPortType getApplicantIntegrationSoapPort(String proposalNumber) throws S2sCommunicationException {
        DevelopmentProposal proposal = (DevelopmentProposal)this.dataObjectService.find(DevelopmentProposal.class, (Object)proposalNumber);
        return this.getApplicantIntegrationSoapPortForDunsNumber(proposal.getApplicantOrganization().getOrganization().getDunsNumber());
    }

    protected ApplicantWebServicesPortType getApplicantIntegrationSoapPortForDunsNumber(String dunsNumber) throws S2sCommunicationException {
        Boolean multiCampusEnabled = this.s2SConfigurationService.getValueAsBoolean("MULTI_CAMPUS_ENABLED");
        return this.configureApplicantIntegrationSoapPort(dunsNumber, multiCampusEnabled);
    }

    protected ApplicantWebServicesPortType configureApplicantIntegrationSoapPort(String alias, boolean mulitCampusEnabled) throws S2sCommunicationException {
        System.clearProperty("java.protocol.handler.pkgs");
        JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
        factory.setAddress(this.getS2SSoapHost());
        factory.setServiceClass(ApplicantWebServicesPortType.class);
        HashMap<String, Boolean> properties = new HashMap<String, Boolean>();
        properties.put("mtom-enabled", Boolean.TRUE);
        factory.setProperties(properties);
        ApplicantWebServicesPortType applicantWebService = (ApplicantWebServicesPortType)factory.create();
        Client client = ClientProxy.getClient((Object)applicantWebService);
        HTTPClientPolicy httpClientPolicy = new HTTPClientPolicy();
        httpClientPolicy.setConnectionTimeout(0L);
        httpClientPolicy.setReceiveTimeout(0L);
        httpClientPolicy.setAllowChunking(false);
        HTTPConduit conduit = (HTTPConduit)client.getConduit();
        conduit.setClient(httpClientPolicy);
        TLSClientParameters tlsConfig = new TLSClientParameters();
        this.setPossibleCypherSuites(tlsConfig);
        this.configureKeyStoreAndTrustStore(tlsConfig, alias, mulitCampusEnabled);
        conduit.setTlsClientParameters(tlsConfig);
        return applicantWebService;
    }

    protected void setPossibleCypherSuites(TLSClientParameters tlsConfig) {
        FiltersType filters = new FiltersType();
        filters.getInclude().add("SSL_RSA_WITH_RC4_128_MD5");
        filters.getInclude().add("SSL_RSA_WITH_RC4_128_SHA");
        filters.getInclude().add("SSL_RSA_WITH_3DES_EDE_CBC_SHA");
        filters.getInclude().add("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA");
        filters.getInclude().add("TLS_DHE_RSA_WITH_AES_128_CBC_SHA");
        filters.getInclude().add("TLS_DHE_DSS_WITH_AES_128_CBC_SHA256");
        filters.getInclude().add(".*_EXPORT_.*");
        filters.getInclude().add(".*_EXPORT1024_.*");
        filters.getInclude().add(".*_WITH_DES_.*");
        filters.getInclude().add(".*_WITH_3DES_.*");
        filters.getInclude().add(".*_WITH_RC4_.*");
        filters.getInclude().add(".*_WITH_NULL_.*");
        filters.getInclude().add(".*_DH_anon_.*");
        tlsConfig.setDisableCNCheck(this.s2SConfigurationReader.getDisableCNCheck().booleanValue());
        tlsConfig.setSecureSocketProtocol(this.s2SConfigurationReader.getCertAlgorithm());
        tlsConfig.setCipherSuitesFilter(filters);
    }

    protected void configureKeyStoreAndTrustStore(TLSClientParameters tlsConfig, String alias, boolean mulitCampusEnabled) throws S2sCommunicationException {
        KeyStore keyStore = this.s2SConfigurationReader.getKeyStore();
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            if (alias != null && mulitCampusEnabled) {
                KeyStore keyStoreAlias = this.s2SConfigurationReader.getKeyStoreAlias(alias);
                keyManagerFactory.init(keyStoreAlias, this.s2SConfigurationReader.getKeyStorePassword().toCharArray());
            } else {
                keyManagerFactory.init(keyStore, this.s2SConfigurationReader.getKeyStorePassword().toCharArray());
            }
            KeyManager[] km = keyManagerFactory.getKeyManagers();
            tlsConfig.setKeyManagers(km);
            KeyStore trustStore = this.s2SConfigurationReader.getTrustStore();
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            TrustManager[] tm = trustManagerFactory.getTrustManagers();
            tlsConfig.setTrustManagers(tm);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new S2sCommunicationException("error.s2s.keystore.config", e.getMessage());
        }
    }

    protected String getS2SSoapHost() throws S2sCommunicationException {
        StringBuilder host = new StringBuilder();
        host.append(this.s2SConfigurationReader.getServiceHost());
        String port = this.s2SConfigurationReader.getServicePort();
        if (!host.toString().endsWith("/") && !port.startsWith("/")) {
            host.append("/");
        }
        host.append(port);
        return host.toString();
    }

    public S2SConfigurationReader getS2SConfigurationReader() {
        return this.s2SConfigurationReader;
    }

    public void setS2SConfigurationReader(S2SConfigurationReader s2SConfigurationReader) {
        this.s2SConfigurationReader = s2SConfigurationReader;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public S2SConfigurationService getS2SConfigurationService() {
        return this.s2SConfigurationService;
    }

    public void setS2SConfigurationService(S2SConfigurationService s2SConfigurationService) {
        this.s2SConfigurationService = s2SConfigurationService;
    }
}

