/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.s2s.map;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"fileName", "mimeType", "fileLocation", "hashAlgorithm", "hashValue", "fileId", "url", "token"})
public class Attachment {
    @JsonProperty(value="fileName")
    @JsonPropertyDescription(value="The file name that was uploaded.")
    private String fileName;
    @JsonProperty(value="mimeType")
    @JsonPropertyDescription(value="The mime type of the file.")
    private MimeType mimeType = MimeType.fromValue("application/octet-stream");
    @JsonProperty(value="fileLocation")
    @JsonPropertyDescription(value="The file name included in the attachment adjusted for uniqueness.")
    private String fileLocation;
    @JsonProperty(value="hashAlgorithm")
    @JsonPropertyDescription(value="The algorithm used to create a hash-based checksum this file.")
    private HashAlgorithm hashAlgorithm = HashAlgorithm.fromValue("SHA-1");
    @JsonProperty(value="hashValue")
    @JsonPropertyDescription(value="The result from hashing the attachment content using the dictated hashing algorithm.")
    private String hashValue;
    @JsonProperty(value="fileId")
    @JsonPropertyDescription(value="The file data ID used in the common api to fetch an attachment.  May be an S3 bucket path or file page.")
    private String fileId;
    @JsonProperty(value="url")
    @JsonPropertyDescription(value="The url where this attachment data can be fetched from.")
    private String url;
    @JsonProperty(value="token")
    @JsonPropertyDescription(value="A one time use token that can be passed to authenticate a call to the url for this attachment.")
    private String token;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @JsonProperty(value="fileName")
    public String getFileName() {
        return this.fileName;
    }

    @JsonProperty(value="fileName")
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @JsonProperty(value="mimeType")
    public MimeType getMimeType() {
        return this.mimeType;
    }

    @JsonProperty(value="mimeType")
    public void setMimeType(MimeType mimeType) {
        this.mimeType = mimeType;
    }

    @JsonProperty(value="fileLocation")
    public String getFileLocation() {
        return this.fileLocation;
    }

    @JsonProperty(value="fileLocation")
    public void setFileLocation(String fileLocation) {
        this.fileLocation = fileLocation;
    }

    @JsonProperty(value="hashAlgorithm")
    public HashAlgorithm getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    @JsonProperty(value="hashAlgorithm")
    public void setHashAlgorithm(HashAlgorithm hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
    }

    @JsonProperty(value="hashValue")
    public String getHashValue() {
        return this.hashValue;
    }

    @JsonProperty(value="hashValue")
    public void setHashValue(String hashValue) {
        this.hashValue = hashValue;
    }

    @JsonProperty(value="fileId")
    public String getFileId() {
        return this.fileId;
    }

    @JsonProperty(value="fileId")
    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    public void setUrl(String url) {
        this.url = url;
    }

    @JsonProperty(value="token")
    public String getToken() {
        return this.token;
    }

    @JsonProperty(value="token")
    public void setToken(String token) {
        this.token = token;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Attachment.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("fileName");
        sb.append('=');
        sb.append(this.fileName == null ? "<null>" : this.fileName);
        sb.append(',');
        sb.append("mimeType");
        sb.append('=');
        sb.append(this.mimeType == null ? "<null>" : this.mimeType);
        sb.append(',');
        sb.append("fileLocation");
        sb.append('=');
        sb.append(this.fileLocation == null ? "<null>" : this.fileLocation);
        sb.append(',');
        sb.append("hashAlgorithm");
        sb.append('=');
        sb.append(this.hashAlgorithm == null ? "<null>" : this.hashAlgorithm);
        sb.append(',');
        sb.append("hashValue");
        sb.append('=');
        sb.append(this.hashValue == null ? "<null>" : this.hashValue);
        sb.append(',');
        sb.append("fileId");
        sb.append('=');
        sb.append(this.fileId == null ? "<null>" : this.fileId);
        sb.append(',');
        sb.append("url");
        sb.append('=');
        sb.append(this.url == null ? "<null>" : this.url);
        sb.append(',');
        sb.append("token");
        sb.append('=');
        sb.append(this.token == null ? "<null>" : this.token);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.fileName == null ? 0 : this.fileName.hashCode());
        result = result * 31 + (this.mimeType == null ? 0 : this.mimeType.hashCode());
        result = result * 31 + (this.fileLocation == null ? 0 : this.fileLocation.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.hashAlgorithm == null ? 0 : this.hashAlgorithm.hashCode());
        result = result * 31 + (this.hashValue == null ? 0 : this.hashValue.hashCode());
        result = result * 31 + (this.url == null ? 0 : this.url.hashCode());
        result = result * 31 + (this.fileId == null ? 0 : this.fileId.hashCode());
        result = result * 31 + (this.token == null ? 0 : this.token.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Attachment)) {
            return false;
        }
        Attachment rhs = (Attachment)other;
        return (this.fileName == rhs.fileName || this.fileName != null && this.fileName.equals(rhs.fileName)) && (this.mimeType == rhs.mimeType || this.mimeType != null && this.mimeType.equals((Object)rhs.mimeType)) && (this.fileLocation == rhs.fileLocation || this.fileLocation != null && this.fileLocation.equals(rhs.fileLocation)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.hashAlgorithm == rhs.hashAlgorithm || this.hashAlgorithm != null && this.hashAlgorithm.equals((Object)rhs.hashAlgorithm)) && (this.hashValue == rhs.hashValue || this.hashValue != null && this.hashValue.equals(rhs.hashValue)) && (this.url == rhs.url || this.url != null && this.url.equals(rhs.url)) && (this.fileId == rhs.fileId || this.fileId != null && this.fileId.equals(rhs.fileId)) && (this.token == rhs.token || this.token != null && this.token.equals(rhs.token));
    }

    public static enum MimeType {
        APPLICATION_OCTET_STREAM("application/octet-stream");

        private final String value;
        private static final Map<String, MimeType> CONSTANTS;

        private MimeType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static MimeType fromValue(String value) {
            MimeType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, MimeType>();
            for (MimeType c : MimeType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum HashAlgorithm {
        SHA_1("SHA-1");

        private final String value;
        private static final Map<String, HashAlgorithm> CONSTANTS;

        private HashAlgorithm(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static HashAlgorithm fromValue(String value) {
            HashAlgorithm constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, HashAlgorithm>();
            for (HashAlgorithm c : HashAlgorithm.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

