/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.controller;

import java.util.List;
import java.util.Map;
import javax.servlet.FilterRegistration;
import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletSecurityElement;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.context.ServletContextAware;

public class ServletRegistrator
implements InitializingBean,
ServletContextAware {
    private ServletContext servletContext;
    private Servlet servlet;
    private String servletName;
    private boolean asyncSupported;
    private Map<String, String> initParameters;
    private int loadOnStartup;
    private MultipartConfigElement multipartConfigElement;
    private String roleName;
    private ServletSecurityElement servletSecurityElement;
    private List<String> urlMappings;
    private List<String> filtersToMap;
    private boolean mapFilters;

    public void afterPropertiesSet() throws Exception {
        ServletRegistration.Dynamic sr = this.servletContext.addServlet(this.servletName, this.servlet);
        sr.setAsyncSupported(this.asyncSupported);
        if (this.initParameters != null) {
            sr.setInitParameters(this.initParameters);
        }
        sr.setLoadOnStartup(this.loadOnStartup);
        if (this.multipartConfigElement != null) {
            sr.setMultipartConfig(this.multipartConfigElement);
        }
        if (this.roleName != null) {
            sr.setRunAsRole(this.roleName);
        }
        if (this.servletSecurityElement != null) {
            sr.setServletSecurity(this.servletSecurityElement);
        }
        sr.addMapping(this.urlMappings.toArray(new String[0]));
        if (this.mapFilters && this.filtersToMap != null) {
            for (String filterName : this.filtersToMap) {
                FilterRegistration filter = this.getServletContext().getFilterRegistration(filterName);
                filter.addMappingForServletNames(null, true, new String[]{this.servletName});
            }
        }
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public Servlet getServlet() {
        return this.servlet;
    }

    public void setServlet(Servlet servlet) {
        this.servlet = servlet;
    }

    public String getServletName() {
        return this.servletName;
    }

    public void setServletName(String servletName) {
        this.servletName = servletName;
    }

    public boolean isAsyncSupported() {
        return this.asyncSupported;
    }

    public void setAsyncSupported(boolean asyncSupported) {
        this.asyncSupported = asyncSupported;
    }

    public Map<String, String> getInitParameters() {
        return this.initParameters;
    }

    public void setInitParameters(Map<String, String> initParameters) {
        this.initParameters = initParameters;
    }

    public int getLoadOnStartup() {
        return this.loadOnStartup;
    }

    public void setLoadOnStartup(int loadOnStartup) {
        this.loadOnStartup = loadOnStartup;
    }

    public MultipartConfigElement getMultipartConfigElement() {
        return this.multipartConfigElement;
    }

    public void setMultipartConfigElement(MultipartConfigElement multipartConfigElement) {
        this.multipartConfigElement = multipartConfigElement;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public ServletSecurityElement getServletSecurityElement() {
        return this.servletSecurityElement;
    }

    public void setServletSecurityElement(ServletSecurityElement servletSecurityElement) {
        this.servletSecurityElement = servletSecurityElement;
    }

    public List<String> getUrlMappings() {
        return this.urlMappings;
    }

    public void setUrlMappings(List<String> urlMappings) {
        this.urlMappings = urlMappings;
    }

    public List<String> getFiltersToMap() {
        return this.filtersToMap;
    }

    public void setFiltersToMap(List<String> filtersToMap) {
        this.filtersToMap = filtersToMap;
    }

    public boolean isMapFilters() {
        return this.mapFilters;
    }

    public void setMapFilters(boolean mapFilters) {
        this.mapFilters = mapFilters;
    }
}

