/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.lookup.keyvalue;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.framework.keyvalue.FormViewAwareUifKeyValuesFinderBase;
import org.kuali.coeus.sys.framework.model.Activatable;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.util.ValuesFinderUtils;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.core.GenericTypeResolver;

public abstract class ActivatableValuesFinder<T extends BusinessObject & Activatable>
extends FormViewAwareUifKeyValuesFinderBase {
    private static final String INACTIVE_IND = " (inactive)";
    private Class<T> finderType = GenericTypeResolver.resolveTypeArgument(((Object)((Object)this)).getClass(), ActivatableValuesFinder.class);
    private boolean excludeInactive = true;

    protected abstract String getKey(T var1);

    protected abstract String getValue(T var1);

    protected abstract String getCurrentValue();

    public List<KeyValue> getKeyValues() {
        String currentValue = this.getCurrentValue();
        List<KeyValue> values = KcServiceLocator.getService(BusinessObjectService.class).findMatching(this.finderType, Collections.emptyMap()).stream().filter(businessObject -> this.shouldInclude(businessObject, currentValue)).map(x$0 -> this.toKeyValue((BusinessObject)x$0)).sorted(Comparator.comparing(KeyValue::getValue)).collect(Collectors.toList());
        if (this.isAddBlankOption()) {
            values.add(0, ValuesFinderUtils.getSelectOption());
        }
        return values;
    }

    private KeyValue toKeyValue(T businessObject) {
        Activatable activatable = (Activatable)businessObject;
        Object value = this.getValue(businessObject);
        if (!activatable.isActive()) {
            value = (String)value + INACTIVE_IND;
        }
        return new ConcreteKeyValue(this.getKey(businessObject), (String)value);
    }

    private boolean shouldInclude(T businessObject, String currentValue) {
        boolean isCurrentValue = StringUtils.equals((CharSequence)currentValue, (CharSequence)this.getKey(businessObject));
        Activatable activatable = (Activatable)businessObject;
        return !this.excludeInactive() || activatable.isActive() || isCurrentValue;
    }

    public boolean excludeInactive() {
        return this.excludeInactive;
    }

    public void setExcludeInactive(boolean excludeInactive) {
        this.excludeInactive = excludeInactive;
    }
}

