/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.timeandmoney.web.struts.action;

import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.ojb.broker.accesslayer.LookupException;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionRedirect;
import org.apache.struts.config.ForwardConfig;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.coeus.sys.framework.controller.KcTransactionalDocumentActionBase;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.workflow.KcWorkflowService;
import org.kuali.kra.award.AwardAmountInfoService;
import org.kuali.kra.award.awardhierarchy.AwardHierarchy;
import org.kuali.kra.award.awardhierarchy.AwardHierarchyService;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardAmountInfo;
import org.kuali.kra.award.paymentreports.awardreports.reporting.service.ReportTrackingService;
import org.kuali.kra.award.paymentreports.closeout.AwardCloseoutService;
import org.kuali.kra.award.timeandmoney.AwardDirectFandADistribution;
import org.kuali.kra.award.version.service.AwardVersionService;
import org.kuali.kra.external.award.AwardAccountService;
import org.kuali.kra.timeandmoney.AwardHierarchyNode;
import org.kuali.kra.timeandmoney.TimeAndMoneyForm;
import org.kuali.kra.timeandmoney.document.TimeAndMoneyDocument;
import org.kuali.kra.timeandmoney.history.TransactionDetail;
import org.kuali.kra.timeandmoney.service.ActivePendingTransactionsService;
import org.kuali.kra.timeandmoney.service.TimeAndMoneyActionSummaryService;
import org.kuali.kra.timeandmoney.service.TimeAndMoneyExistenceService;
import org.kuali.kra.timeandmoney.service.TimeAndMoneyHistoryService;
import org.kuali.kra.timeandmoney.service.TimeAndMoneyService;
import org.kuali.kra.timeandmoney.service.TimeAndMoneyVersionService;
import org.kuali.kra.timeandmoney.transactions.AwardAmountTransaction;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kns.document.authorization.DocumentAuthorizer;
import org.kuali.rice.kns.document.authorization.DocumentPresentationController;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.GlobalVariables;

public class TimeAndMoneyAction
extends KcTransactionalDocumentActionBase {
    private static final String INVALID_AWARD_NUMBER_ERROR = "error.timeandmoney.invalidawardnumber";
    private static final String GO_TO_AWARD_NUMBER_FIELD_NAME = "goToAwardNumber";
    private static final String TIME_AND_MONEY_SUMMARY_AND_HISTORY_MAPPING = "timeAndMoneySummaryAndHistory";
    private static final String TIME_AND_MONEY_MAPPING = "timeAndMoney";
    public static final String AWARD_NUMBER = "awardNumber";
    public static final String TIME_AND_MONEY_DOCUMENT = "TimeAndMoneyDocument";
    public static final String DIRECT_INDIRECT_ENABLED = "1";
    private AwardVersionService awardVersionService;
    private ActivePendingTransactionsService activePendingTransactionsService;
    private TimeAndMoneyVersionService timeAndMoneyVersionService;
    private KcWorkflowService kcWorkflowService;
    private ReportTrackingService reportTrackingService;
    private AwardHierarchyService awardHierarchyService;
    private AwardAmountInfoService awardAmountInfoService;
    private TimeAndMoneyHistoryService timeAndMoneyHistoryService;
    private TimeAndMoneyActionSummaryService timeAndMoneyActionSummaryService;
    private GlobalVariableService globalVariableService;
    private DataObjectService dataObjectService;
    private TimeAndMoneyExistenceService timeAndMoneyExistenceService;
    private TimeAndMoneyService timeAndMoneyService;
    private AwardAccountService awardAccountService;
    private AwardCloseoutService awardCloseoutService;

    @Override
    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TimeAndMoneyForm timeAndMoneyForm = (TimeAndMoneyForm)form;
        TimeAndMoneyDocument timeAndMoneyDocument = timeAndMoneyForm.getTimeAndMoneyDocument();
        List<AwardHierarchyNode> awardHierarchyNodeItems = timeAndMoneyForm.getAwardHierarchyNodeItems();
        this.getTimeAndMoneyService().captureDateChangeTransactions(timeAndMoneyDocument, awardHierarchyNodeItems);
        this.captureSingleNodeMoneyTransactions(mapping, form, request, response);
        return super.save(mapping, form, request, response);
    }

    public void captureSingleNodeMoneyTransactions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TimeAndMoneyForm timeAndMoneyForm = (TimeAndMoneyForm)form;
        TimeAndMoneyDocument timeAndMoneyDocument = timeAndMoneyForm.getTimeAndMoneyDocument();
        ArrayList<TransactionDetail> moneyTransactionDetailItems = new ArrayList<TransactionDetail>();
        this.getTimeAndMoneyService().updateAwardAmountTransactions(timeAndMoneyDocument);
        if (timeAndMoneyDocument.getAwardHierarchyNodes().size() == 1 && !timeAndMoneyForm.getDisableCurrentValues()) {
            for (Map.Entry<String, AwardHierarchyNode> awardHierarchyNode : timeAndMoneyDocument.getAwardHierarchyNodes().entrySet()) {
                List<AwardHierarchyNode> awardHierarchyNodeItems = timeAndMoneyForm.getAwardHierarchyNodeItems();
                boolean refreshNeeded = this.getTimeAndMoneyService().captureMoneyChanges(awardHierarchyNodeItems, timeAndMoneyDocument, moneyTransactionDetailItems, awardHierarchyNode);
                if (!refreshNeeded) continue;
                timeAndMoneyForm.setToPendingView();
                this.refreshView(mapping, (ActionForm)timeAndMoneyForm, request, response);
            }
        }
    }

    protected GlobalVariableService getGlobalVariableService() {
        if (this.globalVariableService == null) {
            this.globalVariableService = KcServiceLocator.getService(GlobalVariableService.class);
        }
        return this.globalVariableService;
    }

    protected DataObjectService getDataObjectService() {
        if (this.dataObjectService == null) {
            this.dataObjectService = KcServiceLocator.getService(DataObjectService.class);
        }
        return this.dataObjectService;
    }

    public ActionForward postTimeAndMoney(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        TimeAndMoneyForm timeAndMoneyForm = (TimeAndMoneyForm)form;
        TimeAndMoneyDocument timeAndMoneyDocument = timeAndMoneyForm.getTimeAndMoneyDocument();
        Award award = timeAndMoneyDocument.getAward();
        this.getTimeAndMoneyService().addPostEntry(award.getAwardId(), award.getAwardNumber(), timeAndMoneyDocument.getDocumentNumber());
        this.getGlobalVariableService().getMessageMap().putInfo("info.tm.information.posted", "info.tm.information.posted", new String[0]);
        return mapping.findForward("basic");
    }

    @Override
    public ActionForward route(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.save(mapping, form, request, response);
        ActionForward actionForward = super.route(mapping, form, request, response);
        TimeAndMoneyForm timeAndMoneyForm = (TimeAndMoneyForm)form;
        TimeAndMoneyDocument timeAndMoneyDocument = timeAndMoneyForm.getTimeAndMoneyDocument();
        Award award = timeAndMoneyDocument.getAward();
        this.getAwardCloseoutService().updateCloseoutDueDatesBeforeSave(award);
        this.getBusinessObjectService().save((PersistableBusinessObject)award);
        return this.doRoutingTasks(mapping, (TimeAndMoneyForm)form, actionForward);
    }

    protected ActionForward doRoutingTasks(ActionMapping mapping, TimeAndMoneyForm timeAndMoneyForm, ActionForward actionForward) throws ParseException {
        this.saveReportTrackingItems(timeAndMoneyForm);
        String routeHeaderId = timeAndMoneyForm.getDocument().getDocumentNumber();
        String returnLocation = this.buildActionUrl(routeHeaderId, TIME_AND_MONEY_MAPPING, TIME_AND_MONEY_DOCUMENT);
        ActionForward basicForward = mapping.findForward("portal");
        ActionRedirect holdingPageForward = new ActionRedirect((ForwardConfig)mapping.findForward("kraHoldingPage"));
        holdingPageForward.addParameter("holdingPageDocumentId", (Object)routeHeaderId);
        return this.routeToHoldingPage(basicForward, actionForward, holdingPageForward, returnLocation, routeHeaderId);
    }

    protected void saveReportTrackingItems(TimeAndMoneyForm timeAndMoneyForm) throws ParseException {
        TimeAndMoneyDocument timeAndMoneyDocument = timeAndMoneyForm.getTimeAndMoneyDocument();
        Award award = timeAndMoneyDocument.getAward();
        this.getReportTrackingService().generateReportTrackingAndSave(award, true);
    }

    public ActionForward blanketApprove(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.save(mapping, form, request, response);
        ActionForward actionForward = super.blanketApprove(mapping, form, request, response);
        return this.doRoutingTasks(mapping, (TimeAndMoneyForm)form, actionForward);
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TimeAndMoneyForm timeAndMoneyForm = (TimeAndMoneyForm)form;
        TimeAndMoneyDocument timeAndMoneyDocument = timeAndMoneyForm.getTimeAndMoneyDocument();
        Map<String, AwardHierarchy> awardHierarchyItems = timeAndMoneyDocument.getAwardHierarchyItems();
        for (Map.Entry<String, AwardHierarchy> awardHierarchyEntry : awardHierarchyItems.entrySet()) {
            AwardHierarchy awardHierarchy = awardHierarchyEntry.getValue();
            Award award = this.getAwardVersionService().getWorkingAwardVersion(awardHierarchy.getAwardNumber());
            ArrayList<AwardAmountInfo> deleteCollection = new ArrayList<AwardAmountInfo>();
            for (AwardAmountInfo awardAmountInfo : award.getAwardAmountInfos()) {
                if (awardAmountInfo.getTimeAndMoneyDocumentNumber() == null || !awardAmountInfo.getTimeAndMoneyDocumentNumber().equals(timeAndMoneyDocument.getDocumentNumber())) continue;
                deleteCollection.add(awardAmountInfo);
            }
            this.getBusinessObjectService().delete(deleteCollection);
            deleteCollection.clear();
        }
        timeAndMoneyDocument.setDocumentStatus(VersionStatus.CANCELED.toString());
        this.getBusinessObjectService().save((PersistableBusinessObject)timeAndMoneyDocument);
        ActionForward actionForward = super.cancel(mapping, form, request, response);
        return actionForward;
    }

    public ActionForward refreshView(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TimeAndMoneyForm timeAndMoneyForm = (TimeAndMoneyForm)form;
        TimeAndMoneyDocument doc = timeAndMoneyForm.getTimeAndMoneyDocument();
        if (StringUtils.equalsIgnoreCase((CharSequence)timeAndMoneyForm.getCurrentOrPendingView(), (CharSequence)DIRECT_INDIRECT_ENABLED)) {
            HashMap<String, AwardAmountTransaction> awardAmountTransactionItems = new HashMap<String, AwardAmountTransaction>();
            ArrayList<Award> awardItems = new ArrayList<Award>();
            ArrayList<TransactionDetail> transactionDetailItems = new ArrayList<TransactionDetail>();
            this.updateDocumentFromSession(doc);
            this.getActivePendingTransactionsService().processTransactions(doc, doc.getAwardAmountTransactions().get(0), awardAmountTransactionItems, awardItems, transactionDetailItems, true);
            GlobalVariables.getUserSession().addObject(GlobalVariables.getUserSession().getKualiSessionId() + "TIME_AND_MONEY", (Object)doc);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)timeAndMoneyForm.getCurrentOrPendingView(), (CharSequence)"0")) {
            timeAndMoneyForm.setOrder(new ArrayList<String>());
            Award tmpAward = this.getCurrentAward(doc);
            doc.setAwardHierarchyItems(this.getAwardHierarchyService().getAwardHierarchy(doc.getRootAwardNumber(), timeAndMoneyForm.getOrder()));
            if (tmpAward != null) {
                this.getAwardHierarchyService().populateAwardHierarchyNodesForTandMDoc(doc.getAwardHierarchyItems(), doc.getAwardHierarchyNodes(), tmpAward.getAwardNumber(), tmpAward.getSequenceNumber().toString(), timeAndMoneyForm.getTimeAndMoneyDocument());
            } else {
                this.getAwardHierarchyService().populateAwardHierarchyNodesForTandMDoc(doc.getAwardHierarchyItems(), doc.getAwardHierarchyNodes(), null, null, timeAndMoneyForm.getTimeAndMoneyDocument());
            }
            GlobalVariables.getUserSession().addObject(GlobalVariables.getUserSession().getKualiSessionId() + "TIME_AND_MONEY", (Object)doc);
        }
        return mapping.findForward("basic");
    }

    private void updateDocumentFromSession(TimeAndMoneyDocument doc) {
        if (doc.getAwardHierarchyNodes() == null || doc.getAwardHierarchyNodes().size() == 0) {
            if (GlobalVariables.getUserSession().retrieveObject(GlobalVariables.getUserSession().getKualiSessionId() + "TIME_AND_MONEY") != null) {
                TimeAndMoneyDocument document = (TimeAndMoneyDocument)GlobalVariables.getUserSession().retrieveObject(GlobalVariables.getUserSession().getKualiSessionId() + "TIME_AND_MONEY");
                doc.setAwardHierarchyItems(document.getAwardHierarchyItems());
                doc.setAwardHierarchyNodes(document.getAwardHierarchyNodes());
            } else {
                throw new RuntimeException("Can't Retrieve Time And Money Document from Session");
            }
        }
    }

    private Award getCurrentAward(TimeAndMoneyDocument timeAndMoneyDocument) {
        Award tmpAward = timeAndMoneyDocument.getAward();
        if (tmpAward == null) {
            tmpAward = this.getAwardVersionService().getWorkingAwardVersion(timeAndMoneyDocument.getAwardNumber());
        }
        return tmpAward;
    }

    @Override
    public ActionForward docHandler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TimeAndMoneyForm timeAndMoneyForm = (TimeAndMoneyForm)form;
        TimeAndMoneyDocument timeAndMoneyDocument = timeAndMoneyForm.getTimeAndMoneyDocument();
        ActionForward forward = this.handleDocument(mapping, form, request, response, timeAndMoneyForm);
        timeAndMoneyForm.initializeFormOrDocumentBasedOnCommand();
        String startingAwardNumber = (String)GlobalVariables.getUserSession().retrieveObject("awardEnteredFrom");
        GlobalVariables.getUserSession().removeObject("awardEnteredFrom");
        if (startingAwardNumber == null) {
            startingAwardNumber = timeAndMoneyForm.getCurrentAwardNumber();
        }
        if (startingAwardNumber == null) {
            startingAwardNumber = timeAndMoneyForm.getTimeAndMoneyDocument().getRootAwardNumber();
        }
        timeAndMoneyForm.setGoToAwardNumber(startingAwardNumber);
        timeAndMoneyDocument.setAwardHierarchyItems(this.getAwardHierarchyService().getAwardHierarchy(startingAwardNumber, timeAndMoneyForm.getOrder()));
        timeAndMoneyDocument.setAwardNumber(startingAwardNumber);
        Award tmpAward = this.getCurrentAward(timeAndMoneyDocument);
        if (tmpAward != null) {
            this.getAwardHierarchyService().populateAwardHierarchyNodesForTandMDoc(timeAndMoneyDocument.getAwardHierarchyItems(), timeAndMoneyDocument.getAwardHierarchyNodes(), tmpAward.getAwardNumber(), tmpAward.getSequenceNumber().toString(), timeAndMoneyForm.getTimeAndMoneyDocument());
        } else {
            this.getAwardHierarchyService().populateAwardHierarchyNodesForTandMDoc(timeAndMoneyDocument.getAwardHierarchyItems(), timeAndMoneyDocument.getAwardHierarchyNodes(), null, null, timeAndMoneyForm.getTimeAndMoneyDocument());
        }
        timeAndMoneyForm.setAwardForSummaryPanelDisplay(tmpAward);
        this.getAwardHierarchyService().createNodeMapsOnFormForSummaryPanel(timeAndMoneyDocument.getAwardHierarchyNodes(), timeAndMoneyForm.getPreviousNodeMap(), timeAndMoneyForm.getNextNodeMap());
        GlobalVariables.getUserSession().addObject(GlobalVariables.getUserSession().getKualiSessionId() + "TIME_AND_MONEY", (Object)timeAndMoneyDocument);
        this.populateOtherPanels(timeAndMoneyForm.getTransactionBean().getNewAwardAmountTransaction(), timeAndMoneyForm, startingAwardNumber);
        return forward;
    }

    public ActionForward handleDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, TimeAndMoneyForm timeAndMoneyForm) throws Exception {
        String command = timeAndMoneyForm.getCommand();
        ActionForward forward = null;
        if ("displayActionListInlineView".equals(command)) {
            String docIdRequestParameter = request.getParameter("docId");
            Document retrievedDocument = this.getDocumentService().getByDocumentHeaderId(docIdRequestParameter);
            timeAndMoneyForm.setDocument(retrievedDocument);
            request.setAttribute("docId", (Object)docIdRequestParameter);
            ActionForward baseForward = mapping.findForward("copyProposal");
            forward = new ActionForward(this.buildForwardStringForActionListCommand(baseForward.getPath(), docIdRequestParameter));
        } else if (TIME_AND_MONEY_MAPPING.equals(command)) {
            this.loadDocument((KualiDocumentFormBase)timeAndMoneyForm);
        } else {
            forward = super.docHandler(mapping, form, request, response);
        }
        if (TIME_AND_MONEY_MAPPING.equals(command)) {
            forward = mapping.findForward("basic");
        }
        return forward;
    }

    public ActionForward addTransaction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TimeAndMoneyForm timeAndMoneyForm = (TimeAndMoneyForm)form;
        TimeAndMoneyDocument timeAndMoneyDocument = timeAndMoneyForm.getTimeAndMoneyDocument();
        List<AwardHierarchyNode> awardHierarchyNodeItems = timeAndMoneyForm.getAwardHierarchyNodeItems();
        this.getTimeAndMoneyService().captureDateChangeTransactions(timeAndMoneyDocument, awardHierarchyNodeItems);
        if (timeAndMoneyForm.getTransactionBean().addPendingTransactionItem()) {
            timeAndMoneyForm.setToPendingView();
            this.refreshView(mapping, form, request, response);
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteTransaction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TimeAndMoneyForm timeAndMoneyForm = (TimeAndMoneyForm)form;
        TimeAndMoneyDocument timeAndMoneyDocument = timeAndMoneyForm.getTimeAndMoneyDocument();
        List<AwardHierarchyNode> awardHierarchyNodeItems = timeAndMoneyForm.getAwardHierarchyNodeItems();
        this.getTimeAndMoneyService().captureDateChangeTransactions(timeAndMoneyDocument, awardHierarchyNodeItems);
        ((TimeAndMoneyForm)form).getTransactionBean().deletePendingTransactionItem(this.getLineToDelete(request));
        this.refreshView(mapping, form, request, response);
        return mapping.findForward("basic");
    }

    public ActionForward switchAward(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TimeAndMoneyForm timeAndMoneyForm = (TimeAndMoneyForm)form;
        String goToAwardNumber = timeAndMoneyForm.getGoToAwardNumber();
        this.populateOtherPanels(timeAndMoneyForm.getTransactionBean().getNewAwardAmountTransaction(), timeAndMoneyForm, goToAwardNumber);
        timeAndMoneyForm.setAwardForSummaryPanelDisplay(timeAndMoneyForm.getTimeAndMoneyDocument().getAward());
        return mapping.findForward("basic");
    }

    public ActionForward timeAndMoneySummaryAndHistory(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TimeAndMoneyForm timeAndMoneyForm = (TimeAndMoneyForm)form;
        TimeAndMoneyDocument timeAndMoneyDocument = timeAndMoneyForm.getTimeAndMoneyDocument();
        String awardNumber = null;
        if (StringUtils.isBlank((CharSequence)timeAndMoneyForm.getGoToAwardNumber())) {
            awardNumber = timeAndMoneyDocument.getAwardNumber();
        } else {
            Award award = this.getAwardVersionService().getWorkingAwardVersion(timeAndMoneyForm.getGoToAwardNumber());
            if (award == null) {
                GlobalVariables.getMessageMap().putError(GO_TO_AWARD_NUMBER_FIELD_NAME, INVALID_AWARD_NUMBER_ERROR, new String[]{timeAndMoneyForm.getGoToAwardNumber()});
                return mapping.findForward("basic");
            }
            awardNumber = award.getAwardNumber();
        }
        timeAndMoneyDocument.setAwardVersionHistoryList(this.getTimeAndMoneyHistoryService().buildTimeAndMoneyHistoryObjects(awardNumber, true));
        timeAndMoneyDocument.setTimeAndMoneyActionSummaryItems(this.getTimeAndMoneyActionSummaryService().populateActionSummary(awardNumber));
        return mapping.findForward(TIME_AND_MONEY_SUMMARY_AND_HISTORY_MAPPING);
    }

    private void populateOtherPanels(AwardAmountTransaction newAwardAmountTransaction, TimeAndMoneyForm timeAndMoneyForm, String goToAwardNumber) throws LookupException, SQLException, WorkflowException {
        Award award = this.getAwardVersionService().getWorkingAwardVersion(goToAwardNumber);
        if (award == null) {
            GlobalVariables.getMessageMap().putError(GO_TO_AWARD_NUMBER_FIELD_NAME, INVALID_AWARD_NUMBER_ERROR, new String[]{goToAwardNumber});
            return;
        }
        TimeAndMoneyDocument timeAndMoneyDocument = timeAndMoneyForm.getTimeAndMoneyDocument();
        timeAndMoneyDocument.setAwardNumber(award.getAwardNumber());
        timeAndMoneyDocument.setAward(award);
        timeAndMoneyDocument.setNewAwardAmountTransaction(newAwardAmountTransaction);
    }

    public boolean isNewAward(TimeAndMoneyForm timeAndMoneyForm) {
        return timeAndMoneyForm.getTimeAndMoneyDocument().getAward().getAwardDirectFandADistributions().size() == 0;
    }

    public String buildForwardStringForActionListCommand(String forwardPath, String docIdRequestParameter) {
        StringBuilder sb = new StringBuilder();
        sb.append(forwardPath);
        sb.append("?");
        sb.append("docId");
        sb.append("=");
        sb.append(docIdRequestParameter);
        return sb.toString();
    }

    public ActionForward addTransaction() {
        return null;
    }

    public ActionForward deleteTransaction() {
        return null;
    }

    public ActionForward submit() {
        return null;
    }

    public ActionForward addAwardDirectFandADistribution(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TimeAndMoneyForm timeAndMoneyForm = (TimeAndMoneyForm)form;
        TimeAndMoneyDocument timeAndMoneyDocument = timeAndMoneyForm.getTimeAndMoneyDocument();
        List<AwardHierarchyNode> awardHierarchyNodeItems = timeAndMoneyForm.getAwardHierarchyNodeItems();
        this.getTimeAndMoneyService().captureDateChangeTransactions(timeAndMoneyDocument, awardHierarchyNodeItems);
        timeAndMoneyForm.getAwardDirectFandADistributionBean().addAwardDirectFandADistribution(((TimeAndMoneyForm)form).getAwardDirectFandADistributionBean());
        return mapping.findForward("basic");
    }

    public ActionForward deleteAwardDirectFandADistribution(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TimeAndMoneyForm timeAndMoneyForm = (TimeAndMoneyForm)form;
        TimeAndMoneyDocument timeAndMoneyDocument = timeAndMoneyForm.getTimeAndMoneyDocument();
        List<AwardHierarchyNode> awardHierarchyNodeItems = timeAndMoneyForm.getAwardHierarchyNodeItems();
        this.getTimeAndMoneyService().captureDateChangeTransactions(timeAndMoneyDocument, awardHierarchyNodeItems);
        AwardDirectFandADistribution awardDirectFandADistribution = timeAndMoneyForm.getTimeAndMoneyDocument().getAward().getAwardDirectFandADistributions().get(this.getLineToDelete(request));
        timeAndMoneyForm.getTimeAndMoneyDocument().getAward().getAwardDirectFandADistributions().remove(this.getLineToDelete(request));
        this.getBusinessObjectService().delete((Object)awardDirectFandADistribution);
        timeAndMoneyForm.getAwardDirectFandADistributionBean().updateBudgetPeriodsAfterDelete(timeAndMoneyForm.getTimeAndMoneyDocument().getAward().getAwardDirectFandADistributions());
        return mapping.findForward("basic");
    }

    public ActionForward timeAndMoney(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward(TIME_AND_MONEY_MAPPING);
    }

    public ActionForward recalculateDirectFandADistributionTotals(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("basic");
    }

    public ActionForward returnToAward(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String awardDocumentNumber;
        TimeAndMoneyForm timeAndMoneyForm = (TimeAndMoneyForm)form;
        TimeAndMoneyDocument timeAndMoneyDocument = timeAndMoneyForm.getTimeAndMoneyDocument();
        if (!this.getKcWorkflowService().isInWorkflow((Document)timeAndMoneyDocument)) {
            this.save(mapping, form, request, response);
        }
        if (StringUtils.isBlank((CharSequence)(awardDocumentNumber = (String)GlobalVariables.getUserSession().retrieveObject("returnToAwardDocument-" + timeAndMoneyDocument.getDocumentNumber())))) {
            awardDocumentNumber = timeAndMoneyDocument.getAward().getAwardDocument().getDocumentNumber();
        }
        AwardDocument awardDocument = (AwardDocument)this.getDocumentService().getByDocumentHeaderId(awardDocumentNumber);
        String routeHeaderId = awardDocument.getDocumentHeader().getWorkflowDocument().getDocumentId();
        GlobalVariables.getUserSession().removeObject("returnToAwardDocument-" + timeAndMoneyDocument.getDocumentNumber());
        String forward = this.buildForwardUrl(routeHeaderId);
        return new ActionForward(forward, true);
    }

    public boolean isDirectIndirectViewEnabled() {
        String directIndirectEnabledValue = this.getParameterService().getParameterValueAsString("KC-AWARD", "Document", "ENABLE_AWD_ANT_OBL_DIRECT_INDIRECT_COST");
        return DIRECT_INDIRECT_ENABLED.equals(directIndirectEnabledValue);
    }

    public ActionForward goToNextAward(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TimeAndMoneyForm timeAndMoneyForm = (TimeAndMoneyForm)form;
        return this.goToAward(mapping, timeAndMoneyForm, timeAndMoneyForm.getNextNodeMap().get(timeAndMoneyForm.getAwardForSummaryPanelDisplay().getAwardNumber()));
    }

    public ActionForward goToPreviousAward(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TimeAndMoneyForm timeAndMoneyForm = (TimeAndMoneyForm)form;
        return this.goToAward(mapping, timeAndMoneyForm, timeAndMoneyForm.getPreviousNodeMap().get(timeAndMoneyForm.getAwardForSummaryPanelDisplay().getAwardNumber()));
    }

    private ActionForward goToAward(ActionMapping mapping, TimeAndMoneyForm timeAndMoneyForm, String awardNumber) throws Exception {
        Award awardForSummary = (Award)((List)this.getBusinessObjectService().findMatching(Award.class, Collections.singletonMap(AWARD_NUMBER, awardNumber))).get(0);
        timeAndMoneyForm.setAwardForSummaryPanelDisplay(awardForSummary);
        return mapping.findForward("basic");
    }

    public ActionForward editOrVersion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TimeAndMoneyForm timeAndMoneyForm = (TimeAndMoneyForm)form;
        TimeAndMoneyDocument doc = timeAndMoneyForm.getTimeAndMoneyDocument();
        String rootAwardNumber = doc.getRootAwardNumber();
        TimeAndMoneyDocument finalTandM = this.getTimeAndMoneyVersionService().findOpenedTimeAndMoney(rootAwardNumber);
        if (finalTandM == null) {
            return mapping.findForward("basic");
        }
        String routeHeaderId = finalTandM.getDocumentHeader().getWorkflowDocument().getDocumentId();
        String returnAwardDocId = (String)GlobalVariables.getUserSession().retrieveObject("returnToAwardDocument-" + doc.getDocumentNumber());
        GlobalVariables.getUserSession().addObject("returnToAwardDocument-" + routeHeaderId, (Object)returnAwardDocId);
        String forwardString = this.buildForwardUrl(routeHeaderId);
        return new ActionForward(forwardString, true);
    }

    @Override
    protected void populateAuthorizationFields(KualiDocumentFormBase formBase) {
        if (formBase.isFormDocumentInitialized()) {
            Document document = formBase.getDocument();
            Person user = GlobalVariables.getUserSession().getPerson();
            DocumentPresentationController documentPresentationController = KNSServiceLocator.getDocumentHelperService().getDocumentPresentationController(document);
            DocumentAuthorizer documentAuthorizer = this.getDocumentHelperService().getDocumentAuthorizer(document);
            Set documentActions = documentPresentationController.getDocumentActions(document);
            documentActions = documentAuthorizer.getDocumentActions(document, user, documentActions);
            if (this.getDataDictionaryService().getDataDictionary().getDocumentEntry(document.getClass().getName()).getUsePessimisticLocking()) {
                documentActions = this.getPessimisticLockService().getDocumentActions(document, user, documentActions);
            }
            HashSet<String> editModes = new HashSet<String>();
            if (!documentAuthorizer.canOpen(document, user)) {
                editModes.add("unviewable");
            } else if (documentActions.contains("canEdit")) {
                editModes.add("fullEntry");
            } else {
                editModes.add("viewOnly");
            }
            Map editMode = this.convertSetToMap(editModes);
            if (this.getDataDictionaryService().getDataDictionary().getDocumentEntry(document.getClass().getName()).getUsePessimisticLocking()) {
                editMode = this.getPessimisticLockService().establishLocks(document, editMode, user);
            }
            if (editMode.containsKey("fullEntry")) {
                if (!documentActions.contains("canEditDocumentOverview")) {
                    documentActions.add("canEditDocumentOverview");
                }
            } else if (documentActions.contains("canEditDocumentOverview")) {
                documentActions.remove("canEditDocumentOverview");
            }
            if (documentActions.contains("canCopy")) {
                documentActions.remove("canCopy");
            }
            formBase.setDocumentActions(this.convertSetToMap(documentActions));
            formBase.setEditingMode(editMode);
        }
    }

    public TimeAndMoneyVersionService getTimeAndMoneyVersionService() {
        if (this.timeAndMoneyVersionService == null) {
            this.timeAndMoneyVersionService = KcServiceLocator.getService(TimeAndMoneyVersionService.class);
        }
        return this.timeAndMoneyVersionService;
    }

    public void setTimeAndMoneyVersionService(TimeAndMoneyVersionService timeAndMoneyVersionService) {
        this.timeAndMoneyVersionService = timeAndMoneyVersionService;
    }

    public AwardVersionService getAwardVersionService() {
        if (this.awardVersionService == null) {
            this.awardVersionService = KcServiceLocator.getService(AwardVersionService.class);
        }
        return this.awardVersionService;
    }

    public AwardAccountService getAwardAccountService() {
        if (this.awardAccountService == null) {
            this.awardAccountService = KcServiceLocator.getService(AwardAccountService.class);
        }
        return this.awardAccountService;
    }

    protected ActivePendingTransactionsService getActivePendingTransactionsService() {
        if (this.activePendingTransactionsService == null) {
            this.activePendingTransactionsService = KcServiceLocator.getService(ActivePendingTransactionsService.class);
        }
        return this.activePendingTransactionsService;
    }

    protected KcWorkflowService getKcWorkflowService() {
        if (this.kcWorkflowService == null) {
            this.kcWorkflowService = KcServiceLocator.getService(KcWorkflowService.class);
        }
        return this.kcWorkflowService;
    }

    public ReportTrackingService getReportTrackingService() {
        if (this.reportTrackingService == null) {
            this.reportTrackingService = KcServiceLocator.getService(ReportTrackingService.class);
        }
        return this.reportTrackingService;
    }

    protected AwardHierarchyService getAwardHierarchyService() {
        if (this.awardHierarchyService == null) {
            this.awardHierarchyService = KcServiceLocator.getService(AwardHierarchyService.class);
        }
        return this.awardHierarchyService;
    }

    public AwardAmountInfoService getAwardAmountInfoService() {
        if (this.awardAmountInfoService == null) {
            this.awardAmountInfoService = KcServiceLocator.getService(AwardAmountInfoService.class);
        }
        return this.awardAmountInfoService;
    }

    public TimeAndMoneyHistoryService getTimeAndMoneyHistoryService() {
        if (this.timeAndMoneyHistoryService == null) {
            this.timeAndMoneyHistoryService = KcServiceLocator.getService(TimeAndMoneyHistoryService.class);
        }
        return this.timeAndMoneyHistoryService;
    }

    public TimeAndMoneyActionSummaryService getTimeAndMoneyActionSummaryService() {
        if (this.timeAndMoneyActionSummaryService == null) {
            this.timeAndMoneyActionSummaryService = KcServiceLocator.getService(TimeAndMoneyActionSummaryService.class);
        }
        return this.timeAndMoneyActionSummaryService;
    }

    protected TimeAndMoneyExistenceService getTimeAndMoneyExistenceService() {
        if (this.timeAndMoneyExistenceService == null) {
            this.timeAndMoneyExistenceService = KcServiceLocator.getService(TimeAndMoneyExistenceService.class);
        }
        return this.timeAndMoneyExistenceService;
    }

    protected TimeAndMoneyService getTimeAndMoneyService() {
        if (this.timeAndMoneyService == null) {
            this.timeAndMoneyService = KcServiceLocator.getService(TimeAndMoneyService.class);
        }
        return this.timeAndMoneyService;
    }

    public AwardCloseoutService getAwardCloseoutService() {
        if (this.awardCloseoutService == null) {
            this.awardCloseoutService = KcServiceLocator.getService(AwardCloseoutService.class);
        }
        return this.awardCloseoutService;
    }

    public void setAwardCloseoutService(AwardCloseoutService awardCloseoutService) {
        this.awardCloseoutService = awardCloseoutService;
    }
}

