/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.hierarchy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.hierarchy.ProposalHierarchyDao;
import org.kuali.coeus.propdev.impl.person.ProposalPerson;
import org.kuali.coeus.propdev.impl.person.ProposalPersonDegree;
import org.kuali.coeus.propdev.impl.state.ProposalState;
import org.kuali.rice.core.api.criteria.CountFlag;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.criteria.QueryResults;
import org.kuali.rice.krad.data.DataObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="proposalHierarchyDao")
public class ProposalHierarchyDaoJpa
implements ProposalHierarchyDao {
    private static final String PROPOSAL_STATE_QUERY = "SELECT a.proposalState from DevelopmentProposal a where a.proposalNumber = :proposalNumber";
    private static final String PERSON_ID = "personId";
    private static final String ROLODEX_ID = "rolodexId";
    private static final String DEVELOPMENT_PROPOSAL_PROPOSAL_NUMBER = "developmentProposal.proposalNumber";
    private static final String HIERARCHY_PARENT_PROPOSAL_NUMBER = "hierarchyParentProposalNumber";
    private static final String PROPOSAL_NUMBER = "proposalNumber";
    private static final String PROPOSAL_PERSON_DEVELOPMENT_PROPOSAL_PROPOSAL_NUMBER = "proposalPerson.developmentProposal.proposalNumber";
    private static final String PROPOSAL_PERSON_PROPOSAL_PERSON_NUMBER = "proposalPerson.proposalPersonNumber";
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="kcEntityManager")
    private EntityManager entityManager;

    @Override
    public boolean employeePersonInMultipleChildProposals(String personId, String hierarchyProposalNumber) {
        return this.personInMultipleChildProposals(PredicateFactory.equal((String)PERSON_ID, (Object)personId), hierarchyProposalNumber);
    }

    @Override
    public boolean nonEmployeePersonInMultipleChildProposals(Integer rolodexId, String hierarchyProposalNumber) {
        return this.personInMultipleChildProposals(PredicateFactory.equal((String)ROLODEX_ID, (Object)rolodexId), hierarchyProposalNumber);
    }

    protected boolean personInMultipleChildProposals(Predicate personPredicate, String hierarchyProposalNumber) {
        List<String> childProposalNumbers = this.getHierarchyChildProposalNumbers(hierarchyProposalNumber);
        if (childProposalNumbers.isEmpty()) {
            return false;
        }
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(personPredicate);
        predicates.add(PredicateFactory.in((String)DEVELOPMENT_PROPOSAL_PROPOSAL_NUMBER, childProposalNumbers));
        Predicate[] preds = predicates.toArray(new Predicate[predicates.size()]);
        builder.setCountFlag(CountFlag.ONLY);
        builder.setPredicates(preds);
        return this.getDataObjectService().findMatching(ProposalPerson.class, builder.build()).getTotalRowCount() > 1;
    }

    @Override
    public List<DevelopmentProposal> getHierarchyChildProposals(String parentProposalNumber) {
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(PredicateFactory.equal((String)HIERARCHY_PARENT_PROPOSAL_NUMBER, (Object)parentProposalNumber));
        Predicate[] preds = predicates.toArray(new Predicate[predicates.size()]);
        builder.setPredicates(preds);
        QueryResults results = this.getDataObjectService().findMatching(DevelopmentProposal.class, builder.build());
        return results.getResults();
    }

    @Override
    public DevelopmentProposal getDevelopmentProposal(String proposalNumber) {
        return (DevelopmentProposal)this.dataObjectService.findUnique(DevelopmentProposal.class, QueryByCriteria.Builder.forAttribute((String)PROPOSAL_NUMBER, (Object)proposalNumber).build());
    }

    @Override
    public ProposalState getProposalState(String proposalNumber) {
        return (ProposalState)this.entityManager.createQuery(PROPOSAL_STATE_QUERY).setParameter(PROPOSAL_NUMBER, (Object)proposalNumber).getSingleResult();
    }

    @Override
    public List<ProposalPerson> isEmployeePersonOnProposal(String proposalNumber, String personId) {
        return this.isPersonOnProposal(proposalNumber, PredicateFactory.equal((String)PERSON_ID, (Object)personId));
    }

    @Override
    public List<ProposalPerson> isNonEmployeePersonOnProposal(String proposalNumber, Integer rolodexId) {
        return this.isPersonOnProposal(proposalNumber, PredicateFactory.equal((String)ROLODEX_ID, (Object)rolodexId));
    }

    protected List<ProposalPerson> isPersonOnProposal(String proposalNumber, Predicate personPredicate) {
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(PredicateFactory.equal((String)DEVELOPMENT_PROPOSAL_PROPOSAL_NUMBER, (Object)proposalNumber));
        predicates.add(personPredicate);
        Predicate[] preds = predicates.toArray(new Predicate[predicates.size()]);
        builder.setPredicates(preds);
        QueryResults list = this.getDataObjectService().findMatching(ProposalPerson.class, builder.build());
        return list.getResults();
    }

    @Override
    public List<String> getHierarchyChildProposalNumbers(String parentProposalNumber) {
        List<DevelopmentProposal> proposals = this.getHierarchyChildProposals(parentProposalNumber);
        ArrayList<String> proposalNumbers = new ArrayList<String>();
        for (DevelopmentProposal proposal : proposals) {
            proposalNumbers.add(proposal.getProposalNumber());
        }
        return proposalNumbers;
    }

    @Override
    public void deleteDegreeInfo(String proposalNumber, Integer proposalPersonNumber, ProposalPerson person) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put(PROPOSAL_PERSON_DEVELOPMENT_PROPOSAL_PROPOSAL_NUMBER, proposalNumber);
        param.put(PROPOSAL_PERSON_PROPOSAL_PERSON_NUMBER, proposalPersonNumber.toString());
        this.getDataObjectService().deleteMatching(ProposalPersonDegree.class, QueryByCriteria.Builder.andAttributes(param).build());
    }

    @Override
    public List<ProposalPersonDegree> getDegreeInformation(String proposalNumber, ProposalPerson person) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put(PROPOSAL_PERSON_DEVELOPMENT_PROPOSAL_PROPOSAL_NUMBER, proposalNumber);
        param.put(PROPOSAL_PERSON_PROPOSAL_PERSON_NUMBER, person.getProposalPersonNumber().toString());
        return this.getDataObjectService().findMatching(ProposalPersonDegree.class, QueryByCriteria.Builder.andAttributes(param).build()).getResults();
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

