/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.lock;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.kuali.coeus.propdev.impl.budget.ProposalDevelopmentBudgetExt;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.lock.ProposalBudgetLockService;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.impl.lock.KcPessimisticLockService;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.document.authorization.PessimisticLock;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.PessimisticLockService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="proposalBudgetLockService")
@Transactional
public class ProposalBudgetLockServiceImpl
implements ProposalBudgetLockService {
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="dataDictionaryService")
    protected DataDictionaryService dataDictionaryService;
    @Autowired
    @Qualifier(value="globalVariableService")
    protected GlobalVariableService globalVariableService;
    @Autowired
    @Qualifier(value="pessimisticLockService")
    protected PessimisticLockService pessimisticLockService;
    @Autowired
    @Qualifier(value="kcPessimisticLockService")
    protected KcPessimisticLockService KcPessimisticLockService;

    @Override
    public void establishBudgetLock(ProposalDevelopmentBudgetExt budget) {
        ProposalDevelopmentDocument document = budget.getDevelopmentProposal().getProposalDocument();
        this.getPessimisticLockService().releaseAllLocksForUser(document.getPessimisticLocks(), this.getGlobalVariableService().getUserSession().getPerson());
        if (this.getKcPessimisticLockService().isPessimisticLockNeeded(document, this.getGlobalVariableService().getUserSession().getPerson(), true, this.getBudgetLockDescriptor(document.getDevelopmentProposal().getProposalNumber(), budget.getBudgetVersionNumber()))) {
            PessimisticLock pessimisticLock = this.getPessimisticLockService().generateNewLock(document.getDocumentNumber(), this.getBudgetLockDescriptor(document.getDevelopmentProposal().getProposalNumber(), budget.getBudgetVersionNumber()), this.getGlobalVariableService().getUserSession().getPerson());
            document.addPessimisticLock(pessimisticLock);
        }
    }

    @Override
    public void deleteBudgetLock(ProposalDevelopmentBudgetExt budget) {
        ProposalDevelopmentDocument document = budget.getDevelopmentProposal().getProposalDocument();
        for (PessimisticLock lock : document.getPessimisticLocks()) {
            if (!lock.isOwnedByUser(this.getGlobalVariableService().getUserSession().getPerson()) || !this.doesBudgetVersionMatchDescriptor(lock.getLockDescriptor(), budget.getBudgetVersionNumber())) continue;
            this.getDataObjectService().delete((Object)lock);
        }
        document.refreshPessimisticLocks();
    }

    @Override
    public boolean doesBudgetVersionMatchDescriptor(String lockDescriptor, int budgetVersionNumber) {
        String[] lockDescriptorValues = StringUtils.split((String)lockDescriptor, (String)"-");
        return lockDescriptorValues != null && lockDescriptorValues.length == 3 && StringUtils.equals((CharSequence)lockDescriptorValues[1], (CharSequence)"BUDGET") && NumberUtils.isNumber((String)lockDescriptorValues[2]) && Integer.parseInt(lockDescriptorValues[2]) == budgetVersionNumber;
    }

    protected String getBudgetLockDescriptor(String proposalNumber, int budgetVersion) {
        return proposalNumber + "-BUDGET-" + budgetVersion;
    }

    public DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    public PessimisticLockService getPessimisticLockService() {
        return this.pessimisticLockService;
    }

    public void setPessimisticLockService(PessimisticLockService pessimisticLockService) {
        this.pessimisticLockService = pessimisticLockService;
    }

    public KcPessimisticLockService getKcPessimisticLockService() {
        return this.KcPessimisticLockService;
    }

    public void setKcPessimisticLockService(KcPessimisticLockService kcPessimisticLockService) {
        this.KcPessimisticLockService = kcPessimisticLockService;
    }
}

