/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.rule;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.framework.rule.KcMaintenanceDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.home.AwardBasisOfPayment;
import org.kuali.kra.award.home.AwardType;
import org.kuali.kra.award.home.ValidAwardBasisPayment;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class ValidAwardBasisPaymentMaintenanceDocumentRule
extends KcMaintenanceDocumentRuleBase {
    public boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        ValidAwardBasisPayment validAwardBasisPayment = (ValidAwardBasisPayment)document.getNewMaintainableObject().getDataObject();
        if (!document.getNewMaintainableObject().getMaintenanceAction().equals("Delete")) {
            return this.validateUniqueueCodes(validAwardBasisPayment.getAwardType(), validAwardBasisPayment.getBasisOfPayment());
        }
        return true;
    }

    private boolean validateUniqueueCodes(AwardType awardType, AwardBasisOfPayment basisOfPayment) {
        boolean valid = true;
        if (awardType != null && basisOfPayment != null && StringUtils.isNotBlank((CharSequence)awardType.getCode().toString()) && StringUtils.isNotBlank((CharSequence)basisOfPayment.getBasisOfPaymentCode())) {
            HashMap<String, String> pkMap = new HashMap<String, String>();
            pkMap.put("awardTypeCode", awardType.getCode().toString());
            pkMap.put("basisOfPaymentCode", basisOfPayment.getBasisOfPaymentCode());
            int matchingCount = KcServiceLocator.getService(BusinessObjectService.class).countMatching(ValidAwardBasisPayment.class, pkMap);
            if (matchingCount > 0) {
                MessageMap errorMap = GlobalVariables.getMessageMap();
                errorMap.putError("document.newMaintainableObject.awardTypeCode", "error.awardBasis.exist", new String[]{awardType.getDescription(), basisOfPayment.getDescription()});
                valid = false;
            }
        }
        return valid;
    }
}

