/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.printing.service.impl;

import java.util.List;
import java.util.stream.Collectors;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPerson;
import org.kuali.kra.institutionalproposal.printing.service.InstitutionalProposalPersonService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class InstitutionalProposalPersonServiceImpl
implements InstitutionalProposalPersonService {
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;

    @Override
    public Boolean isCreditSplitOptInEnabled() {
        return this.parameterService.getParameterValueAsBoolean("KC-PD", "All", "ENABLE_OPT_IN_PERSONNEL_CREDIT_SPLIT_FUNCTIONALITY");
    }

    @Override
    public Boolean generateCreditSplitForPerson(InstitutionalProposalPerson person) {
        boolean optIn = this.isCreditSplitOptInEnabled();
        return !optIn || person.getIncludeInCreditAllocation() != false;
    }

    @Override
    public List<InstitutionalProposalPerson> getPersonsSelectedForCreditSplit(List<InstitutionalProposalPerson> projectPersons) {
        List<InstitutionalProposalPerson> institutionalProposalPersons = projectPersons.stream().filter(person -> this.generateCreditSplitForPerson((InstitutionalProposalPerson)person)).collect(Collectors.toList());
        return institutionalProposalPersons;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

