/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.coeus.sys.impl.monitor;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.persistence.EntityManager;
import javax.persistence.spi.PersistenceProvider;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.springframework.orm.jpa.JpaDialect;
import org.springframework.orm.jpa.vendor.AbstractJpaVendorAdapter;
import org.springframework.orm.jpa.vendor.Database;
import org.springframework.orm.jpa.vendor.EclipseLinkJpaDialect;

public class MonitoringEclipseLinkJpaVendorAdapter
extends AbstractJpaVendorAdapter {
    private final PersistenceProvider persistenceProvider;
    private final JpaDialect jpaDialect;

    public MonitoringEclipseLinkJpaVendorAdapter() {
        try {
            this.persistenceProvider = (PersistenceProvider)Class.forName("net.bull.javamelody.JpaPersistence").newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        this.jpaDialect = new EclipseLinkJpaDialect();
    }

    public PersistenceProvider getPersistenceProvider() {
        return this.persistenceProvider;
    }

    public Map<String, Object> getJpaPropertyMap() {
        String targetDatabase;
        HashMap<String, Object> jpaProperties = new HashMap<String, Object>();
        if (this.getDatabasePlatform() != null) {
            jpaProperties.put("eclipselink.target-database", this.getDatabasePlatform());
        } else if (this.getDatabase() != null && (targetDatabase = this.determineTargetDatabaseName(this.getDatabase())) != null) {
            jpaProperties.put("eclipselink.target-database", targetDatabase);
        }
        if (this.isGenerateDdl()) {
            jpaProperties.put("eclipselink.ddl-generation", "create-tables");
            jpaProperties.put("eclipselink.ddl-generation.output-mode", "database");
        }
        if (this.isShowSql()) {
            jpaProperties.put("eclipselink.logging.level", Level.FINE.toString());
        }
        return jpaProperties;
    }

    protected String determineTargetDatabaseName(Database database) {
        switch (database) {
            case DB2: {
                return "DB2";
            }
            case DERBY: {
                return "Derby";
            }
            case HSQL: {
                return "HSQL";
            }
            case INFORMIX: {
                return "Informix";
            }
            case MYSQL: {
                return "MySQL4";
            }
            case ORACLE: {
                return "Oracle";
            }
            case POSTGRESQL: {
                return "PostgreSQL";
            }
            case SQL_SERVER: {
                return "SQLServer";
            }
            case SYBASE: {
                return "Sybase";
            }
        }
        return null;
    }

    public JpaDialect getJpaDialect() {
        return this.jpaDialect;
    }

    public Class<? extends EntityManager> getEntityManagerInterface() {
        return JpaEntityManager.class;
    }
}

