/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.rate;

import java.util.Collection;
import java.util.HashMap;
import org.kuali.coeus.common.budget.framework.rate.AbstractInstituteRate;
import org.kuali.coeus.common.budget.framework.rate.InstituteLaRate;
import org.kuali.coeus.common.budget.framework.rate.InstituteRate;
import org.kuali.coeus.common.budget.framework.rate.RateType;
import org.kuali.coeus.common.budget.impl.rate.InstituteRateRateTypeRateClassRule;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public final class InstituteRateRateTypeRateClassRuleImpl
implements InstituteRateRateTypeRateClassRule {
    private static final String RATE_TYPE_CODE_PROPERTY_NAME = "document.newMaintainableObject.rateTypeCode";
    private static final String RATE_CLASS_CODE_PROPERTY_NAME = "document.newMaintainableObject.rateClassCode";
    private static final String RATE_TYPE_CODE_FIELD_NAME = "rateTypeCode";
    private static final String RATE_CLASS_CODE_FIELD_NAME = "rateClassCode";
    private static final String INSTITUTE_RATE_CLASS_TYPES_PARAM = "instituteRateClassTypes";
    private static final String INSTITUTE_LA_RATE_CLASS_TYPES_PARAM = "instituteLaRateClassTypes";
    private final BusinessObjectService boService;
    private final ParameterService parameterService;

    public InstituteRateRateTypeRateClassRuleImpl() {
        this(KcServiceLocator.getService(BusinessObjectService.class), KcServiceLocator.getService(ParameterService.class));
    }

    public InstituteRateRateTypeRateClassRuleImpl(BusinessObjectService boService, ParameterService parameterService) {
        if (boService == null) {
            throw new NullPointerException("the boService is null");
        }
        if (parameterService == null) {
            throw new NullPointerException("the parameterService is null");
        }
        this.boService = boService;
        this.parameterService = parameterService;
    }

    @Override
    public boolean validateRateTypeAndRateClass(AbstractInstituteRate rate) {
        if (rate == null) {
            throw new NullPointerException("the rate is null");
        }
        boolean valid = this.checkCorrectRateClass(rate);
        return valid &= this.checkCorrectRateType(rate);
    }

    private boolean checkCorrectRateClass(AbstractInstituteRate rate) {
        Collection<RateType> rateTypes;
        assert (rate != null) : "the rate is null";
        if (rate.getRateClassCode() == null) {
            return true;
        }
        Collection<String> validClassTypes = this.getValidRateClassTypes(rate);
        boolean valid = this.validateRateClassType(validClassTypes, rateTypes = this.getRateTypesFromRateClassCode(rate.getRateClassCode()));
        if (!valid) {
            GlobalVariables.getMessageMap().putError(RATE_CLASS_CODE_PROPERTY_NAME, "error.rateClass.not.valid.for.type", new String[]{rate.getRateClassCode()});
        }
        return valid;
    }

    private boolean checkCorrectRateType(AbstractInstituteRate rate) {
        Collection<RateType> rateTypes;
        assert (rate != null) : "the rate is null";
        if (rate.getRateTypeCode() == null) {
            return true;
        }
        Collection<String> validClassTypes = this.getValidRateClassTypes(rate);
        boolean valid = this.validateRateClassType(validClassTypes, rateTypes = this.getRateTypesFromRateTypeCode(rate.getRateTypeCode()));
        if (!valid) {
            GlobalVariables.getMessageMap().putError(RATE_TYPE_CODE_PROPERTY_NAME, "error.rateType.not.valid.for.type", new String[]{rate.getRateTypeCode()});
        }
        return valid;
    }

    private boolean validateRateClassType(Collection<String> validClassTypes, Collection<RateType> rateTypes) {
        assert (validClassTypes != null) : "the validClassTypes is null";
        assert (rateTypes != null) : "the rateTypes is null";
        for (RateType rateType : rateTypes) {
            if (!validClassTypes.contains(rateType.getRateClass().getRateClassTypeCode())) continue;
            return true;
        }
        return false;
    }

    private Collection<RateType> getRateTypesFromRateClassCode(String rateClassCode) {
        assert (rateClassCode != null) : "the rateClassCode is null";
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(RATE_CLASS_CODE_FIELD_NAME, rateClassCode);
        Collection col = this.boService.findMatching(RateType.class, fieldValues);
        return col;
    }

    private Collection<RateType> getRateTypesFromRateTypeCode(String rateTypeCode) {
        assert (rateTypeCode != null) : "the rateTypeCode is null";
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(RATE_TYPE_CODE_FIELD_NAME, rateTypeCode);
        Collection col = this.boService.findMatching(RateType.class, fieldValues);
        return col;
    }

    private Collection<String> getValidRateClassTypes(AbstractInstituteRate document) {
        assert (document != null) : "the document is null";
        if (document instanceof InstituteLaRate) {
            return this.getRateClassTypesCollection(INSTITUTE_LA_RATE_CLASS_TYPES_PARAM);
        }
        if (document instanceof InstituteRate) {
            return this.getRateClassTypesCollection(INSTITUTE_RATE_CLASS_TYPES_PARAM);
        }
        throw new IllegalArgumentException("Incorrect document type: " + document.getClass().getName());
    }

    private Collection<String> getRateClassTypesCollection(String rateType) {
        assert (rateType != null) : "infoType is null";
        return this.parameterService.getParameterValuesAsString("KC-B", "All", rateType);
    }
}

