/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.unit;

import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.common.framework.unit.UnitService;
import org.kuali.coeus.common.framework.unit.admin.UnitAdministrator;
import org.kuali.coeus.common.impl.unit.UnitLookupDao;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="unitService")
public class UnitServiceImpl
implements UnitService {
    private static final Logger LOGGER = LogManager.getLogger(UnitServiceImpl.class);
    private static final String COLUMN = ":";
    private static final String SEPARATOR = ";1;";
    private static final String DASH = "$-$";
    private static final String UNIT_NUMBER = "unitNumber";
    private static final String PARENT_UNIT_NUMBER = "parentUnitNumber";
    public static final String ACTIVE = "active";
    public static final String ACTIVE_YES = "Y";
    public static final String DELIMITER = ",";
    public static final String UNIT_ADMINISTRATOR_TYPE_CODE = "unitAdministratorTypeCode";
    @Autowired
    @Qualifier(value="unitLookupDao")
    private UnitLookupDao unitLookupDao;
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;
    private final Supplier<List<Unit>> allUnitsCache = Suppliers.memoizeWithExpiration(() -> new ArrayList(this.getBusinessObjectService().findAllOrderBy(Unit.class, UNIT_NUMBER, true)), (long)1L, (TimeUnit)TimeUnit.MINUTES);

    @Override
    public Unit getUnitCaseInsensitive(String unitNumber) {
        Unit unit = null;
        if (StringUtils.isNotEmpty((CharSequence)unitNumber)) {
            unit = this.getUnitLookupDao().findUnitbyNumberCaseInsensitive(unitNumber);
        }
        return unit;
    }

    @Override
    public String getUnitName(String unitNumber) {
        Unit unit = this.getUnit(unitNumber);
        return unit != null ? unit.getUnitName() : null;
    }

    public List<Unit> getUnits() {
        return this.allUnitsCache.get();
    }

    @Override
    public Unit getUnit(String unitNumber) {
        if (StringUtils.isNotEmpty((CharSequence)unitNumber)) {
            return (Unit)this.getBusinessObjectService().findBySinglePrimaryKey(Unit.class, (Object)unitNumber);
        }
        return null;
    }

    @Override
    public Unit getActiveUnit(String unitNumber) {
        if (StringUtils.isNotEmpty((CharSequence)unitNumber)) {
            HashMap<String, Object> fields = new HashMap<String, Object>();
            fields.put(UNIT_NUMBER, unitNumber);
            fields.put(ACTIVE, Boolean.TRUE);
            List units = (List)this.getBusinessObjectService().findMatching(Unit.class, fields);
            return units.size() != 0 ? (Unit)units.get(0) : null;
        }
        return null;
    }

    @Override
    public List<Unit> getSubUnits(String unitNumber) {
        ArrayList<Unit> units = new ArrayList<Unit>();
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(PARENT_UNIT_NUMBER, unitNumber);
        units.addAll(this.getBusinessObjectService().findMatchingOrderBy(Unit.class, fieldValues, UNIT_NUMBER, true));
        return units;
    }

    @Override
    public List<Unit> getActiveSubUnits(String unitNumber) {
        ArrayList<Unit> units = new ArrayList<Unit>();
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(ACTIVE, ACTIVE_YES);
        fieldValues.put(PARENT_UNIT_NUMBER, unitNumber);
        units.addAll(this.getBusinessObjectService().findMatchingOrderBy(Unit.class, fieldValues, UNIT_NUMBER, true));
        return units;
    }

    @Override
    public List<Unit> getAllSubUnits(String unitNumber) {
        return this.findUnitsWithDirectParent((List<Unit>)this.getUnits(), unitNumber);
    }

    protected List<Unit> findUnitsWithDirectParent(List<Unit> units, String directParent) {
        if (CollectionUtils.isNotEmpty(units)) {
            List matched = ListUtils.select(units, input -> input.getParentUnitNumber() != null && input.getParentUnitNumber().equals(directParent));
            ArrayList<Unit> totalMatched = new ArrayList<Unit>(matched);
            for (Unit child : matched) {
                totalMatched.addAll(this.findUnitsWithDirectParent(units, child.getUnitNumber()));
            }
            return totalMatched;
        }
        return Collections.emptyList();
    }

    @Override
    public List<Unit> getUnitHierarchyForUnit(String unitNumber) {
        return this.getParentUnitsInclusive((List<Unit>)this.getUnits(), unitNumber);
    }

    @Override
    public boolean appliesToUnit(String unit, String unitNumbers) {
        if (unitNumbers == null) {
            return Boolean.FALSE;
        }
        for (String environmentUnitNumber : unitNumbers.split(DELIMITER)) {
            List<Unit> unitHierarchyForUnit = this.getUnitHierarchyForUnit(environmentUnitNumber);
            if (!this.appliesToAnyUnitInHierarchy(unit, unitHierarchyForUnit)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean appliesToAnyUnitInHierarchy(String unitNumberToCheck, List<Unit> unitHierarchyForUnit) {
        for (Unit unit : unitHierarchyForUnit) {
            String unitNumber = unit.getUnitNumber();
            if (!unitNumber.equals(unitNumberToCheck)) continue;
            return true;
        }
        return false;
    }

    protected List<Unit> getParentUnitsInclusive(List<Unit> units, String unit) {
        if (CollectionUtils.isNotEmpty(units)) {
            Unit matched = (Unit)IterableUtils.find(units, input -> input.getUnitNumber() != null && input.getUnitNumber().equals(unit));
            if (matched != null) {
                ArrayList<Unit> totalMatched = new ArrayList<Unit>();
                totalMatched.add(matched);
                totalMatched.addAll(this.getParentUnitsInclusive(units, matched.getParentUnitNumber()));
                return totalMatched;
            }
            if (unit != null) {
                LOGGER.error("Invalid parent found " + unit);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public String getSubUnitsForTreeView(String unitNumber) {
        String subUnits = null;
        int startIdx = unitNumber.indexOf("px\">", unitNumber.indexOf("<tr>"));
        for (Unit unit : this.getSubUnits(unitNumber.substring(startIdx + 4, unitNumber.indexOf(COLUMN, startIdx) - 1))) {
            if (StringUtils.isNotBlank(subUnits)) {
                subUnits = subUnits + "#SEPARATOR#" + unit.getUnitNumber() + " : " + unit.getUnitName();
                continue;
            }
            subUnits = unit.getUnitNumber() + " : " + unit.getUnitName();
        }
        return subUnits;
    }

    @Override
    public Unit getTopUnit() {
        return this.getUnitLookupDao().getTopUnit();
    }

    @Override
    public String getInitialUnitsForUnitHierarchy() {
        return this.getInitialUnitsForUnitHierarchy(3);
    }

    @Override
    public String getInitialUnitsForUnitHierarchy(int depth) {
        List<Unit> sortedTruncatedUnits = this.sortUnits(this.truncate((List<Unit>)this.getUnits(), depth));
        return sortedTruncatedUnits.stream().map(unit -> (String)(StringUtils.isNotBlank((CharSequence)unit.getParentUnitNumber()) ? unit.getParentUnitNumber() + DASH : "") + unit.getUnitNumber() + " : " + unit.getUnitName()).collect(Collectors.joining(SEPARATOR));
    }

    protected List<Unit> sortUnits(List<Unit> units) {
        ArrayList<Unit> unsortedUnits = new ArrayList<Unit>(units);
        ArrayList<Unit> sortedUnits = new ArrayList<Unit>();
        LinkedList processQueue = new LinkedList();
        processQueue.addAll(unsortedUnits.stream().filter(unit -> StringUtils.isBlank((CharSequence)unit.getParentUnitNumber())).sorted(Comparator.comparing(Unit::getUnitNumber)).collect(Collectors.toList()));
        while (!processQueue.isEmpty()) {
            Unit toProcess = (Unit)processQueue.remove();
            unsortedUnits.remove(toProcess);
            sortedUnits.add(toProcess);
            processQueue.addAll(unsortedUnits.stream().filter(unit -> unit.getParentUnitNumber().equals(toProcess.getUnitNumber())).sorted(Comparator.comparing(Unit::getUnitNumber)).collect(Collectors.toList()));
        }
        return sortedUnits;
    }

    protected List<Unit> truncate(List<Unit> units, int depth) {
        ArrayList<Unit> unprocessed = new ArrayList<Unit>(units);
        ArrayList<Unit> processed = new ArrayList<Unit>();
        List<Unit> parents = unprocessed.stream().filter(unit -> StringUtils.isBlank((CharSequence)unit.getParentUnitNumber())).collect(Collectors.toList());
        this.processTruncate(unprocessed, processed, parents);
        for (int currentDepth = 1; currentDepth < depth && !unprocessed.isEmpty(); ++currentDepth) {
            List<Unit> currentParents = parents;
            parents = unprocessed.stream().filter(unit -> currentParents.stream().map(Unit::getUnitNumber).collect(Collectors.toList()).contains(unit.getParentUnitNumber())).collect(Collectors.toList());
            this.processTruncate(unprocessed, processed, parents);
        }
        return processed;
    }

    protected void processTruncate(List<Unit> unprocessedList, List<Unit> processedList, List<Unit> currentlyProcessing) {
        processedList.addAll(currentlyProcessing);
        unprocessedList.removeAll(currentlyProcessing);
    }

    @Override
    public List<UnitAdministrator> retrieveUnitAdministratorsByUnitNumber(String unitNumber) {
        return (List)this.getBusinessObjectService().findMatching(UnitAdministrator.class, Collections.singletonMap(UNIT_NUMBER, unitNumber));
    }

    @Override
    public List<UnitAdministrator> retrieveUnitAdministratorsByUnitNumberAndType(String unitNumber, String typeCode) {
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put(UNIT_NUMBER, unitNumber);
        fields.put(UNIT_ADMINISTRATOR_TYPE_CODE, typeCode);
        return (List)this.getBusinessObjectService().findMatching(UnitAdministrator.class, fields);
    }

    @Override
    public int getMaxUnitTreeDepth() {
        return this.getBusinessObjectService().findAll(Unit.class).size();
    }

    public UnitLookupDao getUnitLookupDao() {
        return this.unitLookupDao;
    }

    public void setUnitLookupDao(UnitLookupDao unitLookupDao) {
        this.unitLookupDao = unitLookupDao;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }
}

