/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.contacts;

import java.util.Collection;
import java.util.HashMap;
import org.kuali.coeus.common.framework.type.InvestigatorCreditType;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.kra.award.contacts.AwardPerson;
import org.kuali.kra.award.contacts.AwardPersonUnitCreditSplitRule;
import org.kuali.kra.award.contacts.AwardPersonUnitCreditSplitRuleEvent;

public class AwardPersonUnitCreditSplitRuleImpl
extends KcTransactionalDocumentRuleBase
implements AwardPersonUnitCreditSplitRule {
    private static final ScaleTwoDecimal MAX_TOTAL_VALUE = new ScaleTwoDecimal(100.0);

    @Override
    public boolean checkAwardPersonUnitCreditSplitTotals(AwardPersonUnitCreditSplitRuleEvent event) {
        int errorCount = 0;
        AwardPerson person = event.getProjectPerson();
        for (InvestigatorCreditType creditType : this.loadInvestigatorCreditTypes()) {
            if (!creditType.addsToHundred().booleanValue()) continue;
            ScaleTwoDecimal value = event.getTotalsByCreditSplitType().get(creditType.getCode());
            if (value == null) break;
            if (((ScaleTwoDecimal)MAX_TOTAL_VALUE.subtract((AbstractDecimal)value)).isZero()) continue;
            this.reportError("document.awardList[0].projectPersons.awardPersonUnitCreditSplits", "error.award.person.unit.credit.split.error", creditType.getDescription(), person.getFullName());
            ++errorCount;
        }
        return errorCount == 0;
    }

    Collection<InvestigatorCreditType> loadInvestigatorCreditTypes() {
        HashMap<String, String> valueMap = new HashMap<String, String>();
        valueMap.put("active", "true");
        return this.getBusinessObjectService().findMatching(InvestigatorCreditType.class, valueMap);
    }
}

