/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.lock;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.budget.framework.lock.BudgetLockService;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.kra.award.budget.document.AwardBudgetDocument;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.authorization.PessimisticLock;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.impl.PessimisticLockServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="budgetLockService")
public class BudgetLockServiceImpl
extends PessimisticLockServiceImpl
implements BudgetLockService {
    private static final String ADD_BUDGET = "addBudget";
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;

    @Autowired
    @Qualifier(value="dataObjectService")
    public void setDataObjectService(DataObjectService dataObjectService) {
        super.setDataObjectService(dataObjectService);
    }

    @Autowired
    @Qualifier(value="dataDictionaryService")
    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        super.setDataDictionaryService(dataDictionaryService);
    }

    protected boolean isLockRequiredByUser(Document document, Map editMode, Person user) {
        String activeLockRegion = (String)this.globalVariableService.getUserSession().retrieveObject("ACTIVE_LOCK_REGION");
        for (Map.Entry entry : editMode.entrySet()) {
            if (!this.isEntryEditMode(entry) || !StringUtils.isNotEmpty((CharSequence)activeLockRegion)) continue;
            return true;
        }
        return false;
    }

    public Map establishLocks(Document document, Map editMode, Person user) {
        return super.establishLocks(document, editMode, user);
    }

    protected boolean isEntryEditMode(Map.Entry entry) {
        if ("fullEntry".equals(entry.getKey()) || "modifyBudgets".equals(entry.getKey()) || ADD_BUDGET.equals(entry.getKey())) {
            String fullEntryEditModeValue = (String)entry.getValue();
            return StringUtils.equalsIgnoreCase((CharSequence)"true", (CharSequence)fullEntryEditModeValue);
        }
        return false;
    }

    protected PessimisticLock createNewPessimisticLock(Document document, Map editMode, Person user) {
        if (document instanceof AwardBudgetDocument) {
            AwardBudgetDocument awardBudgetDocument = (AwardBudgetDocument)document;
            if (document.useCustomLockDescriptors()) {
                String lockDescriptor = document.getCustomLockDescriptor(user);
                this.establishLocks((Document)awardBudgetDocument.getBudget().getBudgetParent().getDocument(), editMode, user);
                return this.generateNewLock(document.getDocumentNumber(), lockDescriptor, user);
            }
            return this.generateNewLock(document.getDocumentNumber(), user);
        }
        return super.createNewPessimisticLock(document, editMode, user);
    }

    public boolean hasPreRouteEditAuthorization(Document document, Person user) {
        AwardBudgetDocument awardBudgetDocument = (AwardBudgetDocument)document;
        for (PessimisticLock lock : awardBudgetDocument.getBudget().getBudgetParent().getDocument().getPessimisticLocks()) {
            if (!lock.getLockDescriptor().endsWith("BUDGET") || !lock.isOwnedByUser(user)) continue;
            return true;
        }
        return false;
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }
}

