/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.personnel;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.BudgetConstants;
import org.kuali.coeus.common.budget.framework.core.BudgetContainer;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPerson;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.util.ValuesFinderUtils;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.uif.control.UifKeyValuesFinderBase;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="budgetPersonValuesFinder")
public class BudgetPersonValuesFinder
extends UifKeyValuesFinderBase {
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;

    public List<KeyValue> getKeyValues() {
        BudgetContainer form = (BudgetContainer)KNSGlobalVariables.getKualiForm();
        Budget budget = form.getBudget();
        return this.buildKeyValues(budget.getBudgetPersons());
    }

    public List<KeyValue> getKeyValues(ViewModel model) {
        this.setAddBlankOption(false);
        return this.buildKeyValues(((BudgetContainer)model).getBudget().getBudgetPersons());
    }

    private List<KeyValue> buildKeyValues(List<BudgetPerson> budgetPersons) {
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        keyValues.add(ValuesFinderUtils.getSelectOption());
        HashSet<String> distinctKeys = new HashSet<String>();
        for (BudgetPerson budgetPerson : budgetPersons) {
            boolean duplicatePerson = false;
            if (StringUtils.isNotBlank((CharSequence)budgetPerson.getJobCode()) && StringUtils.isNotBlank((CharSequence)budgetPerson.getAppointmentTypeCode()) && budgetPerson.getCalculationBase().isGreaterEqual((AbstractDecimal)ScaleTwoDecimal.ZERO) && budgetPerson.getEffectiveDate() != null) {
                boolean bl = duplicatePerson = !distinctKeys.add(this.getPersonUniqueKey(budgetPerson));
            }
            if (duplicatePerson) continue;
            keyValues.add((KeyValue)new ConcreteKeyValue(budgetPerson.getPersonSequenceNumber().toString(), this.getBudgetPersonLabel(budgetPerson)));
        }
        keyValues.add((KeyValue)new ConcreteKeyValue(BudgetConstants.BudgetPerson.SUMMARYPERSON.getPersonId(), BudgetConstants.BudgetPerson.SUMMARYPERSON.getPersonName()));
        return keyValues;
    }

    private String getPersonUniqueKey(BudgetPerson budgetPerson) {
        StringBuffer uniqueKey = new StringBuffer();
        uniqueKey.append(budgetPerson.getPersonRolodexTbnId());
        uniqueKey.append(budgetPerson.getJobCode());
        uniqueKey.append(budgetPerson.getEffectiveDate());
        if (Objects.nonNull(budgetPerson.getTbnId())) {
            uniqueKey.append(45 + budgetPerson.getPersonSequenceNumber());
        }
        return uniqueKey.toString();
    }

    protected String getBudgetPersonLabel(BudgetPerson budgetPerson) {
        StringBuffer personLabel = new StringBuffer();
        String personName = budgetPerson.getPersonName() != null ? budgetPerson.getPersonName() : "";
        personLabel.append(personName);
        if (budgetPerson.getJobCode() != null) {
            personLabel.append(" (");
            personLabel.append(budgetPerson.getJobCode());
            personLabel.append(") ");
        }
        return personLabel.toString();
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

