/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.persistence;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ojb.broker.metadata.AttributeDescriptorBase;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.kuali.coeus.sys.framework.persistence.KcPersistenceStructureService;
import org.kuali.rice.krad.bo.DataObjectRelationship;
import org.kuali.rice.krad.exception.ClassNotPersistableException;
import org.kuali.rice.krad.service.PersistenceStructureService;
import org.kuali.rice.krad.service.impl.PersistenceStructureServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="kcPersistenceStructureService")
public class KcPersistenceStructureServiceImpl
extends PersistenceStructureServiceImpl
implements KcPersistenceStructureService {
    @Override
    public Map<String, String> getDBColumnToObjectAttributeMap(Class<?> clazz) throws ClassNotPersistableException {
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        if (this.isPersistable(clazz)) {
            FieldDescriptor[] fieldDescriptors;
            ClassDescriptor classDescriptor = this.getClassDescriptor(clazz);
            for (FieldDescriptor fieldDescriptor : fieldDescriptors = classDescriptor.getFieldDescriptions()) {
                fieldMap.put(fieldDescriptor.getColumnName(), fieldDescriptor.getAttributeName());
            }
            return fieldMap;
        }
        throw new ClassNotPersistableException(clazz.getName() + " is not Persistable");
    }

    @Override
    public List<String> listFieldNames(Class<?> clazz, boolean mapAnonymousFields) {
        if (!mapAnonymousFields) {
            return this.listFieldNames(clazz);
        }
        ClassDescriptor classDescriptor = this.getClassDescriptor(clazz);
        List<String> fieldNames = Stream.of(classDescriptor.getFieldDescriptions()).filter(fd -> !fd.isAnonymous()).map(AttributeDescriptorBase::getAttributeName).collect(Collectors.toList());
        List anonFields = Stream.of(classDescriptor.getFieldDescriptions()).filter(FieldDescriptor::isAnonymous).map(AttributeDescriptorBase::getAttributeName).collect(Collectors.toList());
        classDescriptor.getObjectReferenceDescriptors().forEach(desc -> {
            if (anonFields.containsAll(desc.getForeignKeyFields())) {
                fieldNames.addAll(desc.getForeignKeyFields().stream().map(field -> desc.getAttributeName() + "." + field).collect(Collectors.toList()));
                anonFields.removeAll(desc.getForeignKeyFields());
            }
        });
        return fieldNames;
    }

    @Override
    public Map<String, String> getPersistableAttributesColumnMap(Class<?> clazz) throws ClassNotPersistableException {
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        if (this.isPersistable(clazz)) {
            FieldDescriptor[] fieldDescriptors;
            ClassDescriptor classDescriptor = this.getClassDescriptor(clazz);
            for (FieldDescriptor fieldDescriptor : fieldDescriptors = classDescriptor.getFieldDescriptions()) {
                fieldMap.put(fieldDescriptor.getAttributeName(), fieldDescriptor.getColumnName());
            }
            return fieldMap;
        }
        throw new ClassNotPersistableException(clazz.getName() + " is not Persistable");
    }

    @Override
    public List<DataObjectRelationship> getRelationshipsTo(Class<?> persistableClass) throws ClassNotPersistableException {
        if (!this.isPersistable(persistableClass)) {
            throw new ClassNotPersistableException(persistableClass.getName() + " is not persistable");
        }
        ArrayList<DataObjectRelationship> relationships = new ArrayList<DataObjectRelationship>();
        Set entries = this.getDescriptorRepository().getDescriptorTable().entrySet();
        for (Map.Entry entry : entries) {
            Vector references = ((ClassDescriptor)entry.getValue()).getObjectReferenceDescriptors();
            if (references == null) continue;
            for (ObjectReferenceDescriptor reference : references) {
                if (!reference.getItemClass().equals(persistableClass)) continue;
                DataObjectRelationship relationship = new DataObjectRelationship(((ClassDescriptor)entry.getValue()).getClassOfObject(), reference.getAttributeName(), reference.getItemClass());
                HashMap<String, String> pToC = new HashMap<String, String>();
                for (int i = 0; i < reference.getForeignKeyFields().size(); ++i) {
                    String fkField = reference.getForeignKeyFields().get(i).toString();
                    pToC.put(fkField, this.getDescriptorRepository().getDescriptorFor(reference.getItemClass()).getPkFields()[i].getAttributeName());
                }
                relationship.setParentToChildReferences(pToC);
                relationships.add(relationship);
            }
        }
        return relationships;
    }

    @Autowired
    @Qualifier(value="persistenceStructureServiceOjb")
    public void setPersistenceStructureServiceOjb(PersistenceStructureService persistenceStructureServiceOjb) {
        super.setPersistenceStructureServiceOjb(persistenceStructureServiceOjb);
    }
}

