/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.api.document.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.api.document.DocumentWorkflowUserDetails;
import org.kuali.coeus.common.api.document.DocumentWorkloadDetails;
import org.kuali.coeus.common.api.document.service.DocumentActionListService;
import org.kuali.coeus.common.api.document.service.WorkflowDetailsService;
import org.kuali.coeus.sys.framework.concurrent.WebappContextForkJoinPool;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.workflow.KewDocHeaderDao;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actiontaken.ActionTakenValue;
import org.kuali.rice.kew.api.action.ActionRequest;
import org.kuali.rice.kew.api.action.RecipientType;
import org.kuali.rice.kew.api.action.RoutingReportCriteria;
import org.kuali.rice.kew.api.action.WorkflowDocumentActionsService;
import org.kuali.rice.kew.api.document.DocumentDetail;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.routeheader.service.RouteHeaderService;
import org.kuali.rice.kim.api.group.GroupService;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.DocumentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component(value="workflowDetailsService")
@Transactional(propagation=Propagation.REQUIRES_NEW)
public class WorkflowDetailsServiceImpl
implements WorkflowDetailsService {
    private static final String PRINCIPAL_ID = "principalId";
    private static final int SIMULATION_PROGRESS_SIZE = 10;
    private static final Logger LOG = LogManager.getLogger(WorkflowDetailsServiceImpl.class);
    @Autowired
    @Qualifier(value="documentActionListService")
    private DocumentActionListService documentActionListService;
    @Autowired
    @Qualifier(value="workflowDocumentActionsService")
    private WorkflowDocumentActionsService workflowDocumentActionsService;
    @Autowired
    @Qualifier(value="documentRouteHeaderService")
    private RouteHeaderService documentRouteHeaderService;
    @Autowired
    @Qualifier(value="documentService")
    private DocumentService documentService;
    @Autowired
    @Qualifier(value="groupService")
    private GroupService groupService;
    @Autowired
    @Qualifier(value="kewDocHeaderDao")
    private KewDocHeaderDao kewDocHeaderDao;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;
    @Autowired
    @Qualifier(value="kualiConfigurationService")
    private ConfigurationService configurationService;
    private final ForkJoinPool forkJoinPool = new WebappContextForkJoinPool();

    @Override
    public Future<?> simulateWorkflowOnAllDocuments() {
        this.clearAllWorkflowDetails();
        UserSession serviceUserSession = new UserSession(this.configurationService.getPropertyValueAsString("batchJobUserName"));
        List enrouteDocumentIds = this.kewDocHeaderDao.getEnrouteProposalDocs(serviceUserSession.getPrincipalId(), null, null).stream().filter(Objects::nonNull).filter(doc -> doc.getDocument() != null).filter(doc -> StringUtils.isNotBlank((CharSequence)doc.getDocument().getDocumentId())).map(doc -> doc.getDocument().getDocumentId()).collect(Collectors.toList());
        AtomicInteger progress = new AtomicInteger();
        int recordCount = enrouteDocumentIds.size();
        return this.forkJoinPool.submit(() -> enrouteDocumentIds.parallelStream().forEach(documentId -> {
            try {
                int i;
                this.globalVariableService.setUserSession(serviceUserSession);
                this.calculateAndPersistDetailsForUsersInRouteLog(this.documentService.getByDocumentHeaderId(documentId));
                if (LOG.isInfoEnabled() && (i = progress.getAndIncrement()) % 10 == 0) {
                    LOG.info(String.format("%d / %d workflow details simulations run", i + 1, recordCount));
                }
            }
            catch (RuntimeException | WorkflowException e) {
                LOG.error("Unable to generate workflow details for " + documentId, e);
            }
        }));
    }

    @Override
    public void generateDetailsFromSimulation(Document document) {
        this.clearWorkflowDetails(document.getDocumentNumber());
        this.calculateAndPersistDetailsForUsersInRouteLog(document);
    }

    public void calculateAndPersistDetailsForUsersInRouteLog(Document document) {
        if (document.getDocumentHeader().getWorkflowDocument().isEnroute()) {
            DocumentDetail documentDetail = this.getDocumentDetail(document.getDocumentNumber());
            String documentId = documentDetail.getDocument().getDocumentId();
            DocumentRouteHeaderValue routeHeader = this.documentRouteHeaderService.getRouteHeader(documentId);
            this.documentActionListService.fixActionRequestsPositions(routeHeader);
            List<ActionRequestValue> allIncompleteRequests = Stream.concat(this.documentActionListService.populateRouteLogFormActionRequests(routeHeader).stream(), this.documentActionListService.populateRouteLogFutureRequests(routeHeader).stream()).filter(actionRequestValue -> !actionRequestValue.getStatus().equalsIgnoreCase("D")).collect(Collectors.toList());
            Set<String> usersInRouteLog = this.getUsersInActionRequest(documentDetail);
            this.saveStepsForUsers(documentId, usersInRouteLog, allIncompleteRequests);
            this.saveWorkloadDetails(documentId, routeHeader, allIncompleteRequests);
        }
    }

    public DocumentDetail getDocumentDetail(String documentId) {
        RoutingReportCriteria.Builder reportCriteriaBuilder = RoutingReportCriteria.Builder.createByDocumentId((String)documentId);
        return this.workflowDocumentActionsService.executeSimulation(reportCriteriaBuilder.build());
    }

    public void saveWorkloadDetails(String documentId, DocumentRouteHeaderValue routeHeader, List<ActionRequestValue> allIncompleteRequests) {
        List actionsTaken = routeHeader.getActionsTaken();
        ActionTakenValue lastActionTaken = (ActionTakenValue)actionsTaken.get(actionsTaken.size() - 1);
        allIncompleteRequests.stream().filter(actionRequestValue -> actionRequestValue.getStatus().equalsIgnoreCase("A")).findFirst().ifPresent(request -> this.createWorkloadDetails(documentId, lastActionTaken.getActionDate(), request.getPriority()));
    }

    public void saveStepsForUsers(String documentId, Set<String> usersInRouteLog, List<ActionRequestValue> allRequests) {
        for (String userId : usersInRouteLog) {
            Integer steps = this.calculateStepsForUsers(userId, allRequests);
            String delegateType = this.findRequestForUser(userId, allRequests).map(ActionRequestValue::getDelegationTypeCode).orElse(null);
            if (!Objects.nonNull(steps)) continue;
            this.createWorkflowDetails(userId, documentId, steps, delegateType);
        }
    }

    private Optional<ActionRequestValue> findRequestForUser(String userId, List<ActionRequestValue> allRequests) {
        return allRequests.stream().filter(request -> this.isRequestForUser(userId, (ActionRequestValue)request)).findFirst();
    }

    private boolean isRequestForUser(String userId, ActionRequestValue request) {
        if (StringUtils.equalsIgnoreCase((CharSequence)userId, (CharSequence)request.getPrincipalId())) {
            return true;
        }
        if (request.isGroupRequest()) {
            return this.groupService.isMemberOfGroup(userId, request.getGroupId());
        }
        if (CollectionUtils.isNotEmpty((Collection)request.getChildrenRequests())) {
            return request.getChildrenRequests().stream().anyMatch(child -> this.isRequestForUser(userId, (ActionRequestValue)child));
        }
        return false;
    }

    public Integer calculateStepsForUsers(String userId, List<ActionRequestValue> allRequests) {
        int activePosition = 0;
        for (int position = 0; position < allRequests.size(); ++position) {
            ActionRequestValue actionRequestValue = allRequests.get(position);
            if (actionRequestValue.getStatus().equalsIgnoreCase("A")) {
                activePosition = position;
            }
            int steps = position - activePosition;
            if (!this.isRequestForUser(userId, actionRequestValue)) continue;
            return steps;
        }
        return null;
    }

    protected Set<String> getUsersInActionRequest(DocumentDetail documentDetail) {
        return documentDetail.getActionRequests().stream().filter(this::isPendingApproval).map(this::getUsersInActionRequest).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private boolean isPendingApproval(ActionRequest actionRequest) {
        return actionRequest.isPending() && actionRequest.getActionRequested().getCode().equalsIgnoreCase("A");
    }

    protected List<String> getUsersInActionRequest(ActionRequest actionRequest) {
        ArrayList<String> principalIds = new ArrayList<String>();
        if (actionRequest != null) {
            return this.flattenChildrenToStream(actionRequest).filter(request -> RecipientType.ROLE != request.getRecipientType()).flatMap(this::getPrincipalIdsForRequest).collect(Collectors.toList());
        }
        return principalIds;
    }

    protected Stream<ActionRequest> flattenChildrenToStream(ActionRequest actionRequest) {
        return Stream.concat(Stream.of(actionRequest), actionRequest.getChildRequests().stream().flatMap(this::flattenChildrenToStream));
    }

    protected Stream<String> getPrincipalIdsForRequest(ActionRequest actionRequest) {
        if (StringUtils.isNotBlank((CharSequence)actionRequest.getGroupId())) {
            return this.groupService.getMemberPrincipalIds(actionRequest.getGroupId()).stream();
        }
        if (StringUtils.isNotBlank((CharSequence)actionRequest.getPrincipalId())) {
            return Stream.of(actionRequest.getPrincipalId());
        }
        return Stream.empty();
    }

    private void clearWorkflowDetails(String documentNumber) {
        QueryByCriteria query = QueryByCriteria.Builder.forAttribute((String)"documentNumber", (Object)documentNumber).build();
        this.dataObjectService.deleteMatching(DocumentWorkflowUserDetails.class, query);
        this.dataObjectService.deleteMatching(DocumentWorkloadDetails.class, query);
    }

    private void clearAllWorkflowDetails() {
        this.dataObjectService.deleteAll(DocumentWorkflowUserDetails.class);
        this.dataObjectService.deleteAll(DocumentWorkloadDetails.class);
    }

    private void createWorkflowDetails(String principalId, String documentNumber, Integer steps, String delegateType) {
        HashMap<String, String> keys = new HashMap<String, String>();
        keys.put("documentNumber", documentNumber);
        keys.put(PRINCIPAL_ID, principalId);
        DocumentWorkflowUserDetails detailsRecord = (DocumentWorkflowUserDetails)this.dataObjectService.findUnique(DocumentWorkflowUserDetails.class, QueryByCriteria.Builder.andAttributes(keys).build());
        if (Objects.isNull(detailsRecord)) {
            detailsRecord = new DocumentWorkflowUserDetails(principalId, steps, documentNumber);
        } else {
            detailsRecord.setSteps(steps);
        }
        detailsRecord.setDelegateType(delegateType);
        this.dataObjectService.save((Object)detailsRecord, new PersistenceOption[0]);
    }

    private void createWorkloadDetails(String documentId, Timestamp lastActionDate, Integer currentPeopleFlowStop) {
        HashMap<String, String> keys = new HashMap<String, String>();
        keys.put("documentNumber", documentId);
        DocumentWorkloadDetails workloadDetails = (DocumentWorkloadDetails)this.dataObjectService.findUnique(DocumentWorkloadDetails.class, QueryByCriteria.Builder.andAttributes(keys).build());
        if (Objects.isNull(workloadDetails)) {
            workloadDetails = new DocumentWorkloadDetails(documentId, lastActionDate, currentPeopleFlowStop);
        } else {
            workloadDetails.setCurrentPeopleFlowStop(currentPeopleFlowStop);
        }
        this.dataObjectService.save((Object)workloadDetails, new PersistenceOption[0]);
    }

    public DocumentActionListService getDocumentActionListService() {
        return this.documentActionListService;
    }

    public void setDocumentActionListService(DocumentActionListService documentActionListService) {
        this.documentActionListService = documentActionListService;
    }

    public WorkflowDocumentActionsService getWorkflowDocumentActionsService() {
        return this.workflowDocumentActionsService;
    }

    public void setWorkflowDocumentActionsService(WorkflowDocumentActionsService workflowDocumentActionsService) {
        this.workflowDocumentActionsService = workflowDocumentActionsService;
    }

    public RouteHeaderService getDocumentRouteHeaderService() {
        return this.documentRouteHeaderService;
    }

    public void setDocumentRouteHeaderService(RouteHeaderService documentRouteHeaderService) {
        this.documentRouteHeaderService = documentRouteHeaderService;
    }

    public GroupService getGroupService() {
        return this.groupService;
    }

    public void setGroupService(GroupService groupService) {
        this.groupService = groupService;
    }

    public KewDocHeaderDao getKewDocHeaderDao() {
        return this.kewDocHeaderDao;
    }

    public void setKewDocHeaderDao(KewDocHeaderDao kewDocHeaderDao) {
        this.kewDocHeaderDao = kewDocHeaderDao;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }
}

