/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.committee.impl.rules;

import org.kuali.coeus.common.committee.impl.bo.CommitteeScheduleAttributeReferenceDummy;
import org.kuali.coeus.common.committee.impl.web.struts.form.schedule.DailyScheduleDetails;
import org.kuali.coeus.common.committee.impl.web.struts.form.schedule.MonthlyScheduleDetails;
import org.kuali.coeus.common.committee.impl.web.struts.form.schedule.ScheduleData;
import org.kuali.coeus.common.committee.impl.web.struts.form.schedule.StyleKey;
import org.kuali.coeus.common.committee.impl.web.struts.form.schedule.YearlyScheduleDetails;
import org.kuali.rice.kns.service.DictionaryValidationService;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.krad.util.GlobalVariables;

public class CommitteeScheduleDataDictionaryValidationRule {
    public static final String ATTRIBUTE_DAY_RECURRENCE = "dayRecurrence";
    public static final String ATTRIBUTE_WEEK_RECURRENCE = "weekRecurrence";
    public static final String ATTRIBUTE_MONTH_DAY = "monthDay";
    public static final String ATTRIBUTE_MONTH_RECURRENCE = "monthRecurrence";
    public static final String ATTRIBUTE_YEAR_DAY = "yearDay";
    public static final String ATTRIBUTE_YEAR_RECURRENCE = "yearRecurrence";
    public static final String ERROR_KEY_SCHEDULEDATA_DAILYSCHEDULE_DAY = "committeeHelper.scheduleData.dailySchedule.day";
    public static final String ERROR_KEY_SCHEDULEDATA_WEEKLYSCHEDULE_DAY = "committeeHelper.scheduleData.weeklySchedule.week";
    public static final String ERROR_KEY_SCHEDULEDATA_MONTHLYSCHEDULE_DAY = "committeeHelper.scheduleData.monthlySchedule.day";
    public static final String ERROR_KEY_SCHEDULEDATA_MONTHLYSCHEDULE_OPTION1MONTH = "committeeHelper.scheduleData.monthlySchedule.option1Month";
    public static final String ERROR_KEY_SCHEDULEDATA_MONTHLYSCHEDULE_OPTION2MONTH = "committeeHelper.scheduleData.monthlySchedule.option2Month";
    public static final String ERROR_KEY_SCHEDULEDATA_YEARLYSCHEDULE_DAY = "committeeHelper.scheduleData.yearlySchedule.day";
    public static final String ERROR_KEY_SCHEDULEDATA_YEARLYSCHEDULE_OPTION1YEAR = "committeeHelper.scheduleData.yearlySchedule.option1Year";
    public static final String ERROR_KEY_SCHEDULEDATA_YEARLYSCHEDULE_OPTION2YEAR = "committeeHelper.scheduleData.yearlySchedule.option2Year";

    public boolean applyRules(ScheduleData scheduleData) {
        boolean retVal;
        block20: {
            retVal = false;
            StyleKey key = StyleKey.valueOf(scheduleData.getRecurrenceType());
            block0 : switch (key) {
                case NEVER: {
                    retVal = true;
                    break;
                }
                case DAILY: {
                    DailyScheduleDetails.optionValues dailyoption = DailyScheduleDetails.optionValues.valueOf(scheduleData.getDailySchedule().getDayOption());
                    switch (dailyoption) {
                        case XDAY: {
                            retVal = this.applyRules(ATTRIBUTE_DAY_RECURRENCE, scheduleData.getDailySchedule().getDay(), ERROR_KEY_SCHEDULEDATA_DAILYSCHEDULE_DAY);
                            break;
                        }
                        case WEEKDAY: {
                            retVal = true;
                        }
                    }
                    break;
                }
                case WEEKLY: {
                    retVal = this.applyRules(ATTRIBUTE_WEEK_RECURRENCE, scheduleData.getWeeklySchedule().getWeek(), ERROR_KEY_SCHEDULEDATA_WEEKLYSCHEDULE_DAY);
                    break;
                }
                case MONTHLY: {
                    MonthlyScheduleDetails.optionValues monthOption = MonthlyScheduleDetails.optionValues.valueOf(scheduleData.getMonthlySchedule().getMonthOption());
                    switch (monthOption) {
                        case XDAYANDXMONTH: {
                            retVal = this.applyRules(ATTRIBUTE_MONTH_DAY, scheduleData.getMonthlySchedule().getDay(), ERROR_KEY_SCHEDULEDATA_MONTHLYSCHEDULE_DAY);
                            if (!retVal) break;
                            retVal = this.applyRules(ATTRIBUTE_MONTH_RECURRENCE, scheduleData.getMonthlySchedule().getOption1Month(), ERROR_KEY_SCHEDULEDATA_MONTHLYSCHEDULE_OPTION1MONTH);
                            break;
                        }
                        case XDAYOFWEEKANDXMONTH: {
                            retVal = this.applyRules(ATTRIBUTE_MONTH_RECURRENCE, scheduleData.getMonthlySchedule().getOption2Month(), ERROR_KEY_SCHEDULEDATA_MONTHLYSCHEDULE_OPTION2MONTH);
                        }
                    }
                    break;
                }
                case YEARLY: {
                    YearlyScheduleDetails.yearOptionValues yearOption = YearlyScheduleDetails.yearOptionValues.valueOf(scheduleData.getYearlySchedule().getYearOption());
                    switch (yearOption) {
                        case XDAY: {
                            retVal = this.applyRules(ATTRIBUTE_YEAR_DAY, scheduleData.getYearlySchedule().getDay(), ERROR_KEY_SCHEDULEDATA_YEARLYSCHEDULE_DAY);
                            if (retVal) {
                                retVal = this.applyRules(ATTRIBUTE_YEAR_RECURRENCE, scheduleData.getYearlySchedule().getOption1Year(), ERROR_KEY_SCHEDULEDATA_YEARLYSCHEDULE_OPTION1YEAR);
                                break block0;
                            }
                            break block20;
                        }
                        case CMPLX: {
                            retVal = this.applyRules(ATTRIBUTE_YEAR_RECURRENCE, scheduleData.getYearlySchedule().getOption2Year(), ERROR_KEY_SCHEDULEDATA_YEARLYSCHEDULE_OPTION2YEAR);
                        }
                    }
                }
            }
        }
        return retVal;
    }

    private boolean applyRules(String attributeName, Integer value, String errorKey) {
        boolean retVal = false;
        this.getService().validateAttributeRequired(CommitteeScheduleAttributeReferenceDummy.class.getName(), attributeName, (Object)value, Boolean.valueOf(false), errorKey);
        retVal = this.isError(errorKey);
        if (retVal) {
            this.getService().validateAttributeFormat(CommitteeScheduleAttributeReferenceDummy.class.getName(), attributeName, value.toString(), errorKey);
            retVal = this.isError(errorKey);
        }
        return retVal;
    }

    private boolean isError(String errorKey) {
        boolean retVal = false;
        if (null == GlobalVariables.getMessageMap().getErrorMessages().get(errorKey)) {
            retVal = true;
        }
        return retVal;
    }

    private DictionaryValidationService getService() {
        return KNSServiceLocator.getKNSDictionaryValidationService();
    }
}

