/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.framework.custom;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.auth.task.TaskAuthorizationService;
import org.kuali.coeus.common.framework.custom.DocumentCustomData;
import org.kuali.coeus.common.framework.custom.attr.CustomAttributeDocument;
import org.kuali.coeus.common.framework.custom.attr.CustomAttributeService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class CustomDataHelperBase<T extends DocumentCustomData>
implements Serializable {
    private static final long serialVersionUID = 221007039768111111L;
    private SortedMap<String, List<CustomAttributeDocument>> customAttributeGroups = new TreeMap<String, List<CustomAttributeDocument>>();
    private boolean modifyCustomData = false;

    protected abstract T getNewCustomData();

    public abstract boolean documentNotRouted();

    public abstract List<T> getCustomDataList();

    public abstract Map<String, CustomAttributeDocument> getCustomAttributeDocuments();

    public void buildCustomDataCollectionsOnExistingDocument(SortedMap<String, List<CustomAttributeDocument>> customAttributeGroups) {
        boolean documentNotRouted = false;
        documentNotRouted = this.documentNotRouted();
        List<T> customDataInDocument = this.getCustomDataList();
        Set<Map.Entry<String, CustomAttributeDocument>> allCustomAttributeDocuments = this.getCustomAttributeDocuments().entrySet();
        block0: for (Map.Entry<String, CustomAttributeDocument> customAttributeDocumentEntry : allCustomAttributeDocuments) {
            for (DocumentCustomData documentCustomData : customDataInDocument) {
                if (!this.isMatch(documentCustomData, customAttributeDocumentEntry)) continue;
                String groupName = this.getCustomAttributeDocuments().get(documentCustomData.getCustomAttributeId().toString()).getCustomAttribute().getGroupName();
                this.addToGroup(groupName, customAttributeGroups, customAttributeDocumentEntry);
                continue block0;
            }
        }
        if (documentNotRouted) {
            for (Map.Entry<String, CustomAttributeDocument> customAttributeDocumentEntry : allCustomAttributeDocuments) {
                List entriesInCurrentGroup = (List)customAttributeGroups.get(customAttributeDocumentEntry.getValue().getCustomAttribute().getGroupName());
                if (entriesInCurrentGroup != null && this.alreadyExists(entriesInCurrentGroup, customAttributeDocumentEntry)) continue;
                String groupName = customAttributeDocumentEntry.getValue().getCustomAttribute().getGroupName();
                this.addToCustomDataList(customAttributeDocumentEntry);
                this.addToGroup(groupName, customAttributeGroups, customAttributeDocumentEntry);
            }
        }
    }

    protected void addToCustomDataList(Map.Entry<String, CustomAttributeDocument> customAttributeDocumentEntry) {
        T newCustomData = this.getNewCustomData();
        newCustomData.setCustomAttribute(customAttributeDocumentEntry.getValue().getCustomAttribute());
        newCustomData.setCustomAttributeId(customAttributeDocumentEntry.getValue().getId());
        newCustomData.setValue(customAttributeDocumentEntry.getValue().getCustomAttribute().getDefaultValue());
        this.getCustomDataList().add(newCustomData);
    }

    protected boolean alreadyExists(List<CustomAttributeDocument> entriesInCurrentGroup, Map.Entry<String, CustomAttributeDocument> customAttributeDocumentEntry) {
        for (CustomAttributeDocument entry : entriesInCurrentGroup) {
            if (entry.getId() != (long)Integer.parseInt(customAttributeDocumentEntry.getKey())) continue;
            return true;
        }
        return false;
    }

    protected void addToGroup(String groupName, SortedMap<String, List<CustomAttributeDocument>> customAttributeGroups, Map.Entry<String, CustomAttributeDocument> customAttributeDocument) {
        List customAttributeDocumentList = customAttributeGroups.getOrDefault(groupName, new ArrayList());
        customAttributeDocumentList.add(customAttributeDocument.getValue());
        customAttributeGroups.put(groupName, customAttributeDocumentList);
    }

    protected boolean isMatch(T documentCustomData, Map.Entry<String, CustomAttributeDocument> customAttributeDocumentEntry) {
        return documentCustomData.getCustomAttributeId().longValue() == customAttributeDocumentEntry.getValue().getId().longValue();
    }

    public void buildCustomDataCollectionsOnNewDocument(SortedMap<String, List<CustomAttributeDocument>> customAttributeGroups) {
        for (Map.Entry<String, CustomAttributeDocument> customAttributeDocumentEntry : this.getCustomAttributeDocuments().entrySet()) {
            ArrayList<CustomAttributeDocument> customAttributeDocumentList;
            String groupName = customAttributeDocumentEntry.getValue().getCustomAttribute().getGroupName();
            this.addToCustomDataList(customAttributeDocumentEntry);
            if (StringUtils.isEmpty((CharSequence)groupName)) {
                groupName = "No Group";
            }
            if ((customAttributeDocumentList = (ArrayList<CustomAttributeDocument>)customAttributeGroups.get(groupName)) == null) {
                customAttributeDocumentList = new ArrayList<CustomAttributeDocument>();
                customAttributeGroups.put(groupName, customAttributeDocumentList);
            }
            customAttributeDocumentList.add(this.getCustomAttributeDocuments().get(customAttributeDocumentEntry.getValue().getId().toString()));
        }
    }

    public void prepareCustomData() {
        this.initializePermissions();
        TreeMap<String, List<CustomAttributeDocument>> customAttributeGroups = new TreeMap<String, List<CustomAttributeDocument>>();
        if (this.getCustomDataList().size() > 0) {
            this.buildCustomDataCollectionsOnExistingDocument(customAttributeGroups);
        } else {
            this.buildCustomDataCollectionsOnNewDocument(customAttributeGroups);
        }
        this.setCustomAttributeGroups(customAttributeGroups);
        this.sortCustomDataBySortId();
    }

    protected void sortCustomDataBySortId() {
        Comparator<CustomAttributeDocument> customAttributeDocumentComparator = CustomAttributeService.customAttributeSortIdComparator();
        ArrayList<T> unsortedCustomDataList = new ArrayList<T>(this.getCustomDataList());
        ArrayList<CustomAttributeDocument> sortedCustomAttributeDocuments = new ArrayList<CustomAttributeDocument>(this.getCustomAttributeDocuments().values());
        sortedCustomAttributeDocuments.sort(customAttributeDocumentComparator);
        this.getCustomDataList().clear();
        block0: for (CustomAttributeDocument customAttributeDocument : sortedCustomAttributeDocuments) {
            for (DocumentCustomData customData : unsortedCustomDataList) {
                if (!customData.getCustomAttributeId().equals(customAttributeDocument.getId())) continue;
                this.getCustomDataList().add(customData);
                continue block0;
            }
        }
        for (List list : this.getCustomAttributeGroups().values()) {
            list.sort(customAttributeDocumentComparator);
        }
    }

    public String getValidCustomAttributeGroupName(String groupName) {
        return groupName != null ? groupName : "Custom Data Group";
    }

    public void initializePermissions() {
        this.modifyCustomData = this.canModifyCustomData();
    }

    public boolean canModifyCustomData() {
        return this.modifyCustomData;
    }

    public boolean getModifyCustomData() {
        return this.modifyCustomData;
    }

    public void setCustomAttributeGroups(SortedMap<String, List<CustomAttributeDocument>> customAttributeGroups) {
        this.customAttributeGroups = customAttributeGroups;
    }

    public Map<String, List<CustomAttributeDocument>> getCustomAttributeGroups() {
        return this.customAttributeGroups;
    }

    protected TaskAuthorizationService getTaskAuthorizationService() {
        return KcServiceLocator.getService(TaskAuthorizationService.class);
    }

    protected String getUserIdentifier() {
        return GlobalVariables.getUserSession().getPrincipalId();
    }

    public void setCustomAttributeContent(String documentNumber, String attributeName) {
        this.getCustomAttributeService().setCustomAttributeKeyValue(documentNumber, this.getCustomAttributeDocuments(), attributeName, this.getUserIdentifier());
    }

    protected CustomAttributeService getCustomAttributeService() {
        return KcServiceLocator.getService(CustomAttributeService.class);
    }

    public class LabelComparator
    implements Comparator {
        public int compare(Object cad1, Object cad2) {
            try {
                String label1 = ((CustomAttributeDocument)cad1).getCustomAttribute().getLabel();
                String label2 = ((CustomAttributeDocument)cad2).getCustomAttribute().getLabel();
                if (label1 == null) {
                    label1 = "";
                }
                if (label2 == null) {
                    label2 = "";
                }
                return label1.compareTo(label2);
            }
            catch (Exception e) {
                return 0;
            }
        }
    }
}

